/*
 * Decompiled with CFR 0.152.
 */
package jake2.util;

import jake2.game.GameBase;
import jake2.game.GameItemList;
import jake2.game.SuperAdapter;
import jake2.game.edict_t;
import jake2.game.gitem_t;
import jake2.qcommon.Com;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class QuakeFile
extends RandomAccessFile {
    public QuakeFile(String filename, String mode) throws FileNotFoundException {
        super(filename, mode);
    }

    public void writeVector(float[] v) throws IOException {
        for (int n = 0; n < 3; ++n) {
            this.writeFloat(v[n]);
        }
    }

    public float[] readVector() throws IOException {
        float[] res = new float[]{0.0f, 0.0f, 0.0f};
        for (int n = 0; n < 3; ++n) {
            res[n] = this.readFloat();
        }
        return res;
    }

    public String readString() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        super.read(bb, 0, len);
        return new String(bb, 0, len);
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(s.length());
        if (s.length() != 0) {
            this.writeBytes(s);
        }
    }

    public void writeEdictRef(edict_t ent) throws IOException {
        if (ent == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(ent.s.number);
        }
    }

    public edict_t readEdictRef() throws IOException {
        int i = this.readInt();
        if (i < 0) {
            return null;
        }
        if (i > GameBase.g_edicts.length) {
            Com.DPrintf("jake2: illegal edict num:" + i + "\n");
            return null;
        }
        return GameBase.g_edicts[i];
    }

    public void writeAdapter(SuperAdapter a) throws IOException {
        this.writeInt(3988);
        if (a == null) {
            this.writeString(null);
        } else {
            String str = a.getID();
            if (a == null) {
                Com.DPrintf("writeAdapter: invalid Adapter id for " + a + "\n");
            }
            this.writeString(str);
        }
    }

    public SuperAdapter readAdapter() throws IOException {
        String id;
        if (this.readInt() != 3988) {
            Com.DPrintf("wrong read position: readadapter 3988 \n");
        }
        if ((id = this.readString()) == null) {
            return null;
        }
        return SuperAdapter.getFromID(id);
    }

    public void writeItem(gitem_t item) throws IOException {
        if (item == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(item.index);
        }
    }

    public gitem_t readItem() throws IOException {
        int ndx = this.readInt();
        if (ndx == -1) {
            return null;
        }
        return GameItemList.itemlist[ndx];
    }
}

