/*
 * Decompiled with CFR 0.152.
 */
package jake2.util;

import jake2.game.cplane_t;
import jake2.qcommon.Com;

public class Math3D {
    static final float shortratio = 0.005493164f;
    static final float piratio = (float)Math.PI / 360;
    private static float[][] m;
    private static float[][] im;
    private static float[][] tmpmat;
    private static float[][] zrot;
    private static final float[] vr;
    private static final float[] vup;
    private static final float[] vf;
    private static final float[][] PLANE_XYZ;
    private static float[][] corners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void set(float[] v1, float[] v2) {
        v1[0] = v2[0];
        v1[1] = v2[1];
        v1[2] = v2[2];
    }

    public static void VectorSubtract(float[] a, float[] b, float[] c) {
        c[0] = a[0] - b[0];
        c[1] = a[1] - b[1];
        c[2] = a[2] - b[2];
    }

    public static void VectorSubtract(short[] a, short[] b, int[] c) {
        c[0] = a[0] - b[0];
        c[1] = a[1] - b[1];
        c[2] = a[2] - b[2];
    }

    public static void VectorAdd(float[] a, float[] b, float[] to) {
        to[0] = a[0] + b[0];
        to[1] = a[1] + b[1];
        to[2] = a[2] + b[2];
    }

    public static void VectorCopy(float[] from, float[] to) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static void VectorCopy(short[] from, short[] to) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static void VectorCopy(short[] from, float[] to) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static void VectorCopy(float[] from, short[] to) {
        to[0] = (short)from[0];
        to[1] = (short)from[1];
        to[2] = (short)from[2];
    }

    public static void VectorClear(float[] a) {
        a[2] = 0.0f;
        a[1] = 0.0f;
        a[0] = 0.0f;
    }

    public static boolean VectorEquals(float[] v1, float[] v2) {
        return v1[0] == v2[0] && v1[1] == v2[1] && v1[2] == v2[2];
    }

    public static void VectorNegate(float[] from, float[] to) {
        to[0] = -from[0];
        to[1] = -from[1];
        to[2] = -from[2];
    }

    public static void VectorSet(float[] v, float x, float y, float z) {
        v[0] = x;
        v[1] = y;
        v[2] = z;
    }

    public static void VectorMA(float[] veca, float scale, float[] vecb, float[] to) {
        to[0] = veca[0] + scale * vecb[0];
        to[1] = veca[1] + scale * vecb[1];
        to[2] = veca[2] + scale * vecb[2];
    }

    public static final float VectorNormalize(float[] v) {
        float length = Math3D.VectorLength(v);
        if (length != 0.0f) {
            float ilength = 1.0f / length;
            v[0] = v[0] * ilength;
            v[1] = v[1] * ilength;
            v[2] = v[2] * ilength;
        }
        return length;
    }

    public static final float VectorLength(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static void VectorInverse(float[] v) {
        v[0] = -v[0];
        v[1] = -v[1];
        v[2] = -v[2];
    }

    public static void VectorScale(float[] in, float scale, float[] out) {
        out[0] = in[0] * scale;
        out[1] = in[1] * scale;
        out[2] = in[2] * scale;
    }

    public static float vectoyaw(float[] vec) {
        float yaw;
        if (vec[0] == 0.0f) {
            yaw = 0.0f;
            if (vec[1] > 0.0f) {
                yaw = 90.0f;
            } else if (vec[1] < 0.0f) {
                yaw = -90.0f;
            }
        } else {
            yaw = (int)(Math.atan2(vec[1], vec[0]) * 180.0 / Math.PI);
            if (yaw < 0.0f) {
                yaw += 360.0f;
            }
        }
        return yaw;
    }

    public static void vectoangles(float[] value1, float[] angles) {
        float pitch;
        float yaw;
        if (value1[1] == 0.0f && value1[0] == 0.0f) {
            yaw = 0.0f;
            pitch = value1[2] > 0.0f ? 90.0f : 270.0f;
        } else {
            float forward;
            yaw = value1[0] != 0.0f ? (float)((int)(Math.atan2(value1[1], value1[0]) * 180.0 / Math.PI)) : (value1[1] > 0.0f ? 90.0f : -90.0f);
            if (yaw < 0.0f) {
                yaw += 360.0f;
            }
            if ((pitch = (float)((int)(Math.atan2(value1[2], forward = (float)Math.sqrt(value1[0] * value1[0] + value1[1] * value1[1])) * 180.0 / Math.PI))) < 0.0f) {
                pitch += 360.0f;
            }
        }
        angles[0] = -pitch;
        angles[1] = yaw;
        angles[2] = 0.0f;
    }

    public static void RotatePointAroundVector(float[] dst, float[] dir, float[] point, float degrees) {
        Math3D.vf[0] = dir[0];
        Math3D.vf[1] = dir[1];
        Math3D.vf[2] = dir[2];
        Math3D.PerpendicularVector(vr, dir);
        Math3D.CrossProduct(vr, vf, vup);
        Math3D.m[0][0] = vr[0];
        Math3D.m[1][0] = vr[1];
        Math3D.m[2][0] = vr[2];
        Math3D.m[0][1] = vup[0];
        Math3D.m[1][1] = vup[1];
        Math3D.m[2][1] = vup[2];
        Math3D.m[0][2] = vf[0];
        Math3D.m[1][2] = vf[1];
        Math3D.m[2][2] = vf[2];
        Math3D.im[0][0] = m[0][0];
        Math3D.im[0][1] = m[1][0];
        Math3D.im[0][2] = m[2][0];
        Math3D.im[1][0] = m[0][1];
        Math3D.im[1][1] = m[1][1];
        Math3D.im[1][2] = m[2][1];
        Math3D.im[2][0] = m[0][2];
        Math3D.im[2][1] = m[1][2];
        Math3D.im[2][2] = m[2][2];
        Math3D.zrot[2][1] = 0.0f;
        Math3D.zrot[2][0] = 0.0f;
        Math3D.zrot[1][2] = 0.0f;
        Math3D.zrot[0][2] = 0.0f;
        Math3D.zrot[2][2] = 1.0f;
        float f = (float)Math.cos(Math3D.DEG2RAD(degrees));
        Math3D.zrot[1][1] = f;
        Math3D.zrot[0][0] = f;
        Math3D.zrot[0][1] = (float)Math.sin(Math3D.DEG2RAD(degrees));
        Math3D.zrot[1][0] = -zrot[0][1];
        Math3D.R_ConcatRotations(m, zrot, tmpmat);
        Math3D.R_ConcatRotations(tmpmat, im, zrot);
        for (int i = 0; i < 3; ++i) {
            dst[i] = zrot[i][0] * point[0] + zrot[i][1] * point[1] + zrot[i][2] * point[2];
        }
    }

    public static void MakeNormalVectors(float[] forward, float[] right, float[] up) {
        right[1] = -forward[0];
        right[2] = forward[1];
        right[0] = forward[2];
        float d = Math3D.DotProduct(right, forward);
        Math3D.VectorMA(right, -d, forward, right);
        Math3D.VectorNormalize(right);
        Math3D.CrossProduct(right, forward, up);
    }

    public static float SHORT2ANGLE(int x) {
        return (float)x * 0.005493164f;
    }

    public static void R_ConcatTransforms(float[][] in1, float[][] in2, float[][] out) {
        out[0][0] = in1[0][0] * in2[0][0] + in1[0][1] * in2[1][0] + in1[0][2] * in2[2][0];
        out[0][1] = in1[0][0] * in2[0][1] + in1[0][1] * in2[1][1] + in1[0][2] * in2[2][1];
        out[0][2] = in1[0][0] * in2[0][2] + in1[0][1] * in2[1][2] + in1[0][2] * in2[2][2];
        out[0][3] = in1[0][0] * in2[0][3] + in1[0][1] * in2[1][3] + in1[0][2] * in2[2][3] + in1[0][3];
        out[1][0] = in1[1][0] * in2[0][0] + in1[1][1] * in2[1][0] + in1[1][2] * in2[2][0];
        out[1][1] = in1[1][0] * in2[0][1] + in1[1][1] * in2[1][1] + in1[1][2] * in2[2][1];
        out[1][2] = in1[1][0] * in2[0][2] + in1[1][1] * in2[1][2] + in1[1][2] * in2[2][2];
        out[1][3] = in1[1][0] * in2[0][3] + in1[1][1] * in2[1][3] + in1[1][2] * in2[2][3] + in1[1][3];
        out[2][0] = in1[2][0] * in2[0][0] + in1[2][1] * in2[1][0] + in1[2][2] * in2[2][0];
        out[2][1] = in1[2][0] * in2[0][1] + in1[2][1] * in2[1][1] + in1[2][2] * in2[2][1];
        out[2][2] = in1[2][0] * in2[0][2] + in1[2][1] * in2[1][2] + in1[2][2] * in2[2][2];
        out[2][3] = in1[2][0] * in2[0][3] + in1[2][1] * in2[1][3] + in1[2][2] * in2[2][3] + in1[2][3];
    }

    public static void R_ConcatRotations(float[][] in1, float[][] in2, float[][] out) {
        out[0][0] = in1[0][0] * in2[0][0] + in1[0][1] * in2[1][0] + in1[0][2] * in2[2][0];
        out[0][1] = in1[0][0] * in2[0][1] + in1[0][1] * in2[1][1] + in1[0][2] * in2[2][1];
        out[0][2] = in1[0][0] * in2[0][2] + in1[0][1] * in2[1][2] + in1[0][2] * in2[2][2];
        out[1][0] = in1[1][0] * in2[0][0] + in1[1][1] * in2[1][0] + in1[1][2] * in2[2][0];
        out[1][1] = in1[1][0] * in2[0][1] + in1[1][1] * in2[1][1] + in1[1][2] * in2[2][1];
        out[1][2] = in1[1][0] * in2[0][2] + in1[1][1] * in2[1][2] + in1[1][2] * in2[2][2];
        out[2][0] = in1[2][0] * in2[0][0] + in1[2][1] * in2[1][0] + in1[2][2] * in2[2][0];
        out[2][1] = in1[2][0] * in2[0][1] + in1[2][1] * in2[1][1] + in1[2][2] * in2[2][1];
        out[2][2] = in1[2][0] * in2[0][2] + in1[2][1] * in2[1][2] + in1[2][2] * in2[2][2];
    }

    public static void ProjectPointOnPlane(float[] dst, float[] p, float[] normal) {
        float inv_denom = 1.0f / Math3D.DotProduct(normal, normal);
        float d = Math3D.DotProduct(normal, p) * inv_denom;
        dst[0] = normal[0] * inv_denom;
        dst[1] = normal[1] * inv_denom;
        dst[2] = normal[2] * inv_denom;
        dst[0] = p[0] - d * dst[0];
        dst[1] = p[1] - d * dst[1];
        dst[2] = p[2] - d * dst[2];
    }

    public static void PerpendicularVector(float[] dst, float[] src) {
        float minelem = 1.0f;
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(src[i]) < minelem)) continue;
            pos = i;
            minelem = Math.abs(src[i]);
        }
        Math3D.ProjectPointOnPlane(dst, PLANE_XYZ[pos], src);
        Math3D.VectorNormalize(dst);
    }

    public static final int BoxOnPlaneSide(float[] emins, float[] emaxs, cplane_t p) {
        float dist2;
        float dist1;
        if (!($assertionsDisabled || emins.length == 3 && emaxs.length == 3)) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        if (p.type < 3) {
            if (p.dist <= emins[p.type]) {
                return 1;
            }
            if (p.dist >= emaxs[p.type]) {
                return 2;
            }
            return 3;
        }
        switch (p.signbits) {
            case 0: {
                dist1 = p.normal[0] * emaxs[0] + p.normal[1] * emaxs[1] + p.normal[2] * emaxs[2];
                dist2 = p.normal[0] * emins[0] + p.normal[1] * emins[1] + p.normal[2] * emins[2];
                break;
            }
            case 1: {
                dist1 = p.normal[0] * emins[0] + p.normal[1] * emaxs[1] + p.normal[2] * emaxs[2];
                dist2 = p.normal[0] * emaxs[0] + p.normal[1] * emins[1] + p.normal[2] * emins[2];
                break;
            }
            case 2: {
                dist1 = p.normal[0] * emaxs[0] + p.normal[1] * emins[1] + p.normal[2] * emaxs[2];
                dist2 = p.normal[0] * emins[0] + p.normal[1] * emaxs[1] + p.normal[2] * emins[2];
                break;
            }
            case 3: {
                dist1 = p.normal[0] * emins[0] + p.normal[1] * emins[1] + p.normal[2] * emaxs[2];
                dist2 = p.normal[0] * emaxs[0] + p.normal[1] * emaxs[1] + p.normal[2] * emins[2];
                break;
            }
            case 4: {
                dist1 = p.normal[0] * emaxs[0] + p.normal[1] * emaxs[1] + p.normal[2] * emins[2];
                dist2 = p.normal[0] * emins[0] + p.normal[1] * emins[1] + p.normal[2] * emaxs[2];
                break;
            }
            case 5: {
                dist1 = p.normal[0] * emins[0] + p.normal[1] * emaxs[1] + p.normal[2] * emins[2];
                dist2 = p.normal[0] * emaxs[0] + p.normal[1] * emins[1] + p.normal[2] * emaxs[2];
                break;
            }
            case 6: {
                dist1 = p.normal[0] * emaxs[0] + p.normal[1] * emins[1] + p.normal[2] * emins[2];
                dist2 = p.normal[0] * emins[0] + p.normal[1] * emaxs[1] + p.normal[2] * emaxs[2];
                break;
            }
            case 7: {
                dist1 = p.normal[0] * emins[0] + p.normal[1] * emins[1] + p.normal[2] * emins[2];
                dist2 = p.normal[0] * emaxs[0] + p.normal[1] * emaxs[1] + p.normal[2] * emaxs[2];
                break;
            }
            default: {
                dist2 = 0.0f;
                dist1 = 0.0f;
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"BoxOnPlaneSide bug");
                }
                break;
            }
        }
        int sides = 0;
        if (dist1 >= p.dist) {
            sides = 1;
        }
        if (dist2 < p.dist) {
            sides |= 2;
        }
        if (!$assertionsDisabled && sides == 0) {
            throw new AssertionError((Object)"BoxOnPlaneSide(): sides == 0 bug");
        }
        return sides;
    }

    public static final int BoxOnPlaneSide2(float[] emins, float[] emaxs, cplane_t p) {
        for (int i = 0; i < 3; ++i) {
            if (p.normal[i] < 0.0f) {
                Math3D.corners[0][i] = emins[i];
                Math3D.corners[1][i] = emaxs[i];
                continue;
            }
            Math3D.corners[1][i] = emins[i];
            Math3D.corners[0][i] = emaxs[i];
        }
        float dist1 = Math3D.DotProduct(p.normal, corners[0]) - p.dist;
        float dist2 = Math3D.DotProduct(p.normal, corners[1]) - p.dist;
        int sides = 0;
        if (dist1 >= 0.0f) {
            sides = 1;
        }
        if (dist2 < 0.0f) {
            sides |= 2;
        }
        return sides;
    }

    public static void AngleVectors(float[] angles, float[] forward, float[] right, float[] up) {
        float cr = (float)Math.PI / 180;
        float angle = angles[1] * cr;
        float sy = (float)Math.sin(angle);
        float cy = (float)Math.cos(angle);
        angle = angles[0] * cr;
        float sp = (float)Math.sin(angle);
        float cp = (float)Math.cos(angle);
        if (forward != null) {
            forward[0] = cp * cy;
            forward[1] = cp * sy;
            forward[2] = -sp;
        }
        if (right != null || up != null) {
            angle = angles[2] * cr;
            float sr = (float)Math.sin(angle);
            cr = (float)Math.cos(angle);
            if (right != null) {
                right[0] = -sr * sp * cy + cr * sy;
                right[1] = -sr * sp * sy + -cr * cy;
                right[2] = -sr * cp;
            }
            if (up != null) {
                up[0] = cr * sp * cy + sr * sy;
                up[1] = cr * sp * sy + -sr * cy;
                up[2] = cr * cp;
            }
        }
    }

    public static void G_ProjectSource(float[] point, float[] distance, float[] forward, float[] right, float[] result) {
        result[0] = point[0] + forward[0] * distance[0] + right[0] * distance[1];
        result[1] = point[1] + forward[1] * distance[0] + right[1] * distance[1];
        result[2] = point[2] + forward[2] * distance[0] + right[2] * distance[1] + distance[2];
    }

    public static final float DotProduct(float[] x, float[] y) {
        return x[0] * y[0] + x[1] * y[1] + x[2] * y[2];
    }

    public static void CrossProduct(float[] v1, float[] v2, float[] cross) {
        cross[0] = v1[1] * v2[2] - v1[2] * v2[1];
        cross[1] = v1[2] * v2[0] - v1[0] * v2[2];
        cross[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    public static int Q_log2(int val) {
        int answer = 0;
        while ((val >>= 1) > 0) {
            ++answer;
        }
        return answer;
    }

    public static float DEG2RAD(float in) {
        return in * (float)Math.PI / 180.0f;
    }

    public static float anglemod(float a) {
        return 0.005493164f * (float)((int)(a / 0.005493164f) & 0xFFFF);
    }

    public static int ANGLE2SHORT(float x) {
        return (int)(x / 0.005493164f) & 0xFFFF;
    }

    public static float LerpAngle(float a2, float a1, float frac) {
        if (a1 - a2 > 180.0f) {
            a1 -= 360.0f;
        }
        if (a1 - a2 < -180.0f) {
            a1 += 360.0f;
        }
        return a2 + frac * (a1 - a2);
    }

    public static float CalcFov(float fov_x, float width, float height) {
        double a = 0.0;
        if (fov_x < 1.0f || fov_x > 179.0f) {
            Com.Error(1, "Bad fov: " + fov_x);
        }
        double x = (double)width / Math.tan(fov_x * ((float)Math.PI / 360));
        a = Math.atan((double)height / x);
        return (float)(a /= 0.008726646192371845);
    }

    static {
        $assertionsDisabled = !Math3D.class.desiredAssertionStatus();
        m = new float[3][3];
        im = new float[3][3];
        tmpmat = new float[3][3];
        zrot = new float[3][3];
        vr = new float[]{0.0f, 0.0f, 0.0f};
        vup = new float[]{0.0f, 0.0f, 0.0f};
        vf = new float[]{0.0f, 0.0f, 0.0f};
        PLANE_XYZ = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        corners = new float[2][3];
    }
}

