/*
 * Decompiled with CFR 0.152.
 */
package jake2.util;

import jake2.Globals;
import jake2.qcommon.Com;
import jake2.qcommon.FS;
import jake2.util.Vargs;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Lib {
    static final byte[] nullfiller = new byte[8192];
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;

    public static String vtos(float[] v) {
        return (int)v[0] + " " + (int)v[1] + " " + (int)v[2];
    }

    public static String vtofs(float[] v) {
        return v[0] + " " + v[1] + " " + v[2];
    }

    public static String vtofsbeaty(float[] v) {
        return Com.sprintf("%8.2f %8.2f %8.2f", new Vargs().add(v[0]).add(v[1]).add(v[2]));
    }

    public static short rand() {
        return (short)Globals.rnd.nextInt(32768);
    }

    public static float crandom() {
        return (Globals.rnd.nextFloat() - 0.5f) * 2.0f;
    }

    public static float random() {
        return Globals.rnd.nextFloat();
    }

    public static float crand() {
        return (Globals.rnd.nextFloat() - 0.5f) * 2.0f;
    }

    public static int strcmp(String in1, String in2) {
        return in1.compareTo(in2);
    }

    public static float atof(String in) {
        if (in == null || in.length() == 0) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(in);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static int Q_stricmp(String in1, String in2) {
        return in1.compareToIgnoreCase(in2);
    }

    public static int atoi(String in) {
        try {
            return Integer.parseInt(in);
        }
        catch (Exception e) {
            try {
                return (int)Double.parseDouble(in);
            }
            catch (Exception e1) {
                return 0;
            }
        }
    }

    public static float[] atov(String v) {
        float[] res = new float[]{0.0f, 0.0f, 0.0f};
        String[] strres = v.split(" ");
        for (int n = 0; n < 3 && n < strres.length; ++n) {
            res[n] = Lib.atof(strres[n]);
        }
        return res;
    }

    public static int strlen(char[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != '\u0000') continue;
            return i;
        }
        return in.length;
    }

    public static int strlen(byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != 0) continue;
            return i;
        }
        return in.length;
    }

    public static String hexdumpfile(ByteBuffer bb, int len) throws IOException {
        ByteBuffer bb1 = bb.slice();
        byte[] buf = new byte[len];
        bb1.get(buf);
        return Lib.hexDump(buf, len, false);
    }

    public static String hexDump(byte[] data1, int len, boolean showAddress) {
        StringBuffer result = new StringBuffer();
        StringBuffer charfield = new StringBuffer();
        int i = 0;
        while (i < len) {
            if ((i & 0xF) == 0 && showAddress) {
                String address = Integer.toHexString(i);
                address = ("0000".substring(0, 4 - address.length()) + address).toUpperCase();
                result.append(address + ": ");
            }
            byte v = data1[i];
            result.append(Lib.hex2(v));
            result.append(" ");
            charfield.append(Lib.readableChar(v));
            if ((++i & 0xF) == 0) {
                result.append(charfield);
                result.append("\n");
                charfield.setLength(0);
                continue;
            }
            if ((i & 0xF) != 8) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public static String hex2(int i) {
        String val = Integer.toHexString(i & 0xFF);
        return ("00".substring(0, 2 - val.length()) + val).toUpperCase();
    }

    public static char readableChar(int i) {
        if (i < 32 || i > 127) {
            return '.';
        }
        return (char)i;
    }

    public static void printv(String in, float[] arr) {
        for (int n = 0; n < arr.length; ++n) {
            Com.Println(in + "[" + n + "]: " + arr[n]);
        }
    }

    public static void fwriteString(String s, int len, RandomAccessFile f) throws IOException {
        if (s == null) {
            return;
        }
        int diff = len - s.length();
        if (diff > 0) {
            f.write(Lib.stringToBytes(s));
            f.write(nullfiller, 0, diff);
        } else {
            f.write(Lib.stringToBytes(s), 0, len);
        }
    }

    public static RandomAccessFile fopen(String name, String mode) {
        try {
            return new RandomAccessFile(name, mode);
        }
        catch (Exception e) {
            Com.DPrintf("Could not open file:" + name);
            return null;
        }
    }

    public static void fclose(RandomAccessFile f) {
        try {
            f.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String freadString(RandomAccessFile f, int len) {
        byte[] buffer = new byte[len];
        FS.Read(buffer, len, f);
        return Lib.CtoJava(buffer);
    }

    public static String rightFrom(String in, char c) {
        int pos = in.lastIndexOf(c);
        if (pos == -1) {
            return "";
        }
        if (pos < in.length()) {
            return in.substring(pos + 1, in.length());
        }
        return "";
    }

    public static String leftFrom(String in, char c) {
        int pos = in.lastIndexOf(c);
        if (pos == -1) {
            return "";
        }
        if (pos < in.length()) {
            return in.substring(0, pos);
        }
        return "";
    }

    public static int rename(String oldn, String newn) {
        try {
            File f1 = new File(oldn);
            File f2 = new File(newn);
            f1.renameTo(f2);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static byte[] getIntBytes(int c) {
        byte[] b = new byte[]{(byte)(c & 0xFF), (byte)(c >>> 8 & 0xFF), (byte)(c >>> 16 & 0xFF), (byte)(c >>> 24 & 0xFF)};
        return b;
    }

    public static int getInt(byte[] b) {
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
    }

    public static float[] clone(float[] in) {
        float[] out = new float[in.length];
        if (in.length != 0) {
            System.arraycopy(in, 0, out, 0, in.length);
        }
        return out;
    }

    public static byte[] stringToBytes(String value) {
        try {
            return value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String bytesToString(byte[] value) {
        try {
            return new String(value, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String CtoJava(String old) {
        int index = old.indexOf(0);
        if (index == 0) {
            return "";
        }
        return index > 0 ? old.substring(0, index) : old;
    }

    public static String CtoJava(byte[] old) {
        return Lib.CtoJava(old, 0, old.length);
    }

    public static String CtoJava(byte[] old, int offset, int maxLenght) {
        if (old.length == 0 || old[0] == 0) {
            return "";
        }
        int i = offset;
        while (i - offset < maxLenght && old[i] != 0) {
            ++i;
        }
        return new String(old, offset, i - offset);
    }

    public static FloatBuffer newFloatBuffer(int numElements) {
        ByteBuffer bb = Lib.newByteBuffer(numElements * 4);
        return bb.asFloatBuffer();
    }

    public static FloatBuffer newFloatBuffer(int numElements, ByteOrder order) {
        ByteBuffer bb = Lib.newByteBuffer(numElements * 4, order);
        return bb.asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int numElements) {
        ByteBuffer bb = Lib.newByteBuffer(numElements * 4);
        return bb.asIntBuffer();
    }

    public static IntBuffer newIntBuffer(int numElements, ByteOrder order) {
        ByteBuffer bb = Lib.newByteBuffer(numElements * 4, order);
        return bb.asIntBuffer();
    }

    public static ByteBuffer newByteBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements);
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }

    public static ByteBuffer newByteBuffer(int numElements, ByteOrder order) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements);
        bb.order(order);
        return bb;
    }
}

