/*
 * Decompiled with CFR 0.152.
 */
package jake2.sys;

import jake2.Defines;
import jake2.Globals;
import jake2.client.CL;
import jake2.qcommon.Com;
import jake2.sys.Timer;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Sys
extends Defines {
    static File[] fdir;
    static int fileindex;
    static String findbase;
    static String findpattern;

    public static void Error(String error) {
        CL.Shutdown();
        new Exception(error).printStackTrace();
        if (!Globals.appletMode) {
            System.exit(1);
        }
    }

    public static void Quit() {
        CL.Shutdown();
        if (!Globals.appletMode) {
            System.exit(0);
        }
    }

    public static File[] FindAll(String path, int musthave, int canthave) {
        File fdir;
        int index = path.lastIndexOf(47);
        if (index != -1) {
            findbase = path.substring(0, index);
            findpattern = path.substring(index + 1, path.length());
        } else {
            findbase = path;
            findpattern = "*";
        }
        if (findpattern.equals("*.*")) {
            findpattern = "*";
        }
        if (!(fdir = new File(findbase)).exists()) {
            return null;
        }
        FileFilter filter = new FileFilter(findpattern, musthave, canthave);
        return fdir.listFiles(filter);
    }

    public static File FindFirst(String path, int musthave, int canthave) {
        if (fdir != null) {
            Sys.Error("Sys_BeginFind without close");
        }
        fdir = Sys.FindAll(path, canthave, musthave);
        fileindex = 0;
        if (fdir == null) {
            return null;
        }
        return Sys.FindNext();
    }

    public static File FindNext() {
        if (fileindex >= fdir.length) {
            return null;
        }
        return fdir[fileindex++];
    }

    public static void FindClose() {
        fdir = null;
    }

    public static void SendKeyEvents() {
        Globals.re.getKeyboardHandler().Update();
        Globals.sys_frame_time = Timer.Milliseconds();
    }

    public static String GetClipboardData() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void ConsoleOutput(String msg) {
        if (Globals.nostdout != null && Globals.nostdout.value != 0.0f) {
            return;
        }
        System.out.print(msg);
    }

    static class FileFilter
    implements FilenameFilter {
        String regexpr;
        int musthave;
        int canthave;

        FileFilter(String findpattern, int musthave, int canthave) {
            this.regexpr = this.convert2regexpr(findpattern);
            this.musthave = musthave;
            this.canthave = canthave;
        }

        public boolean accept(File dir, String name) {
            if (name.matches(this.regexpr)) {
                return this.CompareAttributes(dir, this.musthave, this.canthave);
            }
            return false;
        }

        String convert2regexpr(String pattern) {
            StringBuffer sb = new StringBuffer();
            boolean escape = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                String subst = null;
                switch (c) {
                    case '*': {
                        subst = !escape ? ".*" : "*";
                        break;
                    }
                    case '.': {
                        subst = !escape ? "\\." : ".";
                        break;
                    }
                    case '!': {
                        subst = !escape ? "^" : "!";
                        break;
                    }
                    case '?': {
                        subst = !escape ? "." : "?";
                        break;
                    }
                    case '\\': {
                        escape = !escape;
                        break;
                    }
                    default: {
                        escape = false;
                    }
                }
                if (subst != null) {
                    sb.append(subst);
                    escape = false;
                    continue;
                }
                sb.append(c);
            }
            String regexpr = sb.toString();
            try {
                Pattern.compile(regexpr);
            }
            catch (PatternSyntaxException e) {
                Com.Printf("invalid file pattern ( *.* is used instead )\n");
                return ".*";
            }
            return regexpr;
        }

        boolean CompareAttributes(File dir, int musthave, int canthave) {
            String name = dir.getName();
            return !name.equals(".") && !name.equals("..");
        }
    }
}

