/*
 * Decompiled with CFR 0.152.
 */
package jake2.sys;

import jake2.Globals;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.netadr_t;
import jake2.qcommon.sizebuf_t;
import jake2.util.Lib;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class NET {
    private static final int MAX_LOOPBACK = 4;
    private static netadr_t net_local_adr = new netadr_t();
    public static loopback_t[] loopbacks = new loopback_t[2];
    private static DatagramChannel[] ip_channels;
    private static DatagramSocket[] ip_sockets;

    public static boolean CompareAdr(netadr_t a, netadr_t b) {
        return a.ip[0] == b.ip[0] && a.ip[1] == b.ip[1] && a.ip[2] == b.ip[2] && a.ip[3] == b.ip[3] && a.port == b.port;
    }

    public static boolean CompareBaseAdr(netadr_t a, netadr_t b) {
        if (a.type != b.type) {
            return false;
        }
        if (a.type == 0) {
            return true;
        }
        if (a.type == 2) {
            return a.ip[0] == b.ip[0] && a.ip[1] == b.ip[1] && a.ip[2] == b.ip[2] && a.ip[3] == b.ip[3];
        }
        return false;
    }

    public static String AdrToString(netadr_t a) {
        StringBuffer sb = new StringBuffer();
        sb.append(a.ip[0] & 0xFF).append('.').append(a.ip[1] & 0xFF);
        sb.append('.');
        sb.append(a.ip[2] & 0xFF).append('.').append(a.ip[3] & 0xFF);
        sb.append(':').append(a.port);
        return sb.toString();
    }

    public static String BaseAdrToString(netadr_t a) {
        StringBuffer sb = new StringBuffer();
        sb.append(a.ip[0] & 0xFF).append('.').append(a.ip[1] & 0xFF);
        sb.append('.');
        sb.append(a.ip[2] & 0xFF).append('.').append(a.ip[3] & 0xFF);
        return sb.toString();
    }

    public static boolean StringToAdr(String s, netadr_t a) {
        if (s.equalsIgnoreCase("localhost") || s.equalsIgnoreCase("loopback")) {
            a.set(net_local_adr);
            return true;
        }
        try {
            String[] address = s.split(":");
            InetAddress ia = InetAddress.getByName(address[0]);
            a.ip = ia.getAddress();
            a.type = 2;
            if (address.length == 2) {
                a.port = Lib.atoi(address[1]);
            }
            return true;
        }
        catch (Exception e) {
            Com.Println(e.getMessage());
            return false;
        }
    }

    public static boolean IsLocalAddress(netadr_t adr) {
        return NET.CompareAdr(adr, net_local_adr);
    }

    public static boolean GetLoopPacket(int sock, netadr_t net_from, sizebuf_t net_message) {
        loopback_t loop = loopbacks[sock];
        if (loop.send - loop.get > 4) {
            loop.get = loop.send - 4;
        }
        if (loop.get >= loop.send) {
            return false;
        }
        int i = loop.get & 3;
        ++loop.get;
        System.arraycopy(loop.msgs[i].data, 0, net_message.data, 0, loop.msgs[i].datalen);
        net_message.cursize = loop.msgs[i].datalen;
        net_from.set(net_local_adr);
        return true;
    }

    public static void SendLoopPacket(int sock, int length, byte[] data, netadr_t to) {
        loopback_t loop = loopbacks[sock ^ 1];
        int i = loop.send & 3;
        ++loop.send;
        System.arraycopy(data, 0, loop.msgs[i].data, 0, length);
        loop.msgs[i].datalen = length;
    }

    public static boolean GetPacket(int sock, netadr_t net_from, sizebuf_t net_message) {
        if (NET.GetLoopPacket(sock, net_from, net_message)) {
            return true;
        }
        if (ip_sockets[sock] == null) {
            return false;
        }
        try {
            ByteBuffer receiveBuffer = ByteBuffer.wrap(net_message.data);
            InetSocketAddress srcSocket = (InetSocketAddress)ip_channels[sock].receive(receiveBuffer);
            if (srcSocket == null) {
                return false;
            }
            net_from.ip = srcSocket.getAddress().getAddress();
            net_from.port = srcSocket.getPort();
            net_from.type = 2;
            int packetLength = receiveBuffer.position();
            if (packetLength > net_message.maxsize) {
                Com.Println("Oversize packet from " + NET.AdrToString(net_from));
                return false;
            }
            net_message.cursize = packetLength;
            net_message.data[packetLength] = 0;
            return true;
        }
        catch (IOException e) {
            Com.DPrintf("NET_GetPacket: " + e + " from " + NET.AdrToString(net_from) + "\n");
            return false;
        }
    }

    public static void SendPacket(int sock, int length, byte[] data, netadr_t to) {
        if (to.type == 0) {
            NET.SendLoopPacket(sock, length, data, to);
            return;
        }
        if (ip_sockets[sock] == null) {
            return;
        }
        if (to.type != 1 && to.type != 2) {
            Com.Error(0, "NET_SendPacket: bad address type");
            return;
        }
        try {
            InetSocketAddress dstSocket = new InetSocketAddress(to.getInetAddress(), to.port);
            ip_channels[sock].send(ByteBuffer.wrap(data, 0, length), dstSocket);
        }
        catch (Exception e) {
            Com.Println("NET_SendPacket ERROR: " + e + " to " + NET.AdrToString(to));
        }
    }

    public static void OpenIP() {
        cvar_t port = Cvar.Get("port", "27910", 8);
        cvar_t ip = Cvar.Get("ip", "localhost", 8);
        cvar_t clientport = Cvar.Get("clientport", "27901", 8);
        if (ip_sockets[1] == null) {
            NET.ip_sockets[1] = NET.Socket(1, ip.string, (int)port.value);
        }
        if (ip_sockets[0] == null) {
            NET.ip_sockets[0] = NET.Socket(0, ip.string, (int)clientport.value);
        }
        if (ip_sockets[0] == null) {
            NET.ip_sockets[0] = NET.Socket(0, ip.string, -1);
        }
    }

    public static void Config(boolean multiplayer) {
        if (!multiplayer) {
            for (int i = 0; i < 2; ++i) {
                if (ip_sockets[i] == null) continue;
                ip_sockets[i].close();
                NET.ip_sockets[i] = null;
            }
        } else {
            NET.OpenIP();
        }
    }

    public static void Init() {
    }

    public static DatagramSocket Socket(int sock, String ip, int port) {
        DatagramSocket newsocket = null;
        try {
            if (ip_channels[sock] == null || !ip_channels[sock].isOpen()) {
                NET.ip_channels[sock] = DatagramChannel.open();
            }
            if (ip == null || ip.length() == 0 || ip.equals("localhost")) {
                if (port == -1) {
                    newsocket = ip_channels[sock].socket();
                    newsocket.bind(new InetSocketAddress(0));
                } else {
                    newsocket = ip_channels[sock].socket();
                    newsocket.bind(new InetSocketAddress(port));
                }
            } else {
                InetAddress ia = InetAddress.getByName(ip);
                newsocket = ip_channels[sock].socket();
                newsocket.bind(new InetSocketAddress(ia, port));
            }
            ip_channels[sock].configureBlocking(false);
            newsocket.setBroadcast(true);
        }
        catch (Exception e) {
            Com.Println("Error: " + e.toString());
            newsocket = null;
        }
        return newsocket;
    }

    public static void Shutdown() {
        NET.Config(false);
    }

    public static void Sleep(int msec) {
        if (ip_sockets[1] == null || Globals.dedicated != null && Globals.dedicated.value == 0.0f) {
            return;
        }
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        NET.loopbacks[0] = new loopback_t();
        NET.loopbacks[1] = new loopback_t();
        ip_channels = new DatagramChannel[]{null, null};
        ip_sockets = new DatagramSocket[]{null, null};
    }

    public static class loopback_t {
        loopmsg_t[] msgs = new loopmsg_t[4];
        int get;
        int send;

        public loopback_t() {
            for (int n = 0; n < 4; ++n) {
                this.msgs[n] = new loopmsg_t();
            }
        }
    }

    public static class loopmsg_t {
        byte[] data = new byte[1400];
        int datalen;
    }
}

