/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.lwjgl;

import jake2.Globals;
import jake2.util.Math3D;

public class PlaySound {
    static final int MAX_PLAYSOUNDS = 128;
    private static PlaySound freeList;
    private static PlaySound playableList;
    private static PlaySound[] backbuffer;
    int type;
    int entnum;
    int entchannel;
    int bufferId;
    float volume;
    float attenuation;
    float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private long beginTime;
    private PlaySound prev = null;
    private PlaySound next = null;

    private PlaySound() {
        this.clear();
    }

    private void clear() {
        this.entchannel = -1;
        this.entnum = -1;
        this.bufferId = -1;
        this.type = -1;
        this.beginTime = 0L;
        this.attenuation = 0L;
    }

    static void reset() {
        PlaySound.freeList.next = PlaySound.freeList.prev = freeList;
        PlaySound.playableList.next = PlaySound.playableList.prev = playableList;
        for (int i = 0; i < backbuffer.length; ++i) {
            PlaySound ps = backbuffer[i];
            ps.clear();
            ps.prev = freeList;
            ps.next = PlaySound.freeList.next;
            ps.prev.next = ps;
            ps.next.prev = ps;
        }
    }

    static PlaySound nextPlayableSound() {
        PlaySound ps = null;
        ps = PlaySound.playableList.next;
        if (ps == playableList || ps.beginTime > (long)Globals.cl.time) {
            return null;
        }
        PlaySound.release(ps);
        return ps;
    }

    private static PlaySound get() {
        PlaySound ps = PlaySound.freeList.next;
        if (ps == freeList) {
            return null;
        }
        ps.prev.next = ps.next;
        ps.next.prev = ps.prev;
        return ps;
    }

    private static void add(PlaySound ps) {
        PlaySound sort = PlaySound.playableList.next;
        while (sort != playableList && sort.beginTime < ps.beginTime) {
            sort = sort.next;
        }
        ps.next = sort;
        ps.prev = sort.prev;
        ps.next.prev = ps;
        ps.prev.next = ps;
    }

    private static void release(PlaySound ps) {
        ps.prev.next = ps.next;
        ps.next.prev = ps.prev;
        ps.next = PlaySound.freeList.next;
        PlaySound.freeList.next.prev = ps;
        ps.prev = freeList;
        PlaySound.freeList.next = ps;
    }

    static void allocate(float[] origin, int entnum, int entchannel, int bufferId, float volume, float attenuation, float timeoffset) {
        PlaySound ps = PlaySound.get();
        if (ps != null) {
            if (entnum == Globals.cl.playernum + 1) {
                ps.type = 0;
            } else if (origin != null) {
                ps.type = 1;
                Math3D.VectorCopy(origin, ps.origin);
            } else {
                ps.type = 2;
            }
            ps.entnum = entnum;
            ps.entchannel = entchannel;
            ps.bufferId = bufferId;
            ps.volume = volume;
            ps.attenuation = attenuation;
            ps.beginTime = (long)Globals.cl.time + (long)(timeoffset * 1000.0f);
            PlaySound.add(ps);
        } else {
            System.err.println("PlaySounds out of Limit");
        }
    }

    static {
        backbuffer = new PlaySound[128];
        for (int i = 0; i < backbuffer.length; ++i) {
            PlaySound.backbuffer[i] = new PlaySound();
        }
        freeList = new PlaySound();
        playableList = new PlaySound();
        PlaySound.reset();
    }
}

