/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.lwjgl;

import jake2.Globals;
import jake2.client.CL_ents;
import jake2.game.entity_state_t;
import jake2.qcommon.Com;
import jake2.sound.lwjgl.PlaySound;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;

public class Channel {
    static final int LISTENER = 0;
    static final int FIXED = 1;
    static final int DYNAMIC = 2;
    static final int MAX_CHANNELS = 32;
    private static final FloatBuffer NULLVECTOR = Lib.newFloatBuffer(3);
    private static Channel[] channels = new Channel[32];
    private static IntBuffer sources = Lib.newIntBuffer(32);
    private static IntBuffer buffers;
    private static Map looptable;
    private static int numChannels;
    private static boolean streamingEnabled;
    private static int streamQueue;
    private int type;
    private int entnum;
    private int entchannel;
    private int bufferId;
    private int sourceId;
    private float volume;
    private float rolloff;
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private boolean autosound;
    private boolean active;
    private boolean modified;
    private boolean bufferChanged;
    private boolean volumeChanged;
    private static IntBuffer tmp;
    private static FloatBuffer sourceOriginBuffer;
    private static float[] entityOrigin;

    private Channel(int sourceId) {
        this.sourceId = sourceId;
        this.clear();
        this.volumeChanged = false;
        this.volume = 1.0f;
    }

    private void clear() {
        this.bufferId = -1;
        this.entchannel = -1;
        this.entnum = -1;
        this.bufferChanged = false;
        this.rolloff = 0.0f;
        this.autosound = false;
        this.active = false;
        this.modified = false;
    }

    static int init(IntBuffer buffers) {
        Channel.buffers = buffers;
        numChannels = 0;
        for (int i = 0; i < 32; ++i) {
            int sourceId;
            try {
                AL10.alGenSources((IntBuffer)tmp);
                sourceId = tmp.get(0);
                if (sourceId <= 0) {
                }
            }
            catch (OpenALException e) {}
            break;
            sources.put(i, sourceId);
            Channel.channels[i] = new Channel(sourceId);
            ++numChannels;
            AL10.alSourcef((int)sourceId, (int)4106, (float)1.0f);
            AL10.alSourcef((int)sourceId, (int)4099, (float)1.0f);
            AL10.alSourcei((int)sourceId, (int)514, (int)0);
            AL10.alSource((int)sourceId, (int)4102, (FloatBuffer)NULLVECTOR);
            AL10.alSourcei((int)sourceId, (int)4103, (int)0);
            AL10.alSourcef((int)sourceId, (int)4128, (float)200.0f);
            AL10.alSourcef((int)sourceId, (int)4109, (float)5.0E-4f);
            AL10.alSourcef((int)sourceId, (int)4110, (float)1.0f);
        }
        sources.limit(numChannels);
        return numChannels;
    }

    static void reset() {
        for (int i = 0; i < numChannels; ++i) {
            AL10.alSourceStop((int)sources.get(i));
            AL10.alSourcei((int)sources.get(i), (int)4105, (int)0);
            channels[i].clear();
        }
    }

    static void shutdown() {
        AL10.alDeleteSources((IntBuffer)sources);
        numChannels = 0;
    }

    static void enableStreaming() {
        if (streamingEnabled) {
            return;
        }
        streamingEnabled = true;
        streamQueue = 0;
        int source = Channel.channels[--Channel.numChannels].sourceId;
        AL10.alSourcei((int)source, (int)514, (int)1);
        AL10.alSourcef((int)source, (int)4106, (float)1.0f);
        Channel.channels[Channel.numChannels].volumeChanged = true;
        Com.DPrintf("streaming enabled\n");
    }

    static void disableStreaming() {
        if (!streamingEnabled) {
            return;
        }
        Channel.unqueueStreams();
        int source = Channel.channels[Channel.numChannels].sourceId;
        AL10.alSourcei((int)source, (int)514, (int)0);
        ++numChannels;
        streamingEnabled = false;
        Com.DPrintf("streaming disabled\n");
    }

    static void unqueueStreams() {
        if (!streamingEnabled) {
            return;
        }
        int source = Channel.channels[Channel.numChannels].sourceId;
        AL10.alSourceStop((int)source);
        int count = AL10.alGetSourcei((int)source, (int)4117);
        Com.DPrintf("unqueue " + count + " buffers\n");
        while (count-- > 0) {
            AL10.alSourceUnqueueBuffers((int)source, (IntBuffer)tmp);
        }
        streamQueue = 0;
    }

    static void updateStream(ByteBuffer samples, int count, int format, int rate) {
        Channel.enableStreaming();
        int source = Channel.channels[Channel.numChannels].sourceId;
        int processed = AL10.alGetSourcei((int)source, (int)4118);
        boolean playing = AL10.alGetSourcei((int)source, (int)4112) == 4114;
        boolean interupted = !playing && streamQueue > 2;
        IntBuffer buffer = tmp;
        if (interupted) {
            Channel.unqueueStreams();
            buffer.put(0, buffers.get(512 + streamQueue++));
            Com.DPrintf("queue " + (streamQueue - 1) + '\n');
        } else if (processed < 2) {
            if (streamQueue >= 8) {
                return;
            }
            buffer.put(0, buffers.get(512 + streamQueue++));
            Com.DPrintf("queue " + (streamQueue - 1) + '\n');
        } else {
            AL10.alSourceUnqueueBuffers((int)source, (IntBuffer)buffer);
        }
        samples.position(0);
        samples.limit(count);
        AL10.alBufferData((int)buffer.get(0), (int)format, (ByteBuffer)samples, (int)rate);
        AL10.alSourceQueueBuffers((int)source, (IntBuffer)buffer);
        if (streamQueue > 1 && !playing) {
            Com.DPrintf("start sound\n");
            AL10.alSourcePlay((int)source);
        }
    }

    static void addPlaySounds() {
        while (Channel.assign(PlaySound.nextPlayableSound())) {
        }
    }

    private static boolean assign(PlaySound ps) {
        int i;
        if (ps == null) {
            return false;
        }
        Channel ch = null;
        for (i = 0; i < numChannels; ++i) {
            ch = channels[i];
            if (ps.entchannel != 0 && ch.entnum == ps.entnum && ch.entchannel == ps.entchannel) {
                if (ch.bufferId == ps.bufferId) break;
                AL10.alSourceStop((int)ch.sourceId);
                break;
            }
            if ((ch.entnum != Globals.cl.playernum + 1 || ps.entnum == Globals.cl.playernum + 1 || ch.bufferId == -1) && !ch.active) break;
        }
        if (i == numChannels) {
            return false;
        }
        ch.type = ps.type;
        if (ps.type == 1) {
            Math3D.VectorCopy(ps.origin, ch.origin);
        }
        ch.entnum = ps.entnum;
        ch.entchannel = ps.entchannel;
        ch.bufferChanged = ch.bufferId != ps.bufferId;
        ch.bufferId = ps.bufferId;
        ch.rolloff = ps.attenuation * 2.0f;
        ch.volumeChanged = ch.volume != ps.volume;
        ch.volume = ps.volume;
        ch.active = true;
        ch.modified = true;
        return true;
    }

    private static Channel pickForLoop(int bufferId, float attenuation) {
        for (int i = 0; i < numChannels; ++i) {
            Channel ch = channels[i];
            if (ch.active) continue;
            ch.entnum = 0;
            ch.entchannel = 0;
            ch.bufferChanged = ch.bufferId != bufferId;
            ch.bufferId = bufferId;
            ch.volumeChanged = ch.volume != 1.0f;
            ch.volume = 1.0f;
            ch.rolloff = attenuation * 2.0f;
            ch.active = true;
            ch.modified = true;
            return ch;
        }
        return null;
    }

    static void playAllSounds(FloatBuffer listenerOrigin) {
        FloatBuffer sourceOrigin = sourceOriginBuffer;
        for (int i = 0; i < numChannels; ++i) {
            Channel ch = channels[i];
            if (!ch.active) continue;
            int sourceId = ch.sourceId;
            switch (ch.type) {
                case 0: {
                    sourceOrigin.put(0, listenerOrigin.get(0));
                    sourceOrigin.put(1, listenerOrigin.get(1));
                    sourceOrigin.put(2, listenerOrigin.get(2));
                    break;
                }
                case 2: {
                    CL_ents.GetEntitySoundOrigin(ch.entnum, entityOrigin);
                    Channel.convertVector(entityOrigin, sourceOrigin);
                    break;
                }
                case 1: {
                    Channel.convertVector(ch.origin, sourceOrigin);
                }
            }
            if (ch.modified) {
                if (ch.bufferChanged) {
                    try {
                        AL10.alSourcei((int)sourceId, (int)4105, (int)ch.bufferId);
                    }
                    catch (OpenALException e) {
                        AL10.alSourceStop((int)sourceId);
                        AL10.alSourcei((int)sourceId, (int)4105, (int)ch.bufferId);
                    }
                }
                if (ch.volumeChanged) {
                    AL10.alSourcef((int)sourceId, (int)4106, (float)ch.volume);
                }
                AL10.alSourcef((int)sourceId, (int)4129, (float)ch.rolloff);
                AL10.alSource((int)sourceId, (int)4100, (FloatBuffer)sourceOrigin);
                AL10.alSourcePlay((int)sourceId);
                ch.modified = false;
            } else {
                int state = AL10.alGetSourcei((int)sourceId, (int)4112);
                if (state == 4114) {
                    AL10.alSource((int)sourceId, (int)4100, (FloatBuffer)sourceOrigin);
                } else {
                    ch.clear();
                }
            }
            ch.autosound = false;
        }
    }

    static void addLoopSounds() {
        if (Globals.cl_paused.value != 0.0f || Globals.cls.state != 4 || !Globals.cl.sound_prepped) {
            Channel.removeUnusedLoopSounds();
            return;
        }
        int sound = 0;
        for (int i = 0; i < Globals.cl.frame.num_entities; ++i) {
            sfxcache_t sc;
            int num = Globals.cl.frame.parse_entities + i & 0x3FF;
            entity_state_t ent = Globals.cl_parse_entities[num];
            sound = ent.sound;
            if (sound == 0) continue;
            Integer key = new Integer(ent.number);
            Channel ch = (Channel)looptable.get(key);
            if (ch != null) {
                ch.autosound = true;
                Math3D.VectorCopy(ent.origin, ch.origin);
                continue;
            }
            sfx_t sfx = Globals.cl.sound_precache[sound];
            if (sfx == null || (sc = sfx.cache) == null) continue;
            ch = Channel.pickForLoop(buffers.get(sfx.bufferId), 6.0f);
            if (ch == null) break;
            ch.type = 1;
            Math3D.VectorCopy(ent.origin, ch.origin);
            ch.autosound = true;
            looptable.put(key, ch);
            AL10.alSourcei((int)ch.sourceId, (int)4103, (int)1);
        }
        Channel.removeUnusedLoopSounds();
    }

    private static void removeUnusedLoopSounds() {
        Iterator iter = looptable.values().iterator();
        while (iter.hasNext()) {
            Channel ch = (Channel)iter.next();
            if (ch.autosound) continue;
            AL10.alSourceStop((int)ch.sourceId);
            AL10.alSourcei((int)ch.sourceId, (int)4103, (int)0);
            iter.remove();
            ch.clear();
        }
    }

    static void convertVector(float[] from, FloatBuffer to) {
        to.put(0, from[0]);
        to.put(1, from[2]);
        to.put(2, -from[1]);
    }

    static void convertOrientation(float[] forward, float[] up, FloatBuffer orientation) {
        orientation.put(0, forward[0]);
        orientation.put(1, forward[2]);
        orientation.put(2, -forward[1]);
        orientation.put(3, up[0]);
        orientation.put(4, up[2]);
        orientation.put(5, -up[1]);
    }

    static {
        looptable = new Hashtable(32);
        streamingEnabled = false;
        streamQueue = 0;
        tmp = Lib.newIntBuffer(1);
        sourceOriginBuffer = Lib.newFloatBuffer(3);
        entityOrigin = new float[]{0.0f, 0.0f, 0.0f};
    }
}

