/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.jsound;

import jake2.game.cvar_t;
import jake2.sound.WaveLoader;
import jake2.sound.jsound.SND_DMA;
import jake2.sound.jsound.SND_JAVA;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;
import jake2.util.Math3D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class SND_MIX
extends SND_JAVA {
    static final int MAX_CHANNELS = 32;
    static final int MAX_RAW_SAMPLES = 8192;
    static cvar_t s_volume;
    static int s_rawend;
    static final int PAINTBUFFER_SIZE = 2048;
    static IntBuffer paintbuffer;
    static int[][] snd_scaletable;
    static IntBuffer snd_p;
    static ShortBuffer snd_out;
    static int snd_linear_count;
    static int snd_vol;
    static int paintedtime;
    static playsound_t s_pendingplays;
    static IntBuffer s_rawsamples;
    static channel_t[] channels;
    private static ByteBuffer bb;
    private static ShortBuffer sb;

    static void WriteLinearBlastStereo16() {
        for (int i = 0; i < snd_linear_count; i += 2) {
            int val = snd_p.get(i) >> 8;
            if (val > Short.MAX_VALUE) {
                snd_out.put(i, (short)Short.MAX_VALUE);
            } else if (val < Short.MIN_VALUE) {
                snd_out.put(i, (short)Short.MIN_VALUE);
            } else {
                snd_out.put(i, (short)val);
            }
            val = snd_p.get(i + 1) >> 8;
            if (val > Short.MAX_VALUE) {
                snd_out.put(i + 1, (short)Short.MAX_VALUE);
                continue;
            }
            if (val < Short.MIN_VALUE) {
                snd_out.put(i + 1, (short)Short.MIN_VALUE);
                continue;
            }
            snd_out.put(i + 1, (short)val);
        }
    }

    static void TransferStereo16(ByteBuffer pbuf, int endtime) {
        snd_p = paintbuffer;
        for (int lpaintedtime = paintedtime; lpaintedtime < endtime; lpaintedtime += snd_linear_count >> 1) {
            int lpos = lpaintedtime & (SND_MIX.dma.samples >> 1) - 1;
            snd_out = pbuf.asShortBuffer();
            snd_out.position(lpos << 1);
            snd_out = snd_out.slice();
            snd_linear_count = (SND_MIX.dma.samples >> 1) - lpos;
            if (lpaintedtime + snd_linear_count > endtime) {
                snd_linear_count = endtime - lpaintedtime;
            }
            SND_MIX.WriteLinearBlastStereo16();
            paintbuffer.position(snd_linear_count <<= 1);
            snd_p = paintbuffer.slice();
        }
    }

    static void TransferPaintBuffer(int endtime) {
        block11: {
            int step;
            int out_idx;
            int out_mask;
            int count;
            int p;
            ByteBuffer pbuf;
            block12: {
                block10: {
                    pbuf = ByteBuffer.wrap(SND_MIX.dma.buffer);
                    pbuf.order(ByteOrder.LITTLE_ENDIAN);
                    if (SND_DMA.s_testsound.value != 0.0f) {
                        int count2 = (endtime - paintedtime) * 2;
                        for (int i = 0; i < count2; i += 2) {
                            int v = (int)(Math.sin((double)(paintedtime + i) * 0.1) * 20000.0 * 256.0);
                            paintbuffer.put(i, v);
                            paintbuffer.put(i + 1, v);
                        }
                    }
                    if (SND_MIX.dma.samplebits != 16 || SND_MIX.dma.channels != 2) break block10;
                    SND_MIX.TransferStereo16(pbuf, endtime);
                    break block11;
                }
                p = 0;
                count = (endtime - paintedtime) * SND_MIX.dma.channels;
                out_mask = SND_MIX.dma.samples - 1;
                out_idx = paintedtime * SND_MIX.dma.channels & out_mask;
                step = 3 - SND_MIX.dma.channels;
                if (SND_MIX.dma.samplebits != 16) break block12;
                ShortBuffer out = pbuf.asShortBuffer();
                while (count-- > 0) {
                    int val = paintbuffer.get(p) >> 8;
                    p += step;
                    if (val > Short.MAX_VALUE) {
                        val = Short.MAX_VALUE;
                    } else if (val < Short.MIN_VALUE) {
                        val = Short.MIN_VALUE;
                    }
                    out.put(out_idx, (short)val);
                    out_idx = out_idx + 1 & out_mask;
                }
                break block11;
            }
            if (SND_MIX.dma.samplebits != 8) break block11;
            ByteBuffer out = pbuf;
            while (count-- > 0) {
                int val = paintbuffer.get(p) >> 8;
                p += step;
                if (val > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                } else if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                out.put(out_idx, (byte)(val >>> 8));
                out_idx = out_idx + 1 & out_mask;
            }
        }
    }

    static void PaintChannels(int endtime) {
        snd_vol = (int)(SND_MIX.s_volume.value * 256.0f);
        while (paintedtime < endtime) {
            int i;
            playsound_t ps;
            int end = endtime;
            if (endtime - paintedtime > 2048) {
                end = paintedtime + 2048;
            }
            while ((ps = SND_MIX.s_pendingplays.next) != s_pendingplays) {
                if (ps.begin <= (long)paintedtime) {
                    SND_DMA.IssuePlaysound(ps);
                    continue;
                }
                if (ps.begin >= (long)end) break;
                end = (int)ps.begin;
                break;
            }
            if (s_rawend < paintedtime) {
                for (i = 0; i < (end - paintedtime) * 2; ++i) {
                    paintbuffer.put(i, 0);
                }
            } else {
                int stop = end < s_rawend ? end : s_rawend;
                for (i = paintedtime; i < stop; ++i) {
                    int s = i & 0x1FFF;
                    paintbuffer.put((i - paintedtime) * 2, s_rawsamples.get(2 * s));
                    paintbuffer.put((i - paintedtime) * 2 + 1, s_rawsamples.get(2 * s) + 1);
                }
                while (i < end) {
                    paintbuffer.put((i - paintedtime) * 2, 0);
                    paintbuffer.put((i - paintedtime) * 2 + 1, 0);
                    ++i;
                }
            }
            block5: for (i = 0; i < 32; ++i) {
                channel_t ch = channels[i];
                int ltime = paintedtime;
                while (ltime < end && ch.sfx != null && (ch.leftvol != 0 || ch.rightvol != 0)) {
                    sfxcache_t sc;
                    int count = end - ltime;
                    if (ch.end - ltime < count) {
                        count = ch.end - ltime;
                    }
                    if ((sc = WaveLoader.LoadSound(ch.sfx)) == null) continue block5;
                    if (count > 0 && ch.sfx != null) {
                        if (sc.width == 1) {
                            SND_MIX.PaintChannelFrom8(ch, sc, count, ltime - paintedtime);
                        } else {
                            SND_MIX.PaintChannelFrom16(ch, sc, count, ltime - paintedtime);
                        }
                        ltime += count;
                    }
                    if (ltime < ch.end) continue;
                    if (ch.autosound) {
                        ch.pos = 0;
                        ch.end = ltime + sc.length;
                        continue;
                    }
                    if (sc.loopstart >= 0) {
                        ch.pos = sc.loopstart;
                        ch.end = ltime + sc.length - ch.pos;
                        continue;
                    }
                    ch.sfx = null;
                }
            }
            SND_MIX.TransferPaintBuffer(end);
            paintedtime = end;
        }
    }

    static void InitScaletable() {
        SND_MIX.s_volume.modified = false;
        for (int i = 0; i < 32; ++i) {
            int scale = (int)((float)(i * 8 * 256) * SND_MIX.s_volume.value);
            for (int j = 0; j < 256; ++j) {
                SND_MIX.snd_scaletable[i][j] = (byte)j * scale;
            }
        }
    }

    static void PaintChannelFrom8(channel_t ch, sfxcache_t sc, int count, int offset) {
        if (ch.leftvol > 255) {
            ch.leftvol = 255;
        }
        if (ch.rightvol > 255) {
            ch.rightvol = 255;
        }
        int[] lscale = snd_scaletable[ch.leftvol >> 3];
        int[] rscale = snd_scaletable[ch.rightvol >> 3];
        int sfx = ch.pos;
        int i = 0;
        while (i < count) {
            int left = paintbuffer.get(offset * 2);
            int right = paintbuffer.get(offset * 2 + 1);
            byte data = sc.data[sfx + i];
            paintbuffer.put(offset * 2, left += lscale[data]);
            paintbuffer.put(offset * 2 + 1, right += rscale[data]);
            ++i;
            ++offset;
        }
        ch.pos += count;
    }

    static void PaintChannelFrom16(channel_t ch, sfxcache_t sc, int count, int offset) {
        int leftvol = ch.leftvol * snd_vol;
        int rightvol = ch.rightvol * snd_vol;
        ByteBuffer bb = ByteBuffer.wrap(sc.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        sb = bb.asShortBuffer();
        int sfx = ch.pos;
        int i = 0;
        while (i < count) {
            int left = paintbuffer.get(offset * 2);
            int right = paintbuffer.get(offset * 2 + 1);
            short data = sb.get(sfx + i);
            paintbuffer.put(offset * 2, left += data * leftvol >> 8);
            paintbuffer.put(offset * 2 + 1, right += data * rightvol >> 8);
            ++i;
            ++offset;
        }
        ch.pos += count;
    }

    static {
        paintbuffer = IntBuffer.allocate(4096);
        snd_scaletable = new int[32][256];
        s_pendingplays = new playsound_t();
        s_rawsamples = IntBuffer.allocate(16384);
        channels = new channel_t[32];
        for (int i = 0; i < 32; ++i) {
            SND_MIX.channels[i] = new channel_t();
        }
    }

    static class portable_samplepair_t {
        int left;
        int right;

        portable_samplepair_t() {
        }
    }

    static class channel_t {
        sfx_t sfx;
        int leftvol;
        int rightvol;
        int end;
        int pos;
        int looping;
        int entnum;
        int entchannel;
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        float dist_mult;
        int master_vol;
        boolean fixed_origin;
        boolean autosound;

        channel_t() {
        }

        void clear() {
            this.sfx = null;
            this.master_vol = 0;
            this.entchannel = 0;
            this.entnum = 0;
            this.looping = 0;
            this.pos = 0;
            this.end = 0;
            this.rightvol = 0;
            this.leftvol = 0;
            this.dist_mult = 0;
            Math3D.VectorClear(this.origin);
            this.autosound = false;
            this.fixed_origin = false;
        }
    }

    static class playsound_t {
        playsound_t prev;
        playsound_t next;
        sfx_t sfx;
        float volume;
        float attenuation;
        int entnum;
        int entchannel;
        boolean fixed_origin;
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        long begin;

        playsound_t() {
        }

        public void clear() {
            this.next = null;
            this.prev = null;
            this.sfx = null;
            this.entchannel = 0;
            this.entnum = 0;
            this.begin = 0;
            this.volume = this.attenuation = (float)this.begin;
            this.fixed_origin = false;
            Math3D.VectorClear(this.origin);
        }
    }
}

