/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.jsound;

import jake2.Globals;
import jake2.game.cvar_t;
import jake2.qcommon.Cvar;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SND_JAVA
extends Globals {
    static boolean snd_inited = false;
    static cvar_t sndbits;
    static cvar_t sndspeed;
    static cvar_t sndchannels;
    static dma_t dma;
    static SoundThread thread;
    static SourceDataLine line;
    static AudioFormat format;

    static boolean SNDDMA_Init() {
        if (snd_inited) {
            return true;
        }
        if (sndbits == null) {
            sndbits = Cvar.Get("sndbits", "16", 1);
            sndspeed = Cvar.Get("sndspeed", "0", 1);
            sndchannels = Cvar.Get("sndchannels", "1", 1);
        }
        format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, false);
        DataLine.Info dinfo = new DataLine.Info(SourceDataLine.class, format);
        try {
            line = (SourceDataLine)AudioSystem.getLine(dinfo);
        }
        catch (LineUnavailableException e4) {
            return false;
        }
        SND_JAVA.dma.buffer = new byte[65536];
        SND_JAVA.dma.channels = format.getChannels();
        SND_JAVA.dma.samplebits = format.getSampleSizeInBits();
        SND_JAVA.dma.samples = SND_JAVA.dma.buffer.length / format.getFrameSize();
        SND_JAVA.dma.speed = (int)format.getSampleRate();
        SND_JAVA.dma.submission_chunk = 1;
        try {
            line.open(format, 4096);
        }
        catch (LineUnavailableException e5) {
            return false;
        }
        line.start();
        thread = new SoundThread(SND_JAVA.dma.buffer, line);
        thread.start();
        snd_inited = true;
        return true;
    }

    static int SNDDMA_GetDMAPos() {
        return thread.getSamplePos();
    }

    static void SNDDMA_Shutdown() {
        thread.stopLoop();
        line.stop();
        line.flush();
        line.close();
        line = null;
        snd_inited = false;
    }

    public static void SNDDMA_Submit() {
    }

    static void SNDDMA_BeginPainting() {
    }

    static {
        dma = new dma_t();
    }

    static class SoundThread
    extends Thread {
        byte[] b;
        SourceDataLine l;
        int pos = 0;
        boolean running = false;

        public SoundThread(byte[] buffer, SourceDataLine line) {
            this.b = buffer;
            this.l = line;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                line.write(this.b, this.pos, 512);
                this.pos = (this.pos + 512) % this.b.length;
            }
        }

        public synchronized void stopLoop() {
            this.running = false;
        }

        public int getSamplePos() {
            return this.pos >> 1;
        }
    }

    static class dma_t {
        int channels;
        int samples;
        int submission_chunk;
        int samplebits;
        int speed;
        byte[] buffer;

        dma_t() {
        }
    }
}

