/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.jsound;

import jake2.client.CL_ents;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.game.entity_state_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.xcommand_t;
import jake2.sound.WaveLoader;
import jake2.sound.jsound.SND_MIX;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;
import jake2.util.Math3D;
import jake2.util.Vargs;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class SND_DMA
extends SND_MIX {
    static final int SOUND_FULLVOLUME = 80;
    static final float SOUND_LOOPATTENUATE = 0.003f;
    static int s_registration_sequence;
    static boolean sound_started;
    static float[] listener_origin;
    static float[] listener_forward;
    static float[] listener_right;
    static float[] listener_up;
    static boolean s_registering;
    static int soundtime;
    static final int MAX_SFX = 512;
    static sfx_t[] known_sfx;
    static int num_sfx;
    static final int MAX_PLAYSOUNDS = 128;
    static SND_MIX.playsound_t[] s_playsounds;
    static SND_MIX.playsound_t s_freeplays;
    static int s_beginofs;
    static cvar_t s_testsound;
    static cvar_t s_loadas8bit;
    static cvar_t s_khz;
    static cvar_t s_show;
    static cvar_t s_mixahead;
    static cvar_t s_primary;
    static int buffers;
    static int oldsamplepos;

    static void SoundInfo_f() {
        if (!sound_started) {
            Com.Printf("sound system not started\n");
            return;
        }
        Com.Printf("%5d stereo\n", new Vargs(1).add(SND_DMA.dma.channels - 1));
        Com.Printf("%5d samples\n", new Vargs(1).add(SND_DMA.dma.samples));
        Com.Printf("%5d samplebits\n", new Vargs(1).add(SND_DMA.dma.samplebits));
        Com.Printf("%5d submission_chunk\n", new Vargs(1).add(SND_DMA.dma.submission_chunk));
        Com.Printf("%5d speed\n", new Vargs(1).add(SND_DMA.dma.speed));
    }

    public static void Init() {
        Com.Printf("\n------- sound initialization -------\n");
        cvar_t cv = Cvar.Get("s_initsound", "0", 0);
        if (cv.value == 0.0f) {
            Com.Printf("not initializing.\n");
        } else {
            s_volume = Cvar.Get("s_volume", "0.7", 1);
            s_khz = Cvar.Get("s_khz", "11", 1);
            s_loadas8bit = Cvar.Get("s_loadas8bit", "1", 1);
            s_mixahead = Cvar.Get("s_mixahead", "0.2", 1);
            s_show = Cvar.Get("s_show", "0", 0);
            s_testsound = Cvar.Get("s_testsound", "0", 0);
            s_primary = Cvar.Get("s_primary", "0", 1);
            Cmd.AddCommand("play", new xcommand_t(){

                public void execute() {
                    SND_DMA.Play();
                }
            });
            Cmd.AddCommand("stopsound", new xcommand_t(){

                public void execute() {
                    SND_DMA.StopAllSounds();
                }
            });
            Cmd.AddCommand("soundlist", new xcommand_t(){

                public void execute() {
                    SND_DMA.SoundList();
                }
            });
            Cmd.AddCommand("soundinfo", new xcommand_t(){

                public void execute() {
                    SND_DMA.SoundInfo_f();
                }
            });
            if (!SND_DMA.SNDDMA_Init()) {
                return;
            }
            SND_DMA.InitScaletable();
            sound_started = true;
            num_sfx = 0;
            soundtime = 0;
            paintedtime = 0;
            Com.Printf("sound sampling rate: " + SND_DMA.dma.speed + "\n");
            SND_DMA.StopAllSounds();
        }
        Com.Printf("------------------------------------\n");
    }

    public static void Shutdown() {
        if (!sound_started) {
            return;
        }
        SND_DMA.SNDDMA_Shutdown();
        sound_started = false;
        Cmd.RemoveCommand("play");
        Cmd.RemoveCommand("stopsound");
        Cmd.RemoveCommand("soundlist");
        Cmd.RemoveCommand("soundinfo");
        sfx_t[] sfx = known_sfx;
        for (int i = 0; i < num_sfx; ++i) {
            if (sfx[i].name == null) continue;
            sfx[i].clear();
        }
        num_sfx = 0;
    }

    static sfx_t FindName(String name, boolean create) {
        int i;
        sfx_t sfx = null;
        if (name == null) {
            Com.Error(0, "S_FindName: NULL\n");
        }
        if (name.length() == 0) {
            Com.Error(0, "S_FindName: empty name\n");
        }
        if (name.length() >= 64) {
            Com.Error(0, "Sound name too long: " + name);
        }
        for (i = 0; i < num_sfx; ++i) {
            if (!name.equals(SND_DMA.known_sfx[i].name)) continue;
            return known_sfx[i];
        }
        if (!create) {
            return null;
        }
        for (i = 0; i < num_sfx && SND_DMA.known_sfx[i].name != null; ++i) {
        }
        if (i == num_sfx) {
            if (num_sfx == 512) {
                Com.Error(0, "S_FindName: out of sfx_t");
            }
            ++num_sfx;
        }
        sfx = known_sfx[i];
        sfx.clear();
        sfx.name = name;
        sfx.registration_sequence = s_registration_sequence;
        return sfx;
    }

    static sfx_t AliasName(String aliasname, String truename) {
        int i;
        sfx_t sfx = null;
        for (i = 0; i < num_sfx && SND_DMA.known_sfx[i].name != null; ++i) {
        }
        if (i == num_sfx) {
            if (num_sfx == 512) {
                Com.Error(0, "S_FindName: out of sfx_t");
            }
            ++num_sfx;
        }
        sfx = known_sfx[i];
        sfx.name = aliasname;
        sfx.registration_sequence = s_registration_sequence;
        sfx.truename = truename;
        return sfx;
    }

    public static void BeginRegistration() {
        ++s_registration_sequence;
        s_registering = true;
    }

    public static sfx_t RegisterSound(String name) {
        sfx_t sfx = null;
        if (!sound_started) {
            return null;
        }
        sfx = SND_DMA.FindName(name, true);
        sfx.registration_sequence = s_registration_sequence;
        if (!s_registering) {
            WaveLoader.LoadSound(sfx);
        }
        return sfx;
    }

    public static void EndRegistration() {
        sfx_t sfx;
        int i;
        for (i = 0; i < num_sfx; ++i) {
            sfx = known_sfx[i];
            if (sfx.name == null || sfx.registration_sequence == s_registration_sequence) continue;
            sfx.clear();
        }
        for (i = 0; i < num_sfx; ++i) {
            sfx = known_sfx[i];
            if (sfx.name == null) continue;
            WaveLoader.LoadSound(sfx);
        }
        s_registering = false;
    }

    static SND_MIX.channel_t PickChannel(int entnum, int entchannel) {
        if (entchannel < 0) {
            Com.Error(1, "S_PickChannel: entchannel<0");
        }
        int first_to_die = -1;
        int life_left = Integer.MAX_VALUE;
        for (int ch_idx = 0; ch_idx < 32; ++ch_idx) {
            if (entchannel != 0 && SND_DMA.channels[ch_idx].entnum == entnum && SND_DMA.channels[ch_idx].entchannel == entchannel) {
                first_to_die = ch_idx;
                break;
            }
            if (SND_DMA.channels[ch_idx].entnum == SND_DMA.cl.playernum + 1 && entnum != SND_DMA.cl.playernum + 1 && SND_DMA.channels[ch_idx].sfx != null || SND_DMA.channels[ch_idx].end - paintedtime >= life_left) continue;
            life_left = SND_DMA.channels[ch_idx].end - paintedtime;
            first_to_die = ch_idx;
        }
        if (first_to_die == -1) {
            return null;
        }
        SND_MIX.channel_t ch = channels[first_to_die];
        ch.clear();
        return ch;
    }

    static void SpatializeOrigin(float[] origin, float master_vol, float dist_mult, SND_MIX.channel_t ch) {
        float lscale;
        float rscale;
        float[] source_vec = new float[]{0.0f, 0.0f, 0.0f};
        if (SND_DMA.cls.state != 4) {
            ch.rightvol = 255;
            ch.leftvol = 255;
            return;
        }
        Math3D.VectorSubtract(origin, listener_origin, source_vec);
        float dist = Math3D.VectorNormalize(source_vec);
        dist -= 80.0f;
        if (dist < 0.0f) {
            dist = 0.0f;
        }
        dist *= dist_mult;
        float dot = Math3D.DotProduct(listener_right, source_vec);
        if (SND_DMA.dma.channels == 1 || dist_mult == 0.0f) {
            rscale = 1.0f;
            lscale = 1.0f;
        } else {
            rscale = 0.5f * (1.0f + dot);
            lscale = 0.5f * (1.0f - dot);
        }
        float scale = (1.0f - dist) * rscale;
        ch.rightvol = (int)(master_vol * scale);
        if (ch.rightvol < 0) {
            ch.rightvol = 0;
        }
        scale = (1.0f - dist) * lscale;
        ch.leftvol = (int)(master_vol * scale);
        if (ch.leftvol < 0) {
            ch.leftvol = 0;
        }
    }

    static void Spatialize(SND_MIX.channel_t ch) {
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        if (ch.entnum == SND_DMA.cl.playernum + 1) {
            ch.leftvol = ch.master_vol;
            ch.rightvol = ch.master_vol;
            return;
        }
        if (ch.fixed_origin) {
            Math3D.VectorCopy(ch.origin, origin);
        } else {
            CL_ents.GetEntitySoundOrigin(ch.entnum, origin);
        }
        SND_DMA.SpatializeOrigin(origin, ch.master_vol, ch.dist_mult, ch);
    }

    static SND_MIX.playsound_t AllocPlaysound() {
        SND_MIX.playsound_t ps = SND_DMA.s_freeplays.next;
        if (ps == s_freeplays) {
            return null;
        }
        ps.prev.next = ps.next;
        ps.next.prev = ps.prev;
        return ps;
    }

    static void FreePlaysound(SND_MIX.playsound_t ps) {
        ps.prev.next = ps.next;
        ps.next.prev = ps.prev;
        ps.next = SND_DMA.s_freeplays.next;
        SND_DMA.s_freeplays.next.prev = ps;
        ps.prev = s_freeplays;
        SND_DMA.s_freeplays.next = ps;
    }

    static void IssuePlaysound(SND_MIX.playsound_t ps) {
        SND_MIX.channel_t ch;
        if (SND_DMA.s_show.value != 0.0f) {
            Com.Printf("Issue " + ps.begin + "\n");
        }
        if ((ch = SND_DMA.PickChannel(ps.entnum, ps.entchannel)) == null) {
            SND_DMA.FreePlaysound(ps);
            return;
        }
        ch.dist_mult = ps.attenuation == 3.0f ? ps.attenuation * 0.001f : ps.attenuation * 5.0E-4f;
        ch.master_vol = (int)ps.volume;
        ch.entnum = ps.entnum;
        ch.entchannel = ps.entchannel;
        ch.sfx = ps.sfx;
        Math3D.VectorCopy(ps.origin, ch.origin);
        ch.fixed_origin = ps.fixed_origin;
        SND_DMA.Spatialize(ch);
        ch.pos = 0;
        sfxcache_t sc = WaveLoader.LoadSound(ch.sfx);
        ch.end = paintedtime + sc.length;
        SND_DMA.FreePlaysound(ps);
    }

    static sfx_t RegisterSexedSound(entity_state_t ent, String base) {
        String sexedFilename;
        int p;
        sfx_t sfx = null;
        String model = "male";
        int n = 1312 + ent.number - 1;
        if (SND_DMA.cl.configstrings[n] != null && (p = SND_DMA.cl.configstrings[n].indexOf(92)) >= 0) {
            ++p;
            model = SND_DMA.cl.configstrings[n].substring(p);
            if ((p = model.indexOf(47)) > 0) {
                model = model.substring(0, p - 1);
            }
        }
        if (model == null || model.length() == 0) {
            model = "male";
        }
        if ((sfx = SND_DMA.FindName(sexedFilename = "#players/" + model + "/" + base.substring(1), false)) == null) {
            RandomAccessFile f = null;
            try {
                f = FS.FOpenFile(sexedFilename.substring(1));
            }
            catch (IOException e) {
                // empty catch block
            }
            if (f != null) {
                try {
                    FS.FCloseFile(f);
                }
                catch (IOException e1) {
                    // empty catch block
                }
                sfx = SND_DMA.RegisterSound(sexedFilename);
            } else {
                String maleFilename = "player/male/" + base.substring(1);
                sfx = SND_DMA.AliasName(sexedFilename, maleFilename);
            }
        }
        return sfx;
    }

    public static void StartSound(float[] origin, int entnum, int entchannel, sfx_t sfx, float fvol, float attenuation, float timeofs) {
        sfxcache_t sc;
        if (!sound_started) {
            return;
        }
        if (sfx == null) {
            return;
        }
        if (sfx.name.charAt(0) == '*') {
            sfx = SND_DMA.RegisterSexedSound(SND_DMA.cl_entities[entnum].current, sfx.name);
        }
        if ((sc = WaveLoader.LoadSound(sfx)) == null) {
            return;
        }
        int vol = (int)(fvol * 255.0f);
        SND_MIX.playsound_t ps = SND_DMA.AllocPlaysound();
        if (ps == null) {
            return;
        }
        if (origin != null) {
            Math3D.VectorCopy(origin, ps.origin);
            ps.fixed_origin = true;
        } else {
            ps.fixed_origin = false;
        }
        ps.entnum = entnum;
        ps.entchannel = entchannel;
        ps.attenuation = attenuation;
        ps.volume = vol;
        ps.sfx = sfx;
        int start = (int)((float)SND_DMA.cl.frame.servertime * 0.001f * (float)SND_DMA.dma.speed + (float)s_beginofs);
        if (start < paintedtime) {
            start = paintedtime;
            s_beginofs = (int)((float)start - (float)SND_DMA.cl.frame.servertime * 0.001f * (float)SND_DMA.dma.speed);
        } else if ((float)start > (float)paintedtime + 0.3f * (float)SND_DMA.dma.speed) {
            start = (int)((float)paintedtime + 0.1f * (float)SND_DMA.dma.speed);
            s_beginofs = (int)((float)start - (float)SND_DMA.cl.frame.servertime * 0.001f * (float)SND_DMA.dma.speed);
        } else {
            s_beginofs -= 10;
        }
        ps.begin = timeofs == 0.0f ? (long)paintedtime : (long)((float)start + timeofs * (float)SND_DMA.dma.speed);
        SND_MIX.playsound_t sort = SND_DMA.s_pendingplays.next;
        while (sort != s_pendingplays && sort.begin < ps.begin) {
            sort = sort.next;
        }
        ps.next = sort;
        ps.prev = sort.prev;
        ps.next.prev = ps;
        ps.prev.next = ps;
    }

    public static void StartLocalSound(String sound) {
        if (!sound_started) {
            return;
        }
        sfx_t sfx = SND_DMA.RegisterSound(sound);
        if (sfx == null) {
            Com.Printf("S_StartLocalSound: can't cache " + sound + "\n");
            return;
        }
        SND_DMA.StartSound(null, SND_DMA.cl.playernum + 1, 0, sfx, 1.0f, 1.0f, 0.0f);
    }

    static void ClearBuffer() {
        if (!sound_started) {
            return;
        }
        s_rawend = 0;
        if (SND_DMA.dma.samplebits == 8) {
            int clear = 128;
        } else {
            boolean clear = false;
        }
        SND_DMA.SNDDMA_BeginPainting();
        if (SND_DMA.dma.buffer != null) {
            SND_DMA.SNDDMA_Submit();
        }
    }

    public static void StopAllSounds() {
        int i;
        if (!sound_started) {
            return;
        }
        SND_DMA.s_freeplays.next = SND_DMA.s_freeplays.prev = s_freeplays;
        SND_DMA.s_pendingplays.next = SND_DMA.s_pendingplays.prev = s_pendingplays;
        for (i = 0; i < 128; ++i) {
            s_playsounds[i].clear();
            SND_DMA.s_playsounds[i].prev = s_freeplays;
            SND_DMA.s_playsounds[i].next = SND_DMA.s_freeplays.next;
            SND_DMA.s_playsounds[i].prev.next = s_playsounds[i];
            SND_DMA.s_playsounds[i].next.prev = s_playsounds[i];
        }
        for (i = 0; i < 32; ++i) {
            channels[i].clear();
        }
        SND_DMA.ClearBuffer();
    }

    static void AddLoopSounds() {
        entity_state_t ent;
        int num;
        int i;
        int[] sounds = new int[1024];
        if (SND_DMA.cl_paused.value != 0.0f) {
            return;
        }
        if (SND_DMA.cls.state != 4) {
            return;
        }
        if (!SND_DMA.cl.sound_prepped) {
            return;
        }
        for (i = 0; i < SND_DMA.cl.frame.num_entities; ++i) {
            num = SND_DMA.cl.frame.parse_entities + i & 0x3FF;
            ent = cl_parse_entities[num];
            sounds[i] = ent.sound;
        }
        for (i = 0; i < SND_DMA.cl.frame.num_entities; ++i) {
            sfxcache_t sc;
            sfx_t sfx;
            if (sounds[i] == 0 || (sfx = SND_DMA.cl.sound_precache[sounds[i]]) == null || (sc = sfx.cache) == null) continue;
            num = SND_DMA.cl.frame.parse_entities + i & 0x3FF;
            ent = cl_parse_entities[num];
            SND_MIX.channel_t tch = new SND_MIX.channel_t();
            SND_DMA.SpatializeOrigin(ent.origin, 255.0f, 0.003f, tch);
            int left_total = tch.leftvol;
            int right_total = tch.rightvol;
            for (int j = i + 1; j < SND_DMA.cl.frame.num_entities; ++j) {
                if (sounds[j] != sounds[i]) continue;
                sounds[j] = 0;
                num = SND_DMA.cl.frame.parse_entities + j & 0x3FF;
                ent = cl_parse_entities[num];
                SND_DMA.SpatializeOrigin(ent.origin, 255.0f, 0.003f, tch);
                left_total += tch.leftvol;
                right_total += tch.rightvol;
            }
            if (left_total == 0 && right_total == 0) continue;
            SND_MIX.channel_t ch = SND_DMA.PickChannel(0, 0);
            if (ch == null) {
                return;
            }
            if (left_total > 255) {
                left_total = 255;
            }
            if (right_total > 255) {
                right_total = 255;
            }
            ch.leftvol = left_total;
            ch.rightvol = right_total;
            ch.autosound = true;
            ch.sfx = sfx;
            ch.pos = paintedtime % sc.length;
            ch.end = paintedtime + sc.length - ch.pos;
        }
    }

    static void RawSamples(int samples, int rate, int width, int channels, ByteBuffer data) {
        if (!sound_started) {
            return;
        }
        if (s_rawend < paintedtime) {
            s_rawend = paintedtime;
        }
        float scale = (float)rate / (float)SND_DMA.dma.speed;
        if (channels == 2 && width == 2) {
            if ((double)scale != 1.0) {
                int i = 0;
                while (true) {
                    ++i;
                }
            }
        } else {
            if (channels == 1 && width == 2) {
                int i = 0;
                while (true) {
                    ++i;
                }
            }
            if (channels == 2 && width == 1) {
                int i = 0;
                while (true) {
                    ++i;
                }
            }
            if (channels == 1 && width == 1) {
                int i = 0;
                while (true) {
                    ++i;
                }
            }
        }
    }

    public static void Update(float[] origin, float[] forward, float[] right, float[] up) {
        SND_MIX.channel_t ch;
        if (!sound_started) {
            return;
        }
        if (SND_DMA.cls.disable_screen != 0.0f) {
            SND_DMA.ClearBuffer();
            return;
        }
        if (SND_DMA.s_volume.modified) {
            SND_DMA.InitScaletable();
        }
        Math3D.VectorCopy(origin, listener_origin);
        Math3D.VectorCopy(forward, listener_forward);
        Math3D.VectorCopy(right, listener_right);
        Math3D.VectorCopy(up, listener_up);
        Object combine = null;
        for (int i = 0; i < 32; ++i) {
            ch = channels[i];
            if (ch.sfx == null) continue;
            if (ch.autosound) {
                ch.clear();
                continue;
            }
            SND_DMA.Spatialize(ch);
            if (ch.leftvol != 0 || ch.rightvol != 0) continue;
            ch.clear();
        }
        SND_DMA.AddLoopSounds();
        if (SND_DMA.s_show.value != 0.0f) {
            int total = 0;
            for (int i = 0; i < 32; ++i) {
                ch = channels[i];
                if (ch.sfx == null || ch.leftvol == 0 && ch.rightvol == 0) continue;
                Com.Printf(ch.leftvol + " " + ch.rightvol + " " + ch.sfx.name + "\n");
                ++total;
            }
        }
        SND_DMA.Update_();
    }

    static void GetSoundtime() {
        int fullsamples = SND_DMA.dma.samples / SND_DMA.dma.channels;
        int samplepos = SND_DMA.SNDDMA_GetDMAPos();
        if (samplepos < oldsamplepos) {
            ++buffers;
            if (paintedtime > 0x40000000) {
                buffers = 0;
                paintedtime = fullsamples;
                SND_DMA.StopAllSounds();
            }
        }
        oldsamplepos = samplepos;
        soundtime = buffers * fullsamples + samplepos / SND_DMA.dma.channels;
    }

    static void Update_() {
        if (!sound_started) {
            return;
        }
        SND_DMA.SNDDMA_BeginPainting();
        if (SND_DMA.dma.buffer == null) {
            return;
        }
        SND_DMA.GetSoundtime();
        if (paintedtime < soundtime) {
            Com.DPrintf("S_Update_ : overflow\n");
            paintedtime = soundtime;
        }
        int endtime = (int)((float)soundtime + SND_DMA.s_mixahead.value * (float)SND_DMA.dma.speed);
        int samps = SND_DMA.dma.samples >> SND_DMA.dma.channels - 1;
        if ((endtime = endtime + SND_DMA.dma.submission_chunk - 1 & ~(SND_DMA.dma.submission_chunk - 1)) - soundtime > samps) {
            endtime = soundtime + samps;
        }
        SND_DMA.PaintChannels(endtime);
        SND_DMA.SNDDMA_Submit();
    }

    static void Play() {
        for (int i = 1; i < Cmd.Argc(); ++i) {
            String name = new String(Cmd.Argv(i));
            if (name.indexOf(46) == -1) {
                name = name + ".wav";
            }
            sfx_t sfx = SND_DMA.RegisterSound(name);
            SND_DMA.StartSound(null, SND_DMA.cl.playernum + 1, 0, sfx, 1.0f, 1.0f, 0.0f);
        }
    }

    static void SoundList() {
        int total = 0;
        for (int i = 0; i < num_sfx; ++i) {
            sfx_t sfx = known_sfx[i];
            if (sfx.registration_sequence == 0) continue;
            sfxcache_t sc = sfx.cache;
            if (sc != null) {
                int size = sc.length * sc.width * (sc.stereo + 1);
                total += size;
                if (sc.loopstart >= 0) {
                    Com.Printf("L");
                } else {
                    Com.Printf(" ");
                }
                Com.Printf("(%2db) %6i : %s\n", new Vargs(3).add(sc.width * 8).add(size).add(sfx.name));
                continue;
            }
            if (sfx.name.charAt(0) == '*') {
                Com.Printf("  placeholder : " + sfx.name + "\n");
                continue;
            }
            Com.Printf("  not loaded  : " + sfx.name + "\n");
        }
        Com.Printf("Total resident: " + total + "\n");
    }

    static {
        int i;
        sound_started = false;
        listener_origin = new float[]{0.0f, 0.0f, 0.0f};
        listener_forward = new float[]{0.0f, 0.0f, 0.0f};
        listener_right = new float[]{0.0f, 0.0f, 0.0f};
        listener_up = new float[]{0.0f, 0.0f, 0.0f};
        known_sfx = new sfx_t[512];
        for (i = 0; i < known_sfx.length; ++i) {
            SND_DMA.known_sfx[i] = new sfx_t();
        }
        s_playsounds = new SND_MIX.playsound_t[128];
        for (i = 0; i < 128; ++i) {
            SND_DMA.s_playsounds[i] = new SND_MIX.playsound_t();
        }
        s_freeplays = new SND_MIX.playsound_t();
        buffers = 0;
        oldsamplepos = 0;
    }
}

