/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.joal;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.GameBase;
import jake2.game.cvar_t;
import jake2.game.entity_state_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.xcommand_t;
import jake2.sound.S;
import jake2.sound.Sound;
import jake2.sound.WaveLoader;
import jake2.sound.joal.Channel;
import jake2.sound.joal.PlaySound;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;
import jake2.util.Lib;
import jake2.util.Vargs;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import net.java.games.joal.eax.EAX;
import net.java.games.joal.eax.EAXFactory;
import net.java.games.joal.util.ALut;

public final class JOALSoundImpl
implements Sound {
    static AL al;
    static ALC alc;
    static EAX eax;
    cvar_t s_volume;
    private int[] buffers = new int[520];
    private boolean initialized = false;
    private ByteBuffer sfxDataBuffer = Lib.newByteBuffer(0x200000);
    private float[] listenerOrigin = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerOrientation = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private IntBuffer eaxEnv = Lib.newIntBuffer(1);
    private int currentEnv = -1;
    private boolean changeEnv = true;
    int s_registration_sequence;
    boolean s_registering;
    static sfx_t[] known_sfx;
    static int num_sfx;
    private ShortBuffer streamBuffer = this.sfxDataBuffer.slice().order(ByteOrder.BIG_ENDIAN).asShortBuffer();

    private JOALSoundImpl() {
    }

    public boolean Init() {
        try {
            if (!this.initialized) {
                ALut.alutInit();
                this.initialized = true;
            }
            al = ALFactory.getAL();
            alc = ALFactory.getALC();
            this.checkError();
            this.initOpenALExtensions();
        }
        catch (ALException e) {
            Com.Printf(e.getMessage() + '\n');
            return false;
        }
        catch (Throwable e) {
            Com.Printf(e.toString() + '\n');
            return false;
        }
        this.s_volume = Cvar.Get("s_volume", "0.7", 1);
        al.alGenBuffers(this.buffers.length, this.buffers, 0);
        int count = Channel.init(al, this.buffers);
        Com.Printf("... using " + count + " channels\n");
        al.alDistanceModel(53250);
        Cmd.AddCommand("play", new xcommand_t(){

            public void execute() {
                JOALSoundImpl.this.Play();
            }
        });
        Cmd.AddCommand("stopsound", new xcommand_t(){

            public void execute() {
                JOALSoundImpl.this.StopAllSounds();
            }
        });
        Cmd.AddCommand("soundlist", new xcommand_t(){

            public void execute() {
                JOALSoundImpl.this.SoundList();
            }
        });
        Cmd.AddCommand("soundinfo", new xcommand_t(){

            public void execute() {
                JOALSoundImpl.this.SoundInfo_f();
            }
        });
        num_sfx = 0;
        Com.Println("sound sampling rate: 44100Hz");
        this.StopAllSounds();
        Com.Println("------------------------------------");
        return true;
    }

    private void initOpenALExtensions() {
        if (al.alIsExtensionPresent("EAX2.0")) {
            try {
                eax = EAXFactory.getEAX();
                Com.Println("... using EAX2.0");
            }
            catch (Throwable e) {
                Com.Println(e.getMessage());
                Com.Println("... EAX2.0 not initialized");
                eax = null;
            }
        } else {
            Com.Println("... EAX2.0 not found");
            eax = null;
        }
    }

    private void initBuffer(byte[] samples, int bufferId, int freq) {
        ByteBuffer data = this.sfxDataBuffer.slice();
        data.put(samples).flip();
        al.alBufferData(this.buffers[bufferId], 4353, (Buffer)data, data.limit(), freq);
    }

    private void checkError() {
        Com.DPrintf("AL Error: " + this.alErrorString() + '\n');
    }

    private String alErrorString() {
        String message = "";
        int error = al.alGetError();
        if (error != 0) {
            switch (error) {
                case 40964: {
                    message = "invalid operation";
                    break;
                }
                case 40963: {
                    message = "invalid value";
                    break;
                }
                case 40962: {
                    message = "invalid enum";
                    break;
                }
                case 40961: {
                    message = "invalid name";
                    break;
                }
                default: {
                    message = "" + error;
                }
            }
        }
        return message;
    }

    public void Shutdown() {
        this.StopAllSounds();
        Channel.shutdown();
        al.alDeleteBuffers(this.buffers.length, this.buffers, 0);
        Cmd.RemoveCommand("play");
        Cmd.RemoveCommand("stopsound");
        Cmd.RemoveCommand("soundlist");
        Cmd.RemoveCommand("soundinfo");
        for (int i = 0; i < num_sfx; ++i) {
            if (JOALSoundImpl.known_sfx[i].name == null) continue;
            known_sfx[i].clear();
        }
        num_sfx = 0;
    }

    public void StartSound(float[] origin, int entnum, int entchannel, sfx_t sfx, float fvol, float attenuation, float timeofs) {
        if (sfx == null) {
            return;
        }
        if (sfx.name.charAt(0) == '*') {
            sfx = this.RegisterSexedSound(Globals.cl_entities[entnum].current, sfx.name);
        }
        if (this.LoadSound(sfx) == null) {
            return;
        }
        if (attenuation != 3.0f) {
            attenuation *= 0.5f;
        }
        PlaySound.allocate(origin, entnum, entchannel, this.buffers[sfx.bufferId], fvol, attenuation, timeofs);
    }

    public void Update(float[] origin, float[] forward, float[] right, float[] up) {
        Channel.convertVector(origin, this.listenerOrigin);
        al.alListenerfv(4100, this.listenerOrigin, 0);
        Channel.convertOrientation(forward, up, this.listenerOrientation);
        al.alListenerfv(4111, this.listenerOrientation, 0);
        al.alListenerf(4106, this.s_volume.value);
        if (eax != null) {
            if (this.currentEnv == -1) {
                this.eaxEnv.put(0, 22);
                eax.EAXSet(1, -2147483637, 0, (Buffer)this.eaxEnv, 4);
                this.changeEnv = true;
            }
            if ((GameBase.gi.pointcontents.pointcontents(origin) & 0x38) != 0) {
                this.changeEnv = this.currentEnv != 22;
                this.currentEnv = 22;
            } else {
                this.changeEnv = this.currentEnv != 0;
                this.currentEnv = 0;
            }
            if (this.changeEnv) {
                this.eaxEnv.put(0, this.currentEnv);
                eax.EAXSet(1, -2147483637, 0, (Buffer)this.eaxEnv, 4);
            }
        }
        Channel.addLoopSounds();
        Channel.addPlaySounds();
        Channel.playAllSounds(this.listenerOrigin);
    }

    public void StopAllSounds() {
        al.alListenerf(4106, 0.0f);
        PlaySound.reset();
        Channel.reset();
    }

    public String getName() {
        return "joal";
    }

    public void BeginRegistration() {
        ++this.s_registration_sequence;
        this.s_registering = true;
    }

    public sfx_t RegisterSound(String name) {
        sfx_t sfx = this.FindName(name, true);
        sfx.registration_sequence = this.s_registration_sequence;
        if (!this.s_registering) {
            this.LoadSound(sfx);
        }
        return sfx;
    }

    public void EndRegistration() {
        sfx_t sfx;
        int i;
        for (i = 0; i < num_sfx; ++i) {
            sfx = known_sfx[i];
            if (sfx.name == null || sfx.registration_sequence == this.s_registration_sequence) continue;
            sfx.clear();
        }
        for (i = 0; i < num_sfx; ++i) {
            sfx = known_sfx[i];
            if (sfx.name == null) continue;
            this.LoadSound(sfx);
        }
        this.s_registering = false;
    }

    sfx_t RegisterSexedSound(entity_state_t ent, String base) {
        String sexedFilename;
        int p;
        sfx_t sfx = null;
        String model = null;
        int n = 1312 + ent.number - 1;
        if (Globals.cl.configstrings[n] != null && (p = Globals.cl.configstrings[n].indexOf(92)) >= 0) {
            ++p;
            model = Globals.cl.configstrings[n].substring(p);
            if ((p = model.indexOf(47)) > 0) {
                model = model.substring(0, p);
            }
        }
        if (model == null || model.length() == 0) {
            model = "male";
        }
        if ((sfx = this.FindName(sexedFilename = "#players/" + model + "/" + base.substring(1), false)) != null) {
            return sfx;
        }
        if (FS.FileLength(sexedFilename.substring(1)) > 0) {
            return this.RegisterSound(sexedFilename);
        }
        if (model.equalsIgnoreCase("female")) {
            String femaleFilename = "player/female/" + base.substring(1);
            if (FS.FileLength("sound/" + femaleFilename) > 0) {
                return this.AliasName(sexedFilename, femaleFilename);
            }
        }
        String maleFilename = "player/male/" + base.substring(1);
        return this.AliasName(sexedFilename, maleFilename);
    }

    sfx_t FindName(String name, boolean create) {
        int i;
        sfx_t sfx = null;
        if (name == null) {
            Com.Error(0, "S_FindName: NULL\n");
        }
        if (name.length() == 0) {
            Com.Error(0, "S_FindName: empty name\n");
        }
        if (name.length() >= 64) {
            Com.Error(0, "Sound name too long: " + name);
        }
        for (i = 0; i < num_sfx; ++i) {
            if (!name.equals(JOALSoundImpl.known_sfx[i].name)) continue;
            return known_sfx[i];
        }
        if (!create) {
            return null;
        }
        for (i = 0; i < num_sfx && JOALSoundImpl.known_sfx[i].name != null; ++i) {
        }
        if (i == num_sfx) {
            if (num_sfx == 512) {
                Com.Error(0, "S_FindName: out of sfx_t");
            }
            ++num_sfx;
        }
        sfx = known_sfx[i];
        sfx.clear();
        sfx.name = name;
        sfx.registration_sequence = this.s_registration_sequence;
        sfx.bufferId = i;
        return sfx;
    }

    sfx_t AliasName(String aliasname, String truename) {
        int i;
        sfx_t sfx = null;
        String s = new String(truename);
        for (i = 0; i < num_sfx && JOALSoundImpl.known_sfx[i].name != null; ++i) {
        }
        if (i == num_sfx) {
            if (num_sfx == 512) {
                Com.Error(0, "S_FindName: out of sfx_t");
            }
            ++num_sfx;
        }
        sfx = known_sfx[i];
        sfx.clear();
        sfx.name = new String(aliasname);
        sfx.registration_sequence = this.s_registration_sequence;
        sfx.truename = s;
        sfx.bufferId = i;
        return sfx;
    }

    public sfxcache_t LoadSound(sfx_t s) {
        if (s.isCached) {
            return s.cache;
        }
        sfxcache_t sc = WaveLoader.LoadSound(s);
        if (sc != null) {
            this.initBuffer(sc.data, s.bufferId, sc.speed);
            s.isCached = true;
            s.cache.data = null;
        }
        return sc;
    }

    public void StartLocalSound(String sound) {
        sfx_t sfx = this.RegisterSound(sound);
        if (sfx == null) {
            Com.Printf("S_StartLocalSound: can't cache " + sound + "\n");
            return;
        }
        this.StartSound(null, Globals.cl.playernum + 1, 0, sfx, 1.0f, 1.0f, 0.0f);
    }

    public void RawSamples(int samples, int rate, int width, int channels, ByteBuffer data) {
        int format;
        if (channels == 2) {
            format = width == 2 ? 4355 : 4354;
        } else {
            int n = format = width == 2 ? 4353 : 4352;
        }
        if (format == 4352) {
            ShortBuffer sampleData = this.streamBuffer;
            for (int i = 0; i < samples; ++i) {
                int value = (data.get(i) & 0xFF) - 128;
                sampleData.put(i, (short)value);
            }
            format = 4353;
            width = 2;
            data = this.sfxDataBuffer.slice();
        }
        Channel.updateStream(data, samples * channels * width, format, rate);
    }

    public void disableStreaming() {
        Channel.disableStreaming();
    }

    void Play() {
        for (int i = 1; i < Cmd.Argc(); ++i) {
            String name = new String(Cmd.Argv(i));
            if (name.indexOf(46) == -1) {
                name = name + ".wav";
            }
            this.RegisterSound(name);
            this.StartLocalSound(name);
        }
    }

    void SoundList() {
        int total = 0;
        for (int i = 0; i < num_sfx; ++i) {
            sfx_t sfx = known_sfx[i];
            if (sfx.registration_sequence == 0) continue;
            sfxcache_t sc = sfx.cache;
            if (sc != null) {
                int size = sc.length * sc.width * (sc.stereo + 1);
                total += size;
                if (sc.loopstart >= 0) {
                    Com.Printf("L");
                } else {
                    Com.Printf(" ");
                }
                Com.Printf("(%2db) %6i : %s\n", new Vargs(3).add(sc.width * 8).add(size).add(sfx.name));
                continue;
            }
            if (sfx.name.charAt(0) == '*') {
                Com.Printf("  placeholder : " + sfx.name + "\n");
                continue;
            }
            Com.Printf("  not loaded  : " + sfx.name + "\n");
        }
        Com.Printf("Total resident: " + total + "\n");
    }

    void SoundInfo_f() {
        Com.Printf("%5d stereo\n", new Vargs(1).add(1));
        Com.Printf("%5d samples\n", new Vargs(1).add(22050));
        Com.Printf("%5d samplebits\n", new Vargs(1).add(16));
        Com.Printf("%5d speed\n", new Vargs(1).add(44100));
    }

    static {
        S.register(new JOALSoundImpl());
        known_sfx = new sfx_t[512];
        for (int i = 0; i < known_sfx.length; ++i) {
            JOALSoundImpl.known_sfx[i] = new sfx_t();
        }
    }
}

