/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound.joal;

import jake2.Globals;
import jake2.client.CL_ents;
import jake2.game.entity_state_t;
import jake2.qcommon.Com;
import jake2.sound.joal.PlaySound;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;
import jake2.util.Math3D;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.java.games.joal.AL;
import net.java.games.joal.ALException;

public class Channel {
    static final int LISTENER = 0;
    static final int FIXED = 1;
    static final int DYNAMIC = 2;
    static final int MAX_CHANNELS = 32;
    static final float[] NULLVECTOR = new float[]{0.0f, 0.0f, 0.0f};
    private static AL al;
    private static Channel[] channels;
    private static int[] sources;
    private static int[] buffers;
    private static Map looptable;
    private static int numChannels;
    private static boolean streamingEnabled;
    private static int streamQueue;
    private int type;
    private int entnum;
    private int entchannel;
    private int bufferId;
    private int sourceId;
    private float volume;
    private float rolloff;
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private boolean autosound;
    private boolean active;
    private boolean modified;
    private boolean bufferChanged;
    private boolean volumeChanged;
    private static int[] tmp;
    private static float[] entityOrigin;
    private static float[] sourceOrigin;

    private Channel(int sourceId) {
        this.sourceId = sourceId;
        this.clear();
        this.volumeChanged = false;
        this.volume = 1.0f;
    }

    private void clear() {
        this.bufferId = -1;
        this.entchannel = -1;
        this.entnum = -1;
        this.bufferChanged = false;
        this.rolloff = 0.0f;
        this.autosound = false;
        this.active = false;
        this.modified = false;
    }

    static int init(AL al, int[] buffers) {
        Channel.al = al;
        Channel.buffers = buffers;
        numChannels = 0;
        for (int i = 0; i < 32; ++i) {
            int sourceId;
            try {
                al.alGenSources(1, tmp, 0);
                sourceId = tmp[0];
                if (sourceId <= 0) {
                }
            }
            catch (ALException e) {}
            break;
            Channel.sources[i] = sourceId;
            Channel.channels[i] = new Channel(sourceId);
            ++numChannels;
            al.alSourcef(sourceId, 4106, 1.0f);
            al.alSourcef(sourceId, 4099, 1.0f);
            al.alSourcei(sourceId, 514, 0);
            al.alSourcefv(sourceId, 4102, NULLVECTOR, 0);
            al.alSourcei(sourceId, 4103, 0);
            al.alSourcef(sourceId, 4128, 200.0f);
            al.alSourcef(sourceId, 4109, 5.0E-4f);
            al.alSourcef(sourceId, 4110, 1.0f);
        }
        return numChannels;
    }

    static void reset() {
        for (int i = 0; i < numChannels; ++i) {
            al.alSourceStop(sources[i]);
            al.alSourcei(sources[i], 4105, 0);
            channels[i].clear();
        }
    }

    static void shutdown() {
        al.alDeleteSources(numChannels, sources, 0);
        numChannels = 0;
    }

    static void enableStreaming() {
        if (streamingEnabled) {
            return;
        }
        streamingEnabled = true;
        streamQueue = 0;
        int source = Channel.channels[--Channel.numChannels].sourceId;
        al.alSourcei(source, 514, 1);
        al.alSourcef(source, 4106, 1.0f);
        Channel.channels[Channel.numChannels].volumeChanged = true;
        Com.DPrintf("streaming enabled\n");
    }

    static void disableStreaming() {
        if (!streamingEnabled) {
            return;
        }
        Channel.unqueueStreams();
        int source = Channel.channels[Channel.numChannels].sourceId;
        al.alSourcei(source, 514, 0);
        ++numChannels;
        streamingEnabled = false;
        Com.DPrintf("streaming disabled\n");
    }

    static void unqueueStreams() {
        if (!streamingEnabled) {
            return;
        }
        int source = Channel.channels[Channel.numChannels].sourceId;
        al.alSourceStop(source);
        int[] tmpCount = new int[]{0};
        al.alGetSourcei(source, 4117, tmpCount, 0);
        int count = tmpCount[0];
        Com.DPrintf("unqueue " + count + " buffers\n");
        while (count-- > 0) {
            al.alSourceUnqueueBuffers(source, 1, tmp, 0);
        }
        streamQueue = 0;
    }

    static void updateStream(ByteBuffer samples, int count, int format, int rate) {
        boolean interupted;
        Channel.enableStreaming();
        int[] buffer = tmp;
        int source = Channel.channels[Channel.numChannels].sourceId;
        int[] tmp = new int[]{0};
        al.alGetSourcei(source, 4118, tmp, 0);
        int processed = tmp[0];
        al.alGetSourcei(source, 4112, tmp, 0);
        int state = tmp[0];
        boolean playing = state == 4114;
        boolean bl = interupted = !playing && streamQueue > 2;
        if (interupted) {
            Channel.unqueueStreams();
            buffer[0] = buffers[512 + streamQueue++];
            Com.DPrintf("queue " + (streamQueue - 1) + '\n');
        } else if (processed < 2) {
            if (streamQueue >= 8) {
                return;
            }
            buffer[0] = buffers[512 + streamQueue++];
            Com.DPrintf("queue " + (streamQueue - 1) + '\n');
        } else {
            al.alSourceUnqueueBuffers(source, 1, buffer, 0);
        }
        samples.position(0);
        samples.limit(count);
        al.alBufferData(buffer[0], format, (Buffer)samples, count, rate);
        al.alSourceQueueBuffers(source, 1, buffer, 0);
        if (streamQueue > 1 && !playing) {
            Com.DPrintf("start sound\n");
            al.alSourcePlay(source);
        }
    }

    static void addPlaySounds() {
        while (Channel.assign(PlaySound.nextPlayableSound())) {
        }
    }

    private static boolean assign(PlaySound ps) {
        int i;
        if (ps == null) {
            return false;
        }
        Channel ch = null;
        for (i = 0; i < numChannels; ++i) {
            ch = channels[i];
            if (ps.entchannel != 0 && ch.entnum == ps.entnum && ch.entchannel == ps.entchannel) {
                if (ch.bufferId == ps.bufferId) break;
                al.alSourceStop(ch.sourceId);
                break;
            }
            if ((ch.entnum != Globals.cl.playernum + 1 || ps.entnum == Globals.cl.playernum + 1 || ch.bufferId == -1) && !ch.active) break;
        }
        if (i == numChannels) {
            return false;
        }
        ch.type = ps.type;
        if (ps.type == 1) {
            Math3D.VectorCopy(ps.origin, ch.origin);
        }
        ch.entnum = ps.entnum;
        ch.entchannel = ps.entchannel;
        ch.bufferChanged = ch.bufferId != ps.bufferId;
        ch.bufferId = ps.bufferId;
        ch.volumeChanged = ch.volume != ps.volume;
        ch.volume = ps.volume;
        ch.rolloff = ps.attenuation * 2.0f;
        ch.active = true;
        ch.modified = true;
        return true;
    }

    private static Channel pickForLoop(int bufferId, float attenuation) {
        for (int i = 0; i < numChannels; ++i) {
            Channel ch = channels[i];
            if (ch.active) continue;
            ch.entnum = 0;
            ch.entchannel = 0;
            ch.bufferChanged = ch.bufferId != bufferId;
            ch.bufferId = bufferId;
            ch.volumeChanged = ch.volume < 1.0f;
            ch.volume = 1.0f;
            ch.rolloff = attenuation * 2.0f;
            ch.active = true;
            ch.modified = true;
            return ch;
        }
        return null;
    }

    static void playAllSounds(float[] listenerOrigin) {
        int[] tmp = new int[]{0};
        for (int i = 0; i < numChannels; ++i) {
            Channel ch = channels[i];
            if (!ch.active) continue;
            int sourceId = ch.sourceId;
            switch (ch.type) {
                case 0: {
                    Math3D.VectorCopy(listenerOrigin, sourceOrigin);
                    break;
                }
                case 2: {
                    CL_ents.GetEntitySoundOrigin(ch.entnum, entityOrigin);
                    Channel.convertVector(entityOrigin, sourceOrigin);
                    break;
                }
                case 1: {
                    Channel.convertVector(ch.origin, sourceOrigin);
                }
            }
            if (ch.modified) {
                if (ch.bufferChanged) {
                    try {
                        al.alSourcei(sourceId, 4105, ch.bufferId);
                    }
                    catch (ALException e) {
                        al.alSourceStop(sourceId);
                        al.alSourcei(sourceId, 4105, ch.bufferId);
                    }
                }
                if (ch.volumeChanged) {
                    al.alSourcef(sourceId, 4106, ch.volume);
                }
                al.alSourcef(sourceId, 4129, ch.rolloff);
                al.alSourcefv(sourceId, 4100, sourceOrigin, 0);
                al.alSourcePlay(sourceId);
                ch.modified = false;
            } else {
                al.alGetSourcei(sourceId, 4112, tmp, 0);
                int state = tmp[0];
                if (state == 4114) {
                    al.alSourcefv(sourceId, 4100, sourceOrigin, 0);
                } else {
                    ch.clear();
                }
            }
            ch.autosound = false;
        }
    }

    static void addLoopSounds() {
        if (Globals.cl_paused.value != 0.0f || Globals.cls.state != 4 || !Globals.cl.sound_prepped) {
            Channel.removeUnusedLoopSounds();
            return;
        }
        int sound = 0;
        for (int i = 0; i < Globals.cl.frame.num_entities; ++i) {
            sfxcache_t sc;
            int num = Globals.cl.frame.parse_entities + i & 0x3FF;
            entity_state_t ent = Globals.cl_parse_entities[num];
            sound = ent.sound;
            if (sound == 0) continue;
            Integer key = new Integer(ent.number);
            Channel ch = (Channel)looptable.get(key);
            if (ch != null) {
                ch.autosound = true;
                Math3D.VectorCopy(ent.origin, ch.origin);
                continue;
            }
            sfx_t sfx = Globals.cl.sound_precache[sound];
            if (sfx == null || (sc = sfx.cache) == null) continue;
            ch = Channel.pickForLoop(buffers[sfx.bufferId], 6.0f);
            if (ch == null) break;
            ch.type = 1;
            Math3D.VectorCopy(ent.origin, ch.origin);
            ch.autosound = true;
            looptable.put(key, ch);
            al.alSourcei(ch.sourceId, 4103, 1);
        }
        Channel.removeUnusedLoopSounds();
    }

    private static void removeUnusedLoopSounds() {
        Iterator iter = looptable.values().iterator();
        while (iter.hasNext()) {
            Channel ch = (Channel)iter.next();
            if (ch.autosound) continue;
            al.alSourceStop(ch.sourceId);
            al.alSourcei(ch.sourceId, 4103, 0);
            iter.remove();
            ch.clear();
        }
    }

    static void convertVector(float[] from, float[] to) {
        to[0] = from[0];
        to[1] = from[2];
        to[2] = -from[1];
    }

    static void convertOrientation(float[] forward, float[] up, float[] orientation) {
        orientation[0] = forward[0];
        orientation[1] = forward[2];
        orientation[2] = -forward[1];
        orientation[3] = up[0];
        orientation[4] = up[2];
        orientation[5] = -up[1];
    }

    static {
        channels = new Channel[32];
        sources = new int[32];
        looptable = new Hashtable(32);
        streamingEnabled = false;
        streamQueue = 0;
        tmp = new int[1];
        entityOrigin = new float[]{0.0f, 0.0f, 0.0f};
        sourceOrigin = new float[]{0.0f, 0.0f, 0.0f};
    }
}

