/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound;

import jake2.Defines;
import jake2.qcommon.Com;
import jake2.qcommon.FS;
import jake2.sound.S;
import jake2.sound.sfx_t;
import jake2.sound.sfxcache_t;

public class WaveLoader {
    private static boolean DONT_DO_A_RESAMPLING_FOR_JOAL_AND_LWJGL = true;
    private static int maxsamplebytes = 0x200000;
    static byte[] data_b;
    static int data_p;
    static int iff_end;
    static int last_chunk;
    static int iff_data;
    static int iff_chunk_len;

    public static sfxcache_t LoadSound(sfx_t s) {
        if (s.name.charAt(0) == '*') {
            return null;
        }
        sfxcache_t sc = s.cache;
        if (sc != null) {
            return sc;
        }
        String name = s.truename != null ? s.truename : s.name;
        String namebuffer = name.charAt(0) == '#' ? name.substring(1) : "sound/" + name;
        byte[] data = FS.LoadFile(namebuffer);
        if (data == null) {
            Com.DPrintf("Couldn't load " + namebuffer + "\n");
            return null;
        }
        int size = data.length;
        wavinfo_t info = WaveLoader.GetWavinfo(s.name, data, size);
        if (info.channels != 1) {
            Com.Printf(s.name + " is a stereo sample - ignoring\n");
            return null;
        }
        float stepscale = DONT_DO_A_RESAMPLING_FOR_JOAL_AND_LWJGL ? 1.0f : (float)info.rate / (float)S.getDefaultSampleRate();
        int len = (int)((float)info.samples / stepscale);
        if ((len = len * info.width * info.channels) >= maxsamplebytes) {
            Com.Printf(s.name + " is too long: " + len + " bytes?! ignoring.\n");
            return null;
        }
        sc = s.cache = new sfxcache_t(len);
        sc.length = info.samples;
        sc.loopstart = info.loopstart;
        sc.speed = info.rate;
        sc.width = info.width;
        sc.stereo = info.channels;
        WaveLoader.ResampleSfx(s, sc.speed, sc.width, data, info.dataofs);
        data = null;
        return sc;
    }

    public static void ResampleSfx(sfx_t sfx, int inrate, int inwidth, byte[] data, int offset) {
        int outcount;
        sfxcache_t sc = sfx.cache;
        if (sc == null) {
            return;
        }
        float stepscale = DONT_DO_A_RESAMPLING_FOR_JOAL_AND_LWJGL ? 1.0f : (float)inrate / (float)S.getDefaultSampleRate();
        sc.length = outcount = (int)((float)sc.length / stepscale);
        if (sc.loopstart != -1) {
            sc.loopstart = (int)((float)sc.loopstart / stepscale);
        }
        if (!DONT_DO_A_RESAMPLING_FOR_JOAL_AND_LWJGL) {
            sc.speed = S.getDefaultSampleRate();
        }
        sc.width = inwidth;
        sc.stereo = 0;
        int samplefrac = 0;
        int fracstep = (int)(stepscale * 256.0f);
        for (int i = 0; i < outcount; ++i) {
            int srcsample = samplefrac >> 8;
            samplefrac += fracstep;
            int sample = inwidth == 2 ? (data[offset + srcsample * 2] & 0xFF) + (data[offset + srcsample * 2 + 1] << 8) : (data[offset + srcsample] & 0xFF) - 128 << 8;
            if (sc.width == 2) {
                if (Defines.LITTLE_ENDIAN) {
                    sc.data[i * 2] = (byte)(sample & 0xFF);
                    sc.data[i * 2 + 1] = (byte)(sample >>> 8 & 0xFF);
                    continue;
                }
                sc.data[i * 2] = (byte)(sample >>> 8 & 0xFF);
                sc.data[i * 2 + 1] = (byte)(sample & 0xFF);
                continue;
            }
            sc.data[i] = (byte)(sample >> 8);
        }
    }

    static short GetLittleShort() {
        int val = 0;
        val = data_b[data_p] & 0xFF;
        val |= (data_b[++data_p] & 0xFF) << 8;
        ++data_p;
        return (short)val;
    }

    static int GetLittleLong() {
        int val = 0;
        val = data_b[data_p] & 0xFF;
        val |= (data_b[++data_p] & 0xFF) << 8;
        val |= (data_b[++data_p] & 0xFF) << 16;
        val |= (data_b[++data_p] & 0xFF) << 24;
        ++data_p;
        return val;
    }

    static void FindNextChunk(String name) {
        String s;
        do {
            if ((data_p = last_chunk) >= iff_end) {
                data_p = 0;
                return;
            }
            data_p += 4;
            iff_chunk_len = WaveLoader.GetLittleLong();
            if (iff_chunk_len < 0) {
                data_p = 0;
                return;
            }
            if (iff_chunk_len > 0x100000) {
                Com.Println(" Warning: FindNextChunk: length is past the 1 meg sanity limit");
            }
            last_chunk = (data_p -= 8) + 8 + (iff_chunk_len + 1 & 0xFFFFFFFE);
        } while (!(s = new String(data_b, data_p, 4)).equals(name));
    }

    static void FindChunk(String name) {
        last_chunk = iff_data;
        WaveLoader.FindNextChunk(name);
    }

    static wavinfo_t GetWavinfo(String name, byte[] wav, int wavlength) {
        wavinfo_t info = new wavinfo_t();
        if (wav == null) {
            return info;
        }
        iff_data = 0;
        iff_end = wavlength;
        data_b = wav;
        WaveLoader.FindChunk("RIFF");
        String s = new String(data_b, data_p + 8, 4);
        if (!s.equals("WAVE")) {
            Com.Printf("Missing RIFF/WAVE chunks\n");
            return info;
        }
        iff_data = data_p + 12;
        WaveLoader.FindChunk("fmt ");
        if (data_p == 0) {
            Com.Printf("Missing fmt chunk\n");
            return info;
        }
        data_p += 8;
        short format = WaveLoader.GetLittleShort();
        if (format != 1) {
            Com.Printf("Microsoft PCM format only\n");
            return info;
        }
        info.channels = WaveLoader.GetLittleShort();
        info.rate = WaveLoader.GetLittleLong();
        info.width = WaveLoader.GetLittleShort() / 8;
        WaveLoader.FindChunk("cue ");
        if ((data_p += 6) != 0) {
            info.loopstart = WaveLoader.GetLittleLong();
            WaveLoader.FindNextChunk("LIST");
            if ((data_p += 32) != 0 && data_b.length >= data_p + 32 && (s = new String(data_b, data_p + 28, 4)).equals("MARK")) {
                data_p += 24;
                int i = WaveLoader.GetLittleLong();
                info.samples = info.loopstart + i;
            }
        } else {
            info.loopstart = -1;
        }
        WaveLoader.FindChunk("data");
        if (data_p == 0) {
            Com.Printf("Missing data chunk\n");
            return info;
        }
        data_p += 4;
        int samples = WaveLoader.GetLittleLong() / info.width;
        if (info.samples != 0) {
            if (samples < info.samples) {
                Com.Error(1, "Sound " + name + " has a bad loop length");
            }
        } else {
            info.samples = samples;
            if (info.loopstart > 0) {
                info.samples -= info.loopstart;
            }
        }
        info.dataofs = data_p;
        return info;
    }

    static class wavinfo_t {
        int rate;
        int width;
        int channels;
        int loopstart;
        int samples;
        int dataofs;

        wavinfo_t() {
        }
    }
}

