/*
 * Decompiled with CFR 0.152.
 */
package jake2.sound;

import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.sound.Sound;
import jake2.sound.sfx_t;
import java.nio.ByteBuffer;
import java.util.Vector;

public class S {
    static Sound impl;
    static cvar_t s_impl;
    static Vector drivers;

    public static void register(Sound driver) {
        if (driver == null) {
            throw new IllegalArgumentException("Sound implementation can't be null");
        }
        if (!drivers.contains(driver)) {
            drivers.add(driver);
        }
    }

    public static void useDriver(String driverName) {
        Sound driver = null;
        int count = drivers.size();
        for (int i = 0; i < count; ++i) {
            driver = (Sound)drivers.get(i);
            if (!driver.getName().equals(driverName)) continue;
            impl = driver;
            return;
        }
        impl = (Sound)drivers.lastElement();
    }

    public static void Init() {
        Com.Printf("\n------- sound initialization -------\n");
        cvar_t cv = Cvar.Get("s_initsound", "1", 0);
        if (cv.value == 0.0f) {
            Com.Printf("not initializing.\n");
            S.useDriver("dummy");
            return;
        }
        String defaultDriver = "dummy";
        if (drivers.size() > 1) {
            defaultDriver = ((Sound)drivers.lastElement()).getName();
        }
        s_impl = Cvar.Get("s_impl", defaultDriver, 1);
        S.useDriver(S.s_impl.string);
        if (impl.Init()) {
            Cvar.Set("s_impl", impl.getName());
        } else {
            S.useDriver("dummy");
        }
        Com.Printf("\n------- use sound driver \"" + impl.getName() + "\" -------\n");
        S.StopAllSounds();
    }

    public static void Shutdown() {
        impl.Shutdown();
    }

    public static void BeginRegistration() {
        impl.BeginRegistration();
    }

    public static sfx_t RegisterSound(String sample) {
        return impl.RegisterSound(sample);
    }

    public static void EndRegistration() {
        impl.EndRegistration();
    }

    public static void StartLocalSound(String sound) {
        impl.StartLocalSound(sound);
    }

    public static void StartSound(float[] origin, int entnum, int entchannel, sfx_t sfx, float fvol, float attenuation, float timeofs) {
        impl.StartSound(origin, entnum, entchannel, sfx, fvol, attenuation, timeofs);
    }

    public static void Update(float[] origin, float[] forward, float[] right, float[] up) {
        impl.Update(origin, forward, right, up);
    }

    public static void RawSamples(int samples, int rate, int width, int channels, ByteBuffer data) {
        impl.RawSamples(samples, rate, width, channels, data);
    }

    public static void disableStreaming() {
        impl.disableStreaming();
    }

    public static void StopAllSounds() {
        impl.StopAllSounds();
    }

    public static String getDriverName() {
        return impl.getName();
    }

    public static String[] getDriverNames() {
        String[] names = new String[drivers.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Sound)drivers.get(i)).getName();
        }
        return names;
    }

    public static int getDefaultSampleRate() {
        return 44100;
    }

    static {
        drivers = new Vector(3);
        try {
            Class.forName("jake2.sound.DummyDriver");
            S.useDriver("dummy");
        }
        catch (Throwable e) {
            Com.DPrintf("could not init dummy sound driver class.");
        }
        try {
            Class.forName("org.lwjgl.openal.AL");
            Class.forName("jake2.sound.lwjgl.LWJGLSoundImpl");
        }
        catch (Throwable e) {
            Com.DPrintf("could not init lwjgl sound driver class.");
        }
        try {
            Class.forName("net.java.games.joal.AL");
            Class.forName("jake2.sound.joal.JOALSoundImpl");
        }
        catch (Throwable e) {
            Com.DPrintf("could not init joal sound driver class.");
        }
    }
}

