/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.cmodel_t;
import jake2.game.edict_t;
import jake2.game.link_t;
import jake2.game.trace_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.server.SV_INIT;
import jake2.server.areanode_t;
import jake2.server.moveclip_t;
import jake2.util.Math3D;

public class SV_WORLD {
    public static areanode_t[] sv_areanodes = new areanode_t[32];
    public static int sv_numareanodes;
    public static float[] area_mins;
    public static float[] area_maxs;
    public static edict_t[] area_list;
    public static int area_count;
    public static int area_maxcount;
    public static int area_type;
    public static final int MAX_TOTAL_ENT_LEAFS = 128;
    static int[] leafs;
    static int[] clusters;
    static edict_t[] touch;
    static edict_t[] touchlist;

    public static void initNodes() {
        for (int n = 0; n < 32; ++n) {
            SV_WORLD.sv_areanodes[n] = new areanode_t();
        }
    }

    public static void ClearLink(link_t l) {
        l.prev = l.next = l;
    }

    public static void RemoveLink(link_t l) {
        l.next.prev = l.prev;
        l.prev.next = l.next;
    }

    public static void InsertLinkBefore(link_t l, link_t before) {
        l.next = before;
        l.prev = before.prev;
        l.prev.next = l;
        l.next.prev = l;
    }

    public static areanode_t SV_CreateAreaNode(int depth, float[] mins, float[] maxs) {
        float[] size = new float[]{0.0f, 0.0f, 0.0f};
        float[] mins1 = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs1 = new float[]{0.0f, 0.0f, 0.0f};
        float[] mins2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs2 = new float[]{0.0f, 0.0f, 0.0f};
        areanode_t anode = sv_areanodes[sv_numareanodes];
        ++sv_numareanodes;
        SV_WORLD.ClearLink(anode.trigger_edicts);
        SV_WORLD.ClearLink(anode.solid_edicts);
        if (depth == 4) {
            anode.axis = -1;
            anode.children[1] = null;
            anode.children[0] = null;
            return anode;
        }
        Math3D.VectorSubtract(maxs, mins, size);
        anode.axis = size[0] > size[1] ? 0 : 1;
        anode.dist = 0.5f * (maxs[anode.axis] + mins[anode.axis]);
        Math3D.VectorCopy(mins, mins1);
        Math3D.VectorCopy(mins, mins2);
        Math3D.VectorCopy(maxs, maxs1);
        Math3D.VectorCopy(maxs, maxs2);
        maxs1[anode.axis] = mins2[anode.axis] = anode.dist;
        anode.children[0] = SV_WORLD.SV_CreateAreaNode(depth + 1, mins2, maxs2);
        anode.children[1] = SV_WORLD.SV_CreateAreaNode(depth + 1, mins1, maxs1);
        return anode;
    }

    public static void SV_ClearWorld() {
        SV_WORLD.initNodes();
        sv_numareanodes = 0;
        SV_WORLD.SV_CreateAreaNode(0, SV_INIT.sv.models[1].mins, SV_INIT.sv.models[1].maxs);
    }

    public static void SV_UnlinkEdict(edict_t ent) {
        if (null == ent.area.prev) {
            return;
        }
        SV_WORLD.RemoveLink(ent.area);
        ent.area.next = null;
        ent.area.prev = null;
    }

    public static void SV_LinkEdict(edict_t ent) {
        int i;
        int j;
        int topnode = 0;
        if (ent.area.prev != null) {
            SV_WORLD.SV_UnlinkEdict(ent);
        }
        if (ent == GameBase.g_edicts[0]) {
            return;
        }
        if (!ent.inuse) {
            return;
        }
        Math3D.VectorSubtract(ent.maxs, ent.mins, ent.size);
        if (ent.solid == 2 && 0 == (ent.svflags & 2)) {
            int k;
            int i2 = (int)(ent.maxs[0] / 8.0f);
            if (i2 < 1) {
                i2 = 1;
            }
            if (i2 > 31) {
                i2 = 31;
            }
            if ((j = (int)(-ent.mins[2] / 8.0f)) < 1) {
                j = 1;
            }
            if (j > 31) {
                j = 31;
            }
            if ((k = (int)((ent.maxs[2] + 32.0f) / 8.0f)) < 1) {
                k = 1;
            }
            if (k > 63) {
                k = 63;
            }
            ent.s.solid = k << 10 | j << 5 | i2;
        } else {
            ent.s.solid = ent.solid == 3 ? 31 : 0;
        }
        if (ent.solid == 3 && (ent.s.angles[0] != 0.0f || ent.s.angles[1] != 0.0f || ent.s.angles[2] != 0.0f)) {
            int i3;
            float max = 0.0f;
            for (i3 = 0; i3 < 3; ++i3) {
                float v = Math.abs(ent.mins[i3]);
                if (v > max) {
                    max = v;
                }
                if (!((v = Math.abs(ent.maxs[i3])) > max)) continue;
                max = v;
            }
            for (i3 = 0; i3 < 3; ++i3) {
                ent.absmin[i3] = ent.s.origin[i3] - max;
                ent.absmax[i3] = ent.s.origin[i3] + max;
            }
        } else {
            Math3D.VectorAdd(ent.s.origin, ent.mins, ent.absmin);
            Math3D.VectorAdd(ent.s.origin, ent.maxs, ent.absmax);
        }
        ent.absmin[0] = ent.absmin[0] - 1.0f;
        ent.absmin[1] = ent.absmin[1] - 1.0f;
        ent.absmin[2] = ent.absmin[2] - 1.0f;
        ent.absmax[0] = ent.absmax[0] + 1.0f;
        ent.absmax[1] = ent.absmax[1] + 1.0f;
        ent.absmax[2] = ent.absmax[2] + 1.0f;
        ent.num_clusters = 0;
        ent.areanum = 0;
        ent.areanum2 = 0;
        int[] iw = new int[]{topnode};
        int num_leafs = CM.CM_BoxLeafnums(ent.absmin, ent.absmax, leafs, 128, iw);
        topnode = iw[0];
        for (i = 0; i < num_leafs; ++i) {
            SV_WORLD.clusters[i] = CM.CM_LeafCluster(leafs[i]);
            int area = CM.CM_LeafArea(leafs[i]);
            if (area == 0) continue;
            if (ent.areanum != 0 && ent.areanum != area) {
                if (ent.areanum2 != 0 && ent.areanum2 != area && SV_INIT.sv.state == 1) {
                    Com.DPrintf("Object touching 3 areas at " + ent.absmin[0] + " " + ent.absmin[1] + " " + ent.absmin[2] + "\n");
                }
                ent.areanum2 = area;
                continue;
            }
            ent.areanum = area;
        }
        if (num_leafs >= 128) {
            ent.num_clusters = -1;
            ent.headnode = topnode;
        } else {
            ent.num_clusters = 0;
            for (i = 0; i < num_leafs; ++i) {
                if (clusters[i] == -1) continue;
                for (j = 0; j < i && clusters[j] != clusters[i]; ++j) {
                }
                if (j != i) continue;
                if (ent.num_clusters == 16) {
                    ent.num_clusters = -1;
                    ent.headnode = topnode;
                    break;
                }
                ent.clusternums[ent.num_clusters++] = clusters[i];
            }
        }
        if (0 == ent.linkcount) {
            Math3D.VectorCopy(ent.s.origin, ent.s.old_origin);
        }
        ++ent.linkcount;
        if (ent.solid == 0) {
            return;
        }
        areanode_t node = sv_areanodes[0];
        while (node.axis != -1) {
            if (ent.absmin[node.axis] > node.dist) {
                node = node.children[0];
                continue;
            }
            if (!(ent.absmax[node.axis] < node.dist)) break;
            node = node.children[1];
        }
        if (ent.solid == 1) {
            SV_WORLD.InsertLinkBefore(ent.area, node.trigger_edicts);
        } else {
            SV_WORLD.InsertLinkBefore(ent.area, node.solid_edicts);
        }
    }

    public static void SV_AreaEdicts_r(areanode_t node) {
        link_t start = area_type == 1 ? node.solid_edicts : node.trigger_edicts;
        link_t l = start.next;
        while (l != start) {
            link_t next = l.next;
            edict_t check = (edict_t)l.o;
            if (!(check.solid == 0 || check.absmin[0] > area_maxs[0] || check.absmin[1] > area_maxs[1] || check.absmin[2] > area_maxs[2] || check.absmax[0] < area_mins[0] || check.absmax[1] < area_mins[1] || check.absmax[2] < area_mins[2])) {
                if (area_count == area_maxcount) {
                    Com.Printf("SV_AreaEdicts: MAXCOUNT\n");
                    return;
                }
                SV_WORLD.area_list[SV_WORLD.area_count] = check;
                ++area_count;
            }
            l = next;
        }
        if (node.axis == -1) {
            return;
        }
        if (area_maxs[node.axis] > node.dist) {
            SV_WORLD.SV_AreaEdicts_r(node.children[0]);
        }
        if (area_mins[node.axis] < node.dist) {
            SV_WORLD.SV_AreaEdicts_r(node.children[1]);
        }
    }

    public static int SV_AreaEdicts(float[] mins, float[] maxs, edict_t[] list, int maxcount, int areatype) {
        area_mins = mins;
        area_maxs = maxs;
        area_list = list;
        area_count = 0;
        area_maxcount = maxcount;
        area_type = areatype;
        SV_WORLD.SV_AreaEdicts_r(sv_areanodes[0]);
        return area_count;
    }

    public static int SV_PointContents(float[] p) {
        int contents = CM.PointContents(p, SV_INIT.sv.models[1].headnode);
        int num = SV_WORLD.SV_AreaEdicts(p, p, touch, 1024, 1);
        for (int i = 0; i < num; ++i) {
            edict_t hit = touch[i];
            int headnode = SV_WORLD.SV_HullForEntity(hit);
            if (hit.solid != 3) {
                // empty if block
            }
            int c2 = CM.TransformedPointContents(p, headnode, hit.s.origin, hit.s.angles);
            contents |= c2;
        }
        return contents;
    }

    public static int SV_HullForEntity(edict_t ent) {
        if (ent.solid == 3) {
            cmodel_t model = SV_INIT.sv.models[ent.s.modelindex];
            if (null == model) {
                Com.Error(0, "MOVETYPE_PUSH with a non bsp model");
            }
            return model.headnode;
        }
        return CM.HeadnodeForBox(ent.mins, ent.maxs);
    }

    public static void SV_ClipMoveToEntities(moveclip_t clip) {
        int num = SV_WORLD.SV_AreaEdicts(clip.boxmins, clip.boxmaxs, touchlist, 1024, 1);
        for (int i = 0; i < num; ++i) {
            edict_t touch = touchlist[i];
            if (touch.solid == 0 || touch == clip.passedict) continue;
            if (clip.trace.allsolid) {
                return;
            }
            if (clip.passedict != null && (touch.owner == clip.passedict || clip.passedict.owner == touch) || 0 == (clip.contentmask & 0x4000000) && 0 != (touch.svflags & 2)) continue;
            int headnode = SV_WORLD.SV_HullForEntity(touch);
            float[] angles = touch.s.angles;
            if (touch.solid != 3) {
                angles = Globals.vec3_origin;
            }
            trace_t trace = (touch.svflags & 4) != 0 ? CM.TransformedBoxTrace(clip.start, clip.end, clip.mins2, clip.maxs2, headnode, clip.contentmask, touch.s.origin, angles) : CM.TransformedBoxTrace(clip.start, clip.end, clip.mins, clip.maxs, headnode, clip.contentmask, touch.s.origin, angles);
            if (trace.allsolid || trace.startsolid || trace.fraction < clip.trace.fraction) {
                trace.ent = touch;
                if (clip.trace.startsolid) {
                    clip.trace = trace;
                    clip.trace.startsolid = true;
                    continue;
                }
                clip.trace.set(trace);
                continue;
            }
            if (!trace.startsolid) continue;
            clip.trace.startsolid = true;
        }
    }

    public static void SV_TraceBounds(float[] start, float[] mins, float[] maxs, float[] end, float[] boxmins, float[] boxmaxs) {
        for (int i = 0; i < 3; ++i) {
            if (end[i] > start[i]) {
                boxmins[i] = start[i] + mins[i] - 1.0f;
                boxmaxs[i] = end[i] + maxs[i] + 1.0f;
                continue;
            }
            boxmins[i] = end[i] + mins[i] - 1.0f;
            boxmaxs[i] = start[i] + maxs[i] + 1.0f;
        }
    }

    public static trace_t SV_Trace(float[] start, float[] mins, float[] maxs, float[] end, edict_t passedict, int contentmask) {
        moveclip_t clip = new moveclip_t();
        if (mins == null) {
            mins = Globals.vec3_origin;
        }
        if (maxs == null) {
            maxs = Globals.vec3_origin;
        }
        clip.trace = CM.BoxTrace(start, end, mins, maxs, 0, contentmask);
        clip.trace.ent = GameBase.g_edicts[0];
        if (clip.trace.fraction == 0.0f) {
            return clip.trace;
        }
        clip.contentmask = contentmask;
        clip.start = start;
        clip.end = end;
        clip.mins = mins;
        clip.maxs = maxs;
        clip.passedict = passedict;
        Math3D.VectorCopy(mins, clip.mins2);
        Math3D.VectorCopy(maxs, clip.maxs2);
        SV_WORLD.SV_TraceBounds(start, clip.mins2, clip.maxs2, end, clip.boxmins, clip.boxmaxs);
        SV_WORLD.SV_ClipMoveToEntities(clip);
        return clip.trace;
    }

    static {
        SV_WORLD.initNodes();
        leafs = new int[128];
        clusters = new int[128];
        touch = new edict_t[1024];
        touchlist = new edict_t[1024];
    }
}

