/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.GameBase;
import jake2.game.Info;
import jake2.game.PlayerClient;
import jake2.game.edict_t;
import jake2.game.entity_state_t;
import jake2.game.usercmd_t;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.server.SV_INIT;
import jake2.server.SV_MAIN;
import jake2.server.client_t;
import jake2.util.Lib;
import java.io.IOException;

public class SV_USER {
    static edict_t sv_player;
    static ucmd_t u1;
    static ucmd_t[] ucmds;
    public static final int MAX_STRINGCMDS = 8;

    public static void SV_BeginDemoserver() {
        String name = "demos/" + SV_INIT.sv.name;
        try {
            SV_INIT.sv.demofile = FS.FOpenFile(name);
        }
        catch (IOException e) {
            Com.Error(1, "Couldn't open " + name + "\n");
        }
        if (SV_INIT.sv.demofile == null) {
            Com.Error(1, "Couldn't open " + name + "\n");
        }
    }

    public static void SV_New_f() {
        Com.DPrintf("New() from " + SV_MAIN.sv_client.name + "\n");
        if (SV_MAIN.sv_client.state != 2) {
            Com.Printf("New not valid -- already spawned\n");
            return;
        }
        if (SV_INIT.sv.state == 4) {
            SV_USER.SV_BeginDemoserver();
            return;
        }
        String gamedir = Cvar.VariableString("gamedir");
        MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 12);
        MSG.WriteInt(SV_MAIN.sv_client.netchan.message, 34);
        MSG.WriteLong(SV_MAIN.sv_client.netchan.message, SV_INIT.svs.spawncount);
        MSG.WriteByte(SV_MAIN.sv_client.netchan.message, SV_INIT.sv.attractloop ? 1 : 0);
        MSG.WriteString(SV_MAIN.sv_client.netchan.message, gamedir);
        int playernum = SV_INIT.sv.state == 3 || SV_INIT.sv.state == 5 ? -1 : SV_MAIN.sv_client.serverindex;
        MSG.WriteShort(SV_MAIN.sv_client.netchan.message, playernum);
        MSG.WriteString(SV_MAIN.sv_client.netchan.message, SV_INIT.sv.configstrings[0]);
        if (SV_INIT.sv.state == 2) {
            edict_t ent = GameBase.g_edicts[playernum + 1];
            ent.s.number = playernum + 1;
            SV_MAIN.sv_client.edict = ent;
            SV_MAIN.sv_client.lastcmd = new usercmd_t();
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 11);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, "cmd configstrings " + SV_INIT.svs.spawncount + " 0\n");
        }
    }

    public static void SV_Configstrings_f() {
        int start;
        Com.DPrintf("Configstrings() from " + SV_MAIN.sv_client.name + "\n");
        if (SV_MAIN.sv_client.state != 2) {
            Com.Printf("configstrings not valid -- already spawned\n");
            return;
        }
        if (Lib.atoi(Cmd.Argv(1)) != SV_INIT.svs.spawncount) {
            Com.Printf("SV_Configstrings_f from different level\n");
            SV_USER.SV_New_f();
            return;
        }
        for (start = Lib.atoi(Cmd.Argv(2)); SV_MAIN.sv_client.netchan.message.cursize < 700 && start < 2080; ++start) {
            if (SV_INIT.sv.configstrings[start] == null || SV_INIT.sv.configstrings[start].length() == 0) continue;
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 13);
            MSG.WriteShort(SV_MAIN.sv_client.netchan.message, start);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, SV_INIT.sv.configstrings[start]);
        }
        if (start == 2080) {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 11);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, "cmd baselines " + SV_INIT.svs.spawncount + " 0\n");
        } else {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 11);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, "cmd configstrings " + SV_INIT.svs.spawncount + " " + start + "\n");
        }
    }

    public static void SV_Baselines_f() {
        int start;
        Com.DPrintf("Baselines() from " + SV_MAIN.sv_client.name + "\n");
        if (SV_MAIN.sv_client.state != 2) {
            Com.Printf("baselines not valid -- already spawned\n");
            return;
        }
        if (Lib.atoi(Cmd.Argv(1)) != SV_INIT.svs.spawncount) {
            Com.Printf("SV_Baselines_f from different level\n");
            SV_USER.SV_New_f();
            return;
        }
        entity_state_t nullstate = new entity_state_t(null);
        for (start = Lib.atoi(Cmd.Argv(2)); SV_MAIN.sv_client.netchan.message.cursize < 700 && start < 1024; ++start) {
            entity_state_t base = SV_INIT.sv.baselines[start];
            if (base.modelindex == 0 && base.sound == 0 && base.effects == 0) continue;
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 14);
            MSG.WriteDeltaEntity(nullstate, base, SV_MAIN.sv_client.netchan.message, true, true);
        }
        if (start == 1024) {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 11);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, "precache " + SV_INIT.svs.spawncount + "\n");
        } else {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 11);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, "cmd baselines " + SV_INIT.svs.spawncount + " " + start + "\n");
        }
    }

    public static void SV_Begin_f() {
        Com.DPrintf("Begin() from " + SV_MAIN.sv_client.name + "\n");
        if (Lib.atoi(Cmd.Argv(1)) != SV_INIT.svs.spawncount) {
            Com.Printf("SV_Begin_f from different level\n");
            SV_USER.SV_New_f();
            return;
        }
        SV_MAIN.sv_client.state = 3;
        PlayerClient.ClientBegin(sv_player);
        Cbuf.InsertFromDefer();
    }

    public static void SV_NextDownload_f() {
        if (SV_MAIN.sv_client.download == null) {
            return;
        }
        int r = SV_MAIN.sv_client.downloadsize - SV_MAIN.sv_client.downloadcount;
        if (r > 1024) {
            r = 1024;
        }
        MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 16);
        MSG.WriteShort(SV_MAIN.sv_client.netchan.message, r);
        SV_MAIN.sv_client.downloadcount += r;
        int size = SV_MAIN.sv_client.downloadsize;
        if (size == 0) {
            size = 1;
        }
        int percent = SV_MAIN.sv_client.downloadcount * 100 / size;
        MSG.WriteByte(SV_MAIN.sv_client.netchan.message, percent);
        SZ.Write(SV_MAIN.sv_client.netchan.message, SV_MAIN.sv_client.download, SV_MAIN.sv_client.downloadcount - r, r);
        if (SV_MAIN.sv_client.downloadcount != SV_MAIN.sv_client.downloadsize) {
            return;
        }
        FS.FreeFile(SV_MAIN.sv_client.download);
        SV_MAIN.sv_client.download = null;
    }

    public static void SV_BeginDownload_f() {
        int offset = 0;
        String name = Cmd.Argv(1);
        if (Cmd.Argc() > 2) {
            offset = Lib.atoi(Cmd.Argv(2));
        }
        if (name.indexOf("..") != -1 || SV_MAIN.allow_download.value == 0.0f || name.charAt(0) == '.' || name.charAt(0) == '/' || name.startsWith("players/") && 0.0f == SV_MAIN.allow_download_players.value || name.startsWith("models/") && 0.0f == SV_MAIN.allow_download_models.value || name.startsWith("sound/") && 0.0f == SV_MAIN.allow_download_sounds.value || name.startsWith("maps/") && 0.0f == SV_MAIN.allow_download_maps.value || name.indexOf(47) == -1) {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 16);
            MSG.WriteShort(SV_MAIN.sv_client.netchan.message, -1);
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 0);
            return;
        }
        if (SV_MAIN.sv_client.download != null) {
            FS.FreeFile(SV_MAIN.sv_client.download);
        }
        SV_MAIN.sv_client.download = FS.LoadFile(name);
        if (SV_MAIN.sv_client.download == null) {
            return;
        }
        SV_MAIN.sv_client.downloadsize = SV_MAIN.sv_client.download.length;
        SV_MAIN.sv_client.downloadcount = offset;
        if (offset > SV_MAIN.sv_client.downloadsize) {
            SV_MAIN.sv_client.downloadcount = SV_MAIN.sv_client.downloadsize;
        }
        if (SV_MAIN.sv_client.download == null || name.startsWith("maps/") && FS.file_from_pak != 0) {
            Com.DPrintf("Couldn't download " + name + " to " + SV_MAIN.sv_client.name + "\n");
            if (SV_MAIN.sv_client.download != null) {
                FS.FreeFile(SV_MAIN.sv_client.download);
                SV_MAIN.sv_client.download = null;
            }
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 16);
            MSG.WriteShort(SV_MAIN.sv_client.netchan.message, -1);
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 0);
            return;
        }
        SV_USER.SV_NextDownload_f();
        Com.DPrintf("Downloading " + name + " to " + SV_MAIN.sv_client.name + "\n");
    }

    public static void SV_Disconnect_f() {
        SV_MAIN.SV_DropClient(SV_MAIN.sv_client);
    }

    public static void SV_ShowServerinfo_f() {
        Info.Print(Cvar.Serverinfo());
    }

    public static void SV_Nextserver() {
        if (SV_INIT.sv.state == 2 || SV_INIT.sv.state == 5 && 0.0f == Cvar.VariableValue("coop")) {
            return;
        }
        ++SV_INIT.svs.spawncount;
        String v = Cvar.VariableString("nextserver");
        if (v.length() == 0) {
            Cbuf.AddText("killserver\n");
        } else {
            Cbuf.AddText(v);
            Cbuf.AddText("\n");
        }
        Cvar.Set("nextserver", "");
    }

    public static void SV_Nextserver_f() {
        if (Lib.atoi(Cmd.Argv(1)) != SV_INIT.svs.spawncount) {
            Com.DPrintf("Nextserver() from wrong level, from " + SV_MAIN.sv_client.name + "\n");
            return;
        }
        Com.DPrintf("Nextserver() from " + SV_MAIN.sv_client.name + "\n");
        SV_USER.SV_Nextserver();
    }

    public static void SV_ExecuteUserCommand(String s) {
        int i;
        Com.dprintln("SV_ExecuteUserCommand:" + s);
        ucmd_t u = null;
        Cmd.TokenizeString(s.toCharArray(), true);
        sv_player = SV_MAIN.sv_client.edict;
        for (i = 0; i < ucmds.length; ++i) {
            u = ucmds[i];
            if (!Cmd.Argv(0).equals(u.name)) continue;
            u.r.run();
            break;
        }
        if (i == ucmds.length && SV_INIT.sv.state == 2) {
            Cmd.ClientCommand(sv_player);
        }
    }

    public static void SV_ClientThink(client_t cl, usercmd_t cmd) {
        cl.commandMsec -= cmd.msec & 0xFF;
        if (cl.commandMsec < 0 && SV_MAIN.sv_enforcetime.value != 0.0f) {
            Com.DPrintf("commandMsec underflow from " + cl.name + "\n");
            return;
        }
        PlayerClient.ClientThink(cl.edict, cmd);
    }

    public static void SV_ExecuteClientMessage(client_t cl) {
        block19: {
            usercmd_t nullcmd = new usercmd_t();
            usercmd_t oldest = new usercmd_t();
            usercmd_t oldcmd = new usercmd_t();
            usercmd_t newcmd = new usercmd_t();
            SV_MAIN.sv_client = cl;
            sv_player = SV_MAIN.sv_client.edict;
            boolean move_issued = false;
            int stringCmdCount = 0;
            block6: while (true) {
                if (Globals.net_message.readcount > Globals.net_message.cursize) {
                    Com.Printf("SV_ReadClientMessage: bad read:\n");
                    Com.Printf(Lib.hexDump(Globals.net_message.data, 32, false));
                    SV_MAIN.SV_DropClient(cl);
                    return;
                }
                int c = MSG.ReadByte(Globals.net_message);
                if (c == -1) break block19;
                switch (c) {
                    default: {
                        Com.Printf("SV_ReadClientMessage: unknown command char\n");
                        SV_MAIN.SV_DropClient(cl);
                        return;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 3: {
                        cl.userinfo = MSG.ReadString(Globals.net_message);
                        SV_MAIN.SV_UserinfoChanged(cl);
                        continue block6;
                    }
                    case 2: {
                        if (move_issued) {
                            return;
                        }
                        move_issued = true;
                        int checksumIndex = Globals.net_message.readcount;
                        int checksum = MSG.ReadByte(Globals.net_message);
                        int lastframe = MSG.ReadLong(Globals.net_message);
                        if (lastframe != cl.lastframe) {
                            cl.lastframe = lastframe;
                            if (cl.lastframe > 0) {
                                cl.frame_latency[cl.lastframe & 0xF] = SV_INIT.svs.realtime - cl.frames[cl.lastframe & 0xF].senttime;
                            }
                        }
                        nullcmd = new usercmd_t();
                        MSG.ReadDeltaUsercmd(Globals.net_message, nullcmd, oldest);
                        MSG.ReadDeltaUsercmd(Globals.net_message, oldest, oldcmd);
                        MSG.ReadDeltaUsercmd(Globals.net_message, oldcmd, newcmd);
                        if (cl.state != 3) {
                            cl.lastframe = -1;
                            continue block6;
                        }
                        byte calculatedChecksum = Com.BlockSequenceCRCByte(Globals.net_message.data, checksumIndex + 1, Globals.net_message.readcount - checksumIndex - 1, cl.netchan.incoming_sequence);
                        if ((calculatedChecksum & 0xFF) != checksum) {
                            Com.DPrintf("Failed command checksum for " + cl.name + " (" + calculatedChecksum + " != " + checksum + ")/" + cl.netchan.incoming_sequence + "\n");
                            return;
                        }
                        if (0.0f == SV_MAIN.sv_paused.value) {
                            int net_drop = cl.netchan.dropped;
                            if (net_drop < 20) {
                                while (net_drop > 2) {
                                    SV_USER.SV_ClientThink(cl, cl.lastcmd);
                                    --net_drop;
                                }
                                if (net_drop > 1) {
                                    SV_USER.SV_ClientThink(cl, oldest);
                                }
                                if (net_drop > 0) {
                                    SV_USER.SV_ClientThink(cl, oldcmd);
                                }
                            }
                            SV_USER.SV_ClientThink(cl, newcmd);
                        }
                        cl.lastcmd.set(newcmd);
                        continue block6;
                    }
                    case 4: 
                }
                String s = MSG.ReadString(Globals.net_message);
                if (++stringCmdCount < 8) {
                    SV_USER.SV_ExecuteUserCommand(s);
                }
                if (cl.state == 1) break;
            }
            return;
        }
    }

    static {
        u1 = new ucmd_t("new", new Runnable(){

            public void run() {
                SV_USER.SV_New_f();
            }
        });
        ucmds = new ucmd_t[]{new ucmd_t("new", new Runnable(){

            public void run() {
                SV_USER.SV_New_f();
            }
        }), new ucmd_t("configstrings", new Runnable(){

            public void run() {
                SV_USER.SV_Configstrings_f();
            }
        }), new ucmd_t("baselines", new Runnable(){

            public void run() {
                SV_USER.SV_Baselines_f();
            }
        }), new ucmd_t("begin", new Runnable(){

            public void run() {
                SV_USER.SV_Begin_f();
            }
        }), new ucmd_t("nextserver", new Runnable(){

            public void run() {
                SV_USER.SV_Nextserver_f();
            }
        }), new ucmd_t("disconnect", new Runnable(){

            public void run() {
                SV_USER.SV_Disconnect_f();
            }
        }), new ucmd_t("info", new Runnable(){

            public void run() {
                SV_USER.SV_ShowServerinfo_f();
            }
        }), new ucmd_t("download", new Runnable(){

            public void run() {
                SV_USER.SV_BeginDownload_f();
            }
        }), new ucmd_t("nextdl", new Runnable(){

            public void run() {
                SV_USER.SV_NextDownload_f();
            }
        })};
    }

    public static class ucmd_t {
        String name;
        Runnable r;

        public ucmd_t(String n, Runnable r) {
            this.name = n;
            this.r = r;
        }
    }
}

