/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.EndianHandler;
import jake2.game.edict_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.MSG;
import jake2.qcommon.Netchan;
import jake2.qcommon.SZ;
import jake2.qcommon.sizebuf_t;
import jake2.server.SV_ENTS;
import jake2.server.SV_INIT;
import jake2.server.SV_MAIN;
import jake2.server.SV_USER;
import jake2.server.client_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.io.IOException;

public class SV_SEND {
    public static StringBuffer sv_outputbuf = new StringBuffer();
    private static final float[] origin_v = new float[]{0.0f, 0.0f, 0.0f};
    private static final sizebuf_t msg = new sizebuf_t();
    private static final byte[] msgbuf = new byte[1400];
    private static final byte[] NULLBYTE = new byte[]{0};

    public static void SV_FlushRedirect(int sv_redirected, byte[] outputbuf) {
        if (sv_redirected == 2) {
            String s = "print\n" + Lib.CtoJava(outputbuf);
            Netchan.Netchan_OutOfBand(1, Globals.net_from, s.length(), Lib.stringToBytes(s));
        } else if (sv_redirected == 1) {
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 10);
            MSG.WriteByte(SV_MAIN.sv_client.netchan.message, 2);
            MSG.WriteString(SV_MAIN.sv_client.netchan.message, outputbuf);
        }
    }

    public static void SV_ClientPrintf(client_t cl, int level, String s) {
        if (level < cl.messagelevel) {
            return;
        }
        MSG.WriteByte(cl.netchan.message, 10);
        MSG.WriteByte(cl.netchan.message, level);
        MSG.WriteString(cl.netchan.message, s);
    }

    public static void SV_BroadcastPrintf(int level, String s) {
        if (Globals.dedicated.value != 0.0f) {
            Com.Printf(s);
        }
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (level >= cl.messagelevel && cl.state == 3) {
                MSG.WriteByte(cl.netchan.message, 10);
                MSG.WriteByte(cl.netchan.message, level);
                MSG.WriteString(cl.netchan.message, s);
            }
            ++i;
        }
    }

    public static void SV_BroadcastCommand(String s) {
        if (SV_INIT.sv.state == 0) {
            return;
        }
        MSG.WriteByte(SV_INIT.sv.multicast, 11);
        MSG.WriteString(SV_INIT.sv.multicast, s);
        SV_SEND.SV_Multicast(null, 3);
    }

    public static void SV_Multicast(float[] origin, int to) {
        int cluster;
        byte[] mask;
        int area1;
        int leafnum;
        boolean reliable = false;
        if (to != 3 && to != 0) {
            leafnum = CM.CM_PointLeafnum(origin);
            area1 = CM.CM_LeafArea(leafnum);
        } else {
            leafnum = 0;
            area1 = 0;
        }
        if (SV_INIT.svs.demofile != null) {
            SZ.Write(SV_INIT.svs.demo_multicast, SV_INIT.sv.multicast.data, SV_INIT.sv.multicast.cursize);
        }
        switch (to) {
            case 3: {
                reliable = true;
            }
            case 0: {
                leafnum = 0;
                mask = null;
                break;
            }
            case 4: {
                reliable = true;
            }
            case 1: {
                leafnum = CM.CM_PointLeafnum(origin);
                cluster = CM.CM_LeafCluster(leafnum);
                mask = CM.CM_ClusterPHS(cluster);
                break;
            }
            case 5: {
                reliable = true;
            }
            case 2: {
                leafnum = CM.CM_PointLeafnum(origin);
                cluster = CM.CM_LeafCluster(leafnum);
                mask = CM.CM_ClusterPVS(cluster);
                break;
            }
            default: {
                mask = null;
                Com.Error(0, "SV_Multicast: bad to:" + to + "\n");
            }
        }
        int j = 0;
        while ((float)j < SV_MAIN.maxclients.value) {
            block17: {
                client_t client;
                block18: {
                    client = SV_INIT.svs.clients[j];
                    if (client.state == 0 || client.state == 1 || client.state != 3 && !reliable) break block17;
                    if (mask == null) break block18;
                    leafnum = CM.CM_PointLeafnum(client.edict.s.origin);
                    cluster = CM.CM_LeafCluster(leafnum);
                    int area2 = CM.CM_LeafArea(leafnum);
                    if (!CM.CM_AreasConnected(area1, area2) || cluster == -1 || mask != null && 0 == (mask[cluster >> 3] & 1 << (cluster & 7))) break block17;
                }
                if (reliable) {
                    SZ.Write(client.netchan.message, SV_INIT.sv.multicast.data, SV_INIT.sv.multicast.cursize);
                } else {
                    SZ.Write(client.datagram, SV_INIT.sv.multicast.data, SV_INIT.sv.multicast.cursize);
                }
            }
            ++j;
        }
        SZ.Clear(SV_INIT.sv.multicast);
    }

    public static void SV_StartSound(float[] origin, edict_t entity, int channel, int soundindex, float volume, float attenuation, float timeofs) {
        boolean use_phs;
        if (volume < 0.0f || (double)volume > 1.0) {
            Com.Error(0, "SV_StartSound: volume = " + volume);
        }
        if (attenuation < 0.0f || attenuation > 4.0f) {
            Com.Error(0, "SV_StartSound: attenuation = " + attenuation);
        }
        if (timeofs < 0.0f || (double)timeofs > 0.255) {
            Com.Error(0, "SV_StartSound: timeofs = " + timeofs);
        }
        int ent = entity.index;
        if ((channel & 8) != 0) {
            use_phs = false;
            channel &= 7;
        } else {
            use_phs = true;
        }
        int sendchan = ent << 3 | channel & 7;
        int flags = 0;
        if (volume != 1.0f) {
            flags |= 1;
        }
        if (attenuation != 1.0f) {
            flags |= 2;
        }
        if ((entity.svflags & 1) != 0 || entity.solid == 3 || origin != null) {
            flags |= 4;
        }
        flags |= 8;
        if (timeofs != 0.0f) {
            flags |= 0x10;
        }
        if (origin == null) {
            origin = origin_v;
            if (entity.solid == 3) {
                for (int i = 0; i < 3; ++i) {
                    SV_SEND.origin_v[i] = entity.s.origin[i] + 0.5f * (entity.mins[i] + entity.maxs[i]);
                }
            } else {
                Math3D.VectorCopy(entity.s.origin, origin_v);
            }
        }
        MSG.WriteByte(SV_INIT.sv.multicast, 9);
        MSG.WriteByte(SV_INIT.sv.multicast, flags);
        MSG.WriteByte(SV_INIT.sv.multicast, soundindex);
        if ((flags & 1) != 0) {
            MSG.WriteByte(SV_INIT.sv.multicast, volume * 255.0f);
        }
        if ((flags & 2) != 0) {
            MSG.WriteByte(SV_INIT.sv.multicast, attenuation * 64.0f);
        }
        if ((flags & 0x10) != 0) {
            MSG.WriteByte(SV_INIT.sv.multicast, timeofs * 1000.0f);
        }
        if ((flags & 8) != 0) {
            MSG.WriteShort(SV_INIT.sv.multicast, sendchan);
        }
        if ((flags & 4) != 0) {
            MSG.WritePos(SV_INIT.sv.multicast, origin);
        }
        if (attenuation == 0.0f) {
            use_phs = false;
        }
        if ((channel & 0x10) != 0) {
            if (use_phs) {
                SV_SEND.SV_Multicast(origin, 4);
            } else {
                SV_SEND.SV_Multicast(origin, 3);
            }
        } else if (use_phs) {
            SV_SEND.SV_Multicast(origin, 1);
        } else {
            SV_SEND.SV_Multicast(origin, 0);
        }
    }

    public static boolean SV_SendClientDatagram(client_t client) {
        SV_ENTS.SV_BuildClientFrame(client);
        SZ.Init(msg, msgbuf, msgbuf.length);
        SV_SEND.msg.allowoverflow = true;
        SV_ENTS.SV_WriteFrameToClient(client, msg);
        if (client.datagram.overflowed) {
            Com.Printf("WARNING: datagram overflowed for " + client.name + "\n");
        } else {
            SZ.Write(msg, client.datagram.data, client.datagram.cursize);
        }
        SZ.Clear(client.datagram);
        if (SV_SEND.msg.overflowed) {
            Com.Printf("WARNING: msg overflowed for " + client.name + "\n");
            SZ.Clear(msg);
        }
        Netchan.Transmit(client.netchan, SV_SEND.msg.cursize, SV_SEND.msg.data);
        client.message_size[SV_INIT.sv.framenum % 10] = SV_SEND.msg.cursize;
        return true;
    }

    public static void SV_DemoCompleted() {
        if (SV_INIT.sv.demofile != null) {
            try {
                SV_INIT.sv.demofile.close();
            }
            catch (IOException e) {
                Com.Printf("IOError closing d9emo fiele:" + e);
            }
            SV_INIT.sv.demofile = null;
        }
        SV_USER.SV_Nextserver();
    }

    public static boolean SV_RateDrop(client_t c) {
        if (c.netchan.remote_address.type == 0) {
            return false;
        }
        int total = 0;
        for (int i = 0; i < 10; ++i) {
            total += c.message_size[i];
        }
        if (total > c.rate) {
            ++c.surpressCount;
            c.message_size[SV_INIT.sv.framenum % 10] = 0;
            return true;
        }
        return false;
    }

    public static void SV_SendClientMessages() {
        int msglen = 0;
        if (SV_INIT.sv.state == 4 && SV_INIT.sv.demofile != null) {
            if (SV_MAIN.sv_paused.value != 0.0f) {
                msglen = 0;
            } else {
                try {
                    msglen = EndianHandler.swapInt(SV_INIT.sv.demofile.readInt());
                }
                catch (Exception e) {
                    SV_SEND.SV_DemoCompleted();
                    return;
                }
                if (msglen == -1) {
                    SV_SEND.SV_DemoCompleted();
                    return;
                }
                if (msglen > 1400) {
                    Com.Error(1, "SV_SendClientMessages: msglen > MAX_MSGLEN");
                }
                int r = 0;
                try {
                    r = SV_INIT.sv.demofile.read(msgbuf, 0, msglen);
                }
                catch (IOException e1) {
                    Com.Printf("IOError: reading demo file, " + e1);
                }
                if (r != msglen) {
                    SV_SEND.SV_DemoCompleted();
                    return;
                }
            }
        }
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t c = SV_INIT.svs.clients[i];
            if (c.state != 0) {
                if (c.netchan.message.overflowed) {
                    SZ.Clear(c.netchan.message);
                    SZ.Clear(c.datagram);
                    SV_SEND.SV_BroadcastPrintf(2, c.name + " overflowed\n");
                    SV_MAIN.SV_DropClient(c);
                }
                if (SV_INIT.sv.state == 3 || SV_INIT.sv.state == 4 || SV_INIT.sv.state == 5) {
                    Netchan.Transmit(c.netchan, msglen, msgbuf);
                } else if (c.state == 3) {
                    if (!SV_SEND.SV_RateDrop(c)) {
                        SV_SEND.SV_SendClientDatagram(c);
                    }
                } else if (c.netchan.message.cursize != 0 || Globals.curtime - c.netchan.last_sent > 1000) {
                    Netchan.Transmit(c.netchan, 0, NULLBYTE);
                }
            }
            ++i;
        }
    }
}

