/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.GameBase;
import jake2.game.Info;
import jake2.game.PlayerClient;
import jake2.game.cvar_t;
import jake2.game.edict_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.Netchan;
import jake2.qcommon.SZ;
import jake2.qcommon.netadr_t;
import jake2.server.SV_CCMDS;
import jake2.server.SV_ENTS;
import jake2.server.SV_GAME;
import jake2.server.SV_INIT;
import jake2.server.SV_SEND;
import jake2.server.SV_USER;
import jake2.server.client_t;
import jake2.server.server_static_t;
import jake2.server.server_t;
import jake2.sys.NET;
import jake2.sys.Timer;
import jake2.util.Lib;
import java.io.IOException;

public class SV_MAIN {
    public static netadr_t[] master_adr = new netadr_t[8];
    public static client_t sv_client;
    public static cvar_t sv_paused;
    public static cvar_t sv_timedemo;
    public static cvar_t sv_enforcetime;
    public static cvar_t timeout;
    public static cvar_t zombietime;
    public static cvar_t rcon_password;
    public static cvar_t allow_download;
    public static cvar_t allow_download_players;
    public static cvar_t allow_download_models;
    public static cvar_t allow_download_sounds;
    public static cvar_t allow_download_maps;
    public static cvar_t sv_airaccelerate;
    public static cvar_t sv_noreload;
    public static cvar_t maxclients;
    public static cvar_t sv_showclamp;
    public static cvar_t hostname;
    public static cvar_t public_server;
    public static cvar_t sv_reconnect_limit;
    public static final int HEARTBEAT_SECONDS = 300;

    public static void SV_DropClient(client_t drop) {
        MSG.WriteByte(drop.netchan.message, 7);
        if (drop.state == 3) {
            PlayerClient.ClientDisconnect(drop.edict);
        }
        if (drop.download != null) {
            FS.FreeFile(drop.download);
            drop.download = null;
        }
        drop.state = 1;
        drop.name = "";
    }

    public static String SV_StatusString() {
        String status = "";
        status = Cvar.Serverinfo() + "\n";
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (cl.state == 2 || cl.state == 3) {
                String player = "" + cl.edict.client.ps.stats[14] + " " + cl.ping + "\"" + cl.name + "\"\n";
                int playerLength = player.length();
                int statusLength = status.length();
                if (statusLength + playerLength >= 1024) break;
                status = status + player;
            }
            ++i;
        }
        return status;
    }

    public static void SVC_Status() {
        Netchan.OutOfBandPrint(1, Globals.net_from, "print\n" + SV_MAIN.SV_StatusString());
    }

    public static void SVC_Ack() {
        Com.Printf("Ping acknowledge from " + NET.AdrToString(Globals.net_from) + "\n");
    }

    public static void SVC_Info() {
        String string;
        if (SV_MAIN.maxclients.value == 1.0f) {
            return;
        }
        int version = Lib.atoi(Cmd.Argv(1));
        if (version != 34) {
            string = SV_MAIN.hostname.string + ": wrong version\n";
        } else {
            int count = 0;
            int i = 0;
            while ((float)i < SV_MAIN.maxclients.value) {
                if (SV_INIT.svs.clients[i].state >= 2) {
                    ++count;
                }
                ++i;
            }
            string = SV_MAIN.hostname.string + " " + SV_INIT.sv.name + " " + count + "/" + (int)SV_MAIN.maxclients.value + "\n";
        }
        Netchan.OutOfBandPrint(1, Globals.net_from, "info\n" + string);
    }

    public static void SVC_Ping() {
        Netchan.OutOfBandPrint(1, Globals.net_from, "ack");
    }

    public static void SVC_GetChallenge() {
        int i;
        int oldest = 0;
        int oldestTime = Integer.MAX_VALUE;
        for (i = 0; i < 1024 && !NET.CompareBaseAdr(Globals.net_from, SV_INIT.svs.challenges[i].adr); ++i) {
            if (SV_INIT.svs.challenges[i].time >= oldestTime) continue;
            oldestTime = SV_INIT.svs.challenges[i].time;
            oldest = i;
        }
        if (i == 1024) {
            SV_INIT.svs.challenges[oldest].challenge = Lib.rand() & Short.MAX_VALUE;
            SV_INIT.svs.challenges[oldest].adr = Globals.net_from;
            SV_INIT.svs.challenges[oldest].time = Globals.curtime;
            i = oldest;
        }
        Netchan.OutOfBandPrint(1, Globals.net_from, "challenge " + SV_INIT.svs.challenges[i].challenge);
    }

    public static void SVC_DirectConnect() {
        client_t cl;
        int i;
        netadr_t adr = Globals.net_from;
        Com.DPrintf("SVC_DirectConnect ()\n");
        int version = Lib.atoi(Cmd.Argv(1));
        if (version != 34) {
            Netchan.OutOfBandPrint(1, adr, "print\nServer is version 3.21\n");
            Com.DPrintf("    rejected connect from version " + version + "\n");
            return;
        }
        int qport = Lib.atoi(Cmd.Argv(2));
        int challenge = Lib.atoi(Cmd.Argv(3));
        String userinfo = Cmd.Argv(4);
        userinfo = Info.Info_SetValueForKey(userinfo, "ip", NET.AdrToString(Globals.net_from));
        if (SV_INIT.sv.attractloop && !NET.IsLocalAddress(adr)) {
            Com.Printf("Remote connect in attract loop.  Ignored.\n");
            Netchan.OutOfBandPrint(1, adr, "print\nConnection refused.\n");
            return;
        }
        if (!NET.IsLocalAddress(adr)) {
            for (i = 0; i < 1024; ++i) {
                if (!NET.CompareBaseAdr(Globals.net_from, SV_INIT.svs.challenges[i].adr)) continue;
                if (challenge == SV_INIT.svs.challenges[i].challenge) break;
                Netchan.OutOfBandPrint(1, adr, "print\nBad challenge.\n");
                return;
            }
            if (i == 1024) {
                Netchan.OutOfBandPrint(1, adr, "print\nNo challenge for address.\n");
                return;
            }
        }
        i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            cl = SV_INIT.svs.clients[i];
            if (cl.state != 0 && NET.CompareBaseAdr(adr, cl.netchan.remote_address) && (cl.netchan.qport == qport || adr.port == cl.netchan.remote_address.port)) {
                if (!NET.IsLocalAddress(adr) && SV_INIT.svs.realtime - cl.lastconnect < (int)SV_MAIN.sv_reconnect_limit.value * 1000) {
                    Com.DPrintf(NET.AdrToString(adr) + ":reconnect rejected : too soon\n");
                    return;
                }
                Com.Printf(NET.AdrToString(adr) + ":reconnect\n");
                SV_MAIN.gotnewcl(i, challenge, userinfo, adr, qport);
                return;
            }
            ++i;
        }
        int index = -1;
        i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            cl = SV_INIT.svs.clients[i];
            if (cl.state == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            Netchan.OutOfBandPrint(1, adr, "print\nServer is full.\n");
            Com.DPrintf("Rejected a connection.\n");
            return;
        }
        SV_MAIN.gotnewcl(index, challenge, userinfo, adr, qport);
    }

    public static void gotnewcl(int i, int challenge, String userinfo, netadr_t adr, int qport) {
        edict_t ent;
        sv_client = SV_INIT.svs.clients[i];
        int edictnum = i + 1;
        SV_INIT.svs.clients[i].edict = ent = GameBase.g_edicts[edictnum];
        SV_INIT.svs.clients[i].challenge = challenge;
        if (!PlayerClient.ClientConnect(ent, userinfo)) {
            if (Info.Info_ValueForKey(userinfo, "rejmsg") != null) {
                Netchan.OutOfBandPrint(1, adr, "print\n" + Info.Info_ValueForKey(userinfo, "rejmsg") + "\nConnection refused.\n");
            } else {
                Netchan.OutOfBandPrint(1, adr, "print\nConnection refused.\n");
            }
            Com.DPrintf("Game rejected a connection.\n");
            return;
        }
        SV_INIT.svs.clients[i].userinfo = userinfo;
        SV_MAIN.SV_UserinfoChanged(SV_INIT.svs.clients[i]);
        Netchan.OutOfBandPrint(1, adr, "client_connect");
        Netchan.Setup(1, SV_INIT.svs.clients[i].netchan, adr, qport);
        SV_INIT.svs.clients[i].state = 2;
        SZ.Init(SV_INIT.svs.clients[i].datagram, SV_INIT.svs.clients[i].datagram_buf, SV_INIT.svs.clients[i].datagram_buf.length);
        SV_INIT.svs.clients[i].datagram.allowoverflow = true;
        SV_INIT.svs.clients[i].lastmessage = SV_INIT.svs.realtime;
        SV_INIT.svs.clients[i].lastconnect = SV_INIT.svs.realtime;
        Com.DPrintf("new client added.\n");
    }

    public static int Rcon_Validate() {
        if (0 == SV_MAIN.rcon_password.string.length()) {
            return 0;
        }
        if (0 != Lib.strcmp(Cmd.Argv(1), SV_MAIN.rcon_password.string)) {
            return 0;
        }
        return 1;
    }

    public static void SVC_RemoteCommand() {
        int i = SV_MAIN.Rcon_Validate();
        String msg = Lib.CtoJava(Globals.net_message.data, 4, 1024);
        if (i == 0) {
            Com.Printf("Bad rcon from " + NET.AdrToString(Globals.net_from) + ":\n" + msg + "\n");
        } else {
            Com.Printf("Rcon from " + NET.AdrToString(Globals.net_from) + ":\n" + msg + "\n");
        }
        Com.BeginRedirect(2, SV_SEND.sv_outputbuf, 1384, new Com.RD_Flusher(){

            public void rd_flush(int target, StringBuffer buffer) {
                SV_SEND.SV_FlushRedirect(target, Lib.stringToBytes(buffer.toString()));
            }
        });
        if (0 == SV_MAIN.Rcon_Validate()) {
            Com.Printf("Bad rcon_password.\n");
        } else {
            String remaining = "";
            for (i = 2; i < Cmd.Argc(); ++i) {
                remaining = remaining + Cmd.Argv(i);
                remaining = remaining + " ";
            }
            Cmd.ExecuteString(remaining);
        }
        Com.EndRedirect();
    }

    public static void SV_ConnectionlessPacket() {
        MSG.BeginReading(Globals.net_message);
        MSG.ReadLong(Globals.net_message);
        String s = MSG.ReadStringLine(Globals.net_message);
        Cmd.TokenizeString(s.toCharArray(), false);
        String c = Cmd.Argv(0);
        if (0 == Lib.strcmp(c, "ping")) {
            SV_MAIN.SVC_Ping();
        } else if (0 == Lib.strcmp(c, "ack")) {
            SV_MAIN.SVC_Ack();
        } else if (0 == Lib.strcmp(c, "status")) {
            SV_MAIN.SVC_Status();
        } else if (0 == Lib.strcmp(c, "info")) {
            SV_MAIN.SVC_Info();
        } else if (0 == Lib.strcmp(c, "getchallenge")) {
            SV_MAIN.SVC_GetChallenge();
        } else if (0 == Lib.strcmp(c, "connect")) {
            SV_MAIN.SVC_DirectConnect();
        } else if (0 == Lib.strcmp(c, "rcon")) {
            SV_MAIN.SVC_RemoteCommand();
        } else {
            Com.Printf("bad connectionless packet from " + NET.AdrToString(Globals.net_from) + "\n");
            Com.Printf("[" + s + "]\n");
            Com.Printf("" + Lib.hexDump(Globals.net_message.data, 128, false));
        }
    }

    public static void SV_CalcPings() {
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (cl.state == 3) {
                int total = 0;
                int count = 0;
                for (int j = 0; j < 16; ++j) {
                    if (cl.frame_latency[j] <= 0) continue;
                    ++count;
                    total += cl.frame_latency[j];
                }
                cl.ping = 0 == count ? 0 : total / count;
                cl.edict.client.ping = cl.ping;
            }
            ++i;
        }
    }

    public static void SV_GiveMsec() {
        if ((SV_INIT.sv.framenum & 0xF) != 0) {
            return;
        }
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (cl.state != 0) {
                cl.commandMsec = 1800;
            }
            ++i;
        }
    }

    public static void SV_ReadPackets() {
        int qport = 0;
        while (NET.GetPacket(1, Globals.net_from, Globals.net_message)) {
            if (Globals.net_message.data[0] == -1 && Globals.net_message.data[1] == -1 && Globals.net_message.data[2] == -1 && Globals.net_message.data[3] == -1) {
                SV_MAIN.SV_ConnectionlessPacket();
                continue;
            }
            MSG.BeginReading(Globals.net_message);
            MSG.ReadLong(Globals.net_message);
            MSG.ReadLong(Globals.net_message);
            qport = MSG.ReadShort(Globals.net_message) & 0xFFFF;
            int i = 0;
            while ((float)i < SV_MAIN.maxclients.value) {
                client_t cl = SV_INIT.svs.clients[i];
                if (cl.state != 0 && NET.CompareBaseAdr(Globals.net_from, cl.netchan.remote_address) && cl.netchan.qport == qport) {
                    if (cl.netchan.remote_address.port != Globals.net_from.port) {
                        Com.Printf("SV_ReadPackets: fixing up a translated port\n");
                        cl.netchan.remote_address.port = Globals.net_from.port;
                    }
                    if (!Netchan.Process(cl.netchan, Globals.net_message) || cl.state == 1) break;
                    cl.lastmessage = SV_INIT.svs.realtime;
                    SV_USER.SV_ExecuteClientMessage(cl);
                    break;
                }
                ++i;
            }
            if ((float)i == SV_MAIN.maxclients.value) continue;
        }
    }

    public static void SV_CheckTimeouts() {
        int droppoint = (int)((float)SV_INIT.svs.realtime - 1000.0f * SV_MAIN.timeout.value);
        int zombiepoint = (int)((float)SV_INIT.svs.realtime - 1000.0f * SV_MAIN.zombietime.value);
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (cl.lastmessage > SV_INIT.svs.realtime) {
                cl.lastmessage = SV_INIT.svs.realtime;
            }
            if (cl.state == 1 && cl.lastmessage < zombiepoint) {
                cl.state = 0;
            } else if ((cl.state == 2 || cl.state == 3) && cl.lastmessage < droppoint) {
                SV_SEND.SV_BroadcastPrintf(2, cl.name + " timed out\n");
                SV_MAIN.SV_DropClient(cl);
                cl.state = 0;
            }
            ++i;
        }
    }

    public static void SV_PrepWorldFrame() {
        for (int i = 0; i < GameBase.num_edicts; ++i) {
            edict_t ent = GameBase.g_edicts[i];
            ent.s.event = 0;
        }
    }

    public static void SV_RunGameFrame() {
        if (Globals.host_speeds.value != 0.0f) {
            Globals.time_before_game = Timer.Milliseconds();
        }
        ++SV_INIT.sv.framenum;
        SV_INIT.sv.time = SV_INIT.sv.framenum * 100;
        if (0.0f == SV_MAIN.sv_paused.value || SV_MAIN.maxclients.value > 1.0f) {
            GameBase.G_RunFrame();
            if (SV_INIT.sv.time < SV_INIT.svs.realtime) {
                if (SV_MAIN.sv_showclamp.value != 0.0f) {
                    Com.Printf("sv highclamp\n");
                }
                SV_INIT.svs.realtime = SV_INIT.sv.time;
            }
        }
        if (Globals.host_speeds.value != 0.0f) {
            Globals.time_after_game = Timer.Milliseconds();
        }
    }

    public static void SV_Frame(long msec) {
        Globals.time_after_game = 0;
        Globals.time_before_game = 0;
        if (!SV_INIT.svs.initialized) {
            return;
        }
        SV_INIT.svs.realtime = (int)((long)SV_INIT.svs.realtime + msec);
        Lib.rand();
        SV_MAIN.SV_CheckTimeouts();
        SV_MAIN.SV_ReadPackets();
        if (0.0f == SV_MAIN.sv_timedemo.value && SV_INIT.svs.realtime < SV_INIT.sv.time) {
            if (SV_INIT.sv.time - SV_INIT.svs.realtime > 100) {
                if (SV_MAIN.sv_showclamp.value != 0.0f) {
                    Com.Printf("sv lowclamp\n");
                }
                SV_INIT.svs.realtime = SV_INIT.sv.time - 100;
            }
            NET.Sleep(SV_INIT.sv.time - SV_INIT.svs.realtime);
            return;
        }
        SV_MAIN.SV_CalcPings();
        SV_MAIN.SV_GiveMsec();
        SV_MAIN.SV_RunGameFrame();
        SV_SEND.SV_SendClientMessages();
        SV_ENTS.SV_RecordDemoMessage();
        SV_MAIN.Master_Heartbeat();
        SV_MAIN.SV_PrepWorldFrame();
    }

    public static void Master_Heartbeat() {
        if (Globals.dedicated == null || 0.0f == Globals.dedicated.value) {
            return;
        }
        if (null == public_server || 0.0f == SV_MAIN.public_server.value) {
            return;
        }
        if (SV_INIT.svs.last_heartbeat > SV_INIT.svs.realtime) {
            SV_INIT.svs.last_heartbeat = SV_INIT.svs.realtime;
        }
        if (SV_INIT.svs.realtime - SV_INIT.svs.last_heartbeat < 300000) {
            return;
        }
        SV_INIT.svs.last_heartbeat = SV_INIT.svs.realtime;
        String string = SV_MAIN.SV_StatusString();
        for (int i = 0; i < 8; ++i) {
            if (SV_MAIN.master_adr[i].port == 0) continue;
            Com.Printf("Sending heartbeat to " + NET.AdrToString(master_adr[i]) + "\n");
            Netchan.OutOfBandPrint(1, master_adr[i], "heartbeat\n" + string);
        }
    }

    public static void Master_Shutdown() {
        if (null == Globals.dedicated || 0.0f == Globals.dedicated.value) {
            return;
        }
        if (null == public_server || 0.0f == SV_MAIN.public_server.value) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (SV_MAIN.master_adr[i].port == 0) continue;
            if (i > 0) {
                Com.Printf("Sending heartbeat to " + NET.AdrToString(master_adr[i]) + "\n");
            }
            Netchan.OutOfBandPrint(1, master_adr[i], "shutdown");
        }
    }

    public static void SV_UserinfoChanged(client_t cl) {
        PlayerClient.ClientUserinfoChanged(cl.edict, cl.userinfo);
        cl.name = Info.Info_ValueForKey(cl.userinfo, "name");
        String val = Info.Info_ValueForKey(cl.userinfo, "rate");
        if (val.length() > 0) {
            int i;
            cl.rate = i = Lib.atoi(val);
            if (cl.rate < 100) {
                cl.rate = 100;
            }
            if (cl.rate > 15000) {
                cl.rate = 15000;
            }
        } else {
            cl.rate = 5000;
        }
        if ((val = Info.Info_ValueForKey(cl.userinfo, "msg")).length() > 0) {
            cl.messagelevel = Lib.atoi(val);
        }
    }

    public static void SV_Init() {
        SV_CCMDS.SV_InitOperatorCommands();
        rcon_password = Cvar.Get("rcon_password", "", 0);
        Cvar.Get("skill", "1", 0);
        Cvar.Get("deathmatch", "0", 16);
        Cvar.Get("coop", "0", 16);
        Cvar.Get("dmflags", "16", 4);
        Cvar.Get("fraglimit", "0", 4);
        Cvar.Get("timelimit", "0", 4);
        Cvar.Get("cheats", "0", 20);
        Cvar.Get("protocol", "34", 12);
        maxclients = Cvar.Get("maxclients", "1", 20);
        hostname = Cvar.Get("hostname", "noname", 5);
        timeout = Cvar.Get("timeout", "125", 0);
        zombietime = Cvar.Get("zombietime", "2", 0);
        sv_showclamp = Cvar.Get("showclamp", "0", 0);
        sv_paused = Cvar.Get("paused", "0", 0);
        sv_timedemo = Cvar.Get("timedemo", "0", 0);
        sv_enforcetime = Cvar.Get("sv_enforcetime", "0", 0);
        allow_download = Cvar.Get("allow_download", "1", 1);
        allow_download_players = Cvar.Get("allow_download_players", "0", 1);
        allow_download_models = Cvar.Get("allow_download_models", "1", 1);
        allow_download_sounds = Cvar.Get("allow_download_sounds", "1", 1);
        allow_download_maps = Cvar.Get("allow_download_maps", "1", 1);
        sv_noreload = Cvar.Get("sv_noreload", "0", 0);
        sv_airaccelerate = Cvar.Get("sv_airaccelerate", "0", 16);
        public_server = Cvar.Get("public", "0", 0);
        sv_reconnect_limit = Cvar.Get("sv_reconnect_limit", "3", 1);
        SZ.Init(Globals.net_message, Globals.net_message_buffer, Globals.net_message_buffer.length);
    }

    public static void SV_FinalMessage(String message, boolean reconnect) {
        client_t cl;
        int i;
        SZ.Clear(Globals.net_message);
        MSG.WriteByte(Globals.net_message, 10);
        MSG.WriteByte(Globals.net_message, 2);
        MSG.WriteString(Globals.net_message, message);
        if (reconnect) {
            MSG.WriteByte(Globals.net_message, 8);
        } else {
            MSG.WriteByte(Globals.net_message, 7);
        }
        for (i = 0; i < SV_INIT.svs.clients.length; ++i) {
            cl = SV_INIT.svs.clients[i];
            if (cl.state < 2) continue;
            Netchan.Transmit(cl.netchan, Globals.net_message.cursize, Globals.net_message.data);
        }
        for (i = 0; i < SV_INIT.svs.clients.length; ++i) {
            cl = SV_INIT.svs.clients[i];
            if (cl.state < 2) continue;
            Netchan.Transmit(cl.netchan, Globals.net_message.cursize, Globals.net_message.data);
        }
    }

    public static void SV_Shutdown(String finalmsg, boolean reconnect) {
        if (SV_INIT.svs.clients != null) {
            SV_MAIN.SV_FinalMessage(finalmsg, reconnect);
        }
        SV_MAIN.Master_Shutdown();
        SV_GAME.SV_ShutdownGameProgs();
        if (SV_INIT.sv.demofile != null) {
            try {
                SV_INIT.sv.demofile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SV_INIT.sv = new server_t();
        Globals.server_state = SV_INIT.sv.state;
        if (SV_INIT.svs.demofile != null) {
            try {
                SV_INIT.svs.demofile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        SV_INIT.svs = new server_static_t();
    }

    static {
        for (int i = 0; i < 8; ++i) {
            SV_MAIN.master_adr[i] = new netadr_t();
        }
    }
}

