/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.client.CL;
import jake2.client.SCR;
import jake2.game.GameBase;
import jake2.game.GameSpawn;
import jake2.game.edict_t;
import jake2.game.entity_state_t;
import jake2.game.usercmd_t;
import jake2.qcommon.CM;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.PMove;
import jake2.qcommon.SZ;
import jake2.server.SV_CCMDS;
import jake2.server.SV_GAME;
import jake2.server.SV_MAIN;
import jake2.server.SV_SEND;
import jake2.server.SV_WORLD;
import jake2.server.client_t;
import jake2.server.server_static_t;
import jake2.server.server_t;
import jake2.sys.NET;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SV_INIT {
    private static String firstmap = "";
    public static server_static_t svs = new server_static_t();
    public static server_t sv = new server_t();

    public static int SV_FindIndex(String name, int start, int max, boolean create) {
        int i;
        if (name == null || name.length() == 0) {
            return 0;
        }
        for (i = 1; i < max && SV_INIT.sv.configstrings[start + i] != null; ++i) {
            if (0 != Lib.strcmp(SV_INIT.sv.configstrings[start + i], name)) continue;
            return i;
        }
        if (!create) {
            return 0;
        }
        if (i == max) {
            Com.Error(1, "*Index: overflow");
        }
        SV_INIT.sv.configstrings[start + i] = name;
        if (SV_INIT.sv.state != 1) {
            SZ.Clear(SV_INIT.sv.multicast);
            MSG.WriteChar(SV_INIT.sv.multicast, 13);
            MSG.WriteShort(SV_INIT.sv.multicast, start + i);
            MSG.WriteString(SV_INIT.sv.multicast, name);
            SV_SEND.SV_Multicast(Globals.vec3_origin, 3);
        }
        return i;
    }

    public static int SV_ModelIndex(String name) {
        return SV_INIT.SV_FindIndex(name, 32, 256, true);
    }

    public static int SV_SoundIndex(String name) {
        return SV_INIT.SV_FindIndex(name, 288, 256, true);
    }

    public static int SV_ImageIndex(String name) {
        return SV_INIT.SV_FindIndex(name, 544, 256, true);
    }

    public static void SV_CreateBaseline() {
        for (int entnum = 1; entnum < GameBase.num_edicts; ++entnum) {
            edict_t svent = GameBase.g_edicts[entnum];
            if (!svent.inuse || 0 == svent.s.modelindex && 0 == svent.s.sound && 0 == svent.s.effects) continue;
            svent.s.number = entnum;
            Math3D.VectorCopy(svent.s.origin, svent.s.old_origin);
            SV_INIT.sv.baselines[entnum].set(svent.s);
        }
    }

    public static void SV_CheckForSavegame() {
        RandomAccessFile f;
        if (SV_MAIN.sv_noreload.value != 0.0f) {
            return;
        }
        if (Cvar.VariableValue("deathmatch") != 0.0f) {
            return;
        }
        String name = FS.Gamedir() + "/save/current/" + SV_INIT.sv.name + ".sav";
        try {
            f = new RandomAccessFile(name, "r");
        }
        catch (Exception e) {
            return;
        }
        try {
            f.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        SV_WORLD.SV_ClearWorld();
        SV_CCMDS.SV_ReadLevelFile();
        if (!SV_INIT.sv.loadgame) {
            int previousState = SV_INIT.sv.state;
            SV_INIT.sv.state = 1;
            for (int i = 0; i < 100; ++i) {
                GameBase.G_RunFrame();
            }
            SV_INIT.sv.state = previousState;
        }
    }

    public static void SV_SpawnServer(String server, String spawnpoint, int serverstate, boolean attractloop, boolean loadgame) {
        int checksum = 0;
        if (attractloop) {
            Cvar.Set("paused", "0");
        }
        Com.Printf("------- Server Initialization -------\n");
        Com.DPrintf("SpawnServer: " + server + "\n");
        if (SV_INIT.sv.demofile != null) {
            try {
                SV_INIT.sv.demofile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ++SV_INIT.svs.spawncount;
        Globals.server_state = SV_INIT.sv.state = 0;
        sv = new server_t();
        SV_INIT.svs.realtime = 0;
        SV_INIT.sv.loadgame = loadgame;
        SV_INIT.sv.attractloop = attractloop;
        SV_INIT.sv.configstrings[0] = server;
        if (Cvar.VariableValue("deathmatch") != 0.0f) {
            SV_INIT.sv.configstrings[29] = "" + SV_MAIN.sv_airaccelerate.value;
            PMove.pm_airaccelerate = SV_MAIN.sv_airaccelerate.value;
        } else {
            SV_INIT.sv.configstrings[29] = "0";
            PMove.pm_airaccelerate = 0.0f;
        }
        SZ.Init(SV_INIT.sv.multicast, SV_INIT.sv.multicast_buf, SV_INIT.sv.multicast_buf.length);
        SV_INIT.sv.name = server;
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            if (SV_INIT.svs.clients[i].state > 2) {
                SV_INIT.svs.clients[i].state = 2;
            }
            SV_INIT.svs.clients[i].lastframe = -1;
            ++i;
        }
        SV_INIT.sv.time = 1000;
        SV_INIT.sv.name = server;
        SV_INIT.sv.configstrings[0] = server;
        int[] iw = new int[]{checksum};
        if (serverstate != 2) {
            SV_INIT.sv.models[1] = CM.CM_LoadMap("", false, iw);
        } else {
            SV_INIT.sv.configstrings[33] = "maps/" + server + ".bsp";
            SV_INIT.sv.models[1] = CM.CM_LoadMap(SV_INIT.sv.configstrings[33], false, iw);
        }
        checksum = iw[0];
        SV_INIT.sv.configstrings[31] = "" + checksum;
        SV_WORLD.SV_ClearWorld();
        for (i = 1; i < CM.CM_NumInlineModels(); ++i) {
            SV_INIT.sv.configstrings[33 + i] = "*" + i;
            SV_INIT.sv.models[i + 1] = CM.InlineModel(SV_INIT.sv.configstrings[33 + i]);
        }
        Globals.server_state = SV_INIT.sv.state = 1;
        GameSpawn.SpawnEntities(SV_INIT.sv.name, CM.CM_EntityString(), spawnpoint);
        GameBase.G_RunFrame();
        GameBase.G_RunFrame();
        Globals.server_state = SV_INIT.sv.state = serverstate;
        SV_INIT.SV_CreateBaseline();
        SV_INIT.SV_CheckForSavegame();
        Cvar.FullSet("mapname", SV_INIT.sv.name, 12);
    }

    public static void SV_InitGame() {
        int n;
        if (SV_INIT.svs.initialized) {
            SV_MAIN.SV_Shutdown("Server restarted\n", true);
        } else {
            CL.Drop();
            SCR.BeginLoadingPlaque();
        }
        Cvar.GetLatchedVars();
        SV_INIT.svs.initialized = true;
        if (Cvar.VariableValue("coop") != 0.0f && Cvar.VariableValue("deathmatch") != 0.0f) {
            Com.Printf("Deathmatch and Coop both set, disabling Coop\n");
            Cvar.FullSet("coop", "0", 20);
        }
        if (Globals.dedicated.value != 0.0f && 0.0f == Cvar.VariableValue("coop")) {
            Cvar.FullSet("deathmatch", "1", 20);
        }
        if (Cvar.VariableValue("deathmatch") != 0.0f) {
            if (SV_MAIN.maxclients.value <= 1.0f) {
                Cvar.FullSet("maxclients", "8", 20);
            } else if (SV_MAIN.maxclients.value > 256.0f) {
                Cvar.FullSet("maxclients", "256", 20);
            }
        } else if (Cvar.VariableValue("coop") != 0.0f) {
            if (SV_MAIN.maxclients.value <= 1.0f || SV_MAIN.maxclients.value > 4.0f) {
                Cvar.FullSet("maxclients", "4", 20);
            }
        } else {
            Cvar.FullSet("maxclients", "1", 20);
        }
        SV_INIT.svs.spawncount = Lib.rand();
        SV_INIT.svs.clients = new client_t[(int)SV_MAIN.maxclients.value];
        for (n = 0; n < SV_INIT.svs.clients.length; ++n) {
            SV_INIT.svs.clients[n] = new client_t();
            SV_INIT.svs.clients[n].serverindex = n;
        }
        SV_INIT.svs.num_client_entities = (int)SV_MAIN.maxclients.value * 16 * 64;
        SV_INIT.svs.client_entities = new entity_state_t[SV_INIT.svs.num_client_entities];
        for (n = 0; n < SV_INIT.svs.client_entities.length; ++n) {
            SV_INIT.svs.client_entities[n] = new entity_state_t(null);
        }
        NET.Config(SV_MAIN.maxclients.value > 1.0f);
        SV_INIT.svs.last_heartbeat = -99999;
        String idmaster = "192.246.40.37:27900";
        NET.StringToAdr(idmaster, SV_MAIN.master_adr[0]);
        SV_GAME.SV_InitGameProgs();
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            edict_t ent;
            SV_INIT.svs.clients[i].edict = ent = GameBase.g_edicts[i + 1];
            SV_INIT.svs.clients[i].lastcmd = new usercmd_t();
            ++i;
        }
    }

    public static void SV_Map(boolean attractloop, String levelstring, boolean loadgame) {
        int l;
        String spawnpoint;
        int pos;
        String level;
        int c;
        SV_INIT.sv.loadgame = loadgame;
        SV_INIT.sv.attractloop = attractloop;
        if (SV_INIT.sv.state == 0 && !SV_INIT.sv.loadgame) {
            SV_INIT.SV_InitGame();
        }
        if ((c = (level = levelstring).indexOf(43)) != -1) {
            Cvar.Set("nextserver", "gamemap \"" + level.substring(c + 1) + "\"");
            level = level.substring(0, c);
        } else {
            Cvar.Set("nextserver", "");
        }
        if (!(firstmap.length() != 0 || levelstring.endsWith(".cin") || levelstring.endsWith(".pcx") || levelstring.endsWith(".dm2"))) {
            pos = levelstring.indexOf(43);
            firstmap = levelstring.substring(pos + 1);
        }
        if (Cvar.VariableValue("coop") != 0.0f && level.equals("victory.pcx")) {
            Cvar.Set("nextserver", "gamemap \"*" + firstmap + "\"");
        }
        if ((pos = level.indexOf(36)) != -1) {
            spawnpoint = level.substring(pos + 1);
            level = level.substring(0, pos);
        } else {
            spawnpoint = "";
        }
        if (level.charAt(0) == '*') {
            level = level.substring(1);
        }
        if ((l = level.length()) > 4 && level.endsWith(".cin")) {
            SCR.BeginLoadingPlaque();
            SV_SEND.SV_BroadcastCommand("changing\n");
            SV_INIT.SV_SpawnServer(level, spawnpoint, 3, attractloop, loadgame);
        } else if (l > 4 && level.endsWith(".dm2")) {
            SCR.BeginLoadingPlaque();
            SV_SEND.SV_BroadcastCommand("changing\n");
            SV_INIT.SV_SpawnServer(level, spawnpoint, 4, attractloop, loadgame);
        } else if (l > 4 && level.endsWith(".pcx")) {
            SCR.BeginLoadingPlaque();
            SV_SEND.SV_BroadcastCommand("changing\n");
            SV_INIT.SV_SpawnServer(level, spawnpoint, 5, attractloop, loadgame);
        } else {
            SCR.BeginLoadingPlaque();
            SV_SEND.SV_BroadcastCommand("changing\n");
            SV_SEND.SV_SendClientMessages();
            SV_INIT.SV_SpawnServer(level, spawnpoint, 2, attractloop, loadgame);
            Cbuf.CopyToDefer();
        }
        SV_SEND.SV_BroadcastCommand("reconnect\n");
    }
}

