/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.GameBase;
import jake2.game.GameSave;
import jake2.game.cmodel_t;
import jake2.game.edict_t;
import jake2.game.game_import_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.server.SV_INIT;
import jake2.server.SV_MAIN;
import jake2.server.SV_SEND;
import jake2.server.SV_WORLD;
import jake2.server.client_t;
import jake2.util.Math3D;

public class SV_GAME {
    public static void PF_Unicast(edict_t ent, boolean reliable) {
        if (ent == null) {
            return;
        }
        int p = ent.index;
        if (p < 1 || (float)p > SV_MAIN.maxclients.value) {
            return;
        }
        client_t client = SV_INIT.svs.clients[p - 1];
        if (reliable) {
            SZ.Write(client.netchan.message, SV_INIT.sv.multicast.data, SV_INIT.sv.multicast.cursize);
        } else {
            SZ.Write(client.datagram, SV_INIT.sv.multicast.data, SV_INIT.sv.multicast.cursize);
        }
        SZ.Clear(SV_INIT.sv.multicast);
    }

    public static void PF_dprintf(String fmt) {
        Com.Printf(fmt);
    }

    public static void PF_cprintfhigh(edict_t ent, String fmt) {
        SV_GAME.PF_cprintf(ent, 2, fmt);
    }

    public static void PF_cprintf(edict_t ent, int level, String fmt) {
        int n = 0;
        if (ent != null && ((n = ent.index) < 1 || (float)n > SV_MAIN.maxclients.value)) {
            Com.Error(1, "cprintf to a non-client");
        }
        if (ent != null) {
            SV_SEND.SV_ClientPrintf(SV_INIT.svs.clients[n - 1], level, fmt);
        } else {
            Com.Printf(fmt);
        }
    }

    public static void PF_centerprintf(edict_t ent, String fmt) {
        int n = ent.index;
        if (n < 1 || (float)n > SV_MAIN.maxclients.value) {
            return;
        }
        MSG.WriteByte(SV_INIT.sv.multicast, 15);
        MSG.WriteString(SV_INIT.sv.multicast, fmt);
        SV_GAME.PF_Unicast(ent, true);
    }

    public static void PF_error(String fmt) {
        Com.Error(1, "Game Error: " + fmt);
    }

    public static void PF_error(int level, String fmt) {
        Com.Error(level, fmt);
    }

    public static void PF_setmodel(edict_t ent, String name) {
        int i;
        if (name == null) {
            Com.Error(1, "PF_setmodel: NULL");
        }
        ent.s.modelindex = i = SV_INIT.SV_ModelIndex(name);
        if (name.startsWith("*")) {
            cmodel_t mod = CM.InlineModel(name);
            Math3D.VectorCopy(mod.mins, ent.mins);
            Math3D.VectorCopy(mod.maxs, ent.maxs);
            SV_WORLD.SV_LinkEdict(ent);
        }
    }

    public static void PF_Configstring(int index, String val) {
        if (index < 0 || index >= 2080) {
            Com.Error(1, "configstring: bad index " + index + "\n");
        }
        if (val == null) {
            val = "";
        }
        SV_INIT.sv.configstrings[index] = val;
        if (SV_INIT.sv.state != 1) {
            SZ.Clear(SV_INIT.sv.multicast);
            MSG.WriteChar(SV_INIT.sv.multicast, 13);
            MSG.WriteShort(SV_INIT.sv.multicast, index);
            MSG.WriteString(SV_INIT.sv.multicast, val);
            SV_SEND.SV_Multicast(Globals.vec3_origin, 3);
        }
    }

    public static void PF_WriteChar(int c) {
        MSG.WriteChar(SV_INIT.sv.multicast, c);
    }

    public static void PF_WriteByte(int c) {
        MSG.WriteByte(SV_INIT.sv.multicast, c);
    }

    public static void PF_WriteShort(int c) {
        MSG.WriteShort(SV_INIT.sv.multicast, c);
    }

    public static void PF_WriteLong(int c) {
        MSG.WriteLong(SV_INIT.sv.multicast, c);
    }

    public static void PF_WriteFloat(float f) {
        MSG.WriteFloat(SV_INIT.sv.multicast, f);
    }

    public static void PF_WriteString(String s) {
        MSG.WriteString(SV_INIT.sv.multicast, s);
    }

    public static void PF_WritePos(float[] pos) {
        MSG.WritePos(SV_INIT.sv.multicast, pos);
    }

    public static void PF_WriteDir(float[] dir) {
        MSG.WriteDir(SV_INIT.sv.multicast, dir);
    }

    public static void PF_WriteAngle(float f) {
        MSG.WriteAngle(SV_INIT.sv.multicast, f);
    }

    public static boolean PF_inPVS(float[] p1, float[] p2) {
        int leafnum = CM.CM_PointLeafnum(p1);
        int cluster = CM.CM_LeafCluster(leafnum);
        int area1 = CM.CM_LeafArea(leafnum);
        byte[] mask = CM.CM_ClusterPVS(cluster);
        leafnum = CM.CM_PointLeafnum(p2);
        cluster = CM.CM_LeafCluster(leafnum);
        int area2 = CM.CM_LeafArea(leafnum);
        if (cluster == -1) {
            return false;
        }
        if (mask != null && 0 == (mask[cluster >>> 3] & 1 << (cluster & 7))) {
            return false;
        }
        return CM.CM_AreasConnected(area1, area2);
    }

    public static boolean PF_inPHS(float[] p1, float[] p2) {
        int leafnum = CM.CM_PointLeafnum(p1);
        int cluster = CM.CM_LeafCluster(leafnum);
        int area1 = CM.CM_LeafArea(leafnum);
        byte[] mask = CM.CM_ClusterPHS(cluster);
        leafnum = CM.CM_PointLeafnum(p2);
        cluster = CM.CM_LeafCluster(leafnum);
        int area2 = CM.CM_LeafArea(leafnum);
        if (cluster == -1) {
            return false;
        }
        if (mask != null && 0 == (mask[cluster >> 3] & 1 << (cluster & 7))) {
            return false;
        }
        return CM.CM_AreasConnected(area1, area2);
    }

    public static void PF_StartSound(edict_t entity, int channel, int sound_num, float volume, float attenuation, float timeofs) {
        if (null == entity) {
            return;
        }
        SV_SEND.SV_StartSound(null, entity, channel, sound_num, volume, attenuation, timeofs);
    }

    public static void SV_ShutdownGameProgs() {
        GameBase.ShutdownGame();
    }

    public static void SV_InitGameProgs() {
        SV_GAME.SV_ShutdownGameProgs();
        game_import_t gimport = new game_import_t();
        GameBase.GetGameApi(gimport);
        GameSave.InitGame();
    }
}

