/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.game.EndianHandler;
import jake2.game.GameBase;
import jake2.game.edict_t;
import jake2.game.entity_state_t;
import jake2.game.player_state_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.qcommon.sizebuf_t;
import jake2.server.SV_INIT;
import jake2.server.SV_MAIN;
import jake2.server.client_frame_t;
import jake2.server.client_t;
import jake2.util.Math3D;
import java.io.IOException;

public class SV_ENTS {
    public static byte[] fatpvs = new byte[8192];
    private static final byte[] buf_data = new byte[32768];

    static void SV_EmitPacketEntities(client_frame_t from, client_frame_t to, sizebuf_t msg) {
        entity_state_t oldent = null;
        entity_state_t newent = null;
        MSG.WriteByte(msg, 18);
        int from_num_entities = from == null ? 0 : from.num_entities;
        int newindex = 0;
        int oldindex = 0;
        while (newindex < to.num_entities || oldindex < from_num_entities) {
            int oldnum;
            int newnum;
            if (newindex >= to.num_entities) {
                newnum = 9999;
            } else {
                newent = SV_INIT.svs.client_entities[(to.first_entity + newindex) % SV_INIT.svs.num_client_entities];
                newnum = newent.number;
            }
            if (oldindex >= from_num_entities) {
                oldnum = 9999;
            } else {
                oldent = SV_INIT.svs.client_entities[(from.first_entity + oldindex) % SV_INIT.svs.num_client_entities];
                oldnum = oldent.number;
            }
            if (newnum == oldnum) {
                MSG.WriteDeltaEntity(oldent, newent, msg, false, (float)newent.number <= SV_MAIN.maxclients.value);
                ++oldindex;
                ++newindex;
                continue;
            }
            if (newnum < oldnum) {
                MSG.WriteDeltaEntity(SV_INIT.sv.baselines[newnum], newent, msg, true, true);
                ++newindex;
                continue;
            }
            if (newnum <= oldnum) continue;
            int bits = 64;
            if (oldnum >= 256) {
                bits |= 0x180;
            }
            MSG.WriteByte(msg, bits & 0xFF);
            if ((bits & 0xFF00) != 0) {
                MSG.WriteByte(msg, bits >> 8 & 0xFF);
            }
            if ((bits & 0x100) != 0) {
                MSG.WriteShort(msg, oldnum);
            } else {
                MSG.WriteByte(msg, oldnum);
            }
            ++oldindex;
        }
        MSG.WriteShort(msg, 0);
    }

    static void SV_WritePlayerstateToClient(client_frame_t from, client_frame_t to, sizebuf_t msg) {
        int i;
        player_state_t dummy;
        player_state_t ps = to.ps;
        player_state_t ops = from == null ? (dummy = new player_state_t()) : from.ps;
        int pflags = 0;
        if (ps.pmove.pm_type != ops.pmove.pm_type) {
            pflags |= 1;
        }
        if (ps.pmove.origin[0] != ops.pmove.origin[0] || ps.pmove.origin[1] != ops.pmove.origin[1] || ps.pmove.origin[2] != ops.pmove.origin[2]) {
            pflags |= 2;
        }
        if (ps.pmove.velocity[0] != ops.pmove.velocity[0] || ps.pmove.velocity[1] != ops.pmove.velocity[1] || ps.pmove.velocity[2] != ops.pmove.velocity[2]) {
            pflags |= 4;
        }
        if (ps.pmove.pm_time != ops.pmove.pm_time) {
            pflags |= 8;
        }
        if (ps.pmove.pm_flags != ops.pmove.pm_flags) {
            pflags |= 0x10;
        }
        if (ps.pmove.gravity != ops.pmove.gravity) {
            pflags |= 0x20;
        }
        if (ps.pmove.delta_angles[0] != ops.pmove.delta_angles[0] || ps.pmove.delta_angles[1] != ops.pmove.delta_angles[1] || ps.pmove.delta_angles[2] != ops.pmove.delta_angles[2]) {
            pflags |= 0x40;
        }
        if (ps.viewoffset[0] != ops.viewoffset[0] || ps.viewoffset[1] != ops.viewoffset[1] || ps.viewoffset[2] != ops.viewoffset[2]) {
            pflags |= 0x80;
        }
        if (ps.viewangles[0] != ops.viewangles[0] || ps.viewangles[1] != ops.viewangles[1] || ps.viewangles[2] != ops.viewangles[2]) {
            pflags |= 0x100;
        }
        if (ps.kick_angles[0] != ops.kick_angles[0] || ps.kick_angles[1] != ops.kick_angles[1] || ps.kick_angles[2] != ops.kick_angles[2]) {
            pflags |= 0x200;
        }
        if (ps.blend[0] != ops.blend[0] || ps.blend[1] != ops.blend[1] || ps.blend[2] != ops.blend[2] || ps.blend[3] != ops.blend[3]) {
            pflags |= 0x400;
        }
        if (ps.fov != ops.fov) {
            pflags |= 0x800;
        }
        if (ps.rdflags != ops.rdflags) {
            pflags |= 0x4000;
        }
        if (ps.gunframe != ops.gunframe) {
            pflags |= 0x2000;
        }
        MSG.WriteByte(msg, 17);
        MSG.WriteShort(msg, pflags |= 0x1000);
        if ((pflags & 1) != 0) {
            MSG.WriteByte(msg, ps.pmove.pm_type);
        }
        if ((pflags & 2) != 0) {
            MSG.WriteShort(msg, ps.pmove.origin[0]);
            MSG.WriteShort(msg, ps.pmove.origin[1]);
            MSG.WriteShort(msg, ps.pmove.origin[2]);
        }
        if ((pflags & 4) != 0) {
            MSG.WriteShort(msg, ps.pmove.velocity[0]);
            MSG.WriteShort(msg, ps.pmove.velocity[1]);
            MSG.WriteShort(msg, ps.pmove.velocity[2]);
        }
        if ((pflags & 8) != 0) {
            MSG.WriteByte(msg, ps.pmove.pm_time);
        }
        if ((pflags & 0x10) != 0) {
            MSG.WriteByte(msg, ps.pmove.pm_flags);
        }
        if ((pflags & 0x20) != 0) {
            MSG.WriteShort(msg, ps.pmove.gravity);
        }
        if ((pflags & 0x40) != 0) {
            MSG.WriteShort(msg, ps.pmove.delta_angles[0]);
            MSG.WriteShort(msg, ps.pmove.delta_angles[1]);
            MSG.WriteShort(msg, ps.pmove.delta_angles[2]);
        }
        if ((pflags & 0x80) != 0) {
            MSG.WriteChar(msg, ps.viewoffset[0] * 4.0f);
            MSG.WriteChar(msg, ps.viewoffset[1] * 4.0f);
            MSG.WriteChar(msg, ps.viewoffset[2] * 4.0f);
        }
        if ((pflags & 0x100) != 0) {
            MSG.WriteAngle16(msg, ps.viewangles[0]);
            MSG.WriteAngle16(msg, ps.viewangles[1]);
            MSG.WriteAngle16(msg, ps.viewangles[2]);
        }
        if ((pflags & 0x200) != 0) {
            MSG.WriteChar(msg, ps.kick_angles[0] * 4.0f);
            MSG.WriteChar(msg, ps.kick_angles[1] * 4.0f);
            MSG.WriteChar(msg, ps.kick_angles[2] * 4.0f);
        }
        if ((pflags & 0x1000) != 0) {
            MSG.WriteByte(msg, ps.gunindex);
        }
        if ((pflags & 0x2000) != 0) {
            MSG.WriteByte(msg, ps.gunframe);
            MSG.WriteChar(msg, ps.gunoffset[0] * 4.0f);
            MSG.WriteChar(msg, ps.gunoffset[1] * 4.0f);
            MSG.WriteChar(msg, ps.gunoffset[2] * 4.0f);
            MSG.WriteChar(msg, ps.gunangles[0] * 4.0f);
            MSG.WriteChar(msg, ps.gunangles[1] * 4.0f);
            MSG.WriteChar(msg, ps.gunangles[2] * 4.0f);
        }
        if ((pflags & 0x400) != 0) {
            MSG.WriteByte(msg, ps.blend[0] * 255.0f);
            MSG.WriteByte(msg, ps.blend[1] * 255.0f);
            MSG.WriteByte(msg, ps.blend[2] * 255.0f);
            MSG.WriteByte(msg, ps.blend[3] * 255.0f);
        }
        if ((pflags & 0x800) != 0) {
            MSG.WriteByte(msg, ps.fov);
        }
        if ((pflags & 0x4000) != 0) {
            MSG.WriteByte(msg, ps.rdflags);
        }
        int statbits = 0;
        for (i = 0; i < 32; ++i) {
            if (ps.stats[i] == ops.stats[i]) continue;
            statbits |= 1 << i;
        }
        MSG.WriteLong(msg, statbits);
        for (i = 0; i < 32; ++i) {
            if ((statbits & 1 << i) == 0) continue;
            MSG.WriteShort(msg, ps.stats[i]);
        }
    }

    public static void SV_WriteFrameToClient(client_t client, sizebuf_t msg) {
        int lastframe;
        client_frame_t oldframe;
        client_frame_t frame = client.frames[SV_INIT.sv.framenum & 0xF];
        if (client.lastframe <= 0) {
            oldframe = null;
            lastframe = -1;
        } else if (SV_INIT.sv.framenum - client.lastframe >= 13) {
            oldframe = null;
            lastframe = -1;
        } else {
            oldframe = client.frames[client.lastframe & 0xF];
            lastframe = client.lastframe;
        }
        MSG.WriteByte(msg, 20);
        MSG.WriteLong(msg, SV_INIT.sv.framenum);
        MSG.WriteLong(msg, lastframe);
        MSG.WriteByte(msg, client.surpressCount);
        client.surpressCount = 0;
        MSG.WriteByte(msg, frame.areabytes);
        SZ.Write(msg, frame.areabits, frame.areabytes);
        SV_ENTS.SV_WritePlayerstateToClient(oldframe, frame, msg);
        SV_ENTS.SV_EmitPacketEntities(oldframe, frame, msg);
    }

    public static void SV_FatPVS(float[] org) {
        int i;
        int[] leafs = new int[64];
        float[] mins = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
        for (i = 0; i < 3; ++i) {
            mins[i] = org[i] - 8.0f;
            maxs[i] = org[i] + 8.0f;
        }
        int count = CM.CM_BoxLeafnums(mins, maxs, leafs, 64, null);
        if (count < 1) {
            Com.Error(0, "SV_FatPVS: count < 1");
        }
        int longs = CM.CM_NumClusters() + 31 >> 5;
        for (i = 0; i < count; ++i) {
            leafs[i] = CM.CM_LeafCluster(leafs[i]);
        }
        System.arraycopy(CM.CM_ClusterPVS(leafs[0]), 0, fatpvs, 0, longs << 2);
        for (i = 1; i < count; ++i) {
            int j;
            for (j = 0; j < i && leafs[i] != leafs[j]; ++j) {
            }
            if (j != i) continue;
            byte[] src = CM.CM_ClusterPVS(leafs[i]);
            int k = 0;
            for (j = 0; j < longs; ++j) {
                int n = k;
                fatpvs[n] = (byte)(fatpvs[n] | src[k++]);
                int n2 = k;
                fatpvs[n2] = (byte)(fatpvs[n2] | src[k++]);
                int n3 = k;
                fatpvs[n3] = (byte)(fatpvs[n3] | src[k++]);
                int n4 = k;
                fatpvs[n4] = (byte)(fatpvs[n4] | src[k++]);
            }
        }
    }

    public static void SV_BuildClientFrame(client_t client) {
        int i;
        float[] org = new float[]{0.0f, 0.0f, 0.0f};
        edict_t clent = client.edict;
        if (clent.client == null) {
            return;
        }
        client_frame_t frame = client.frames[SV_INIT.sv.framenum & 0xF];
        frame.senttime = SV_INIT.svs.realtime;
        for (i = 0; i < 3; ++i) {
            org[i] = (float)clent.client.ps.pmove.origin[i] * 0.125f + clent.client.ps.viewoffset[i];
        }
        int leafnum = CM.CM_PointLeafnum(org);
        int clientarea = CM.CM_LeafArea(leafnum);
        int clientcluster = CM.CM_LeafCluster(leafnum);
        frame.areabytes = CM.CM_WriteAreaBits(frame.areabits, clientarea);
        frame.ps.set(clent.client.ps);
        SV_ENTS.SV_FatPVS(org);
        byte[] clientphs = CM.CM_ClusterPHS(clientcluster);
        frame.num_entities = 0;
        frame.first_entity = SV_INIT.svs.next_client_entities;
        int c_fullsend = 0;
        for (int e = 1; e < GameBase.num_edicts; ++e) {
            edict_t ent = GameBase.g_edicts[e];
            if ((ent.svflags & 1) != 0 || 0 == ent.s.modelindex && 0 == ent.s.effects && 0 == ent.s.sound && 0 == ent.s.event) continue;
            if (ent != clent) {
                int l;
                if (!CM.CM_AreasConnected(clientarea, ent.areanum) && (0 == ent.areanum2 || !CM.CM_AreasConnected(clientarea, ent.areanum2))) continue;
                if ((ent.s.renderfx & 0x80) != 0) {
                    l = ent.clusternums[0];
                    if (0 == (clientphs[l >> 3] & 1 << (l & 7))) {
                        continue;
                    }
                } else {
                    byte[] bitvector = ent.s.sound == 0 ? fatpvs : fatpvs;
                    if (ent.num_clusters == -1) {
                        if (!CM.CM_HeadnodeVisible(ent.headnode, bitvector)) continue;
                        ++c_fullsend;
                    } else {
                        for (i = 0; i < ent.num_clusters && (bitvector[(l = ent.clusternums[i]) >> 3] & 1 << (l & 7)) == 0; ++i) {
                        }
                        if (i == ent.num_clusters) continue;
                    }
                    if (ent.s.modelindex == 0) {
                        float[] delta = new float[]{0.0f, 0.0f, 0.0f};
                        Math3D.VectorSubtract(org, ent.s.origin, delta);
                        float len = Math3D.VectorLength(delta);
                        if (len > 400.0f) continue;
                    }
                }
            }
            int ix = SV_INIT.svs.next_client_entities % SV_INIT.svs.num_client_entities;
            entity_state_t state = SV_INIT.svs.client_entities[ix];
            if (ent.s.number != e) {
                Com.DPrintf("FIXING ENT.S.NUMBER!!!\n");
                ent.s.number = e;
            }
            SV_INIT.svs.client_entities[ix].set(ent.s);
            if (ent.owner == client.edict) {
                state.solid = 0;
            }
            ++SV_INIT.svs.next_client_entities;
            ++frame.num_entities;
        }
    }

    public static void SV_RecordDemoMessage() {
        if (SV_INIT.svs.demofile == null) {
            return;
        }
        entity_state_t nostate = new entity_state_t(null);
        sizebuf_t buf = new sizebuf_t();
        SZ.Init(buf, buf_data, buf_data.length);
        MSG.WriteByte(buf, 20);
        MSG.WriteLong(buf, SV_INIT.sv.framenum);
        MSG.WriteByte(buf, 18);
        int e = 1;
        edict_t ent = GameBase.g_edicts[e];
        while (e < GameBase.num_edicts) {
            if (ent.inuse && ent.s.number != 0 && (ent.s.modelindex != 0 || ent.s.effects != 0 || ent.s.sound != 0 || ent.s.event != 0) && 0 == (ent.svflags & 1)) {
                MSG.WriteDeltaEntity(nostate, ent.s, buf, false, true);
            }
            ent = GameBase.g_edicts[++e];
        }
        MSG.WriteShort(buf, 0);
        SZ.Write(buf, SV_INIT.svs.demo_multicast.data, SV_INIT.svs.demo_multicast.cursize);
        SZ.Clear(SV_INIT.svs.demo_multicast);
        int len = EndianHandler.swapInt(buf.cursize);
        try {
            SV_INIT.svs.demofile.writeInt(len);
            SV_INIT.svs.demofile.write(buf.data, 0, buf.cursize);
        }
        catch (IOException e1) {
            Com.Printf("Error writing demo file:" + e);
        }
    }
}

