/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.EndianHandler;
import jake2.game.GameSVCmds;
import jake2.game.GameSave;
import jake2.game.Info;
import jake2.game.cvar_t;
import jake2.qcommon.CM;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MSG;
import jake2.qcommon.Netchan;
import jake2.qcommon.SZ;
import jake2.qcommon.netadr_t;
import jake2.qcommon.sizebuf_t;
import jake2.qcommon.xcommand_t;
import jake2.server.SV_INIT;
import jake2.server.SV_MAIN;
import jake2.server.SV_SEND;
import jake2.server.SV_USER;
import jake2.server.client_t;
import jake2.sys.NET;
import jake2.sys.Sys;
import jake2.util.Lib;
import jake2.util.QuakeFile;
import jake2.util.Vargs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;

public class SV_CCMDS {
    public static void SV_SetMaster_f() {
        int i;
        if (Globals.dedicated.value == 0.0f) {
            Com.Printf("Only dedicated servers use masters.\n");
            return;
        }
        Cvar.Set("public", "1");
        for (i = 1; i < 8; ++i) {
            SV_MAIN.master_adr[i] = new netadr_t();
        }
        int slot = 1;
        for (i = 1; i < Cmd.Argc() && slot != 8; ++i) {
            if (!NET.StringToAdr(Cmd.Argv(i), SV_MAIN.master_adr[i])) {
                Com.Printf("Bad address: " + Cmd.Argv(i) + "\n");
                continue;
            }
            if (SV_MAIN.master_adr[slot].port == 0) {
                SV_MAIN.master_adr[slot].port = 27900;
            }
            Com.Printf("Master server at " + NET.AdrToString(SV_MAIN.master_adr[slot]) + "\n");
            Com.Printf("Sending a ping.\n");
            Netchan.OutOfBandPrint(1, SV_MAIN.master_adr[slot], "ping");
            ++slot;
        }
        SV_INIT.svs.last_heartbeat = -9999999;
    }

    public static boolean SV_SetPlayer() {
        if (Cmd.Argc() < 2) {
            return false;
        }
        String s = Cmd.Argv(1);
        if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
            int idnum = Lib.atoi(Cmd.Argv(1));
            if (idnum < 0 || (float)idnum >= SV_MAIN.maxclients.value) {
                Com.Printf("Bad client slot: " + idnum + "\n");
                return false;
            }
            SV_MAIN.sv_client = SV_INIT.svs.clients[idnum];
            SV_USER.sv_player = SV_MAIN.sv_client.edict;
            if (0 == SV_MAIN.sv_client.state) {
                Com.Printf("Client " + idnum + " is not active\n");
                return false;
            }
            return true;
        }
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (0 != cl.state && 0 == Lib.strcmp(cl.name, s)) {
                SV_MAIN.sv_client = cl;
                SV_USER.sv_player = SV_MAIN.sv_client.edict;
                return true;
            }
            ++i;
        }
        Com.Printf("Userid " + s + " is not on the server\n");
        return false;
    }

    public static void remove(String name) {
        try {
            new File(name).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void SV_WipeSavegame(String savename) {
        Com.DPrintf("SV_WipeSaveGame(" + savename + ")\n");
        String name = FS.Gamedir() + "/save/" + savename + "/server.ssv";
        SV_CCMDS.remove(name);
        name = FS.Gamedir() + "/save/" + savename + "/game.ssv";
        SV_CCMDS.remove(name);
        name = FS.Gamedir() + "/save/" + savename + "/*.sav";
        File f = Sys.FindFirst(name, 0, 0);
        while (f != null) {
            f.delete();
            f = Sys.FindNext();
        }
        Sys.FindClose();
        name = FS.Gamedir() + "/save/" + savename + "/*.sv2";
        f = Sys.FindFirst(name, 0, 0);
        while (f != null) {
            f.delete();
            f = Sys.FindNext();
        }
        Sys.FindClose();
    }

    public static void CopyFile(String src, String dst) {
        RandomAccessFile f2;
        RandomAccessFile f1;
        int l = -1;
        byte[] buffer = new byte[65536];
        try {
            f1 = new RandomAccessFile(src, "r");
        }
        catch (Exception e) {
            return;
        }
        try {
            f2 = new RandomAccessFile(dst, "rw");
        }
        catch (Exception e) {
            try {
                f1.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        while (true) {
            try {
                l = f1.read(buffer, 0, 65536);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (l == -1) break;
            try {
                f2.write(buffer, 0, l);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        try {
            f1.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            f2.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void SV_CopySaveGame(String src, String dst) {
        Com.DPrintf("SV_CopySaveGame(" + src + "," + dst + ")\n");
        SV_CCMDS.SV_WipeSavegame(dst);
        String name = FS.Gamedir() + "/save/" + src + "/server.ssv";
        String name2 = FS.Gamedir() + "/save/" + dst + "/server.ssv";
        FS.CreatePath(name2);
        SV_CCMDS.CopyFile(name, name2);
        name = FS.Gamedir() + "/save/" + src + "/game.ssv";
        name2 = FS.Gamedir() + "/save/" + dst + "/game.ssv";
        SV_CCMDS.CopyFile(name, name2);
        String name1 = FS.Gamedir() + "/save/" + src + "/";
        name = FS.Gamedir() + "/save/" + src + "/*.sav";
        File found = Sys.FindFirst(name, 0, 0);
        while (found != null) {
            name = name1 + found.getName();
            name2 = FS.Gamedir() + "/save/" + dst + "/" + found.getName();
            SV_CCMDS.CopyFile(name, name2);
            name = name.substring(0, name.length() - 3) + "sv2";
            name2 = name2.substring(0, name2.length() - 3) + "sv2";
            SV_CCMDS.CopyFile(name, name2);
            found = Sys.FindNext();
        }
        Sys.FindClose();
    }

    public static void SV_WriteLevelFile() {
        Com.DPrintf("SV_WriteLevelFile()\n");
        String name = FS.Gamedir() + "/save/current/" + SV_INIT.sv.name + ".sv2";
        try {
            QuakeFile f = new QuakeFile(name, "rw");
            for (int i = 0; i < 2080; ++i) {
                f.writeString(SV_INIT.sv.configstrings[i]);
            }
            CM.CM_WritePortalState(f);
            f.close();
        }
        catch (Exception e) {
            Com.Printf("Failed to open " + name + "\n");
            e.printStackTrace();
        }
        name = FS.Gamedir() + "/save/current/" + SV_INIT.sv.name + ".sav";
        GameSave.WriteLevel(name);
    }

    public static void SV_ReadLevelFile() {
        Com.DPrintf("SV_ReadLevelFile()\n");
        String name = FS.Gamedir() + "/save/current/" + SV_INIT.sv.name + ".sv2";
        try {
            QuakeFile f = new QuakeFile(name, "r");
            for (int n = 0; n < 2080; ++n) {
                SV_INIT.sv.configstrings[n] = f.readString();
            }
            CM.CM_ReadPortalState(f);
            f.close();
        }
        catch (IOException e1) {
            Com.Printf("Failed to open " + name + "\n");
            e1.printStackTrace();
        }
        name = FS.Gamedir() + "/save/current/" + SV_INIT.sv.name + ".sav";
        GameSave.ReadLevel(name);
    }

    public static void SV_WriteServerFile(boolean autosave) {
        Com.DPrintf("SV_WriteServerFile(" + (autosave ? "true" : "false") + ")\n");
        String filename = FS.Gamedir() + "/save/current/server.ssv";
        try {
            String comment;
            QuakeFile f = new QuakeFile(filename, "rw");
            if (!autosave) {
                Calendar c = Calendar.getInstance();
                comment = Com.sprintf("%2i:%2i %2i/%2i  ", new Vargs().add(c.get(11)).add(c.get(12)).add(c.get(2) + 1).add(c.get(5)));
                comment = comment + SV_INIT.sv.configstrings[0];
            } else {
                comment = "ENTERING " + SV_INIT.sv.configstrings[0];
            }
            f.writeString(comment);
            f.writeString(SV_INIT.svs.mapcmd);
            cvar_t var = Globals.cvar_vars;
            while (var != null) {
                if (0 != (var.flags & 0x10)) {
                    if (var.name.length() >= 127 || var.string.length() >= 127) {
                        Com.Printf("Cvar too long: " + var.name + " = " + var.string + "\n");
                    } else {
                        String name = var.name;
                        String string = var.string;
                        try {
                            f.writeString(name);
                            f.writeString(string);
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                }
                var = var.next;
            }
            f.writeString(null);
            f.close();
        }
        catch (Exception e) {
            Com.Printf("Couldn't write " + filename + "\n");
        }
        filename = FS.Gamedir() + "/save/current/game.ssv";
        GameSave.WriteGame(filename, autosave);
    }

    public static void SV_ReadServerFile() {
        String filename = "";
        String name = "";
        try {
            String mapcmd = "";
            Com.DPrintf("SV_ReadServerFile()\n");
            filename = FS.Gamedir() + "/save/current/server.ssv";
            QuakeFile f = new QuakeFile(filename, "r");
            f.readString();
            mapcmd = f.readString();
            while ((name = f.readString()) != null) {
                String string = f.readString();
                Com.DPrintf("Set " + name + " = " + string + "\n");
                Cvar.ForceSet(name, string);
            }
            f.close();
            SV_INIT.SV_InitGame();
            SV_INIT.svs.mapcmd = mapcmd;
            filename = FS.Gamedir() + "/save/current/game.ssv";
            GameSave.ReadGame(filename);
        }
        catch (Exception e) {
            Com.Printf("Couldn't read file " + filename + "\n");
            e.printStackTrace();
        }
    }

    public static void SV_DemoMap_f() {
        SV_INIT.SV_Map(true, Cmd.Argv(1), false);
    }

    public static void SV_GameMap_f() {
        if (Cmd.Argc() != 2) {
            Com.Printf("USAGE: gamemap <map>\n");
            return;
        }
        Com.DPrintf("SV_GameMap(" + Cmd.Argv(1) + ")\n");
        FS.CreatePath(FS.Gamedir() + "/save/current/");
        String map = Cmd.Argv(1);
        if (map.charAt(0) == '*') {
            SV_CCMDS.SV_WipeSavegame("current");
        } else if (SV_INIT.sv.state == 2) {
            client_t cl;
            boolean[] savedInuse = new boolean[(int)SV_MAIN.maxclients.value];
            int i = 0;
            while ((float)i < SV_MAIN.maxclients.value) {
                cl = SV_INIT.svs.clients[i];
                savedInuse[i] = cl.edict.inuse;
                cl.edict.inuse = false;
                ++i;
            }
            SV_CCMDS.SV_WriteLevelFile();
            i = 0;
            while ((float)i < SV_MAIN.maxclients.value) {
                cl = SV_INIT.svs.clients[i];
                cl.edict.inuse = savedInuse[i];
                ++i;
            }
            Object var2_1 = null;
        }
        SV_INIT.SV_Map(false, Cmd.Argv(1), false);
        SV_INIT.svs.mapcmd = Cmd.Argv(1);
        if (0.0f == Globals.dedicated.value) {
            SV_CCMDS.SV_WriteServerFile(true);
            SV_CCMDS.SV_CopySaveGame("current", "save0");
        }
    }

    public static void VM_Mem_f() {
        Com.Printf("vm memory:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "\n");
    }

    public static void SV_Map_f() {
        String expanded;
        String map = Cmd.Argv(1);
        if (map.indexOf(".") < 0 && FS.LoadFile(expanded = "maps/" + map + ".bsp") == null) {
            Com.Printf("Can't find " + expanded + "\n");
            return;
        }
        SV_INIT.sv.state = 0;
        SV_CCMDS.SV_WipeSavegame("current");
        SV_CCMDS.SV_GameMap_f();
    }

    public static void SV_Loadgame_f() {
        RandomAccessFile f;
        if (Cmd.Argc() != 2) {
            Com.Printf("USAGE: loadgame <directory>\n");
            return;
        }
        Com.Printf("Loading game...\n");
        String dir = Cmd.Argv(1);
        if (dir.indexOf("..") > -1 || dir.indexOf("/") > -1 || dir.indexOf("\\") > -1) {
            Com.Printf("Bad savedir.\n");
        }
        String name = FS.Gamedir() + "/save/" + Cmd.Argv(1) + "/server.ssv";
        try {
            f = new RandomAccessFile(name, "r");
        }
        catch (FileNotFoundException e) {
            Com.Printf("No such savegame: " + name + "\n");
            return;
        }
        try {
            f.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        SV_CCMDS.SV_CopySaveGame(Cmd.Argv(1), "current");
        SV_CCMDS.SV_ReadServerFile();
        SV_INIT.sv.state = 0;
        SV_INIT.SV_Map(false, SV_INIT.svs.mapcmd, true);
    }

    public static void SV_Savegame_f() {
        if (SV_INIT.sv.state != 2) {
            Com.Printf("You must be in a game to save.\n");
            return;
        }
        if (Cmd.Argc() != 2) {
            Com.Printf("USAGE: savegame <directory>\n");
            return;
        }
        if (Cvar.VariableValue("deathmatch") != 0.0f) {
            Com.Printf("Can't savegame in a deathmatch\n");
            return;
        }
        if (0 == Lib.strcmp(Cmd.Argv(1), "current")) {
            Com.Printf("Can't save to 'current'\n");
            return;
        }
        if (SV_MAIN.maxclients.value == 1.0f && SV_INIT.svs.clients[0].edict.client.ps.stats[1] <= 0) {
            Com.Printf("\nCan't savegame while dead!\n");
            return;
        }
        String dir = Cmd.Argv(1);
        if (dir.indexOf("..") > -1 || dir.indexOf("/") > -1 || dir.indexOf("\\") > -1) {
            Com.Printf("Bad savedir.\n");
        }
        Com.Printf("Saving game...\n");
        SV_CCMDS.SV_WriteLevelFile();
        try {
            SV_CCMDS.SV_WriteServerFile(false);
        }
        catch (Exception e) {
            Com.Printf("IOError in SV_WriteServerFile: " + e);
        }
        SV_CCMDS.SV_CopySaveGame("current", dir);
        Com.Printf("Done.\n");
    }

    public static void SV_Kick_f() {
        if (!SV_INIT.svs.initialized) {
            Com.Printf("No server running.\n");
            return;
        }
        if (Cmd.Argc() != 2) {
            Com.Printf("Usage: kick <userid>\n");
            return;
        }
        if (!SV_CCMDS.SV_SetPlayer()) {
            return;
        }
        SV_SEND.SV_BroadcastPrintf(2, SV_MAIN.sv_client.name + " was kicked\n");
        SV_SEND.SV_ClientPrintf(SV_MAIN.sv_client, 2, "You were kicked from the game\n");
        SV_MAIN.SV_DropClient(SV_MAIN.sv_client);
        SV_MAIN.sv_client.lastmessage = SV_INIT.svs.realtime;
    }

    public static void SV_Status_f() {
        if (SV_INIT.svs.clients == null) {
            Com.Printf("No server running.\n");
            return;
        }
        Com.Printf("map              : " + SV_INIT.sv.name + "\n");
        Com.Printf("num score ping name            lastmsg address               qport \n");
        Com.Printf("--- ----- ---- --------------- ------- --------------------- ------\n");
        int i = 0;
        while ((float)i < SV_MAIN.maxclients.value) {
            client_t cl = SV_INIT.svs.clients[i];
            if (0 != cl.state) {
                int j;
                Com.Printf("%3i ", new Vargs().add(i));
                Com.Printf("%5i ", new Vargs().add(cl.edict.client.ps.stats[14]));
                if (cl.state == 2) {
                    Com.Printf("CNCT ");
                } else if (cl.state == 1) {
                    Com.Printf("ZMBI ");
                } else {
                    int ping = cl.ping < 9999 ? cl.ping : 9999;
                    Com.Printf("%4i ", new Vargs().add(ping));
                }
                Com.Printf("%s", new Vargs().add(cl.name));
                int l = 16 - cl.name.length();
                for (j = 0; j < l; ++j) {
                    Com.Printf(" ");
                }
                Com.Printf("%7i ", new Vargs().add(SV_INIT.svs.realtime - cl.lastmessage));
                String s = NET.AdrToString(cl.netchan.remote_address);
                Com.Printf(s);
                l = 22 - s.length();
                for (j = 0; j < l; ++j) {
                    Com.Printf(" ");
                }
                Com.Printf("%5i", new Vargs().add(cl.netchan.qport));
                Com.Printf("\n");
            }
            ++i;
        }
        Com.Printf("\n");
    }

    public static void SV_ConSay_f() {
        if (Cmd.Argc() < 2) {
            return;
        }
        String text = "console: ";
        String p = Cmd.Args();
        if (p.charAt(0) == '\"') {
            p = p.substring(1, p.length() - 1);
        }
        text = text + p;
        int j = 0;
        while ((float)j < SV_MAIN.maxclients.value) {
            client_t client = SV_INIT.svs.clients[j];
            if (client.state == 3) {
                SV_SEND.SV_ClientPrintf(client, 3, text + "\n");
            }
            ++j;
        }
    }

    public static void SV_Heartbeat_f() {
        SV_INIT.svs.last_heartbeat = -9999999;
    }

    public static void SV_Serverinfo_f() {
        Com.Printf("Server info settings:\n");
        Info.Print(Cvar.Serverinfo());
    }

    public static void SV_DumpUser_f() {
        if (Cmd.Argc() != 2) {
            Com.Printf("Usage: info <userid>\n");
            return;
        }
        if (!SV_CCMDS.SV_SetPlayer()) {
            return;
        }
        Com.Printf("userinfo\n");
        Com.Printf("--------\n");
        Info.Print(SV_MAIN.sv_client.userinfo);
    }

    public static void SV_ServerRecord_f() {
        byte[] buf_data = new byte[32768];
        sizebuf_t buf = new sizebuf_t();
        if (Cmd.Argc() != 2) {
            Com.Printf("serverrecord <demoname>\n");
            return;
        }
        if (SV_INIT.svs.demofile != null) {
            Com.Printf("Already recording.\n");
            return;
        }
        if (SV_INIT.sv.state != 2) {
            Com.Printf("You must be in a level to record.\n");
            return;
        }
        String name = FS.Gamedir() + "/demos/" + Cmd.Argv(1) + ".dm2";
        Com.Printf("recording to " + name + ".\n");
        FS.CreatePath(name);
        try {
            SV_INIT.svs.demofile = new RandomAccessFile(name, "rw");
        }
        catch (Exception e) {
            Com.Printf("ERROR: couldn't open.\n");
            return;
        }
        SZ.Init(SV_INIT.svs.demo_multicast, SV_INIT.svs.demo_multicast_buf, SV_INIT.svs.demo_multicast_buf.length);
        SZ.Init(buf, buf_data, buf_data.length);
        MSG.WriteByte(buf, 12);
        MSG.WriteLong(buf, 34);
        MSG.WriteLong(buf, SV_INIT.svs.spawncount);
        MSG.WriteByte(buf, 2);
        MSG.WriteString(buf, Cvar.VariableString("gamedir"));
        MSG.WriteShort(buf, -1);
        MSG.WriteString(buf, SV_INIT.sv.configstrings[0]);
        for (int i = 0; i < 2080; ++i) {
            if (SV_INIT.sv.configstrings[i].length() != 0) continue;
            MSG.WriteByte(buf, 13);
            MSG.WriteShort(buf, i);
            MSG.WriteString(buf, SV_INIT.sv.configstrings[i]);
        }
        Com.DPrintf("signon message length: " + buf.cursize + "\n");
        int len = EndianHandler.swapInt(buf.cursize);
        try {
            SV_INIT.svs.demofile.writeInt(len);
            SV_INIT.svs.demofile.write(buf.data, 0, buf.cursize);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void SV_ServerStop_f() {
        if (SV_INIT.svs.demofile == null) {
            Com.Printf("Not doing a serverrecord.\n");
            return;
        }
        try {
            SV_INIT.svs.demofile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SV_INIT.svs.demofile = null;
        Com.Printf("Recording completed.\n");
    }

    public static void SV_KillServer_f() {
        if (!SV_INIT.svs.initialized) {
            return;
        }
        SV_MAIN.SV_Shutdown("Server was killed.\n", false);
        NET.Config(false);
    }

    public static void SV_ServerCommand_f() {
        GameSVCmds.ServerCommand();
    }

    public static void SV_InitOperatorCommands() {
        Cmd.AddCommand("heartbeat", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Heartbeat_f();
            }
        });
        Cmd.AddCommand("kick", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Kick_f();
            }
        });
        Cmd.AddCommand("status", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Status_f();
            }
        });
        Cmd.AddCommand("serverinfo", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Serverinfo_f();
            }
        });
        Cmd.AddCommand("dumpuser", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_DumpUser_f();
            }
        });
        Cmd.AddCommand("map", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Map_f();
            }
        });
        Cmd.AddCommand("demomap", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_DemoMap_f();
            }
        });
        Cmd.AddCommand("gamemap", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_GameMap_f();
            }
        });
        Cmd.AddCommand("setmaster", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_SetMaster_f();
            }
        });
        if (Globals.dedicated.value != 0.0f) {
            Cmd.AddCommand("say", new xcommand_t(){

                public void execute() {
                    SV_CCMDS.SV_ConSay_f();
                }
            });
        }
        Cmd.AddCommand("serverrecord", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_ServerRecord_f();
            }
        });
        Cmd.AddCommand("serverstop", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_ServerStop_f();
            }
        });
        Cmd.AddCommand("save", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Savegame_f();
            }
        });
        Cmd.AddCommand("load", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_Loadgame_f();
            }
        });
        Cmd.AddCommand("killserver", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_KillServer_f();
            }
        });
        Cmd.AddCommand("sv", new xcommand_t(){

            public void execute() {
                SV_CCMDS.SV_ServerCommand_f();
            }
        });
        Cmd.AddCommand("jvm_memory", new xcommand_t(){

            public void execute() {
                SV_CCMDS.VM_Mem_f();
            }
        });
    }
}

