/*
 * Decompiled with CFR 0.152.
 */
package jake2.server;

import jake2.Globals;
import jake2.client.M;
import jake2.game.GameBase;
import jake2.game.edict_t;
import jake2.game.pushed_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.server.SV_GAME;
import jake2.util.Lib;
import jake2.util.Math3D;

public final class SV {
    public static final int MAX_CLIP_PLANES = 5;
    public static int DI_NODIR = -1;

    public static edict_t[] SV_TestEntityPosition(edict_t ent) {
        int mask = ent.clipmask != 0 ? ent.clipmask : 3;
        trace_t trace = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, ent.s.origin, ent, mask);
        if (trace.startsolid) {
            return GameBase.g_edicts;
        }
        return null;
    }

    public static void SV_CheckVelocity(edict_t ent) {
        for (int i = 0; i < 3; ++i) {
            if (ent.velocity[i] > GameBase.sv_maxvelocity.value) {
                ent.velocity[i] = GameBase.sv_maxvelocity.value;
                continue;
            }
            if (!(ent.velocity[i] < -GameBase.sv_maxvelocity.value)) continue;
            ent.velocity[i] = -GameBase.sv_maxvelocity.value;
        }
    }

    public static boolean SV_RunThink(edict_t ent) {
        float thinktime = ent.nextthink;
        if (thinktime <= 0.0f) {
            return true;
        }
        if ((double)thinktime > (double)GameBase.level.time + 0.001) {
            return true;
        }
        ent.nextthink = 0.0f;
        if (ent.think == null) {
            Com.Error(0, "NULL ent.think");
        }
        ent.think.think(ent);
        return false;
    }

    public static void SV_Impact(edict_t e1, trace_t trace) {
        edict_t e2 = trace.ent;
        if (e1.touch != null && e1.solid != 0) {
            e1.touch.touch(e1, e2, trace.plane, trace.surface);
        }
        if (e2.touch != null && e2.solid != 0) {
            e2.touch.touch(e2, e1, GameBase.dummyplane, null);
        }
    }

    public static int SV_FlyMove(edict_t ent, float time, int mask) {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        float[][] planes = new float[5][3];
        float[] primal_velocity = new float[]{0.0f, 0.0f, 0.0f};
        float[] original_velocity = new float[]{0.0f, 0.0f, 0.0f};
        float[] new_velocity = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        int numbumps = 4;
        int blocked = 0;
        Math3D.VectorCopy(ent.velocity, original_velocity);
        Math3D.VectorCopy(ent.velocity, primal_velocity);
        int numplanes = 0;
        float time_left = time;
        ent.groundentity = null;
        for (int bumpcount = 0; bumpcount < numbumps; ++bumpcount) {
            int i;
            for (i = 0; i < 3; ++i) {
                end[i] = ent.s.origin[i] + time_left * ent.velocity[i];
            }
            trace_t trace = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, end, ent, mask);
            if (trace.allsolid) {
                Math3D.VectorCopy(Globals.vec3_origin, ent.velocity);
                return 3;
            }
            if (trace.fraction > 0.0f) {
                Math3D.VectorCopy(trace.endpos, ent.s.origin);
                Math3D.VectorCopy(ent.velocity, original_velocity);
                numplanes = 0;
            }
            if (trace.fraction == 1.0f) break;
            edict_t hit = trace.ent;
            if ((double)trace.plane.normal[2] > 0.7) {
                blocked |= 1;
                if (hit.solid == 3) {
                    ent.groundentity = hit;
                    ent.groundentity_linkcount = hit.linkcount;
                }
            }
            if (trace.plane.normal[2] == 0.0f) {
                blocked |= 2;
            }
            SV.SV_Impact(ent, trace);
            if (!ent.inuse) break;
            time_left -= time_left * trace.fraction;
            if (numplanes >= 5) {
                Math3D.VectorCopy(Globals.vec3_origin, ent.velocity);
                return 3;
            }
            Math3D.VectorCopy(trace.plane.normal, planes[numplanes]);
            ++numplanes;
            for (i = 0; i < numplanes; ++i) {
                int j;
                GameBase.ClipVelocity(original_velocity, planes[i], new_velocity, 1.0f);
                for (j = 0; j < numplanes && (j == i || Math3D.VectorEquals(planes[i], planes[j]) || !(Math3D.DotProduct(new_velocity, planes[j]) < 0.0f)); ++j) {
                }
                if (j == numplanes) break;
            }
            if (i != numplanes) {
                Math3D.VectorCopy(new_velocity, ent.velocity);
            } else {
                if (numplanes != 2) {
                    Math3D.VectorCopy(Globals.vec3_origin, ent.velocity);
                    return 7;
                }
                Math3D.CrossProduct(planes[0], planes[1], dir);
                float d = Math3D.DotProduct(dir, ent.velocity);
                Math3D.VectorScale(dir, d, ent.velocity);
            }
            if (!(Math3D.DotProduct(ent.velocity, primal_velocity) <= 0.0f)) continue;
            Math3D.VectorCopy(Globals.vec3_origin, ent.velocity);
            return blocked;
        }
        return blocked;
    }

    public static void SV_AddGravity(edict_t ent) {
        ent.velocity[2] = ent.velocity[2] - ent.gravity * GameBase.sv_gravity.value * 0.1f;
    }

    public static trace_t SV_PushEntity(edict_t ent, float[] push) {
        trace_t trace;
        float[] start = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorCopy(ent.s.origin, start);
        Math3D.VectorAdd(start, push, end);
        boolean retry = false;
        do {
            int mask = ent.clipmask != 0 ? ent.clipmask : 3;
            trace = GameBase.gi.trace(start, ent.mins, ent.maxs, end, ent, mask);
            Math3D.VectorCopy(trace.endpos, ent.s.origin);
            GameBase.gi.linkentity(ent);
            retry = false;
            if ((double)trace.fraction == 1.0) continue;
            SV.SV_Impact(ent, trace);
            if (trace.ent.inuse || !ent.inuse) continue;
            Math3D.VectorCopy(start, ent.s.origin);
            GameBase.gi.linkentity(ent);
            retry = true;
        } while (retry);
        if (ent.inuse) {
            GameBase.G_TouchTriggers(ent);
        }
        return trace;
    }

    public static boolean SV_Push(edict_t pusher, float[] move, float[] amove) {
        int i;
        float[] mins = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
        float[] org = new float[]{0.0f, 0.0f, 0.0f};
        float[] org2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] move2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        for (i = 0; i < 3; ++i) {
            float temp = move[i] * 8.0f;
            temp = (double)temp > 0.0 ? (float)((double)temp + 0.5) : (float)((double)temp - 0.5);
            move[i] = 0.125f * (float)((int)temp);
        }
        for (i = 0; i < 3; ++i) {
            mins[i] = pusher.absmin[i] + move[i];
            maxs[i] = pusher.absmax[i] + move[i];
        }
        Math3D.VectorSubtract(Globals.vec3_origin, amove, org);
        Math3D.AngleVectors(org, forward, right, up);
        GameBase.pushed[GameBase.pushed_p].ent = pusher;
        Math3D.VectorCopy(pusher.s.origin, GameBase.pushed[GameBase.pushed_p].origin);
        Math3D.VectorCopy(pusher.s.angles, GameBase.pushed[GameBase.pushed_p].angles);
        if (pusher.client != null) {
            GameBase.pushed[GameBase.pushed_p].deltayaw = pusher.client.ps.pmove.delta_angles[1];
        }
        ++GameBase.pushed_p;
        Math3D.VectorAdd(pusher.s.origin, move, pusher.s.origin);
        Math3D.VectorAdd(pusher.s.angles, amove, pusher.s.angles);
        GameBase.gi.linkentity(pusher);
        for (int e = 1; e < GameBase.num_edicts; ++e) {
            edict_t check = GameBase.g_edicts[e];
            if (!check.inuse || check.movetype == 2 || check.movetype == 3 || check.movetype == 0 || check.movetype == 1 || check.area.prev == null || check.groundentity != pusher && (check.absmin[0] >= maxs[0] || check.absmin[1] >= maxs[1] || check.absmin[2] >= maxs[2] || check.absmax[0] <= mins[0] || check.absmax[1] <= mins[1] || check.absmax[2] <= mins[2] || SV.SV_TestEntityPosition(check) == null)) continue;
            if (pusher.movetype == 2 || check.groundentity == pusher) {
                edict_t[] block;
                GameBase.pushed[GameBase.pushed_p].ent = check;
                Math3D.VectorCopy(check.s.origin, GameBase.pushed[GameBase.pushed_p].origin);
                Math3D.VectorCopy(check.s.angles, GameBase.pushed[GameBase.pushed_p].angles);
                ++GameBase.pushed_p;
                Math3D.VectorAdd(check.s.origin, move, check.s.origin);
                if (check.client != null) {
                    check.client.ps.pmove.delta_angles[1] = (short)((float)check.client.ps.pmove.delta_angles[1] + amove[1]);
                }
                Math3D.VectorSubtract(check.s.origin, pusher.s.origin, org);
                org2[0] = Math3D.DotProduct(org, forward);
                org2[1] = -Math3D.DotProduct(org, right);
                org2[2] = Math3D.DotProduct(org, up);
                Math3D.VectorSubtract(org2, org, move2);
                Math3D.VectorAdd(check.s.origin, move2, check.s.origin);
                if (check.groundentity != pusher) {
                    check.groundentity = null;
                }
                if ((block = SV.SV_TestEntityPosition(check)) == null) {
                    GameBase.gi.linkentity(check);
                    continue;
                }
                Math3D.VectorSubtract(check.s.origin, move, check.s.origin);
                block = SV.SV_TestEntityPosition(check);
                if (block == null) {
                    --GameBase.pushed_p;
                    continue;
                }
            }
            GameBase.obstacle = check;
            for (int ip = GameBase.pushed_p - 1; ip >= 0; --ip) {
                pushed_t p = GameBase.pushed[ip];
                Math3D.VectorCopy(p.origin, p.ent.s.origin);
                Math3D.VectorCopy(p.angles, p.ent.s.angles);
                if (p.ent.client != null) {
                    p.ent.client.ps.pmove.delta_angles[1] = (short)p.deltayaw;
                }
                GameBase.gi.linkentity(p.ent);
            }
            return false;
        }
        for (int ip = GameBase.pushed_p - 1; ip >= 0; --ip) {
            GameBase.G_TouchTriggers(GameBase.pushed[ip].ent);
        }
        return true;
    }

    public static void SV_Physics_Pusher(edict_t ent) {
        float[] move = new float[]{0.0f, 0.0f, 0.0f};
        float[] amove = new float[]{0.0f, 0.0f, 0.0f};
        if ((ent.flags & 0x400) != 0) {
            return;
        }
        GameBase.pushed_p = 0;
        edict_t part = ent;
        while (part != null) {
            if (part.velocity[0] != 0.0f || part.velocity[1] != 0.0f || part.velocity[2] != 0.0f || part.avelocity[0] != 0.0f || part.avelocity[1] != 0.0f || part.avelocity[2] != 0.0f) {
                Math3D.VectorScale(part.velocity, 0.1f, move);
                Math3D.VectorScale(part.avelocity, 0.1f, amove);
                if (!SV.SV_Push(part, move, amove)) break;
            }
            part = part.teamchain;
        }
        if (GameBase.pushed_p > 1024) {
            SV_GAME.PF_error(0, "pushed_p > &pushed[MAX_EDICTS], memory corrupted");
        }
        if (part != null) {
            edict_t mv = ent;
            while (mv != null) {
                if (mv.nextthink > 0.0f) {
                    mv.nextthink += 0.1f;
                }
                mv = mv.teamchain;
            }
            if (part.blocked != null) {
                part.blocked.blocked(part, GameBase.obstacle);
            }
        } else {
            part = ent;
            while (part != null) {
                SV.SV_RunThink(part);
                part = part.teamchain;
            }
        }
    }

    public static void SV_Physics_None(edict_t ent) {
        SV.SV_RunThink(ent);
    }

    public static void SV_Physics_Noclip(edict_t ent) {
        if (!SV.SV_RunThink(ent)) {
            return;
        }
        Math3D.VectorMA(ent.s.angles, 0.1f, ent.avelocity, ent.s.angles);
        Math3D.VectorMA(ent.s.origin, 0.1f, ent.velocity, ent.s.origin);
        GameBase.gi.linkentity(ent);
    }

    public static void SV_Physics_Toss(edict_t ent) {
        float[] move = new float[]{0.0f, 0.0f, 0.0f};
        float[] old_origin = new float[]{0.0f, 0.0f, 0.0f};
        SV.SV_RunThink(ent);
        if ((ent.flags & 0x400) != 0) {
            return;
        }
        if (ent.velocity[2] > 0.0f) {
            ent.groundentity = null;
        }
        if (ent.groundentity != null && !ent.groundentity.inuse) {
            ent.groundentity = null;
        }
        if (ent.groundentity != null) {
            return;
        }
        Math3D.VectorCopy(ent.s.origin, old_origin);
        SV.SV_CheckVelocity(ent);
        if (ent.movetype != 6 && ent.movetype != 8) {
            SV.SV_AddGravity(ent);
        }
        Math3D.VectorMA(ent.s.angles, 0.1f, ent.avelocity, ent.s.angles);
        Math3D.VectorScale(ent.velocity, 0.1f, move);
        trace_t trace = SV.SV_PushEntity(ent, move);
        if (!ent.inuse) {
            return;
        }
        if (trace.fraction < 1.0f) {
            float backoff = ent.movetype == 9 ? 1.5f : 1.0f;
            GameBase.ClipVelocity(ent.velocity, trace.plane.normal, ent.velocity, backoff);
            if ((double)trace.plane.normal[2] > 0.7 && (ent.velocity[2] < 60.0f || ent.movetype != 9)) {
                ent.groundentity = trace.ent;
                ent.groundentity_linkcount = trace.ent.linkcount;
                Math3D.VectorCopy(Globals.vec3_origin, ent.velocity);
                Math3D.VectorCopy(Globals.vec3_origin, ent.avelocity);
            }
        }
        boolean wasinwater = (ent.watertype & 0x38) != 0;
        ent.watertype = GameBase.gi.pointcontents.pointcontents(ent.s.origin);
        boolean isinwater = (ent.watertype & 0x38) != 0;
        ent.waterlevel = isinwater ? 1 : 0;
        if (!wasinwater && isinwater) {
            GameBase.gi.positioned_sound(old_origin, ent, 0, GameBase.gi.soundindex("misc/h2ohit1.wav"), 1.0f, 1.0f, 0.0f);
        } else if (wasinwater && !isinwater) {
            GameBase.gi.positioned_sound(ent.s.origin, ent, 0, GameBase.gi.soundindex("misc/h2ohit1.wav"), 1.0f, 1.0f, 0.0f);
        }
        edict_t slave = ent.teamchain;
        while (slave != null) {
            Math3D.VectorCopy(ent.s.origin, slave.s.origin);
            GameBase.gi.linkentity(slave);
            slave = slave.teamchain;
        }
    }

    public static void SV_AddRotationalFriction(edict_t ent) {
        Math3D.VectorMA(ent.s.angles, 0.1f, ent.avelocity, ent.s.angles);
        float adjustment = 60.0f;
        for (int n = 0; n < 3; ++n) {
            if (ent.avelocity[n] > 0.0f) {
                int n2 = n;
                ent.avelocity[n2] = ent.avelocity[n2] - adjustment;
                if (!(ent.avelocity[n] < 0.0f)) continue;
                ent.avelocity[n] = 0.0f;
                continue;
            }
            int n3 = n;
            ent.avelocity[n3] = ent.avelocity[n3] + adjustment;
            if (!(ent.avelocity[n] > 0.0f)) continue;
            ent.avelocity[n] = 0.0f;
        }
    }

    public static void SV_Physics_Step(edict_t ent) {
        float newspeed;
        float friction;
        float control;
        float speed;
        boolean hitsound = false;
        if (ent.groundentity == null) {
            M.M_CheckGround(ent);
        }
        edict_t groundentity = ent.groundentity;
        SV.SV_CheckVelocity(ent);
        boolean wasonground = groundentity != null;
        if (ent.avelocity[0] != 0.0f || ent.avelocity[1] != 0.0f || ent.avelocity[2] != 0.0f) {
            SV.SV_AddRotationalFriction(ent);
        }
        if (!(wasonground || 0 != (ent.flags & 1) || (ent.flags & 2) != 0 && ent.waterlevel > 2)) {
            if ((double)ent.velocity[2] < (double)GameBase.sv_gravity.value * -0.1) {
                hitsound = true;
            }
            if (ent.waterlevel == 0) {
                SV.SV_AddGravity(ent);
            }
        }
        if ((ent.flags & 1) != 0 && ent.velocity[2] != 0.0f) {
            control = (speed = Math.abs(ent.velocity[2])) < 100.0f ? 100.0f : speed;
            newspeed = speed - 0.1f * control * (friction = 2.0f);
            if (newspeed < 0.0f) {
                newspeed = 0.0f;
            }
            ent.velocity[2] = ent.velocity[2] * (newspeed /= speed);
        }
        if ((ent.flags & 2) != 0 && ent.velocity[2] != 0.0f) {
            control = (speed = Math.abs(ent.velocity[2])) < 100.0f ? 100.0f : speed;
            newspeed = speed - 0.1f * control * 1.0f * (float)ent.waterlevel;
            if (newspeed < 0.0f) {
                newspeed = 0.0f;
            }
            ent.velocity[2] = ent.velocity[2] * (newspeed /= speed);
        }
        if (ent.velocity[2] != 0.0f || ent.velocity[1] != 0.0f || ent.velocity[0] != 0.0f) {
            float[] vel;
            if (!(!wasonground && 0 == (ent.flags & 3) || (double)ent.health <= 0.0 && !M.M_CheckBottom(ent) || (speed = (float)Math.sqrt((vel = ent.velocity)[0] * vel[0] + vel[1] * vel[1])) == 0.0f)) {
                control = speed < 100.0f ? 100.0f : speed;
                newspeed = speed - 0.1f * control * (friction = 6.0f);
                if (newspeed < 0.0f) {
                    newspeed = 0.0f;
                }
                vel[0] = vel[0] * (newspeed /= speed);
                vel[1] = vel[1] * newspeed;
            }
            int mask = (ent.svflags & 4) != 0 ? 0x2020003 : 3;
            SV.SV_FlyMove(ent, 0.1f, mask);
            GameBase.gi.linkentity(ent);
            GameBase.G_TouchTriggers(ent);
            if (!ent.inuse) {
                return;
            }
            if (ent.groundentity != null && !wasonground && hitsound) {
                GameBase.gi.sound(ent, 0, GameBase.gi.soundindex("world/land.wav"), 1.0f, 1.0f, 0.0f);
            }
        }
        SV.SV_RunThink(ent);
    }

    public static boolean SV_movestep(edict_t ent, float[] move, boolean relink) {
        float[] oldorg = new float[]{0.0f, 0.0f, 0.0f};
        float[] neworg = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        trace_t trace = null;
        float[] test = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorCopy(ent.s.origin, oldorg);
        Math3D.VectorAdd(ent.s.origin, move, neworg);
        if ((ent.flags & 3) != 0) {
            for (int i = 0; i < 2; ++i) {
                int contents;
                Math3D.VectorAdd(ent.s.origin, move, neworg);
                if (i == 0 && ent.enemy != null) {
                    if (ent.goalentity == null) {
                        ent.goalentity = ent.enemy;
                    }
                    float dz = ent.s.origin[2] - ent.goalentity.s.origin[2];
                    if (ent.goalentity.client != null) {
                        if (dz > 40.0f) {
                            neworg[2] = neworg[2] - 8.0f;
                        }
                        if (((ent.flags & 2) == 0 || ent.waterlevel >= 2) && dz < 30.0f) {
                            neworg[2] = neworg[2] + 8.0f;
                        }
                    } else {
                        neworg[2] = dz > 8.0f ? neworg[2] - 8.0f : (dz > 0.0f ? neworg[2] - dz : (dz < -8.0f ? neworg[2] + 8.0f : neworg[2] + dz));
                    }
                }
                trace = GameBase.gi.trace(ent.s.origin, ent.mins, ent.maxs, neworg, ent, 0x2020003);
                if ((ent.flags & 1) != 0 && ent.waterlevel == 0) {
                    test[0] = trace.endpos[0];
                    test[1] = trace.endpos[1];
                    test[2] = trace.endpos[2] + ent.mins[2] + 1.0f;
                    contents = GameBase.gi.pointcontents.pointcontents(test);
                    if ((contents & 0x38) != 0) {
                        return false;
                    }
                }
                if ((ent.flags & 2) != 0 && ent.waterlevel < 2) {
                    test[0] = trace.endpos[0];
                    test[1] = trace.endpos[1];
                    test[2] = trace.endpos[2] + ent.mins[2] + 1.0f;
                    contents = GameBase.gi.pointcontents.pointcontents(test);
                    if ((contents & 0x38) == 0) {
                        return false;
                    }
                }
                if (trace.fraction == 1.0f) {
                    Math3D.VectorCopy(trace.endpos, ent.s.origin);
                    if (relink) {
                        GameBase.gi.linkentity(ent);
                        GameBase.G_TouchTriggers(ent);
                    }
                    return true;
                }
                if (ent.enemy == null) break;
            }
            return false;
        }
        float stepsize = (ent.monsterinfo.aiflags & 0x400) == 0 ? (float)GameBase.STEPSIZE : 1.0f;
        neworg[2] = neworg[2] + stepsize;
        Math3D.VectorCopy(neworg, end);
        end[2] = end[2] - stepsize * 2.0f;
        trace = GameBase.gi.trace(neworg, ent.mins, ent.maxs, end, ent, 0x2020003);
        if (trace.allsolid) {
            return false;
        }
        if (trace.startsolid) {
            neworg[2] = neworg[2] - stepsize;
            trace = GameBase.gi.trace(neworg, ent.mins, ent.maxs, end, ent, 0x2020003);
            if (trace.allsolid || trace.startsolid) {
                return false;
            }
        }
        if (ent.waterlevel == 0) {
            test[0] = trace.endpos[0];
            test[1] = trace.endpos[1];
            test[2] = trace.endpos[2] + ent.mins[2] + 1.0f;
            int contents = GameBase.gi.pointcontents.pointcontents(test);
            if ((contents & 0x38) != 0) {
                return false;
            }
        }
        if (trace.fraction == 1.0f) {
            if ((ent.flags & 0x100) != 0) {
                Math3D.VectorAdd(ent.s.origin, move, ent.s.origin);
                if (relink) {
                    GameBase.gi.linkentity(ent);
                    GameBase.G_TouchTriggers(ent);
                }
                ent.groundentity = null;
                return true;
            }
            return false;
        }
        Math3D.VectorCopy(trace.endpos, ent.s.origin);
        if (!M.M_CheckBottom(ent)) {
            if ((ent.flags & 0x100) != 0) {
                if (relink) {
                    GameBase.gi.linkentity(ent);
                    GameBase.G_TouchTriggers(ent);
                }
                return true;
            }
            Math3D.VectorCopy(oldorg, ent.s.origin);
            return false;
        }
        if ((ent.flags & 0x100) != 0) {
            ent.flags &= 0xFFFFFEFF;
        }
        ent.groundentity = trace.ent;
        ent.groundentity_linkcount = trace.ent.linkcount;
        if (relink) {
            GameBase.gi.linkentity(ent);
            GameBase.G_TouchTriggers(ent);
        }
        return true;
    }

    public static boolean SV_StepDirection(edict_t ent, float yaw, float dist) {
        float[] move = new float[]{0.0f, 0.0f, 0.0f};
        float[] oldorigin = new float[]{0.0f, 0.0f, 0.0f};
        ent.ideal_yaw = yaw;
        M.M_ChangeYaw(ent);
        yaw = (float)((double)yaw * Math.PI * 2.0 / 360.0);
        move[0] = (float)Math.cos(yaw) * dist;
        move[1] = (float)Math.sin(yaw) * dist;
        move[2] = 0.0f;
        Math3D.VectorCopy(ent.s.origin, oldorigin);
        if (SV.SV_movestep(ent, move, false)) {
            float delta = ent.s.angles[1] - ent.ideal_yaw;
            if (delta > 45.0f && delta < 315.0f) {
                Math3D.VectorCopy(oldorigin, ent.s.origin);
            }
            GameBase.gi.linkentity(ent);
            GameBase.G_TouchTriggers(ent);
            return true;
        }
        GameBase.gi.linkentity(ent);
        GameBase.G_TouchTriggers(ent);
        return false;
    }

    public static void SV_FixCheckBottom(edict_t ent) {
        ent.flags |= 0x100;
    }

    public static void SV_NewChaseDir(edict_t actor, edict_t enemy, float dist) {
        float tdir;
        float[] d = new float[]{0.0f, 0.0f, 0.0f};
        if (enemy == null) {
            Com.DPrintf("SV_NewChaseDir without enemy!\n");
            return;
        }
        float olddir = Math3D.anglemod((int)(actor.ideal_yaw / 45.0f) * 45);
        float turnaround = Math3D.anglemod(olddir - 180.0f);
        float deltax = enemy.s.origin[0] - actor.s.origin[0];
        float deltay = enemy.s.origin[1] - actor.s.origin[1];
        d[1] = deltax > 10.0f ? 0.0f : (deltax < -10.0f ? 180.0f : (float)DI_NODIR);
        d[2] = deltay < -10.0f ? 270.0f : (deltay > 10.0f ? 90.0f : (float)DI_NODIR);
        if (d[1] != (float)DI_NODIR && d[2] != (float)DI_NODIR) {
            if (d[1] == 0.0f) {
                tdir = d[2] == 90.0f ? 45.0f : 315.0f;
            } else {
                float f = tdir = d[2] == 90.0f ? 135.0f : 215.0f;
            }
            if (tdir != turnaround && SV.SV_StepDirection(actor, tdir, dist)) {
                return;
            }
        }
        if ((Lib.rand() & 3 & 1) != 0 || Math.abs(deltay) > Math.abs(deltax)) {
            tdir = d[1];
            d[1] = d[2];
            d[2] = tdir;
        }
        if (d[1] != (float)DI_NODIR && d[1] != turnaround && SV.SV_StepDirection(actor, d[1], dist)) {
            return;
        }
        if (d[2] != (float)DI_NODIR && d[2] != turnaround && SV.SV_StepDirection(actor, d[2], dist)) {
            return;
        }
        if (olddir != (float)DI_NODIR && SV.SV_StepDirection(actor, olddir, dist)) {
            return;
        }
        if ((Lib.rand() & 1) != 0) {
            for (tdir = 0.0f; tdir <= 315.0f; tdir += 45.0f) {
                if (tdir == turnaround || !SV.SV_StepDirection(actor, tdir, dist)) continue;
                return;
            }
        } else {
            for (tdir = 315.0f; tdir >= 0.0f; tdir -= 45.0f) {
                if (tdir == turnaround || !SV.SV_StepDirection(actor, tdir, dist)) continue;
                return;
            }
        }
        if (turnaround != (float)DI_NODIR && SV.SV_StepDirection(actor, turnaround, dist)) {
            return;
        }
        actor.ideal_yaw = olddir;
        if (!M.M_CheckBottom(actor)) {
            SV.SV_FixCheckBottom(actor);
        }
    }

    public static boolean SV_CloseEnough(edict_t ent, edict_t goal, float dist) {
        for (int i = 0; i < 3; ++i) {
            if (goal.absmin[i] > ent.absmax[i] + dist) {
                return false;
            }
            if (!(goal.absmax[i] < ent.absmin[i] - dist)) continue;
            return false;
        }
        return true;
    }
}

