/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.opengl;

import jake2.client.VID;
import jake2.qcommon.Com;
import jake2.qcommon.xcommand_t;
import jake2.render.Base;
import jake2.render.opengl.GLDriver;
import jake2.render.opengl.LwjglGL;
import java.awt.Dimension;
import java.util.LinkedList;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public abstract class LwjglDriver
extends LwjglGL
implements GLDriver {
    private DisplayMode oldDisplayMode;
    int window_xpos;
    int window_ypos;

    protected LwjglDriver() {
    }

    private java.awt.DisplayMode toAwtDisplayMode(DisplayMode m) {
        return new java.awt.DisplayMode(m.getWidth(), m.getHeight(), m.getBitsPerPixel(), m.getFrequency());
    }

    public java.awt.DisplayMode[] getModeList() {
        DisplayMode[] modes;
        try {
            modes = Display.getAvailableDisplayModes();
        }
        catch (LWJGLException e) {
            Com.Println(e.getMessage());
            return new java.awt.DisplayMode[0];
        }
        LinkedList<java.awt.DisplayMode> l = new LinkedList<java.awt.DisplayMode>();
        l.add(this.toAwtDisplayMode(this.oldDisplayMode));
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            if (m.getBitsPerPixel() != this.oldDisplayMode.getBitsPerPixel() || m.getFrequency() > this.oldDisplayMode.getFrequency() || m.getHeight() < 240 || m.getWidth() < 320) continue;
            int j = 0;
            java.awt.DisplayMode ml = null;
            for (j = 0; j < l.size() && (ml = (java.awt.DisplayMode)l.get(j)).getWidth() <= m.getWidth() && (ml.getWidth() != m.getWidth() || ml.getHeight() < m.getHeight()); ++j) {
            }
            if (j == l.size()) {
                l.addLast(this.toAwtDisplayMode(m));
                continue;
            }
            if (ml.getWidth() > m.getWidth() || ml.getHeight() > m.getHeight()) {
                l.add(j, this.toAwtDisplayMode(m));
                continue;
            }
            if (m.getFrequency() <= ml.getRefreshRate()) continue;
            l.remove(j);
            l.add(j, this.toAwtDisplayMode(m));
        }
        java.awt.DisplayMode[] ma = new java.awt.DisplayMode[l.size()];
        l.toArray(ma);
        return ma;
    }

    public DisplayMode[] getLWJGLModeList() {
        DisplayMode[] modes;
        try {
            modes = Display.getAvailableDisplayModes();
        }
        catch (LWJGLException e) {
            Com.Println(e.getMessage());
            return new DisplayMode[0];
        }
        LinkedList<DisplayMode> l = new LinkedList<DisplayMode>();
        l.add(this.oldDisplayMode);
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            if (m.getBitsPerPixel() != this.oldDisplayMode.getBitsPerPixel() || m.getFrequency() > Math.max(60, this.oldDisplayMode.getFrequency()) || m.getHeight() < 240 || m.getWidth() < 320 || m.getHeight() > this.oldDisplayMode.getHeight() || m.getWidth() > this.oldDisplayMode.getWidth()) continue;
            int j = 0;
            DisplayMode ml = null;
            for (j = 0; j < l.size() && (ml = (DisplayMode)l.get(j)).getWidth() <= m.getWidth() && (ml.getWidth() != m.getWidth() || ml.getHeight() < m.getHeight()); ++j) {
            }
            if (j == l.size()) {
                l.addLast(m);
                continue;
            }
            if (ml.getWidth() > m.getWidth() || ml.getHeight() > m.getHeight()) {
                l.add(j, m);
                continue;
            }
            if (m.getFrequency() <= ml.getFrequency()) continue;
            l.remove(j);
            l.add(j, m);
        }
        DisplayMode[] ma = new DisplayMode[l.size()];
        l.toArray(ma);
        return ma;
    }

    private DisplayMode findDisplayMode(Dimension dim) {
        DisplayMode mode = null;
        DisplayMode m = null;
        DisplayMode[] modes = this.getLWJGLModeList();
        int w = dim.width;
        int h = dim.height;
        for (int i = 0; i < modes.length; ++i) {
            m = modes[i];
            if (m.getWidth() != w || m.getHeight() != h) continue;
            mode = m;
            break;
        }
        if (mode == null) {
            mode = this.oldDisplayMode;
        }
        return mode;
    }

    String getModeString(DisplayMode m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getWidth());
        sb.append('x');
        sb.append(m.getHeight());
        sb.append('x');
        sb.append(m.getBitsPerPixel());
        sb.append('@');
        sb.append(m.getFrequency());
        sb.append("Hz");
        return sb.toString();
    }

    public int setMode(Dimension dim, int mode, boolean fullscreen) {
        Dimension newDim = new Dimension();
        VID.Printf(0, "Initializing OpenGL display\n");
        VID.Printf(0, "...setting mode " + mode + ":");
        if (this.oldDisplayMode == null) {
            this.oldDisplayMode = Display.getDisplayMode();
        }
        if (!VID.GetModeInfo(newDim, mode)) {
            VID.Printf(0, " invalid mode\n");
            return 2;
        }
        VID.Printf(0, " " + newDim.width + " " + newDim.height + '\n');
        this.shutdown();
        Display.setTitle((String)"Jake2 (lwjgl)");
        DisplayMode displayMode = this.findDisplayMode(newDim);
        newDim.width = displayMode.getWidth();
        newDim.height = displayMode.getHeight();
        if (fullscreen) {
            try {
                Display.setDisplayMode((DisplayMode)displayMode);
            }
            catch (LWJGLException e) {
                return 2;
            }
            Display.setLocation((int)0, (int)0);
            try {
                Display.setFullscreen((boolean)fullscreen);
            }
            catch (LWJGLException e) {
                return 1;
            }
            VID.Printf(0, "...setting fullscreen " + this.getModeString(displayMode) + '\n');
        } else {
            try {
                Display.setDisplayMode((DisplayMode)displayMode);
            }
            catch (LWJGLException e) {
                return 2;
            }
            try {
                Display.setFullscreen((boolean)false);
            }
            catch (LWJGLException e) {
                return 1;
            }
        }
        Base.setVid(newDim.width, newDim.height);
        try {
            Display.create();
        }
        catch (LWJGLException e) {
            return 3;
        }
        VID.NewWindow(newDim.width, newDim.height);
        return 0;
    }

    public void shutdown() {
        if (this.oldDisplayMode != null && Display.isFullscreen()) {
            try {
                Display.setDisplayMode((DisplayMode)this.oldDisplayMode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (Display.isCreated()) {
            Display.destroy();
        }
    }

    public boolean init(int xpos, int ypos) {
        this.window_xpos = xpos;
        this.window_ypos = ypos;
        return true;
    }

    public void beginFrame(float camera_separation) {
    }

    public void endFrame() {
        this.glFlush();
        Display.update();
    }

    public void appActivate(boolean activate) {
    }

    public void enableLogging(boolean enable) {
    }

    public void logNewFrame() {
    }

    public final void updateScreen(xcommand_t callback) {
        callback.execute();
    }
}

