/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.opengl;

import jake2.Globals;
import jake2.SizeChangeListener;
import jake2.client.VID;
import jake2.qcommon.Cbuf;
import jake2.qcommon.xcommand_t;
import jake2.render.Base;
import jake2.render.opengl.GLDriver;
import jake2.render.opengl.Jsr231GL;
import jake2.sys.JOGLKBD;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.swing.ImageIcon;

public abstract class Jsr231Driver
extends Jsr231GL
implements GLDriver {
    private GraphicsDevice device;
    private DisplayMode oldDisplayMode;
    private volatile Display display;
    private volatile Frame window;
    private volatile Container container;
    int window_xpos;
    int window_ypos;

    protected Jsr231Driver() {
    }

    public DisplayMode[] getModeList() {
        DisplayMode[] modes = this.device.getDisplayModes();
        LinkedList<DisplayMode> l = new LinkedList<DisplayMode>();
        l.add(this.oldDisplayMode);
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            if (m.getBitDepth() != this.oldDisplayMode.getBitDepth() || m.getRefreshRate() > this.oldDisplayMode.getRefreshRate() || m.getHeight() < 240 || m.getWidth() < 320) continue;
            int j = 0;
            DisplayMode ml = null;
            for (j = 0; j < l.size() && (ml = (DisplayMode)l.get(j)).getWidth() <= m.getWidth() && (ml.getWidth() != m.getWidth() || ml.getHeight() < m.getHeight()); ++j) {
            }
            if (j == l.size()) {
                l.addLast(m);
                continue;
            }
            if (ml.getWidth() > m.getWidth() || ml.getHeight() > m.getHeight()) {
                l.add(j, m);
                continue;
            }
            if (m.getRefreshRate() <= ml.getRefreshRate()) continue;
            l.remove(j);
            l.add(j, m);
        }
        DisplayMode[] ma = new DisplayMode[l.size()];
        l.toArray(ma);
        return ma;
    }

    DisplayMode findDisplayMode(Dimension dim) {
        DisplayMode mode = null;
        DisplayMode m = null;
        DisplayMode[] modes = this.getModeList();
        int w = dim.width;
        int h = dim.height;
        for (int i = 0; i < modes.length; ++i) {
            m = modes[i];
            if (m.getWidth() != w || m.getHeight() != h) continue;
            mode = m;
            break;
        }
        if (mode == null) {
            mode = this.oldDisplayMode;
        }
        return mode;
    }

    String getModeString(DisplayMode m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getWidth());
        sb.append('x');
        sb.append(m.getHeight());
        sb.append('x');
        sb.append(m.getBitDepth());
        sb.append('@');
        sb.append(m.getRefreshRate());
        sb.append("Hz");
        return sb.toString();
    }

    public int setMode(Dimension dim, int mode, boolean fullscreen) {
        final Dimension newDim = new Dimension();
        VID.Printf(0, "Initializing OpenGL display\n");
        VID.Printf(0, "...setting mode " + mode + ":");
        if (Globals.appletMode && this.container == null) {
            this.container = (Container)Globals.applet;
        }
        if (this.device == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.device = env.getDefaultScreenDevice();
        }
        if (this.oldDisplayMode == null) {
            this.oldDisplayMode = this.device.getDisplayMode();
        }
        if (!VID.GetModeInfo(newDim, mode)) {
            VID.Printf(0, " invalid mode\n");
            return 2;
        }
        VID.Printf(0, " " + newDim.width + " " + newDim.height + '\n');
        if (!Globals.appletMode) {
            if (this.window != null) {
                this.shutdown();
            }
            this.window = new Frame("Jake2 (jsr231)");
            this.container = this.window;
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/icon-small.png"));
            this.window.setIconImage(icon.getImage());
            this.window.setLayout(new GridBagLayout());
            this.window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Cbuf.ExecuteText(2, "quit");
                }
            });
        }
        if (Globals.appletMode) {
            this.shutdown();
            fullscreen = false;
            JOGLKBD.Init(this.container);
        }
        Display canvas = new Display(new GLCapabilities());
        canvas.setFocusTraversalKeysEnabled(false);
        canvas.setSize(newDim.width, newDim.height);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.container.addComponentListener(JOGLKBD.listener);
        canvas.addKeyListener(JOGLKBD.listener);
        canvas.addMouseListener(JOGLKBD.listener);
        canvas.addMouseMotionListener(JOGLKBD.listener);
        canvas.addMouseWheelListener(JOGLKBD.listener);
        if (fullscreen) {
            this.container.add((Component)canvas, gbc);
            DisplayMode displayMode = this.findDisplayMode(newDim);
            newDim.width = displayMode.getWidth();
            newDim.height = displayMode.getHeight();
            this.window.setUndecorated(true);
            this.window.setResizable(false);
            this.device.setFullScreenWindow(this.window);
            if (this.device.isFullScreenSupported()) {
                this.device.setDisplayMode(displayMode);
            }
            this.window.setLocation(0, 0);
            this.window.setSize(displayMode.getWidth(), displayMode.getHeight());
            canvas.setSize(displayMode.getWidth(), displayMode.getHeight());
            VID.Printf(0, "...setting fullscreen " + this.getModeString(displayMode) + '\n');
        } else if (!Globals.appletMode) {
            this.container.add((Component)canvas, gbc);
            final Frame f2 = this.window;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        f2.pack();
                        f2.setResizable(false);
                        f2.setVisible(true);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            final Display fd = canvas;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Jsr231Driver.this.container.add((Component)fd, "Center");
                        SizeChangeListener listener = Globals.sizeChangeListener;
                        if (listener != null) {
                            listener.sizeChanged(newDim.width, newDim.height);
                        }
                        fd.setSize(newDim.width, newDim.height);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!Globals.appletMode) {
            while (!canvas.isDisplayable() || !this.window.isDisplayable()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        canvas.requestFocus();
        this.display = canvas;
        this.setGL(this.display.getGL());
        this.init(0, 0);
        return 0;
    }

    public void shutdown() {
        if (!Globals.appletMode) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        if (Jsr231Driver.this.oldDisplayMode != null && Jsr231Driver.this.device.getFullScreenWindow() != null) {
                            try {
                                if (Jsr231Driver.this.device.isFullScreenSupported() && !Jsr231Driver.this.device.getDisplayMode().equals(Jsr231Driver.this.oldDisplayMode)) {
                                    Jsr231Driver.this.device.setDisplayMode(Jsr231Driver.this.oldDisplayMode);
                                }
                                Jsr231Driver.this.device.setFullScreenWindow(null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.window != null) {
                if (this.display != null) {
                    this.display.destroy();
                }
                this.window.dispose();
                while (this.window.isDisplayable()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else if (this.display != null) {
            this.display.destroy();
            this.container.remove(this.display);
        }
        this.display = null;
    }

    public boolean init(int xpos, int ypos) {
        this.window_xpos = xpos;
        this.window_ypos = ypos;
        this.beginFrame(0.0f);
        this.glViewport(0, 0, this.display.getWidth(), this.display.getHeight());
        this.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.glClear(16640);
        this.endFrame();
        this.beginFrame(0.0f);
        this.glViewport(0, 0, this.display.getWidth(), this.display.getHeight());
        this.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.glClear(16640);
        this.endFrame();
        return true;
    }

    public void beginFrame(float camera_separation) {
        this.display.activate();
    }

    public void endFrame() {
        this.glFlush();
        this.display.update();
    }

    public void appActivate(boolean activate) {
    }

    public void enableLogging(boolean enable) {
    }

    public void logNewFrame() {
    }

    public void updateScreen(xcommand_t callback) {
        callback.execute();
    }

    protected void activate() {
        this.display.activate();
    }

    private static class Display
    extends Canvas {
        private GLDrawable drawable;
        private GLContext context;

        public Display(GLCapabilities capabilities) {
            super(Display.unwrap((AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration(capabilities, null, null)));
            this.drawable = GLDrawableFactory.getFactory().getGLDrawable((Object)this, capabilities, null);
            this.context = this.drawable.createContext(null);
        }

        GL getGL() {
            this.activate();
            return this.context.getGL();
        }

        public void setBounds(int x, int y, int width, int height) {
            int mask = -4;
            if ((width & 3) != 0) {
                width &= 0xFFFFFFFC;
                width += 4;
            }
            super.setBounds(x, y, width, height);
            Base.setVid(width, height);
            VID.NewWindow(width, height);
        }

        public void paint(Graphics g) {
        }

        public void update(Graphics g) {
        }

        public void addNotify() {
            super.addNotify();
            super.setBackground(Color.BLACK);
            this.drawable.setRealized(true);
        }

        public void removeNotify() {
            if (this.drawable != null) {
                this.drawable.setRealized(false);
                this.drawable = null;
            }
            super.removeNotify();
        }

        void activate() {
            if (GLContext.getCurrent() != this.context) {
                this.context.makeCurrent();
            }
        }

        private void release() {
            if (GLContext.getCurrent() == this.context) {
                this.context.release();
            }
        }

        void update() {
            this.release();
            this.drawable.swapBuffers();
        }

        void destroy() {
            if (this.context != null) {
                this.release();
                this.context.destroy();
                this.context = null;
            }
        }

        private static GraphicsConfiguration unwrap(AWTGraphicsConfiguration config) {
            if (config == null) {
                return null;
            }
            return config.getGraphicsConfiguration();
        }
    }
}

