/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.opengl;

import jake2.client.VID;
import jake2.qcommon.Cbuf;
import jake2.qcommon.xcommand_t;
import jake2.render.Base;
import jake2.render.opengl.GLDriver;
import jake2.render.opengl.JoglGL;
import jake2.sys.JOGLKBD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;

public abstract class JoglDriver
extends JoglGL
implements GLDriver,
GLEventListener {
    private GraphicsDevice device;
    private DisplayMode oldDisplayMode;
    private GLCanvas canvas;
    JFrame window;
    int window_xpos;
    int window_ypos;
    protected boolean post_init = false;
    protected boolean contextInUse = false;
    protected final xcommand_t INIT_CALLBACK;
    xcommand_t callback = this.INIT_CALLBACK = new xcommand_t(){

        public void execute() {
            JoglDriver.this.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            JoglDriver.this.glClear(16640);
            if (!JoglDriver.this.post_init) {
                VID.Printf(0, "Missing multi-texturing for FastJOGL renderer\n");
            }
            JoglDriver.this.endFrame();
        }
    };

    protected JoglDriver() {
    }

    public DisplayMode[] getModeList() {
        DisplayMode[] modes = this.device.getDisplayModes();
        LinkedList<DisplayMode> l = new LinkedList<DisplayMode>();
        l.add(this.oldDisplayMode);
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            if (m.getBitDepth() != this.oldDisplayMode.getBitDepth() || m.getRefreshRate() > this.oldDisplayMode.getRefreshRate() || m.getHeight() < 240 || m.getWidth() < 320) continue;
            int j = 0;
            DisplayMode ml = null;
            for (j = 0; j < l.size() && (ml = (DisplayMode)l.get(j)).getWidth() <= m.getWidth() && (ml.getWidth() != m.getWidth() || ml.getHeight() < m.getHeight()); ++j) {
            }
            if (j == l.size()) {
                l.addLast(m);
                continue;
            }
            if (ml.getWidth() > m.getWidth() || ml.getHeight() > m.getHeight()) {
                l.add(j, m);
                continue;
            }
            if (m.getRefreshRate() <= ml.getRefreshRate()) continue;
            l.remove(j);
            l.add(j, m);
        }
        DisplayMode[] ma = new DisplayMode[l.size()];
        l.toArray(ma);
        return ma;
    }

    DisplayMode findDisplayMode(Dimension dim) {
        DisplayMode mode = null;
        DisplayMode m = null;
        DisplayMode[] modes = this.getModeList();
        int w = dim.width;
        int h = dim.height;
        for (int i = 0; i < modes.length; ++i) {
            m = modes[i];
            if (m.getWidth() != w || m.getHeight() != h) continue;
            mode = m;
            break;
        }
        if (mode == null) {
            mode = this.oldDisplayMode;
        }
        return mode;
    }

    String getModeString(DisplayMode m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getWidth());
        sb.append('x');
        sb.append(m.getHeight());
        sb.append('x');
        sb.append(m.getBitDepth());
        sb.append('@');
        sb.append(m.getRefreshRate());
        sb.append("Hz");
        return sb.toString();
    }

    public int setMode(Dimension dim, int mode, boolean fullscreen) {
        Dimension newDim = new Dimension();
        VID.Printf(0, "Initializing OpenGL display\n");
        VID.Printf(0, "...setting mode " + mode + ":");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = env.getDefaultScreenDevice();
        if (this.oldDisplayMode == null) {
            this.oldDisplayMode = this.device.getDisplayMode();
        }
        if (!VID.GetModeInfo(newDim, mode)) {
            VID.Printf(0, " invalid mode\n");
            return 2;
        }
        VID.Printf(0, " " + newDim.width + " " + newDim.height + '\n');
        this.shutdown();
        this.window = new JFrame("Jake2 (jogl)");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icon-small.png"));
        this.window.setIconImage(icon.getImage());
        GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities());
        canvas.setFocusTraversalKeysEnabled(false);
        canvas.setNoAutoRedrawMode(true);
        canvas.setAutoSwapBufferMode(false);
        canvas.addGLEventListener((GLEventListener)this);
        this.window.getContentPane().add((Component)canvas);
        canvas.setSize(newDim.width, newDim.height);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Cbuf.ExecuteText(2, "quit");
            }
        });
        this.window.addComponentListener(JOGLKBD.listener);
        canvas.addKeyListener((KeyListener)JOGLKBD.listener);
        canvas.addMouseListener((MouseListener)JOGLKBD.listener);
        canvas.addMouseMotionListener((MouseMotionListener)JOGLKBD.listener);
        canvas.addMouseWheelListener((MouseWheelListener)JOGLKBD.listener);
        if (fullscreen) {
            DisplayMode displayMode = this.findDisplayMode(newDim);
            newDim.width = displayMode.getWidth();
            newDim.height = displayMode.getHeight();
            this.window.setUndecorated(true);
            this.window.setResizable(false);
            this.device.setFullScreenWindow(this.window);
            if (this.device.isFullScreenSupported()) {
                this.device.setDisplayMode(displayMode);
            }
            this.window.setLocation(0, 0);
            this.window.setSize(displayMode.getWidth(), displayMode.getHeight());
            canvas.setSize(displayMode.getWidth(), displayMode.getHeight());
            VID.Printf(0, "...setting fullscreen " + this.getModeString(displayMode) + '\n');
        } else {
            this.window.setLocation(this.window_xpos, this.window_ypos);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setVisible(true);
        }
        while (!canvas.isDisplayable()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        canvas.requestFocus();
        this.canvas = canvas;
        Base.setVid(newDim.width, newDim.height);
        VID.NewWindow(newDim.width, newDim.height);
        return 0;
    }

    public void shutdown() {
        if (this.oldDisplayMode != null && this.device.getFullScreenWindow() != null) {
            try {
                if (this.device.isFullScreenSupported()) {
                    this.device.setDisplayMode(this.oldDisplayMode);
                }
                this.device.setFullScreenWindow(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.window != null) {
            if (this.canvas != null) {
                this.canvas.setVisible(false);
                this.window.remove((Component)this.canvas);
                this.canvas = null;
            }
            this.window.dispose();
        }
        this.post_init = false;
        this.callback = this.INIT_CALLBACK;
    }

    public boolean init(int xpos, int ypos) {
        this.window_xpos = xpos;
        this.window_ypos = ypos;
        return true;
    }

    public void beginFrame(float camera_separation) {
    }

    public void endFrame() {
        this.glFlush();
        this.canvas.swapBuffers();
    }

    public void appActivate(boolean activate) {
    }

    public void enableLogging(boolean enable) {
    }

    public void logNewFrame() {
    }

    public void updateScreen() {
        this.callback = this.INIT_CALLBACK;
        this.canvas.display();
    }

    public void updateScreen(xcommand_t callback) {
        this.callback = callback;
        this.canvas.display();
    }

    public void init(GLDrawable drawable) {
        this.setGL(drawable.getGL());
    }

    public void display(GLDrawable drawable) {
        this.setGL(drawable.getGL());
        this.contextInUse = true;
        this.callback.execute();
        this.contextInUse = false;
    }

    public void displayChanged(GLDrawable drawable, boolean arg1, boolean arg2) {
    }

    public void reshape(GLDrawable drawable, int x, int y, int width, int height) {
    }
}

