/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.Globals;
import jake2.qcommon.Com;
import jake2.render.fast.Model;
import jake2.render.fast.Polygon;
import jake2.render.glpoly_t;
import jake2.render.image_t;
import jake2.render.msurface_t;
import jake2.util.Math3D;
import jake2.util.Vec3Cache;

public abstract class Warp
extends Model {
    public static final float[] SIN;
    String skyname;
    float skyrotate;
    float[] skyaxis = new float[]{0.0f, 0.0f, 0.0f};
    image_t[] sky_images = new image_t[6];
    msurface_t warpface;
    static final int SUBDIVIDE_SIZE = 64;
    private final float[][] tmpVerts = new float[64][3];
    static final float TURBSCALE = 40.743664f;
    float[][] skyclip = new float[][]{{1.0f, 1.0f, 0.0f}, {1.0f, -1.0f, 0.0f}, {0.0f, -1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 1.0f}};
    int c_sky;
    int[][] st_to_vec = new int[][]{{3, -1, 2}, {-3, 1, 2}, {1, 3, 2}, {-1, -3, 2}, {-2, -1, 3}, {2, -1, -3}};
    int[][] vec_to_st = new int[][]{{-2, 3, 1}, {2, 3, -1}, {1, 3, 2}, {-1, 3, -2}, {-2, -1, 3}, {-2, 1, -3}};
    float[][] skymins = new float[2][6];
    float[][] skymaxs = new float[2][6];
    float sky_min;
    float sky_max;
    private final float[] v = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] av = new float[]{0.0f, 0.0f, 0.0f};
    static final float ON_EPSILON = 0.1f;
    static final int MAX_CLIP_VERTS = 64;
    static final int SIDE_BACK = 1;
    static final int SIDE_FRONT = 0;
    static final int SIDE_ON = 2;
    float[] dists = new float[64];
    int[] sides = new int[64];
    float[][][][] newv = new float[6][2][64][3];
    float[][] verts = new float[64][3];
    private final float[] v1 = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] b = new float[]{0.0f, 0.0f, 0.0f};
    int[] skytexorder = new int[]{0, 2, 1, 3, 4, 5};
    String[] suf = new String[]{"rt", "bk", "lf", "ft", "up", "dn"};
    static final /* synthetic */ boolean $assertionsDisabled;

    void BoundPoly(int numverts, float[][] verts, float[] mins, float[] maxs) {
        mins[2] = 9999.0f;
        mins[1] = 9999.0f;
        mins[0] = 9999.0f;
        maxs[2] = -9999.0f;
        maxs[1] = -9999.0f;
        maxs[0] = -9999.0f;
        for (int i = 0; i < numverts; ++i) {
            float[] v = verts[i];
            for (int j = 0; j < 3; ++j) {
                if (v[j] < mins[j]) {
                    mins[j] = v[j];
                }
                if (!(v[j] > maxs[j])) continue;
                maxs[j] = v[j];
            }
        }
    }

    void SubdividePolygon(int numverts, float[][] verts) {
        int i;
        float[][] front = new float[64][3];
        float[][] back = new float[64][3];
        float[] dist = new float[64];
        if (numverts > 60) {
            Com.Error(1, "numverts = " + numverts);
        }
        float[] mins = Vec3Cache.get();
        float[] maxs = Vec3Cache.get();
        this.BoundPoly(numverts, verts, mins, maxs);
        for (i = 0; i < 3; ++i) {
            int j;
            float m = (mins[i] + maxs[i]) * 0.5f;
            if (maxs[i] - (m = 64.0f * (float)Math.floor(m / 64.0f + 0.5f)) < 8.0f || m - mins[i] < 8.0f) continue;
            for (j = 0; j < numverts; ++j) {
                dist[j] = verts[j][i] - m;
            }
            dist[j] = dist[0];
            Math3D.VectorCopy(verts[0], verts[numverts]);
            int b = 0;
            int f = 0;
            for (j = 0; j < numverts; ++j) {
                float[] v = verts[j];
                if (dist[j] >= 0.0f) {
                    Math3D.VectorCopy(v, front[f]);
                    ++f;
                }
                if (dist[j] <= 0.0f) {
                    Math3D.VectorCopy(v, back[b]);
                    ++b;
                }
                if (dist[j] == 0.0f || dist[j + 1] == 0.0f || dist[j] > 0.0f == dist[j + 1] > 0.0f) continue;
                float frac = dist[j] / (dist[j] - dist[j + 1]);
                for (int k = 0; k < 3; ++k) {
                    float f2 = v[k] + frac * (verts[j + 1][k] - v[k]);
                    back[b][k] = f2;
                    front[f][k] = f2;
                }
                ++f;
                ++b;
            }
            this.SubdividePolygon(f, front);
            this.SubdividePolygon(b, back);
            Vec3Cache.release(2);
            return;
        }
        Vec3Cache.release(2);
        glpoly_t poly = Polygon.create(numverts + 2);
        poly.next = this.warpface.polys;
        this.warpface.polys = poly;
        float[] total = Vec3Cache.get();
        Math3D.VectorClear(total);
        float total_s = 0.0f;
        float total_t = 0.0f;
        for (i = 0; i < numverts; ++i) {
            poly.x(i + 1, verts[i][0]);
            poly.y(i + 1, verts[i][1]);
            poly.z(i + 1, verts[i][2]);
            float s = Math3D.DotProduct(verts[i], this.warpface.texinfo.vecs[0]);
            float t = Math3D.DotProduct(verts[i], this.warpface.texinfo.vecs[1]);
            total_s += s;
            total_t += t;
            Math3D.VectorAdd(total, verts[i], total);
            poly.s1(i + 1, s);
            poly.t1(i + 1, t);
        }
        float scale = 1.0f / (float)numverts;
        poly.x(0, total[0] * scale);
        poly.y(0, total[1] * scale);
        poly.z(0, total[2] * scale);
        poly.s1(0, total_s * scale);
        poly.t1(0, total_t * scale);
        poly.x(i + 1, poly.x(1));
        poly.y(i + 1, poly.y(1));
        poly.z(i + 1, poly.z(1));
        poly.s1(i + 1, poly.s1(1));
        poly.t1(i + 1, poly.t1(1));
        poly.s2(i + 1, poly.s2(1));
        poly.t2(i + 1, poly.t2(1));
        Vec3Cache.release();
    }

    void GL_SubdivideSurface(msurface_t fa) {
        float[][] verts = this.tmpVerts;
        this.warpface = fa;
        int numverts = 0;
        for (int i = 0; i < fa.numedges; ++i) {
            int lindex = this.loadmodel.surfedges[fa.firstedge + i];
            float[] vec = lindex > 0 ? this.loadmodel.vertexes[this.loadmodel.edges[lindex].v[0]].position : this.loadmodel.vertexes[this.loadmodel.edges[-lindex].v[1]].position;
            Math3D.VectorCopy(vec, verts[numverts]);
            ++numverts;
        }
        this.SubdividePolygon(numverts, verts);
    }

    void EmitWaterPolys(msurface_t fa) {
        float rdt = this.r_newrefdef.time;
        float scroll = (fa.texinfo.flags & 0x40) != 0 ? -64.0f * (this.r_newrefdef.time * 0.5f - (float)((int)(this.r_newrefdef.time * 0.5f))) : 0.0f;
        glpoly_t bp = fa.polys;
        while (bp != null) {
            glpoly_t p = bp;
            this.gl.glBegin(6);
            for (int i = 0; i < p.numverts; ++i) {
                float os = p.s1(i);
                float ot = p.t1(i);
                float s = os + SIN[(int)((ot * 0.125f + this.r_newrefdef.time) * 40.743664f) & 0xFF];
                s += scroll;
                float t = ot + SIN[(int)((os * 0.125f + rdt) * 40.743664f) & 0xFF];
                this.gl.glTexCoord2f(s *= 0.015625f, t *= 0.015625f);
                this.gl.glVertex3f(p.x(i), p.y(i), p.z(i));
            }
            this.gl.glEnd();
            bp = bp.next;
        }
    }

    void DrawSkyPolygon(int nump, float[][] vecs) {
        int i;
        ++this.c_sky;
        Math3D.VectorCopy(Globals.vec3_origin, this.v);
        for (i = 0; i < nump; ++i) {
            Math3D.VectorAdd(vecs[i], this.v, this.v);
        }
        this.av[0] = Math.abs(this.v[0]);
        this.av[1] = Math.abs(this.v[1]);
        this.av[2] = Math.abs(this.v[2]);
        int axis = this.av[0] > this.av[1] && this.av[0] > this.av[2] ? (this.v[0] < 0.0f ? 1 : 0) : (this.av[1] > this.av[2] && this.av[1] > this.av[0] ? (this.v[1] < 0.0f ? 3 : 2) : (this.v[2] < 0.0f ? 5 : 4));
        for (i = 0; i < nump; ++i) {
            int j = this.vec_to_st[axis][2];
            float dv = j > 0 ? vecs[i][j - 1] : -vecs[i][-j - 1];
            if (dv < 0.001f) continue;
            j = this.vec_to_st[axis][0];
            float s = j < 0 ? -vecs[i][-j - 1] / dv : vecs[i][j - 1] / dv;
            j = this.vec_to_st[axis][1];
            float t = j < 0 ? -vecs[i][-j - 1] / dv : vecs[i][j - 1] / dv;
            if (s < this.skymins[0][axis]) {
                this.skymins[0][axis] = s;
            }
            if (t < this.skymins[1][axis]) {
                this.skymins[1][axis] = t;
            }
            if (s > this.skymaxs[0][axis]) {
                this.skymaxs[0][axis] = s;
            }
            if (!(t > this.skymaxs[1][axis])) continue;
            this.skymaxs[1][axis] = t;
        }
    }

    void ClipSkyPolygon(int nump, float[][] vecs, int stage) {
        float d;
        int i;
        if (nump > 62) {
            Com.Error(1, "ClipSkyPolygon: MAX_CLIP_VERTS");
        }
        if (stage == 6) {
            this.DrawSkyPolygon(nump, vecs);
            return;
        }
        boolean front = false;
        boolean back = false;
        float[] norm = this.skyclip[stage];
        for (i = 0; i < nump; ++i) {
            d = Math3D.DotProduct(vecs[i], norm);
            if (d > 0.1f) {
                front = true;
                this.sides[i] = 0;
            } else if (d < -0.1f) {
                back = true;
                this.sides[i] = 1;
            } else {
                this.sides[i] = 2;
            }
            this.dists[i] = d;
        }
        if (!front || !back) {
            this.ClipSkyPolygon(nump, vecs, stage + 1);
            return;
        }
        this.sides[i] = this.sides[0];
        this.dists[i] = this.dists[0];
        Math3D.VectorCopy(vecs[0], vecs[i]);
        int newc0 = 0;
        int newc1 = 0;
        for (i = 0; i < nump; ++i) {
            float[] v = vecs[i];
            switch (this.sides[i]) {
                case 0: {
                    Math3D.VectorCopy(v, this.newv[stage][0][newc0]);
                    ++newc0;
                    break;
                }
                case 1: {
                    Math3D.VectorCopy(v, this.newv[stage][1][newc1]);
                    ++newc1;
                    break;
                }
                case 2: {
                    Math3D.VectorCopy(v, this.newv[stage][0][newc0]);
                    ++newc0;
                    Math3D.VectorCopy(v, this.newv[stage][1][newc1]);
                    ++newc1;
                }
            }
            if (this.sides[i] == 2 || this.sides[i + 1] == 2 || this.sides[i + 1] == this.sides[i]) continue;
            d = this.dists[i] / (this.dists[i] - this.dists[i + 1]);
            for (int j = 0; j < 3; ++j) {
                float e;
                this.newv[stage][0][newc0][j] = e = v[j] + d * (vecs[i + 1][j] - v[j]);
                this.newv[stage][1][newc1][j] = e;
            }
            ++newc0;
            ++newc1;
        }
        this.ClipSkyPolygon(newc0, this.newv[stage][0], stage + 1);
        this.ClipSkyPolygon(newc1, this.newv[stage][1], stage + 1);
    }

    void R_AddSkySurface(msurface_t fa) {
        glpoly_t p = fa.polys;
        while (p != null) {
            for (int i = 0; i < p.numverts; ++i) {
                this.verts[i][0] = p.x(i) - this.r_origin[0];
                this.verts[i][1] = p.y(i) - this.r_origin[1];
                this.verts[i][2] = p.z(i) - this.r_origin[2];
            }
            this.ClipSkyPolygon(p.numverts, this.verts, 0);
            p = p.next;
        }
    }

    void R_ClearSkyBox() {
        float[] skymins0 = this.skymins[0];
        float[] skymins1 = this.skymins[1];
        float[] skymaxs0 = this.skymaxs[0];
        float[] skymaxs1 = this.skymaxs[1];
        for (int i = 0; i < 6; ++i) {
            skymins1[i] = 9999.0f;
            skymins0[i] = 9999.0f;
            skymaxs1[i] = -9999.0f;
            skymaxs0[i] = -9999.0f;
        }
    }

    void MakeSkyVec(float s, float t, int axis) {
        this.b[0] = s * 2300.0f;
        this.b[1] = t * 2300.0f;
        this.b[2] = 2300.0f;
        for (int j = 0; j < 3; ++j) {
            int k = this.st_to_vec[axis][j];
            this.v1[j] = k < 0 ? -this.b[-k - 1] : this.b[k - 1];
        }
        s = (s + 1.0f) * 0.5f;
        t = (t + 1.0f) * 0.5f;
        if (s < this.sky_min) {
            s = this.sky_min;
        } else if (s > this.sky_max) {
            s = this.sky_max;
        }
        if (t < this.sky_min) {
            t = this.sky_min;
        } else if (t > this.sky_max) {
            t = this.sky_max;
        }
        t = 1.0f - t;
        this.gl.glTexCoord2f(s, t);
        this.gl.glVertex3f(this.v1[0], this.v1[1], this.v1[2]);
    }

    void R_DrawSkyBox() {
        int i;
        if (this.skyrotate != 0.0f) {
            for (i = 0; !(i >= 6 || this.skymins[0][i] < this.skymaxs[0][i] && this.skymins[1][i] < this.skymaxs[1][i]); ++i) {
            }
            if (i == 6) {
                return;
            }
        }
        this.gl.glPushMatrix();
        this.gl.glTranslatef(this.r_origin[0], this.r_origin[1], this.r_origin[2]);
        this.gl.glRotatef(this.r_newrefdef.time * this.skyrotate, this.skyaxis[0], this.skyaxis[1], this.skyaxis[2]);
        for (i = 0; i < 6; ++i) {
            if (this.skyrotate != 0.0f) {
                this.skymins[0][i] = -1.0f;
                this.skymins[1][i] = -1.0f;
                this.skymaxs[0][i] = 1.0f;
                this.skymaxs[1][i] = 1.0f;
            }
            if (this.skymins[0][i] >= this.skymaxs[0][i] || this.skymins[1][i] >= this.skymaxs[1][i]) continue;
            this.GL_Bind(this.sky_images[this.skytexorder[i]].texnum);
            this.gl.glBegin(7);
            this.MakeSkyVec(this.skymins[0][i], this.skymins[1][i], i);
            this.MakeSkyVec(this.skymins[0][i], this.skymaxs[1][i], i);
            this.MakeSkyVec(this.skymaxs[0][i], this.skymaxs[1][i], i);
            this.MakeSkyVec(this.skymaxs[0][i], this.skymins[1][i], i);
            this.gl.glEnd();
        }
        this.gl.glPopMatrix();
    }

    public void R_SetSky(String name, float rotate, float[] axis) {
        if (!$assertionsDisabled && axis.length != 3) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        this.skyname = name;
        this.skyrotate = rotate;
        Math3D.VectorCopy(axis, this.skyaxis);
        for (int i = 0; i < 6; ++i) {
            if (this.gl_skymip.value != 0.0f || this.skyrotate != 0.0f) {
                this.gl_picmip.value += 1.0f;
            }
            String pathname = this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f ? "env/" + this.skyname + this.suf[i] + ".pcx" : "env/" + this.skyname + this.suf[i] + ".tga";
            this.sky_images[i] = this.GL_FindImage(pathname, 4);
            if (this.sky_images[i] == null) {
                this.sky_images[i] = this.r_notexture;
            }
            if (this.gl_skymip.value != 0.0f || this.skyrotate != 0.0f) {
                this.gl_picmip.value -= 1.0f;
                this.sky_min = 0.00390625f;
                this.sky_max = 0.99609375f;
                continue;
            }
            this.sky_min = 0.001953125f;
            this.sky_max = 0.9980469f;
        }
    }

    static {
        $assertionsDisabled = !Warp.class.desiredAssertionStatus();
        SIN = new float[]{0.0f, 0.19633f, 0.392541f, 0.588517f, 0.784137f, 0.979285f, 1.17384f, 1.3677f, 1.56072f, 1.75281f, 1.94384f, 2.1337f, 2.32228f, 2.50945f, 2.69512f, 2.87916f, 3.06147f, 3.24193f, 3.42044f, 3.59689f, 3.77117f, 3.94319f, 4.11282f, 4.27998f, 4.44456f, 4.60647f, 4.76559f, 4.92185f, 5.07515f, 5.22538f, 5.37247f, 5.51632f, 5.65685f, 5.79398f, 5.92761f, 6.05767f, 6.18408f, 6.30677f, 6.42566f, 6.54068f, 6.65176f, 6.75883f, 6.86183f, 6.9607f, 7.05537f, 7.14579f, 7.23191f, 7.31368f, 7.39104f, 7.46394f, 7.53235f, 7.59623f, 7.65552f, 7.71021f, 7.76025f, 7.80562f, 7.84628f, 7.88222f, 7.91341f, 7.93984f, 7.96148f, 7.97832f, 7.99036f, 7.99759f, 8.0f, 7.99759f, 7.99036f, 7.97832f, 7.96148f, 7.93984f, 7.91341f, 7.88222f, 7.84628f, 7.80562f, 7.76025f, 7.71021f, 7.65552f, 7.59623f, 7.53235f, 7.46394f, 7.39104f, 7.31368f, 7.23191f, 7.14579f, 7.05537f, 6.9607f, 6.86183f, 6.75883f, 6.65176f, 6.54068f, 6.42566f, 6.30677f, 6.18408f, 6.05767f, 5.92761f, 5.79398f, 5.65685f, 5.51632f, 5.37247f, 5.22538f, 5.07515f, 4.92185f, 4.76559f, 4.60647f, 4.44456f, 4.27998f, 4.11282f, 3.94319f, 3.77117f, 3.59689f, 3.42044f, 3.24193f, 3.06147f, 2.87916f, 2.69512f, 2.50945f, 2.32228f, 2.1337f, 1.94384f, 1.75281f, 1.56072f, 1.3677f, 1.17384f, 0.979285f, 0.784137f, 0.588517f, 0.392541f, 0.19633f, 9.79717E-16f, -0.19633f, -0.392541f, -0.588517f, -0.784137f, -0.979285f, -1.17384f, -1.3677f, -1.56072f, -1.75281f, -1.94384f, -2.1337f, -2.32228f, -2.50945f, -2.69512f, -2.87916f, -3.06147f, -3.24193f, -3.42044f, -3.59689f, -3.77117f, -3.94319f, -4.11282f, -4.27998f, -4.44456f, -4.60647f, -4.76559f, -4.92185f, -5.07515f, -5.22538f, -5.37247f, -5.51632f, -5.65685f, -5.79398f, -5.92761f, -6.05767f, -6.18408f, -6.30677f, -6.42566f, -6.54068f, -6.65176f, -6.75883f, -6.86183f, -6.9607f, -7.05537f, -7.14579f, -7.23191f, -7.31368f, -7.39104f, -7.46394f, -7.53235f, -7.59623f, -7.65552f, -7.71021f, -7.76025f, -7.80562f, -7.84628f, -7.88222f, -7.91341f, -7.93984f, -7.96148f, -7.97832f, -7.99036f, -7.99759f, -8.0f, -7.99759f, -7.99036f, -7.97832f, -7.96148f, -7.93984f, -7.91341f, -7.88222f, -7.84628f, -7.80562f, -7.76025f, -7.71021f, -7.65552f, -7.59623f, -7.53235f, -7.46394f, -7.39104f, -7.31368f, -7.23191f, -7.14579f, -7.05537f, -6.9607f, -6.86183f, -6.75883f, -6.65176f, -6.54068f, -6.42566f, -6.30677f, -6.18408f, -6.05767f, -5.92761f, -5.79398f, -5.65685f, -5.51632f, -5.37247f, -5.22538f, -5.07515f, -4.92185f, -4.76559f, -4.60647f, -4.44456f, -4.27998f, -4.11282f, -3.94319f, -3.77117f, -3.59689f, -3.42044f, -3.24193f, -3.06147f, -2.87916f, -2.69512f, -2.50945f, -2.32228f, -2.1337f, -1.94384f, -1.75281f, -1.56072f, -1.3677f, -1.17384f, -0.979285f, -0.784137f, -0.588517f, -0.392541f, -0.19633f};
    }
}

