/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.client.dlight_t;
import jake2.client.entity_t;
import jake2.client.lightstyle_t;
import jake2.game.cplane_t;
import jake2.qcommon.Com;
import jake2.render.fast.Draw;
import jake2.render.fast.Image;
import jake2.render.fast.Polygon;
import jake2.render.glpoly_t;
import jake2.render.image_t;
import jake2.render.medge_t;
import jake2.render.mleaf_t;
import jake2.render.mnode_t;
import jake2.render.model_t;
import jake2.render.msurface_t;
import jake2.render.mtexinfo_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Vector;

public abstract class Surf
extends Draw {
    float[] modelorg = new float[]{0.0f, 0.0f, 0.0f};
    msurface_t r_alpha_surfaces;
    static final int DYNAMIC_LIGHT_WIDTH = 128;
    static final int DYNAMIC_LIGHT_HEIGHT = 128;
    static final int LIGHTMAP_BYTES = 4;
    static final int BLOCK_WIDTH = 128;
    static final int BLOCK_HEIGHT = 128;
    static final int MAX_LIGHTMAPS = 128;
    int c_visible_lightmaps;
    int c_visible_textures;
    static final int GL_LIGHTMAP_FORMAT = 6408;
    gllightmapstate_t gl_lms = new gllightmapstate_t();
    Vector polys = new Vector();
    private final IntBuffer temp2 = Lib.newIntBuffer(1156, ByteOrder.LITTLE_ENDIAN);
    private final IntBuffer temp = Lib.newIntBuffer(16384, ByteOrder.LITTLE_ENDIAN);
    private final float[] mins = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] org = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] forward = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] right = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] up = new float[]{0.0f, 0.0f, 0.0f};
    private final entity_t worldEntity = new entity_t();
    final byte[] fatvis = new byte[8192];
    lightstyle_t[] lightstyles;
    private final IntBuffer dummy = Lib.newIntBuffer(16384);
    static FloatBuffer globalPolygonInterleavedBuf = Polygon.getInterleavedBuffer();
    static FloatBuffer globalPolygonTexCoord1Buf = null;

    abstract byte[] Mod_ClusterPVS(int var1, model_t var2);

    abstract void R_DrawSkyBox();

    abstract void R_AddSkySurface(msurface_t var1);

    abstract void R_ClearSkyBox();

    abstract void EmitWaterPolys(msurface_t var1);

    abstract void R_MarkLights(dlight_t var1, int var2, mnode_t var3);

    abstract void R_SetCacheState(msurface_t var1);

    abstract void R_BuildLightMap(msurface_t var1, IntBuffer var2, int var3);

    image_t R_TextureAnimation(mtexinfo_t tex) {
        if (tex.next == null) {
            return tex.image;
        }
        for (int c = this.currententity.frame % tex.numframes; c != 0; --c) {
            tex = tex.next;
        }
        return tex.image;
    }

    void DrawGLPoly(glpoly_t p) {
        this.gl.glDrawArrays(9, p.pos, p.numverts);
    }

    void DrawGLFlowingPoly(glpoly_t p) {
        float scroll = -64.0f * (this.r_newrefdef.time / 40.0f - (float)((int)(this.r_newrefdef.time / 40.0f)));
        if (scroll == 0.0f) {
            scroll = -64.0f;
        }
        p.beginScrolling(scroll);
        this.gl.glDrawArrays(9, p.pos, p.numverts);
        p.endScrolling();
    }

    void drawPolyLines(glpoly_t p) {
        for (int j = 2; j < p.numverts; ++j) {
            this.gl.glBegin(3);
            this.gl.glVertex3f(p.x(0), p.y(0), p.z(0));
            this.gl.glVertex3f(p.x(j - 1), p.y(j - 1), p.z(j - 1));
            this.gl.glVertex3f(p.x(j), p.y(j), p.z(j));
            this.gl.glVertex3f(p.x(0), p.y(0), p.z(0));
            this.gl.glEnd();
        }
    }

    void R_DrawTriangleOutlines() {
        if (this.gl_showtris.value == 0.0f) {
            return;
        }
        this.gl.glDisable(3553);
        this.gl.glPushMatrix();
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        for (int n = this.polys.size() - 1; n >= 0; --n) {
            glpoly_t p = (glpoly_t)this.polys.elementAt(n);
            this.drawPolyLines(p);
        }
        this.gl.glPopMatrix();
        this.gl.glEnable(2929);
        this.gl.glEnable(3553);
    }

    void R_RenderBrushPoly(msurface_t fa) {
        int maps;
        ++this.c_brush_polys;
        image_t image = this.R_TextureAnimation(fa.texinfo);
        if ((fa.flags & 0x10) != 0) {
            this.GL_Bind(image.texnum);
            this.GL_TexEnv(8448);
            this.gl.glColor4f(this.gl_state.inverse_intensity, this.gl_state.inverse_intensity, this.gl_state.inverse_intensity, 1.0f);
            this.EmitWaterPolys(fa);
            this.GL_TexEnv(7681);
            return;
        }
        this.GL_Bind(image.texnum);
        this.GL_TexEnv(7681);
        if ((fa.texinfo.flags & 0x40) != 0) {
            this.DrawGLFlowingPoly(fa.polys);
        } else {
            this.DrawGLPoly(fa.polys);
        }
        boolean gotoDynamic = false;
        for (maps = 0; maps < 4 && fa.styles[maps] != -1; ++maps) {
            if (this.r_newrefdef.lightstyles[fa.styles[maps] & 0xFF].white == fa.cached_light[maps]) continue;
            gotoDynamic = true;
            break;
        }
        if (maps == 4) {
            --maps;
        }
        boolean is_dynamic = false;
        if ((gotoDynamic || fa.dlightframe == this.r_framecount) && this.gl_dynamic.value != 0.0f && (fa.texinfo.flags & 0x3C) == 0) {
            is_dynamic = true;
        }
        if (is_dynamic) {
            if (((fa.styles[maps] & 0xFF) >= 32 || fa.styles[maps] == 0) && fa.dlightframe != this.r_framecount) {
                int smax = (fa.extents[0] >> 4) + 1;
                int tmax = (fa.extents[1] >> 4) + 1;
                this.R_BuildLightMap(fa, this.temp2, smax);
                this.R_SetCacheState(fa);
                this.GL_Bind(this.gl_state.lightmap_textures + fa.lightmaptexturenum);
                this.gl.glTexSubImage2D(3553, 0, fa.light_s, fa.light_t, smax, tmax, 6408, 5121, this.temp2);
                fa.lightmapchain = this.gl_lms.lightmap_surfaces[fa.lightmaptexturenum];
                this.gl_lms.lightmap_surfaces[fa.lightmaptexturenum] = fa;
            } else {
                fa.lightmapchain = this.gl_lms.lightmap_surfaces[0];
                this.gl_lms.lightmap_surfaces[0] = fa;
            }
        } else {
            fa.lightmapchain = this.gl_lms.lightmap_surfaces[fa.lightmaptexturenum];
            this.gl_lms.lightmap_surfaces[fa.lightmaptexturenum] = fa;
        }
    }

    void R_DrawAlphaSurfaces() {
        this.r_world_matrix.clear();
        this.gl.glLoadMatrix(this.r_world_matrix);
        this.gl.glEnable(3042);
        this.GL_TexEnv(8448);
        float intens = this.gl_state.inverse_intensity;
        this.gl.glInterleavedArrays(10791, 28, globalPolygonInterleavedBuf);
        msurface_t s = this.r_alpha_surfaces;
        while (s != null) {
            this.GL_Bind(s.texinfo.image.texnum);
            ++this.c_brush_polys;
            if ((s.texinfo.flags & 0x10) != 0) {
                this.gl.glColor4f(intens, intens, intens, 0.33f);
            } else if ((s.texinfo.flags & 0x20) != 0) {
                this.gl.glColor4f(intens, intens, intens, 0.66f);
            } else {
                this.gl.glColor4f(intens, intens, intens, 1.0f);
            }
            if ((s.flags & 0x10) != 0) {
                this.EmitWaterPolys(s);
            } else if ((s.texinfo.flags & 0x40) != 0) {
                this.DrawGLFlowingPoly(s.polys);
            } else {
                this.DrawGLPoly(s.polys);
            }
            s = s.texturechain;
        }
        this.GL_TexEnv(7681);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.gl.glDisable(3042);
        this.r_alpha_surfaces = null;
    }

    void DrawTextureChains() {
        msurface_t s;
        image_t image;
        int i;
        this.c_visible_textures = 0;
        for (i = 0; i < this.numgltextures; ++i) {
            image = this.gltextures[i];
            if (image.registration_sequence == 0 || image.texturechain == null) continue;
            ++this.c_visible_textures;
            s = image.texturechain;
            while (s != null) {
                if ((s.flags & 0x10) == 0) {
                    this.R_RenderBrushPoly(s);
                }
                s = s.texturechain;
            }
        }
        this.GL_EnableMultitexture(false);
        for (i = 0; i < this.numgltextures; ++i) {
            image = this.gltextures[i];
            if (image.registration_sequence == 0 || (s = image.texturechain) == null) continue;
            while (s != null) {
                if ((s.flags & 0x10) != 0) {
                    this.R_RenderBrushPoly(s);
                }
                s = s.texturechain;
            }
            image.texturechain = null;
        }
        this.GL_TexEnv(7681);
    }

    void GL_RenderLightmappedPoly(msurface_t surf) {
        int map;
        boolean gotoDynamic = false;
        for (map = 0; map < 4 && surf.styles[map] != -1; ++map) {
            if (this.r_newrefdef.lightstyles[surf.styles[map] & 0xFF].white == surf.cached_light[map]) continue;
            gotoDynamic = true;
            break;
        }
        if (map == 4) {
            --map;
        }
        boolean is_dynamic = false;
        if ((gotoDynamic || surf.dlightframe == this.r_framecount) && this.gl_dynamic.value != 0.0f && (surf.texinfo.flags & 0x3C) == 0) {
            is_dynamic = true;
        }
        image_t image = this.R_TextureAnimation(surf.texinfo);
        int lmtex = surf.lightmaptexturenum;
        if (is_dynamic) {
            int tmax;
            int smax;
            if (((surf.styles[map] & 0xFF) >= 32 || surf.styles[map] == 0) && surf.dlightframe != this.r_framecount) {
                smax = (surf.extents[0] >> 4) + 1;
                tmax = (surf.extents[1] >> 4) + 1;
                this.R_BuildLightMap(surf, this.temp, smax);
                this.R_SetCacheState(surf);
                this.GL_MBind(this.TEXTURE1, this.gl_state.lightmap_textures + surf.lightmaptexturenum);
                lmtex = surf.lightmaptexturenum;
                this.gl.glTexSubImage2D(3553, 0, surf.light_s, surf.light_t, smax, tmax, 6408, 5121, this.temp);
            } else {
                smax = (surf.extents[0] >> 4) + 1;
                tmax = (surf.extents[1] >> 4) + 1;
                this.R_BuildLightMap(surf, this.temp, smax);
                this.GL_MBind(this.TEXTURE1, this.gl_state.lightmap_textures + 0);
                lmtex = 0;
                this.gl.glTexSubImage2D(3553, 0, surf.light_s, surf.light_t, smax, tmax, 6408, 5121, this.temp);
            }
            ++this.c_brush_polys;
            this.GL_MBind(this.TEXTURE0, image.texnum);
            this.GL_MBind(this.TEXTURE1, this.gl_state.lightmap_textures + lmtex);
            if ((surf.texinfo.flags & 0x40) != 0) {
                float scroll = -64.0f * (this.r_newrefdef.time / 40.0f - (float)((int)(this.r_newrefdef.time / 40.0f)));
                if (scroll == 0.0f) {
                    scroll = -64.0f;
                }
                glpoly_t p = surf.polys;
                while (p != null) {
                    if (this.gl_showtris.value != 0.0f) {
                        this.polys.add(p);
                    }
                    p.beginScrolling(scroll);
                    this.gl.glDrawArrays(9, p.pos, p.numverts);
                    p.endScrolling();
                    p = p.chain;
                }
            } else {
                glpoly_t p = surf.polys;
                while (p != null) {
                    if (this.gl_showtris.value != 0.0f) {
                        this.polys.add(p);
                    }
                    this.gl.glDrawArrays(9, p.pos, p.numverts);
                    p = p.chain;
                }
            }
        } else {
            ++this.c_brush_polys;
            this.GL_MBind(this.TEXTURE0, image.texnum);
            this.GL_MBind(this.TEXTURE1, this.gl_state.lightmap_textures + lmtex);
            if ((surf.texinfo.flags & 0x40) != 0) {
                float scroll = -64.0f * (this.r_newrefdef.time / 40.0f - (float)((int)(this.r_newrefdef.time / 40.0f)));
                if ((double)scroll == 0.0) {
                    scroll = -64.0f;
                }
                glpoly_t p = surf.polys;
                while (p != null) {
                    if (this.gl_showtris.value != 0.0f) {
                        this.polys.add(p);
                    }
                    p.beginScrolling(scroll);
                    this.gl.glDrawArrays(9, p.pos, p.numverts);
                    p.endScrolling();
                    p = p.chain;
                }
            } else {
                glpoly_t p = surf.polys;
                while (p != null) {
                    if (this.gl_showtris.value != 0.0f) {
                        this.polys.add(p);
                    }
                    this.gl.glDrawArrays(9, p.pos, p.numverts);
                    p = p.chain;
                }
            }
        }
    }

    void R_DrawInlineBModel() {
        if (this.gl_flashblend.value == 0.0f) {
            for (int k = 0; k < this.r_newrefdef.num_dlights; ++k) {
                dlight_t lt = this.r_newrefdef.dlights[k];
                this.R_MarkLights(lt, 1 << k, this.currentmodel.nodes[this.currentmodel.firstnode]);
            }
        }
        int psurfp = this.currentmodel.firstmodelsurface;
        msurface_t[] surfaces = this.currentmodel.surfaces;
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glEnable(3042);
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.25f);
            this.GL_TexEnv(8448);
        }
        for (int i = 0; i < this.currentmodel.nummodelsurfaces; ++i) {
            msurface_t psurf = surfaces[psurfp++];
            cplane_t pplane = psurf.plane;
            float dot = Math3D.DotProduct(this.modelorg, pplane.normal) - pplane.dist;
            if (!((psurf.flags & 2) != 0 && dot < -0.01f) && ((psurf.flags & 2) != 0 || !(dot > 0.01f))) continue;
            if ((psurf.texinfo.flags & 0x30) != 0) {
                psurf.texturechain = this.r_alpha_surfaces;
                this.r_alpha_surfaces = psurf;
                continue;
            }
            if ((psurf.flags & 0x10) == 0) {
                this.GL_RenderLightmappedPoly(psurf);
                continue;
            }
            this.GL_EnableMultitexture(false);
            this.R_RenderBrushPoly(psurf);
            this.GL_EnableMultitexture(true);
        }
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glDisable(3042);
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.GL_TexEnv(7681);
        }
    }

    void R_DrawBrushModel(entity_t e) {
        boolean rotated;
        if (this.currentmodel.nummodelsurfaces == 0) {
            return;
        }
        this.currententity = e;
        this.gl_state.currenttextures[1] = -1;
        this.gl_state.currenttextures[0] = -1;
        if (e.angles[0] != 0.0f || e.angles[1] != 0.0f || e.angles[2] != 0.0f) {
            rotated = true;
            for (int i = 0; i < 3; ++i) {
                this.mins[i] = e.origin[i] - this.currentmodel.radius;
                this.maxs[i] = e.origin[i] + this.currentmodel.radius;
            }
        } else {
            rotated = false;
            Math3D.VectorAdd(e.origin, this.currentmodel.mins, this.mins);
            Math3D.VectorAdd(e.origin, this.currentmodel.maxs, this.maxs);
        }
        if (this.R_CullBox(this.mins, this.maxs)) {
            return;
        }
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        Math3D.VectorSubtract(this.r_newrefdef.vieworg, e.origin, this.modelorg);
        if (rotated) {
            Math3D.VectorCopy(this.modelorg, this.org);
            Math3D.AngleVectors(e.angles, this.forward, this.right, this.up);
            this.modelorg[0] = Math3D.DotProduct(this.org, this.forward);
            this.modelorg[1] = -Math3D.DotProduct(this.org, this.right);
            this.modelorg[2] = Math3D.DotProduct(this.org, this.up);
        }
        this.gl.glPushMatrix();
        e.angles[0] = -e.angles[0];
        e.angles[2] = -e.angles[2];
        this.R_RotateForEntity(e);
        e.angles[0] = -e.angles[0];
        e.angles[2] = -e.angles[2];
        this.GL_EnableMultitexture(true);
        this.GL_SelectTexture(this.TEXTURE0);
        this.GL_TexEnv(7681);
        this.gl.glInterleavedArrays(10791, 28, globalPolygonInterleavedBuf);
        this.GL_SelectTexture(this.TEXTURE1);
        this.GL_TexEnv(8448);
        this.gl.glTexCoordPointer(2, 28, globalPolygonTexCoord1Buf);
        this.gl.glEnableClientState(32888);
        this.R_DrawInlineBModel();
        this.gl.glClientActiveTextureARB(this.TEXTURE1);
        this.gl.glDisableClientState(32888);
        this.GL_EnableMultitexture(false);
        this.gl.glPopMatrix();
    }

    void R_RecursiveWorldNode(mnode_t node) {
        int sidebit;
        int side;
        float dot;
        if (node.contents == 1) {
            return;
        }
        if (node.visframe != this.r_visframecount) {
            return;
        }
        if (this.R_CullBox(node.mins, node.maxs)) {
            return;
        }
        if (node.contents != -1) {
            mleaf_t pleaf = (mleaf_t)node;
            if (this.r_newrefdef.areabits != null && (this.r_newrefdef.areabits[pleaf.area >> 3] & 0xFF & 1 << (pleaf.area & 7)) == 0) {
                return;
            }
            int markp = 0;
            msurface_t mark = pleaf.getMarkSurface(markp);
            int c = pleaf.nummarksurfaces;
            if (c != 0) {
                do {
                    mark.visframe = this.r_framecount;
                    mark = pleaf.getMarkSurface(++markp);
                } while (--c != 0);
            }
            return;
        }
        cplane_t plane = node.plane;
        switch (plane.type) {
            case 0: {
                dot = this.modelorg[0] - plane.dist;
                break;
            }
            case 1: {
                dot = this.modelorg[1] - plane.dist;
                break;
            }
            case 2: {
                dot = this.modelorg[2] - plane.dist;
                break;
            }
            default: {
                dot = Math3D.DotProduct(this.modelorg, plane.normal) - plane.dist;
            }
        }
        if (dot >= 0.0f) {
            side = 0;
            sidebit = 0;
        } else {
            side = 1;
            sidebit = 2;
        }
        this.R_RecursiveWorldNode(node.children[side]);
        for (int c = 0; c < node.numsurfaces; ++c) {
            msurface_t surf = Surf.r_worldmodel.surfaces[node.firstsurface + c];
            if (surf.visframe != this.r_framecount || (surf.flags & 2) != sidebit) continue;
            if ((surf.texinfo.flags & 4) != 0) {
                this.R_AddSkySurface(surf);
                continue;
            }
            if ((surf.texinfo.flags & 0x30) != 0) {
                surf.texturechain = this.r_alpha_surfaces;
                this.r_alpha_surfaces = surf;
                continue;
            }
            if ((surf.flags & 0x10) == 0) {
                this.GL_RenderLightmappedPoly(surf);
                continue;
            }
            image_t image = this.R_TextureAnimation(surf.texinfo);
            surf.texturechain = image.texturechain;
            image.texturechain = surf;
        }
        this.R_RecursiveWorldNode(node.children[1 - side]);
    }

    void R_DrawWorld() {
        if (this.r_drawworld.value == 0.0f) {
            return;
        }
        if ((this.r_newrefdef.rdflags & 2) != 0) {
            return;
        }
        this.currentmodel = r_worldmodel;
        Math3D.VectorCopy(this.r_newrefdef.vieworg, this.modelorg);
        entity_t ent = this.worldEntity;
        ent.clear();
        ent.frame = (int)(this.r_newrefdef.time * 2.0f);
        this.currententity = ent;
        this.gl_state.currenttextures[1] = -1;
        this.gl_state.currenttextures[0] = -1;
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        this.R_ClearSkyBox();
        this.GL_EnableMultitexture(true);
        this.GL_SelectTexture(this.TEXTURE0);
        this.GL_TexEnv(7681);
        this.gl.glInterleavedArrays(10791, 28, globalPolygonInterleavedBuf);
        this.GL_SelectTexture(this.TEXTURE1);
        this.gl.glTexCoordPointer(2, 28, globalPolygonTexCoord1Buf);
        this.gl.glEnableClientState(32888);
        if (this.gl_lightmap.value != 0.0f) {
            this.GL_TexEnv(7681);
        } else {
            this.GL_TexEnv(8448);
        }
        this.R_RecursiveWorldNode(Surf.r_worldmodel.nodes[0]);
        this.gl.glClientActiveTextureARB(this.TEXTURE1);
        this.gl.glDisableClientState(32888);
        this.GL_EnableMultitexture(false);
        this.DrawTextureChains();
        this.R_DrawSkyBox();
        this.R_DrawTriangleOutlines();
        if (this.gl_showtrisnum.value != 0.0f && this.gl_showtris.value != 0.0f) {
            Com.DPrintf("num triangles: " + this.polys.size() + "\n");
        }
        this.polys = new Vector();
    }

    void R_MarkLeaves() {
        if (this.r_oldviewcluster == r_viewcluster && this.r_oldviewcluster2 == this.r_viewcluster2 && this.r_novis.value == 0.0f && r_viewcluster != -1) {
            return;
        }
        if (this.gl_lockpvs.value != 0.0f) {
            return;
        }
        ++this.r_visframecount;
        this.r_oldviewcluster = r_viewcluster;
        this.r_oldviewcluster2 = this.r_viewcluster2;
        if (this.r_novis.value != 0.0f || r_viewcluster == -1 || Surf.r_worldmodel.vis == null) {
            int i;
            for (i = 0; i < Surf.r_worldmodel.numleafs; ++i) {
                Surf.r_worldmodel.leafs[i].visframe = this.r_visframecount;
            }
            for (i = 0; i < Surf.r_worldmodel.numnodes; ++i) {
                Surf.r_worldmodel.nodes[i].visframe = this.r_visframecount;
            }
            return;
        }
        byte[] vis = this.Mod_ClusterPVS(r_viewcluster, r_worldmodel);
        if (this.r_viewcluster2 != r_viewcluster) {
            System.arraycopy(vis, 0, this.fatvis, 0, Surf.r_worldmodel.numleafs + 7 >> 3);
            vis = this.Mod_ClusterPVS(this.r_viewcluster2, r_worldmodel);
            int c = Surf.r_worldmodel.numleafs + 31 >> 5;
            c <<= 2;
            for (int k = 0; k < c; k += 4) {
                int n = k;
                this.fatvis[n] = (byte)(this.fatvis[n] | vis[k]);
                int n2 = k + 1;
                this.fatvis[n2] = (byte)(this.fatvis[n2] | vis[k + 1]);
                int n3 = k + 2;
                this.fatvis[n3] = (byte)(this.fatvis[n3] | vis[k + 2]);
                int n4 = k + 3;
                this.fatvis[n4] = (byte)(this.fatvis[n4] | vis[k + 3]);
            }
            vis = this.fatvis;
        }
        for (int i = 0; i < Surf.r_worldmodel.numleafs; ++i) {
            mleaf_t leaf = Surf.r_worldmodel.leafs[i];
            int cluster = leaf.cluster;
            if (cluster == -1 || (vis[cluster >> 3] & 0xFF & 1 << (cluster & 7)) == 0) continue;
            mnode_t node = leaf;
            while (node.visframe != this.r_visframecount) {
                node.visframe = this.r_visframecount;
                node = node.parent;
                if (node != null) continue;
            }
        }
    }

    void LM_InitBlock() {
        Arrays.fill(this.gl_lms.allocated, 0);
    }

    void LM_UploadBlock(boolean dynamic) {
        int texture = dynamic ? 0 : this.gl_lms.current_lightmap_texture;
        this.GL_Bind(this.gl_state.lightmap_textures + texture);
        this.gl.glTexParameterf(3553, 10241, 9729.0f);
        this.gl.glTexParameterf(3553, 10240, 9729.0f);
        this.gl_lms.lightmap_buffer.rewind();
        if (dynamic) {
            int height = 0;
            for (int i = 0; i < 128; ++i) {
                if (this.gl_lms.allocated[i] <= height) continue;
                height = this.gl_lms.allocated[i];
            }
            this.gl.glTexSubImage2D(3553, 0, 0, 0, 128, height, 6408, 5121, this.gl_lms.lightmap_buffer);
        } else {
            this.gl.glTexImage2D(3553, 0, this.gl_lms.internal_format, 128, 128, 0, 6408, 5121, this.gl_lms.lightmap_buffer);
            if (++this.gl_lms.current_lightmap_texture == 128) {
                Com.Error(1, "LM_UploadBlock() - MAX_LIGHTMAPS exceeded\n");
            }
        }
    }

    boolean LM_AllocBlock(int w, int h, Image.pos_t pos) {
        int i;
        int best = 128;
        int x = pos.x;
        for (i = 0; i < 128 - w; ++i) {
            int j;
            int best2 = 0;
            for (j = 0; j < w && this.gl_lms.allocated[i + j] < best; ++j) {
                if (this.gl_lms.allocated[i + j] <= best2) continue;
                best2 = this.gl_lms.allocated[i + j];
            }
            if (j != w) continue;
            pos.x = x = i;
            pos.y = best = best2;
        }
        if (best + h > 128) {
            return false;
        }
        for (i = 0; i < w; ++i) {
            this.gl_lms.allocated[x + i] = best + h;
        }
        return true;
    }

    void GL_BuildPolygonFromSurface(msurface_t fa) {
        medge_t[] pedges = this.currentmodel.edges;
        int lnumverts = fa.numedges;
        glpoly_t poly = Polygon.create(lnumverts);
        poly.next = fa.polys;
        poly.flags = fa.flags;
        fa.polys = poly;
        for (int i = 0; i < lnumverts; ++i) {
            float[] vec;
            medge_t r_pedge;
            int lindex = this.currentmodel.surfedges[fa.firstedge + i];
            if (lindex > 0) {
                r_pedge = pedges[lindex];
                vec = this.currentmodel.vertexes[r_pedge.v[0]].position;
            } else {
                r_pedge = pedges[-lindex];
                vec = this.currentmodel.vertexes[r_pedge.v[1]].position;
            }
            float s = Math3D.DotProduct(vec, fa.texinfo.vecs[0]) + fa.texinfo.vecs[0][3];
            float t = Math3D.DotProduct(vec, fa.texinfo.vecs[1]) + fa.texinfo.vecs[1][3];
            poly.x(i, vec[0]);
            poly.y(i, vec[1]);
            poly.z(i, vec[2]);
            poly.s1(i, s /= (float)fa.texinfo.image.width);
            poly.t1(i, t /= (float)fa.texinfo.image.height);
            s = Math3D.DotProduct(vec, fa.texinfo.vecs[0]) + fa.texinfo.vecs[0][3];
            s -= (float)fa.texturemins[0];
            s += (float)(fa.light_s * 16);
            s += 8.0f;
            t = Math3D.DotProduct(vec, fa.texinfo.vecs[1]) + fa.texinfo.vecs[1][3];
            t -= (float)fa.texturemins[1];
            t += (float)(fa.light_t * 16);
            t += 8.0f;
            poly.s2(i, s /= 2048.0f);
            poly.t2(i, t /= 2048.0f);
        }
    }

    void GL_CreateSurfaceLightmap(msurface_t surf) {
        if ((surf.flags & 0x14) != 0) {
            return;
        }
        int smax = (surf.extents[0] >> 4) + 1;
        int tmax = (surf.extents[1] >> 4) + 1;
        Image.pos_t lightPos = new Image.pos_t(surf.light_s, surf.light_t);
        if (!this.LM_AllocBlock(smax, tmax, lightPos)) {
            this.LM_UploadBlock(false);
            this.LM_InitBlock();
            lightPos = new Image.pos_t(surf.light_s, surf.light_t);
            if (!this.LM_AllocBlock(smax, tmax, lightPos)) {
                Com.Error(0, "Consecutive calls to LM_AllocBlock(" + smax + "," + tmax + ") failed\n");
            }
        }
        surf.light_s = lightPos.x;
        surf.light_t = lightPos.y;
        surf.lightmaptexturenum = this.gl_lms.current_lightmap_texture;
        IntBuffer base = this.gl_lms.lightmap_buffer;
        base.position(surf.light_t * 128 + surf.light_s);
        this.R_SetCacheState(surf);
        this.R_BuildLightMap(surf, base.slice(), 128);
    }

    void GL_BeginBuildingLightmaps(model_t m) {
        int i;
        if (this.lightstyles == null) {
            this.lightstyles = new lightstyle_t[256];
            for (i = 0; i < this.lightstyles.length; ++i) {
                this.lightstyles[i] = new lightstyle_t();
            }
        }
        Arrays.fill(this.gl_lms.allocated, 0);
        this.r_framecount = 1;
        this.GL_EnableMultitexture(true);
        this.GL_SelectTexture(this.TEXTURE1);
        for (i = 0; i < 256; ++i) {
            this.lightstyles[i].rgb[0] = 1.0f;
            this.lightstyles[i].rgb[1] = 1.0f;
            this.lightstyles[i].rgb[2] = 1.0f;
            this.lightstyles[i].white = 3.0f;
        }
        this.r_newrefdef.lightstyles = this.lightstyles;
        if (this.gl_state.lightmap_textures == 0) {
            this.gl_state.lightmap_textures = 1024;
        }
        this.gl_lms.current_lightmap_texture = 1;
        char format = this.gl_monolightmap.string.toUpperCase().charAt(0);
        this.gl_lms.internal_format = format == 'A' ? this.gl_tex_alpha_format : (format == 'C' ? this.gl_tex_alpha_format : (format == 'I' ? 32843 : (format == 'L' ? 32832 : this.gl_tex_solid_format)));
        this.GL_Bind(this.gl_state.lightmap_textures + 0);
        this.gl.glTexParameterf(3553, 10241, 9729.0f);
        this.gl.glTexParameterf(3553, 10240, 9729.0f);
        this.gl.glTexImage2D(3553, 0, this.gl_lms.internal_format, 128, 128, 0, 6408, 5121, this.dummy);
    }

    void GL_EndBuildingLightmaps() {
        this.LM_UploadBlock(false);
        this.GL_EnableMultitexture(false);
    }

    static {
        globalPolygonInterleavedBuf.position(5);
        globalPolygonTexCoord1Buf = globalPolygonInterleavedBuf.slice();
        globalPolygonInterleavedBuf.position(0);
    }

    static class gllightmapstate_t {
        int internal_format;
        int current_lightmap_texture;
        msurface_t[] lightmap_surfaces = new msurface_t[128];
        int[] allocated = new int[128];
        IntBuffer lightmap_buffer = Lib.newIntBuffer(16384, ByteOrder.LITTLE_ENDIAN);

        public gllightmapstate_t() {
            for (int i = 0; i < 128; ++i) {
                this.lightmap_surfaces[i] = new msurface_t();
            }
        }

        public void clearLightmapSurfaces() {
            for (int i = 0; i < 128; ++i) {
                this.lightmap_surfaces[i] = new msurface_t();
            }
        }
    }
}

