/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.render.glpoly_t;
import jake2.util.Lib;
import java.nio.FloatBuffer;

public final class Polygon
extends glpoly_t {
    private static final int MAX_POLYS = 20000;
    private static final int MAX_BUFFER_VERTICES = 120000;
    private static float[] s1_old = new float[64];
    private static FloatBuffer buffer = Lib.newFloatBuffer(840000);
    private static int bufferIndex = 0;
    private static int polyCount = 0;
    private static Polygon[] polyCache = new Polygon[20000];

    static glpoly_t create(int numverts) {
        Polygon poly = polyCache[polyCount++];
        poly.clear();
        poly.numverts = numverts;
        poly.pos = bufferIndex;
        bufferIndex += numverts;
        return poly;
    }

    static void reset() {
        polyCount = 0;
        bufferIndex = 0;
    }

    static FloatBuffer getInterleavedBuffer() {
        return (FloatBuffer)buffer.rewind();
    }

    private Polygon() {
    }

    private final void clear() {
        this.next = null;
        this.chain = null;
        this.numverts = 0;
        this.flags = 0;
    }

    public final float s1(int index) {
        return buffer.get((index + this.pos) * 7);
    }

    public final void s1(int index, float value) {
        buffer.put((index + this.pos) * 7, value);
    }

    public final float t1(int index) {
        return buffer.get((index + this.pos) * 7 + 1);
    }

    public final void t1(int index, float value) {
        buffer.put((index + this.pos) * 7 + 1, value);
    }

    public final float x(int index) {
        return buffer.get((index + this.pos) * 7 + 2);
    }

    public final void x(int index, float value) {
        buffer.put((index + this.pos) * 7 + 2, value);
    }

    public final float y(int index) {
        return buffer.get((index + this.pos) * 7 + 3);
    }

    public final void y(int index, float value) {
        buffer.put((index + this.pos) * 7 + 3, value);
    }

    public final float z(int index) {
        return buffer.get((index + this.pos) * 7 + 4);
    }

    public final void z(int index, float value) {
        buffer.put((index + this.pos) * 7 + 4, value);
    }

    public final float s2(int index) {
        return buffer.get((index + this.pos) * 7 + 5);
    }

    public final void s2(int index, float value) {
        buffer.put((index + this.pos) * 7 + 5, value);
    }

    public final float t2(int index) {
        return buffer.get((index + this.pos) * 7 + 6);
    }

    public final void t2(int index, float value) {
        buffer.put((index + this.pos) * 7 + 6, value);
    }

    public final void beginScrolling(float scroll) {
        int index = this.pos * 7;
        int i = 0;
        while (i < this.numverts) {
            Polygon.s1_old[i] = buffer.get(index);
            buffer.put(index, scroll += Polygon.s1_old[i]);
            ++i;
            index += 7;
        }
    }

    public final void endScrolling() {
        int index = this.pos * 7;
        int i = 0;
        while (i < this.numverts) {
            buffer.put(index, s1_old[i]);
            ++i;
            index += 7;
        }
    }

    static {
        for (int i = 0; i < polyCache.length; ++i) {
            Polygon.polyCache[i] = new Polygon();
        }
    }
}

