/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.client.VID;
import jake2.game.cplane_t;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.lump_t;
import jake2.qcommon.qfiles;
import jake2.qcommon.texinfo_t;
import jake2.render.fast.Polygon;
import jake2.render.fast.Surf;
import jake2.render.medge_t;
import jake2.render.mleaf_t;
import jake2.render.mmodel_t;
import jake2.render.mnode_t;
import jake2.render.model_t;
import jake2.render.msurface_t;
import jake2.render.mtexinfo_t;
import jake2.render.mvertex_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import jake2.util.Vargs;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Vector;

public abstract class Model
extends Surf {
    model_t loadmodel;
    int modfilelen;
    byte[] mod_novis = new byte[8192];
    static final int MAX_MOD_KNOWN = 512;
    model_t[] mod_known = new model_t[512];
    int mod_numknown;
    model_t[] mod_inline = new model_t[512];
    byte[] decompressed = new byte[8192];
    byte[] model_visibility = new byte[0x100000];
    byte[] fileBuffer;
    byte[] mod_base;
    static final int MODEL_BUFFER_SIZE = 50000;
    static FloatBuffer globalModelTextureCoordBuf = Lib.newFloatBuffer(100000);
    static IntBuffer globalModelVertexIndexBuf = Lib.newIntBuffer(50000);

    abstract void GL_SubdivideSurface(msurface_t var1);

    mleaf_t Mod_PointInLeaf(float[] p, model_t model) {
        if (model == null || model.nodes == null) {
            Com.Error(1, "Mod_PointInLeaf: bad model");
        }
        mnode_t node = model.nodes[0];
        while (node.contents == -1) {
            cplane_t plane = node.plane;
            float d = Math3D.DotProduct(p, plane.normal) - plane.dist;
            if (d > 0.0f) {
                node = node.children[0];
                continue;
            }
            node = node.children[1];
        }
        return (mleaf_t)node;
    }

    byte[] Mod_DecompressVis(byte[] in, int offset, model_t model) {
        int row;
        byte[] out = this.decompressed;
        int outp = 0;
        int inp = offset;
        if (in == null) {
            for (row = model.vis.numclusters + 7 >> 3; row != 0; --row) {
                out[outp++] = -1;
            }
            return this.decompressed;
        }
        do {
            if (in[inp] != 0) {
                out[outp++] = in[inp++];
                continue;
            }
            int c = in[inp + 1] & 0xFF;
            inp += 2;
            while (c != 0) {
                out[outp++] = 0;
                --c;
            }
        } while (outp < row);
        return this.decompressed;
    }

    byte[] Mod_ClusterPVS(int cluster, model_t model) {
        if (cluster == -1 || model.vis == null) {
            return this.mod_novis;
        }
        return this.Mod_DecompressVis(this.model_visibility, model.vis.bitofs[cluster][0], model);
    }

    void Mod_Modellist_f() {
        int total = 0;
        VID.Printf(0, "Loaded models:\n");
        for (int i = 0; i < this.mod_numknown; ++i) {
            model_t mod = this.mod_known[i];
            if (mod.name.length() == 0) continue;
            VID.Printf(0, "%8i : %s\n", new Vargs(2).add(mod.extradatasize).add(mod.name));
            total += mod.extradatasize;
        }
        VID.Printf(0, "Total resident: " + total + '\n');
    }

    void Mod_Init() {
        for (int i = 0; i < 512; ++i) {
            this.mod_known[i] = new model_t();
        }
        Arrays.fill(this.mod_novis, (byte)-1);
    }

    model_t Mod_ForName(String name, boolean crash) {
        int i;
        model_t mod = null;
        if (name == null || name.length() == 0) {
            Com.Error(1, "Mod_ForName: NULL name");
        }
        if (name.charAt(0) == '*') {
            int i2 = Integer.parseInt(name.substring(1));
            if (i2 < 1 || r_worldmodel == null || i2 >= Model.r_worldmodel.numsubmodels) {
                Com.Error(1, "bad inline model number");
            }
            return this.mod_inline[i2];
        }
        for (i = 0; i < this.mod_numknown; ++i) {
            mod = this.mod_known[i];
            if (mod.name.length() == 0 || !mod.name.equals(name)) continue;
            return mod;
        }
        for (i = 0; i < this.mod_numknown; ++i) {
            mod = this.mod_known[i];
            if (mod.name.length() == 0) break;
        }
        if (i == this.mod_numknown) {
            if (this.mod_numknown == 512) {
                Com.Error(1, "mod_numknown == MAX_MOD_KNOWN");
            }
            ++this.mod_numknown;
            mod = this.mod_known[i];
        }
        mod.name = name;
        this.fileBuffer = FS.LoadFile(name);
        if (this.fileBuffer == null) {
            if (crash) {
                Com.Error(1, "Mod_NumForName: " + mod.name + " not found");
            }
            mod.name = "";
            return null;
        }
        this.modfilelen = this.fileBuffer.length;
        this.loadmodel = mod;
        ByteBuffer bb = ByteBuffer.wrap(this.fileBuffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.mark();
        int ident = bb.getInt();
        bb.reset();
        switch (ident) {
            case 844121161: {
                this.Mod_LoadAliasModel(mod, bb);
                break;
            }
            case 844317769: {
                this.Mod_LoadSpriteModel(mod, bb);
                break;
            }
            case 1347633737: {
                this.Mod_LoadBrushModel(mod, bb);
                break;
            }
            default: {
                Com.Error(1, "Mod_NumForName: unknown fileid for " + mod.name);
            }
        }
        this.fileBuffer = null;
        return mod;
    }

    void Mod_LoadLighting(lump_t l) {
        if (l.filelen == 0) {
            this.loadmodel.lightdata = null;
            return;
        }
        this.loadmodel.lightdata = new byte[l.filelen];
        System.arraycopy(this.mod_base, l.fileofs, this.loadmodel.lightdata, 0, l.filelen);
    }

    void Mod_LoadVisibility(lump_t l) {
        if (l.filelen == 0) {
            this.loadmodel.vis = null;
            return;
        }
        System.arraycopy(this.mod_base, l.fileofs, this.model_visibility, 0, l.filelen);
        ByteBuffer bb = ByteBuffer.wrap(this.model_visibility, 0, l.filelen);
        this.loadmodel.vis = new qfiles.dvis_t(bb.order(ByteOrder.LITTLE_ENDIAN));
    }

    void Mod_LoadVertexes(lump_t l) {
        if (l.filelen % 12 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 12;
        mvertex_t[] vertexes = new mvertex_t[count];
        this.loadmodel.vertexes = vertexes;
        this.loadmodel.numvertexes = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            vertexes[i] = new mvertex_t(bb);
        }
    }

    float RadiusFromBounds(float[] mins, float[] maxs) {
        float[] corner = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < 3; ++i) {
            corner[i] = Math.abs(mins[i]) > Math.abs(maxs[i]) ? Math.abs(mins[i]) : Math.abs(maxs[i]);
        }
        return Math3D.VectorLength(corner);
    }

    void Mod_LoadSubmodels(lump_t l) {
        int i;
        if (l.filelen % qfiles.dmodel_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / qfiles.dmodel_t.SIZE;
        mmodel_t[] outs = new mmodel_t[count];
        for (i = 0; i < count; ++i) {
            outs[i] = new mmodel_t();
        }
        this.loadmodel.submodels = outs;
        this.loadmodel.numsubmodels = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < count; ++i) {
            qfiles.dmodel_t in = new qfiles.dmodel_t(bb);
            mmodel_t out = outs[i];
            for (int j = 0; j < 3; ++j) {
                out.mins[j] = in.mins[j] - 1.0f;
                out.maxs[j] = in.maxs[j] + 1.0f;
                out.origin[j] = in.origin[j];
            }
            out.radius = this.RadiusFromBounds(out.mins, out.maxs);
            out.headnode = in.headnode;
            out.firstface = in.firstface;
            out.numfaces = in.numfaces;
        }
    }

    void Mod_LoadEdges(lump_t l) {
        if (l.filelen % 4 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 4;
        medge_t[] edges = new medge_t[count + 1];
        this.loadmodel.edges = edges;
        this.loadmodel.numedges = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            edges[i] = new medge_t(bb);
        }
    }

    void Mod_LoadTexinfo(lump_t l) {
        int i;
        if (l.filelen % 76 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 76;
        mtexinfo_t[] out = new mtexinfo_t[count];
        for (i = 0; i < count; ++i) {
            out[i] = new mtexinfo_t();
        }
        this.loadmodel.texinfo = out;
        this.loadmodel.numtexinfo = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < count; ++i) {
            texinfo_t in = new texinfo_t(bb);
            out[i].vecs = in.vecs;
            out[i].flags = in.flags;
            int next = in.nexttexinfo;
            out[i].next = next > 0 ? this.loadmodel.texinfo[next] : null;
            String name = "textures/" + in.texture + ".wal";
            out[i].image = this.GL_FindImage(name, 2);
            if (out[i].image != null) continue;
            VID.Printf(0, "Couldn't load " + name + '\n');
            out[i].image = this.r_notexture;
        }
        for (i = 0; i < count; ++i) {
            out[i].numframes = 1;
            mtexinfo_t step = out[i].next;
            while (step != null && step != out[i]) {
                ++out[i].numframes;
                step = step.next;
            }
        }
    }

    void CalcSurfaceExtents(msurface_t s) {
        int i;
        float[] mins = new float[]{0.0f, 0.0f};
        float[] maxs = new float[]{0.0f, 0.0f};
        int[] bmins = new int[]{0, 0};
        int[] bmaxs = new int[]{0, 0};
        mins[1] = 999999.0f;
        mins[0] = 999999.0f;
        maxs[1] = -99999.0f;
        maxs[0] = -99999.0f;
        mtexinfo_t tex = s.texinfo;
        for (i = 0; i < s.numedges; ++i) {
            int e = this.loadmodel.surfedges[s.firstedge + i];
            mvertex_t v = e >= 0 ? this.loadmodel.vertexes[this.loadmodel.edges[e].v[0]] : this.loadmodel.vertexes[this.loadmodel.edges[-e].v[1]];
            for (int j = 0; j < 2; ++j) {
                float val = v.position[0] * tex.vecs[j][0] + v.position[1] * tex.vecs[j][1] + v.position[2] * tex.vecs[j][2] + tex.vecs[j][3];
                if (val < mins[j]) {
                    mins[j] = val;
                }
                if (!(val > maxs[j])) continue;
                maxs[j] = val;
            }
        }
        for (i = 0; i < 2; ++i) {
            bmins[i] = (int)Math.floor(mins[i] / 16.0f);
            bmaxs[i] = (int)Math.ceil(maxs[i] / 16.0f);
            s.texturemins[i] = (short)(bmins[i] * 16);
            s.extents[i] = (short)((bmaxs[i] - bmins[i]) * 16);
        }
    }

    void Mod_LoadFaces(lump_t l) {
        int i;
        if (l.filelen % 20 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 20;
        msurface_t[] outs = new msurface_t[count];
        for (i = 0; i < count; ++i) {
            outs[i] = new msurface_t();
        }
        this.loadmodel.surfaces = outs;
        this.loadmodel.numsurfaces = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.currentmodel = this.loadmodel;
        this.GL_BeginBuildingLightmaps(this.loadmodel);
        for (int surfnum = 0; surfnum < count; ++surfnum) {
            qfiles.dface_t in = new qfiles.dface_t(bb);
            msurface_t out = outs[surfnum];
            out.firstedge = in.firstedge;
            out.numedges = in.numedges;
            out.flags = 0;
            out.polys = null;
            int planenum = in.planenum;
            short side = in.side;
            if (side != 0) {
                out.flags |= 2;
            }
            out.plane = this.loadmodel.planes[planenum];
            short ti = in.texinfo;
            if (ti < 0 || ti >= this.loadmodel.numtexinfo) {
                Com.Error(1, "MOD_LoadBmodel: bad texinfo number");
            }
            out.texinfo = this.loadmodel.texinfo[ti];
            this.CalcSurfaceExtents(out);
            for (i = 0; i < 4; ++i) {
                out.styles[i] = in.styles[i];
            }
            i = in.lightofs;
            if (i == -1) {
                out.samples = null;
            } else {
                ByteBuffer pointer = ByteBuffer.wrap(this.loadmodel.lightdata);
                pointer.position(i);
                pointer = pointer.slice();
                pointer.mark();
                out.samples = pointer;
            }
            if ((out.texinfo.flags & 8) != 0) {
                out.flags |= 0x10;
                for (i = 0; i < 2; ++i) {
                    out.extents[i] = 16384;
                    out.texturemins[i] = -8192;
                }
                this.GL_SubdivideSurface(out);
            }
            if ((out.texinfo.flags & 0x3C) == 0) {
                this.GL_CreateSurfaceLightmap(out);
            }
            if ((out.texinfo.flags & 8) != 0) continue;
            this.GL_BuildPolygonFromSurface(out);
        }
        this.GL_EndBuildingLightmaps();
    }

    void Mod_SetParent(mnode_t node, mnode_t parent) {
        node.parent = parent;
        if (node.contents != -1) {
            return;
        }
        this.Mod_SetParent(node.children[0], node);
        this.Mod_SetParent(node.children[1], node);
    }

    void Mod_LoadNodes(lump_t l) {
        int i;
        if (l.filelen % qfiles.dnode_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / qfiles.dnode_t.SIZE;
        mnode_t[] out = new mnode_t[count];
        this.loadmodel.nodes = out;
        this.loadmodel.numnodes = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < count; ++i) {
            out[i] = new mnode_t();
        }
        for (i = 0; i < count; ++i) {
            int j;
            qfiles.dnode_t in = new qfiles.dnode_t(bb);
            for (j = 0; j < 3; ++j) {
                out[i].mins[j] = in.mins[j];
                out[i].maxs[j] = in.maxs[j];
            }
            int p = in.planenum;
            out[i].plane = this.loadmodel.planes[p];
            out[i].firstsurface = in.firstface;
            out[i].numsurfaces = in.numfaces;
            out[i].contents = -1;
            for (j = 0; j < 2; ++j) {
                p = in.children[j];
                out[i].children[j] = p >= 0 ? this.loadmodel.nodes[p] : this.loadmodel.leafs[-1 - p];
            }
        }
        this.Mod_SetParent(this.loadmodel.nodes[0], null);
    }

    void Mod_LoadLeafs(lump_t l) {
        if (l.filelen % 28 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 28;
        mleaf_t[] out = new mleaf_t[count];
        this.loadmodel.leafs = out;
        this.loadmodel.numleafs = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            qfiles.dleaf_t in = new qfiles.dleaf_t(bb);
            out[i] = new mleaf_t();
            for (int j = 0; j < 3; ++j) {
                out[i].mins[j] = in.mins[j];
                out[i].maxs[j] = in.maxs[j];
            }
            out[i].contents = in.contents;
            out[i].cluster = in.cluster;
            out[i].area = in.area;
            out[i].setMarkSurface(in.firstleafface, this.loadmodel.marksurfaces);
            out[i].nummarksurfaces = in.numleaffaces;
        }
    }

    void Mod_LoadMarksurfaces(lump_t l) {
        if (l.filelen % 2 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 2;
        msurface_t[] out = new msurface_t[count];
        this.loadmodel.marksurfaces = out;
        this.loadmodel.nummarksurfaces = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            short j = bb.getShort();
            if (j < 0 || j >= this.loadmodel.numsurfaces) {
                Com.Error(1, "Mod_ParseMarksurfaces: bad surface number");
            }
            out[i] = this.loadmodel.surfaces[j];
        }
    }

    void Mod_LoadSurfedges(lump_t l) {
        int count;
        if (l.filelen % 4 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        if ((count = l.filelen / 4) < 1 || count >= 256000) {
            Com.Error(1, "MOD_LoadBmodel: bad surfedges count in " + this.loadmodel.name + ": " + count);
        }
        int[] offsets = new int[count];
        this.loadmodel.surfedges = offsets;
        this.loadmodel.numsurfedges = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            offsets[i] = bb.getInt();
        }
    }

    void Mod_LoadPlanes(lump_t l) {
        int i;
        if (l.filelen % 20 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size in " + this.loadmodel.name);
        }
        int count = l.filelen / 20;
        cplane_t[] out = new cplane_t[count * 2];
        for (i = 0; i < count; ++i) {
            out[i] = new cplane_t();
        }
        this.loadmodel.planes = out;
        this.loadmodel.numplanes = count;
        ByteBuffer bb = ByteBuffer.wrap(this.mod_base, l.fileofs, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < count; ++i) {
            int bits = 0;
            qfiles.dplane_t in = new qfiles.dplane_t(bb);
            for (int j = 0; j < 3; ++j) {
                out[i].normal[j] = in.normal[j];
                if (!(out[i].normal[j] < 0.0f)) continue;
                bits |= 1 << j;
            }
            out[i].dist = in.dist;
            out[i].type = (byte)in.type;
            out[i].signbits = (byte)bits;
        }
    }

    void Mod_LoadBrushModel(model_t mod, ByteBuffer buffer) {
        this.loadmodel.type = 1;
        if (this.loadmodel != this.mod_known[0]) {
            Com.Error(1, "Loaded a brush model after the world");
        }
        qfiles.dheader_t header = new qfiles.dheader_t(buffer);
        int i = header.version;
        if (i != 38) {
            Com.Error(1, "Mod_LoadBrushModel: " + mod.name + " has wrong version number (" + i + " should be " + 38 + ")");
        }
        this.mod_base = this.fileBuffer;
        this.Mod_LoadVertexes(header.lumps[2]);
        this.Mod_LoadEdges(header.lumps[11]);
        this.Mod_LoadSurfedges(header.lumps[12]);
        this.Mod_LoadLighting(header.lumps[7]);
        this.Mod_LoadPlanes(header.lumps[1]);
        this.Mod_LoadTexinfo(header.lumps[5]);
        this.Mod_LoadFaces(header.lumps[6]);
        this.Mod_LoadMarksurfaces(header.lumps[9]);
        this.Mod_LoadVisibility(header.lumps[3]);
        this.Mod_LoadLeafs(header.lumps[8]);
        this.Mod_LoadNodes(header.lumps[4]);
        this.Mod_LoadSubmodels(header.lumps[13]);
        mod.numframes = 2;
        for (i = 0; i < mod.numsubmodels; ++i) {
            mmodel_t bm = mod.submodels[i];
            model_t starmod = this.mod_inline[i] = this.loadmodel.copy();
            starmod.firstmodelsurface = bm.firstface;
            starmod.nummodelsurfaces = bm.numfaces;
            starmod.firstnode = bm.headnode;
            if (starmod.firstnode >= this.loadmodel.numnodes) {
                Com.Error(1, "Inline model " + i + " has bad firstnode");
            }
            Math3D.VectorCopy(bm.maxs, starmod.maxs);
            Math3D.VectorCopy(bm.mins, starmod.mins);
            starmod.radius = bm.radius;
            if (i == 0) {
                this.loadmodel = starmod.copy();
            }
            starmod.numleafs = bm.visleafs;
        }
    }

    void Mod_LoadAliasModel(model_t mod, ByteBuffer buffer) {
        int i;
        qfiles.dmdl_t pheader = new qfiles.dmdl_t(buffer);
        if (pheader.version != 8) {
            Com.Error(1, "%s has wrong version number (%i should be %i)", new Vargs(3).add(mod.name).add(pheader.version).add(8));
        }
        if (pheader.skinheight > 480) {
            Com.Error(1, "model " + mod.name + " has a skin taller than " + 480);
        }
        if (pheader.num_xyz <= 0) {
            Com.Error(1, "model " + mod.name + " has no vertices");
        }
        if (pheader.num_xyz > 2048) {
            Com.Error(1, "model " + mod.name + " has too many vertices");
        }
        if (pheader.num_st <= 0) {
            Com.Error(1, "model " + mod.name + " has no st vertices");
        }
        if (pheader.num_tris <= 0) {
            Com.Error(1, "model " + mod.name + " has no triangles");
        }
        if (pheader.num_frames <= 0) {
            Com.Error(1, "model " + mod.name + " has no frames");
        }
        qfiles.dstvert_t[] poutst = new qfiles.dstvert_t[pheader.num_st];
        buffer.position(pheader.ofs_st);
        for (i = 0; i < pheader.num_st; ++i) {
            poutst[i] = new qfiles.dstvert_t(buffer);
        }
        qfiles.dtriangle_t[] pouttri = new qfiles.dtriangle_t[pheader.num_tris];
        buffer.position(pheader.ofs_tris);
        for (i = 0; i < pheader.num_tris; ++i) {
            pouttri[i] = new qfiles.dtriangle_t(buffer);
        }
        qfiles.daliasframe_t[] poutframe = new qfiles.daliasframe_t[pheader.num_frames];
        buffer.position(pheader.ofs_frames);
        for (i = 0; i < pheader.num_frames; ++i) {
            poutframe[i] = new qfiles.daliasframe_t(buffer);
            poutframe[i].verts = new int[pheader.num_xyz];
            for (int k = 0; k < pheader.num_xyz; ++k) {
                poutframe[i].verts[k] = buffer.getInt();
            }
        }
        mod.type = 3;
        int[] poutcmd = new int[pheader.num_glcmds];
        buffer.position(pheader.ofs_glcmds);
        for (i = 0; i < pheader.num_glcmds; ++i) {
            poutcmd[i] = buffer.getInt();
        }
        String[] skinNames = new String[pheader.num_skins];
        byte[] nameBuf = new byte[64];
        buffer.position(pheader.ofs_skins);
        for (i = 0; i < pheader.num_skins; ++i) {
            buffer.get(nameBuf);
            skinNames[i] = new String(nameBuf);
            int n = skinNames[i].indexOf(0);
            if (n > -1) {
                skinNames[i] = skinNames[i].substring(0, n);
            }
            mod.skins[i] = this.GL_FindImage(skinNames[i], 0);
        }
        pheader.skinNames = skinNames;
        pheader.stVerts = poutst;
        pheader.triAngles = pouttri;
        pheader.glCmds = poutcmd;
        pheader.aliasFrames = poutframe;
        mod.extradata = pheader;
        mod.mins[0] = -32.0f;
        mod.mins[1] = -32.0f;
        mod.mins[2] = -32.0f;
        mod.maxs[0] = 32.0f;
        mod.maxs[1] = 32.0f;
        mod.maxs[2] = 32.0f;
        this.precompileGLCmds(pheader);
    }

    void Mod_LoadSpriteModel(model_t mod, ByteBuffer buffer) {
        qfiles.dsprite_t sprout = new qfiles.dsprite_t(buffer);
        if (sprout.version != 2) {
            Com.Error(1, "%s has wrong version number (%i should be %i)", new Vargs(3).add(mod.name).add(sprout.version).add(2));
        }
        if (sprout.numframes > 32) {
            Com.Error(1, "%s has too many frames (%i > %i)", new Vargs(3).add(mod.name).add(sprout.numframes).add(32));
        }
        for (int i = 0; i < sprout.numframes; ++i) {
            mod.skins[i] = this.GL_FindImage(sprout.frames[i].name, 1);
        }
        mod.type = 2;
        mod.extradata = sprout;
    }

    public void R_BeginRegistration(String model) {
        Model.resetModelArrays();
        Polygon.reset();
        ++this.registration_sequence;
        this.r_oldviewcluster = -1;
        String fullname = "maps/" + model + ".bsp";
        cvar_t flushmap = Cvar.Get("flushmap", "0", 0);
        if (!this.mod_known[0].name.equals(fullname) || flushmap.value != 0.0f) {
            this.Mod_Free(this.mod_known[0]);
        }
        r_worldmodel = this.Mod_ForName(fullname, true);
        r_viewcluster = -1;
    }

    public model_t R_RegisterModel(String name) {
        model_t mod;
        block3: {
            block5: {
                block4: {
                    mod = null;
                    mod = this.Mod_ForName(name, false);
                    if (mod == null) break block3;
                    mod.registration_sequence = this.registration_sequence;
                    if (mod.type != 2) break block4;
                    qfiles.dsprite_t sprout = (qfiles.dsprite_t)mod.extradata;
                    for (int i = 0; i < sprout.numframes; ++i) {
                        mod.skins[i] = this.GL_FindImage(sprout.frames[i].name, 1);
                    }
                    break block3;
                }
                if (mod.type != 3) break block5;
                qfiles.dmdl_t pheader = (qfiles.dmdl_t)mod.extradata;
                for (int i = 0; i < pheader.num_skins; ++i) {
                    mod.skins[i] = this.GL_FindImage(pheader.skinNames[i], 0);
                }
                mod.numframes = pheader.num_frames;
                break block3;
            }
            if (mod.type != 1) break block3;
            for (int i = 0; i < mod.numtexinfo; ++i) {
                mod.texinfo[i].image.registration_sequence = this.registration_sequence;
            }
        }
        return mod;
    }

    public void R_EndRegistration() {
        for (int i = 0; i < this.mod_numknown; ++i) {
            model_t mod = this.mod_known[i];
            if (mod.name.length() == 0) continue;
            if (mod.registration_sequence != this.registration_sequence) {
                this.Mod_Free(mod);
                continue;
            }
            if (mod.type != 3) continue;
            this.precompileGLCmds((qfiles.dmdl_t)mod.extradata);
        }
        this.GL_FreeUnusedImages();
    }

    void Mod_Free(model_t mod) {
        mod.clear();
    }

    void Mod_FreeAll() {
        for (int i = 0; i < this.mod_numknown; ++i) {
            if (this.mod_known[i].extradata == null) continue;
            this.Mod_Free(this.mod_known[i]);
        }
    }

    void precompileGLCmds(qfiles.dmdl_t model) {
        model.textureCoordBuf = globalModelTextureCoordBuf.slice();
        model.vertexIndexBuf = globalModelVertexIndexBuf.slice();
        Vector<Integer> tmp = new Vector<Integer>();
        int count = 0;
        int[] order = model.glCmds;
        int orderIndex = 0;
        while ((count = order[orderIndex++]) != 0) {
            tmp.addElement(new Integer(count));
            if (count < 0) {
                count = -count;
            }
            do {
                globalModelTextureCoordBuf.put(Float.intBitsToFloat(order[orderIndex + 0]));
                globalModelTextureCoordBuf.put(Float.intBitsToFloat(order[orderIndex + 1]));
                globalModelVertexIndexBuf.put(order[orderIndex + 2]);
                orderIndex += 3;
            } while (--count != 0);
        }
        int size = tmp.size();
        model.counts = new int[size];
        model.indexElements = new IntBuffer[size];
        count = 0;
        int pos = 0;
        for (int i = 0; i < model.counts.length; ++i) {
            model.counts[i] = count = ((Integer)tmp.get(i)).intValue();
            count = count < 0 ? -count : count;
            model.vertexIndexBuf.position(pos);
            model.indexElements[i] = model.vertexIndexBuf.slice();
            model.indexElements[i].limit(count);
            pos += count;
        }
    }

    static void resetModelArrays() {
        globalModelTextureCoordBuf.rewind();
        globalModelVertexIndexBuf.rewind();
    }

    static void modelMemoryUsage() {
        System.out.println("AliasModels: globalVertexBuffer size " + globalModelVertexIndexBuf.position());
    }
}

