/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.client.VID;
import jake2.client.entity_t;
import jake2.qcommon.qfiles;
import jake2.render.Anorms;
import jake2.render.fast.Light;
import jake2.render.image_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Vector;

public abstract class Mesh
extends Light {
    static final int NUMVERTEXNORMALS = 162;
    float[][] r_avertexnormals = Anorms.VERTEXNORMALS;
    float[] shadevector = new float[]{0.0f, 0.0f, 0.0f};
    float[] shadelight = new float[]{0.0f, 0.0f, 0.0f};
    static final int SHADEDOT_QUANT = 16;
    float[][] r_avertexnormal_dots = Anorms.VERTEXNORMAL_DOTS;
    float[] shadedots = this.r_avertexnormal_dots[0];
    private final FloatBuffer colorArrayBuf = Lib.newFloatBuffer(8192);
    private final FloatBuffer vertexArrayBuf = Lib.newFloatBuffer(6144);
    private final FloatBuffer textureArrayBuf = Lib.newFloatBuffer(4096);
    boolean isFilled = false;
    float[] tmpVec = new float[]{0.0f, 0.0f, 0.0f};
    float[][] vectors = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
    private final float[] move = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] frontv = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] backv = new float[]{0.0f, 0.0f, 0.0f};
    Vector modeltris = new Vector();
    private final float[] point = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] mins = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
    float[][] bbox = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};

    void GL_LerpVerts(int nverts, int[] ov, int[] v, float[] move, float[] frontv, float[] backv) {
        FloatBuffer lerp = this.vertexArrayBuf;
        lerp.limit((nverts << 2) - nverts);
        if ((this.currententity.flags & 0x31C00) != 0) {
            int j = 0;
            for (int i = 0; i < nverts; ++i) {
                int vv = v[i];
                float[] normal = this.r_avertexnormals[vv >>> 24 & 0xFF];
                int ovv = ov[i];
                lerp.put(j, move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0] + normal[0] * 4.0f);
                lerp.put(j + 1, move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1] + normal[1] * 4.0f);
                lerp.put(j + 2, move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2] + normal[2] * 4.0f);
                j += 3;
            }
        } else {
            int j = 0;
            for (int i = 0; i < nverts; ++i) {
                int ovv = ov[i];
                int vv = v[i];
                lerp.put(j, move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0]);
                lerp.put(j + 1, move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1]);
                lerp.put(j + 2, move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2]);
                j += 3;
            }
        }
    }

    public void drawModelTris() {
        if (this.gl_modeltris.value == 0.0f) {
            return;
        }
        this.gl.glDisable(3553);
        this.gl.glPolygonMode(1032, 6913);
        this.gl.glColor4f(0.5f, 0.7f, 1.0f, 1.0f);
        int x = 2;
        for (int j = 0; j < this.modeltris.size(); ++j) {
            int n;
            drawinfo di = (drawinfo)this.modeltris.elementAt(j);
            if (di.mode == 5) {
                if (x != 2) {
                    this.gl.glBegin(3);
                    for (n = 0; n < di.count * 3; n += 3) {
                        this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
                        if (n < 6) continue;
                        this.gl.glVertex3f(di.fb[n - 6], di.fb[n - 5], di.fb[n - 4]);
                        this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
                    }
                    this.gl.glEnd();
                } else {
                    this.gl.glBegin(5);
                    for (n = 0; n < di.count * 3; n += 3) {
                        this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
                    }
                    this.gl.glEnd();
                }
            }
            if (di.mode != 6) continue;
            if (x != 2) {
                this.gl.glBegin(3);
                for (n = 3; n < di.count * 3; n += 3) {
                    this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
                    this.gl.glVertex3f(di.fb[0], di.fb[1], di.fb[2]);
                    this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
                }
                this.gl.glEnd();
                continue;
            }
            this.gl.glBegin(6);
            for (n = 0; n < di.count * 3; n += 3) {
                this.gl.glVertex3f(di.fb[n], di.fb[n + 1], di.fb[n + 2]);
            }
            this.gl.glEnd();
        }
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glEnable(2929);
        this.gl.glEnable(3553);
    }

    void GL_DrawAliasFrameLerp(qfiles.dmdl_t paliashdr, float backlerp) {
        int count;
        qfiles.daliasframe_t frame = paliashdr.aliasFrames[this.currententity.frame];
        int[] verts = frame.verts;
        qfiles.daliasframe_t oldframe = paliashdr.aliasFrames[this.currententity.oldframe];
        int[] ov = oldframe.verts;
        float alpha = (this.currententity.flags & 0x20) != 0 ? this.currententity.alpha : 1.0f;
        alpha = 0.2f;
        if ((this.currententity.flags & 0x31C00) != 0) {
            this.gl.glDisable(3553);
        }
        float frontlerp = 1.0f - backlerp;
        Math3D.VectorSubtract(this.currententity.oldorigin, this.currententity.origin, this.frontv);
        Math3D.AngleVectors(this.currententity.angles, this.vectors[0], this.vectors[1], this.vectors[2]);
        this.move[0] = Math3D.DotProduct(this.frontv, this.vectors[0]);
        this.move[1] = -Math3D.DotProduct(this.frontv, this.vectors[1]);
        this.move[2] = Math3D.DotProduct(this.frontv, this.vectors[2]);
        Math3D.VectorAdd(this.move, oldframe.translate, this.move);
        for (int i = 0; i < 3; ++i) {
            this.move[i] = backlerp * this.move[i] + frontlerp * frame.translate[i];
            this.frontv[i] = frontlerp * frame.scale[i];
            this.backv[i] = backlerp * oldframe.scale[i];
        }
        this.GL_LerpVerts(paliashdr.num_xyz, ov, verts, this.move, this.frontv, this.backv);
        this.gl.glVertexPointer(3, 0, this.vertexArrayBuf);
        if ((this.currententity.flags & 0x31C00) != 0) {
            this.gl.glColor4f(this.shadelight[0], this.shadelight[1], this.shadelight[2], alpha);
        } else {
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 0, this.colorArrayBuf);
            FloatBuffer color = this.colorArrayBuf;
            int size = paliashdr.num_xyz;
            int j = 0;
            for (int i = 0; i < size; ++i) {
                float l = this.shadedots[verts[i] >>> 24 & 0xFF];
                color.put(j, l * this.shadelight[0]);
                color.put(j + 1, l * this.shadelight[1]);
                color.put(j + 2, l * this.shadelight[2]);
                color.put(j + 3, alpha);
                j += 4;
            }
        }
        this.gl.glClientActiveTextureARB(this.TEXTURE0);
        this.gl.glTexCoordPointer(2, 0, this.textureArrayBuf);
        int pos = 0;
        int[] counts = paliashdr.counts;
        IntBuffer srcIndexBuf = null;
        FloatBuffer dstTextureCoords = this.textureArrayBuf;
        FloatBuffer srcTextureCoords = paliashdr.textureCoordBuf;
        int dstIndex = 0;
        int srcIndex = 0;
        int size = counts.length;
        for (int j = 0; j < size && (count = counts[j]) != 0; ++j) {
            srcIndexBuf = paliashdr.indexElements[j];
            int mode = 5;
            if (count < 0) {
                mode = 6;
                count = -count;
            }
            srcIndex = pos << 1;
            --srcIndex;
            for (int k = 0; k < count; ++k) {
                dstIndex = srcIndexBuf.get(k) << 1;
                dstTextureCoords.put(dstIndex, srcTextureCoords.get(++srcIndex));
                dstTextureCoords.put(++dstIndex, srcTextureCoords.get(++srcIndex));
            }
            this.gl.glDrawElements(mode, srcIndexBuf);
            if (this.gl_modeltris.value != 0.0f) {
                IntBuffer ib = srcIndexBuf;
                float[] buf = new float[count * 3];
                FloatBuffer fb = this.vertexArrayBuf;
                for (int k = 0; k < count; ++k) {
                    int index = ib.get(k) * 3;
                    buf[k * 3] = fb.get(index);
                    buf[k * 3 + 1] = fb.get(index + 1);
                    buf[k * 3 + 2] = fb.get(index + 2);
                }
                drawinfo di = new drawinfo();
                di.mode = mode;
                di.fb = buf;
                di.count = count;
                this.modeltris.add(di);
            }
            pos += count;
        }
        if ((this.currententity.flags & 0x31C00) != 0) {
            this.gl.glEnable(3553);
        }
        this.gl.glDisableClientState(32886);
        this.drawModelTris();
        this.modeltris = new Vector();
    }

    void GL_DrawAliasShadow(qfiles.dmdl_t paliashdr, int posenum) {
        int count;
        float lheight = this.currententity.origin[2] - this.lightspot[2];
        int[] order = paliashdr.glCmds;
        float height = -lheight + 1.0f;
        int orderIndex = 0;
        int index = 0;
        while ((count = order[orderIndex++]) != 0) {
            if (count < 0) {
                count = -count;
                this.gl.glBegin(6);
            } else {
                this.gl.glBegin(5);
            }
            do {
                index = order[orderIndex + 2] * 3;
                this.point[0] = this.vertexArrayBuf.get(index);
                this.point[1] = this.vertexArrayBuf.get(index + 1);
                this.point[2] = this.vertexArrayBuf.get(index + 2);
                this.point[0] = this.point[0] - this.shadevector[0] * (this.point[2] + lheight);
                this.point[1] = this.point[1] - this.shadevector[1] * (this.point[2] + lheight);
                this.point[2] = height;
                this.gl.glVertex3f(this.point[0], this.point[1], this.point[2]);
                orderIndex += 3;
            } while (--count != 0);
            this.gl.glEnd();
        }
    }

    boolean R_CullAliasModel(entity_t e) {
        int i;
        qfiles.daliasframe_t poldframe;
        qfiles.daliasframe_t pframe;
        qfiles.dmdl_t paliashdr = (qfiles.dmdl_t)this.currentmodel.extradata;
        if (e.frame >= paliashdr.num_frames || e.frame < 0) {
            VID.Printf(0, "R_CullAliasModel " + this.currentmodel.name + ": no such frame " + e.frame + '\n');
            e.frame = 0;
        }
        if (e.oldframe >= paliashdr.num_frames || e.oldframe < 0) {
            VID.Printf(0, "R_CullAliasModel " + this.currentmodel.name + ": no such oldframe " + e.oldframe + '\n');
            e.oldframe = 0;
        }
        if ((pframe = paliashdr.aliasFrames[e.frame]) == (poldframe = paliashdr.aliasFrames[e.oldframe])) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.mins[i2] = pframe.translate[i2];
                this.maxs[i2] = this.mins[i2] + pframe.scale[i2] * 255.0f;
            }
        } else {
            for (int i3 = 0; i3 < 3; ++i3) {
                float thismaxs = pframe.translate[i3] + pframe.scale[i3] * 255.0f;
                float oldmaxs = poldframe.translate[i3] + poldframe.scale[i3] * 255.0f;
                this.mins[i3] = pframe.translate[i3] < poldframe.translate[i3] ? pframe.translate[i3] : poldframe.translate[i3];
                this.maxs[i3] = thismaxs > oldmaxs ? thismaxs : oldmaxs;
            }
        }
        for (i = 0; i < 8; ++i) {
            float[] tmp = this.bbox[i];
            tmp[0] = (i & 1) != 0 ? this.mins[0] : this.maxs[0];
            tmp[1] = (i & 2) != 0 ? this.mins[1] : this.maxs[1];
            tmp[2] = (i & 4) != 0 ? this.mins[2] : this.maxs[2];
        }
        float[] tmp = this.mins;
        Math3D.VectorCopy(e.angles, tmp);
        tmp[1] = -tmp[1];
        Math3D.AngleVectors(tmp, this.vectors[0], this.vectors[1], this.vectors[2]);
        for (i = 0; i < 8; ++i) {
            Math3D.VectorCopy(this.bbox[i], tmp);
            this.bbox[i][0] = Math3D.DotProduct(this.vectors[0], tmp);
            this.bbox[i][1] = -Math3D.DotProduct(this.vectors[1], tmp);
            this.bbox[i][2] = Math3D.DotProduct(this.vectors[2], tmp);
            Math3D.VectorAdd(e.origin, this.bbox[i], this.bbox[i]);
        }
        int aggregatemask = -1;
        for (int p = 0; p < 8; ++p) {
            int mask = 0;
            for (int f = 0; f < 4; ++f) {
                float dp = Math3D.DotProduct(this.frustum[f].normal, this.bbox[p]);
                if (!(dp - this.frustum[f].dist < 0.0f)) continue;
                mask |= 1 << f;
            }
            aggregatemask &= mask;
        }
        return aggregatemask != 0;
    }

    void R_DrawAliasModel(entity_t e) {
        image_t skin;
        int i;
        if ((e.flags & 4) == 0 && this.R_CullAliasModel(e)) {
            return;
        }
        if ((e.flags & 4) != 0 && this.r_lefthand.value == 2.0f) {
            return;
        }
        qfiles.dmdl_t paliashdr = (qfiles.dmdl_t)this.currentmodel.extradata;
        if ((this.currententity.flags & 0x31C00) != 0) {
            Math3D.VectorClear(this.shadelight);
            if ((this.currententity.flags & 0x20000) != 0) {
                this.shadelight[0] = 0.56f;
                this.shadelight[1] = 0.59f;
                this.shadelight[2] = 0.45f;
            }
            if ((this.currententity.flags & 0x10000) != 0) {
                this.shadelight[0] = 0.9f;
                this.shadelight[1] = 0.7f;
            }
            if ((this.currententity.flags & 0x400) != 0) {
                this.shadelight[0] = 1.0f;
            }
            if ((this.currententity.flags & 0x800) != 0) {
                this.shadelight[1] = 1.0f;
            }
            if ((this.currententity.flags & 0x1000) != 0) {
                this.shadelight[2] = 1.0f;
            }
        } else if ((this.currententity.flags & 8) != 0) {
            for (i = 0; i < 3; ++i) {
                this.shadelight[i] = 1.0f;
            }
        } else {
            this.R_LightPoint(this.currententity.origin, this.shadelight);
            if ((this.currententity.flags & 4) != 0) {
                this.r_lightlevel.value = this.shadelight[0] > this.shadelight[1] ? (this.shadelight[0] > this.shadelight[2] ? 150.0f * this.shadelight[0] : 150.0f * this.shadelight[2]) : (this.shadelight[1] > this.shadelight[2] ? 150.0f * this.shadelight[1] : 150.0f * this.shadelight[2]);
            }
            if (this.gl_monolightmap.string.charAt(0) != '0') {
                float s = this.shadelight[0];
                if (s < this.shadelight[1]) {
                    s = this.shadelight[1];
                }
                if (s < this.shadelight[2]) {
                    s = this.shadelight[2];
                }
                this.shadelight[0] = s;
                this.shadelight[1] = s;
                this.shadelight[2] = s;
            }
        }
        if ((this.currententity.flags & 1) != 0) {
            for (i = 0; i < 3 && !(this.shadelight[i] > 0.1f); ++i) {
            }
            if (i == 3) {
                this.shadelight[0] = 0.1f;
                this.shadelight[1] = 0.1f;
                this.shadelight[2] = 0.1f;
            }
        }
        if ((this.currententity.flags & 0x200) != 0) {
            float scale = (float)((double)0.1f * Math.sin(this.r_newrefdef.time * 7.0f));
            for (i = 0; i < 3; ++i) {
                float min = this.shadelight[i] * 0.8f;
                int n = i;
                this.shadelight[n] = this.shadelight[n] + scale;
                if (!(this.shadelight[i] < min)) continue;
                this.shadelight[i] = min;
            }
        }
        if ((this.r_newrefdef.rdflags & 4) != 0 && (this.currententity.flags & 0x8000) != 0) {
            this.shadelight[0] = 1.0f;
            this.shadelight[1] = 0.0f;
            this.shadelight[2] = 0.0f;
        }
        this.shadedots = this.r_avertexnormal_dots[(int)((double)this.currententity.angles[1] * 0.044444444444444446) & 0xF];
        float an = (float)((double)(this.currententity.angles[1] / 180.0f) * Math.PI);
        this.shadevector[0] = (float)Math.cos(-an);
        this.shadevector[1] = (float)Math.sin(-an);
        this.shadevector[2] = 1.0f;
        Math3D.VectorNormalize(this.shadevector);
        this.c_alias_polys += paliashdr.num_tris;
        if ((this.currententity.flags & 0x10) != 0) {
            this.gl.glDepthRange(this.gldepthmin, (double)this.gldepthmin + 0.3 * (double)(this.gldepthmax - this.gldepthmin));
        }
        if ((this.currententity.flags & 4) != 0 && this.r_lefthand.value == 1.0f) {
            this.gl.glMatrixMode(5889);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            this.gl.glScalef(-1.0f, 1.0f, 1.0f);
            this.MYgluPerspective(this.r_newrefdef.fov_y, (float)this.r_newrefdef.width / (float)this.r_newrefdef.height, 4.0, 4096.0);
            this.gl.glMatrixMode(5888);
            this.gl.glCullFace(1029);
        }
        this.gl.glPushMatrix();
        e.angles[0] = -e.angles[0];
        this.R_RotateForEntity(e);
        e.angles[0] = -e.angles[0];
        if (this.currententity.skin != null) {
            skin = this.currententity.skin;
        } else if (this.currententity.skinnum >= 32) {
            skin = this.currentmodel.skins[0];
        } else {
            skin = this.currentmodel.skins[this.currententity.skinnum];
            if (skin == null) {
                skin = this.currentmodel.skins[0];
            }
        }
        if (skin == null) {
            skin = this.r_notexture;
        }
        this.GL_Bind(skin.texnum);
        this.gl.glShadeModel(7425);
        this.GL_TexEnv(8448);
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glEnable(3042);
        }
        if (this.currententity.frame >= paliashdr.num_frames || this.currententity.frame < 0) {
            VID.Printf(0, "R_DrawAliasModel " + this.currentmodel.name + ": no such frame " + this.currententity.frame + '\n');
            this.currententity.frame = 0;
            this.currententity.oldframe = 0;
        }
        if (this.currententity.oldframe >= paliashdr.num_frames || this.currententity.oldframe < 0) {
            VID.Printf(0, "R_DrawAliasModel " + this.currentmodel.name + ": no such oldframe " + this.currententity.oldframe + '\n');
            this.currententity.frame = 0;
            this.currententity.oldframe = 0;
        }
        if (this.r_lerpmodels.value == 0.0f) {
            this.currententity.backlerp = 0.0f;
        }
        this.GL_DrawAliasFrameLerp(paliashdr, this.currententity.backlerp);
        this.GL_TexEnv(7681);
        this.gl.glShadeModel(7424);
        this.gl.glPopMatrix();
        if (this.gl_modelbbox.value != 0.0f) {
            this.gl.glDisable(2884);
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glDisable(3553);
            this.gl.glBegin(3);
            this.gl.glVertex3f(this.bbox[0][0], this.bbox[0][1], this.bbox[0][2]);
            this.gl.glVertex3f(this.bbox[1][0], this.bbox[1][1], this.bbox[1][2]);
            this.gl.glVertex3f(this.bbox[3][0], this.bbox[3][1], this.bbox[3][2]);
            this.gl.glVertex3f(this.bbox[2][0], this.bbox[2][1], this.bbox[2][2]);
            this.gl.glVertex3f(this.bbox[0][0], this.bbox[0][1], this.bbox[0][2]);
            this.gl.glVertex3f(this.bbox[4][0], this.bbox[4][1], this.bbox[4][2]);
            this.gl.glVertex3f(this.bbox[5][0], this.bbox[5][1], this.bbox[5][2]);
            this.gl.glVertex3f(this.bbox[7][0], this.bbox[7][1], this.bbox[7][2]);
            this.gl.glVertex3f(this.bbox[6][0], this.bbox[6][1], this.bbox[6][2]);
            this.gl.glVertex3f(this.bbox[4][0], this.bbox[4][1], this.bbox[4][2]);
            this.gl.glEnd();
            this.gl.glBegin(3);
            this.gl.glVertex3f(this.bbox[1][0], this.bbox[1][1], this.bbox[1][2]);
            this.gl.glVertex3f(this.bbox[5][0], this.bbox[5][1], this.bbox[5][2]);
            this.gl.glEnd();
            this.gl.glBegin(3);
            this.gl.glVertex3f(this.bbox[2][0], this.bbox[2][1], this.bbox[2][2]);
            this.gl.glVertex3f(this.bbox[6][0], this.bbox[6][1], this.bbox[6][2]);
            this.gl.glEnd();
            this.gl.glBegin(3);
            this.gl.glVertex3f(this.bbox[3][0], this.bbox[3][1], this.bbox[3][2]);
            this.gl.glVertex3f(this.bbox[7][0], this.bbox[7][1], this.bbox[7][2]);
            this.gl.glEnd();
            this.gl.glEnable(3553);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glEnable(2884);
        }
        if ((this.currententity.flags & 4) != 0 && this.r_lefthand.value == 1.0f) {
            this.gl.glMatrixMode(5889);
            this.gl.glPopMatrix();
            this.gl.glMatrixMode(5888);
            this.gl.glCullFace(1028);
        }
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glDisable(3042);
        }
        if ((this.currententity.flags & 0x10) != 0) {
            this.gl.glDepthRange(this.gldepthmin, this.gldepthmax);
        }
        if (this.gl_shadows.value != 0.0f && (this.currententity.flags & 0x24) == 0) {
            this.gl.glPushMatrix();
            this.R_RotateForEntity(e);
            this.gl.glDisable(3553);
            this.gl.glEnable(3042);
            this.gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
            this.GL_DrawAliasShadow(paliashdr, this.currententity.frame);
            this.gl.glEnable(3553);
            this.gl.glDisable(3042);
            this.gl.glPopMatrix();
        }
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    class drawinfo {
        float[] fb;
        int mode;
        public int count;

        drawinfo() {
        }
    }
}

