/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.Globals;
import jake2.client.dlight_t;
import jake2.game.cplane_t;
import jake2.qcommon.Com;
import jake2.render.fast.Warp;
import jake2.render.mnode_t;
import jake2.render.msurface_t;
import jake2.render.mtexinfo_t;
import jake2.util.Math3D;
import jake2.util.Vec3Cache;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public abstract class Light
extends Warp {
    int r_dlightframecount;
    static final int DLIGHT_CUTOFF = 64;
    private final float[] v = new float[]{0.0f, 0.0f, 0.0f};
    float[] pointcolor = new float[]{0.0f, 0.0f, 0.0f};
    cplane_t lightplane;
    float[] lightspot = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] end = new float[]{0.0f, 0.0f, 0.0f};
    float[] s_blocklights = new float[3468];
    private final float[] impact = new float[]{0.0f, 0.0f, 0.0f};
    private Throwable gotoStore = new Throwable();
    static final /* synthetic */ boolean $assertionsDisabled;

    void R_RenderDlight(dlight_t light) {
        int i;
        float rad = light.intensity * 0.35f;
        Math3D.VectorSubtract(light.origin, this.r_origin, this.v);
        this.gl.glBegin(6);
        this.gl.glColor3f(light.color[0] * 0.2f, light.color[1] * 0.2f, light.color[2] * 0.2f);
        for (i = 0; i < 3; ++i) {
            this.v[i] = light.origin[i] - this.vpn[i] * rad;
        }
        this.gl.glVertex3f(this.v[0], this.v[1], this.v[2]);
        this.gl.glColor3f(0.0f, 0.0f, 0.0f);
        for (i = 16; i >= 0; --i) {
            float a = (float)((double)((float)i / 16.0f) * Math.PI * 2.0);
            for (int j = 0; j < 3; ++j) {
                this.v[j] = (float)((double)light.origin[j] + (double)this.vright[j] * Math.cos(a) * (double)rad + (double)this.vup[j] * Math.sin(a) * (double)rad);
            }
            this.gl.glVertex3f(this.v[0], this.v[1], this.v[2]);
        }
        this.gl.glEnd();
    }

    void R_RenderDlights() {
        if (this.gl_flashblend.value == 0.0f) {
            return;
        }
        this.r_dlightframecount = this.r_framecount + 1;
        this.gl.glDepthMask(false);
        this.gl.glDisable(3553);
        this.gl.glShadeModel(7425);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(1, 1);
        for (int i = 0; i < this.r_newrefdef.num_dlights; ++i) {
            this.R_RenderDlight(this.r_newrefdef.dlights[i]);
        }
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        this.gl.glDisable(3042);
        this.gl.glEnable(3553);
        this.gl.glBlendFunc(770, 771);
        this.gl.glDepthMask(true);
    }

    void R_MarkLights(dlight_t light, int bit, mnode_t node) {
        if (node.contents != -1) {
            return;
        }
        cplane_t splitplane = node.plane;
        float dist = Math3D.DotProduct(light.origin, splitplane.normal) - splitplane.dist;
        if (dist > light.intensity - 64.0f) {
            this.R_MarkLights(light, bit, node.children[0]);
            return;
        }
        if (dist < -light.intensity + 64.0f) {
            this.R_MarkLights(light, bit, node.children[1]);
            return;
        }
        for (int i = 0; i < node.numsurfaces; ++i) {
            int sidebit;
            msurface_t surf = Light.r_worldmodel.surfaces[node.firstsurface + i];
            dist = Math3D.DotProduct(light.origin, surf.plane.normal) - surf.plane.dist;
            int n = sidebit = dist >= 0.0f ? 0 : 2;
            if ((surf.flags & 2) != sidebit) continue;
            if (surf.dlightframe != this.r_dlightframecount) {
                surf.dlightbits = 0;
                surf.dlightframe = this.r_dlightframecount;
            }
            surf.dlightbits |= bit;
        }
        this.R_MarkLights(light, bit, node.children[0]);
        this.R_MarkLights(light, bit, node.children[1]);
    }

    void R_PushDlights() {
        if (this.gl_flashblend.value != 0.0f) {
            return;
        }
        this.r_dlightframecount = this.r_framecount + 1;
        for (int i = 0; i < this.r_newrefdef.num_dlights; ++i) {
            dlight_t l = this.r_newrefdef.dlights[i];
            this.R_MarkLights(l, 1 << i, Light.r_worldmodel.nodes[0]);
        }
    }

    int RecursiveLightPoint(mnode_t node, float[] start, float[] end) {
        if (node.contents != -1) {
            return -1;
        }
        cplane_t plane = node.plane;
        float front = Math3D.DotProduct(start, plane.normal) - plane.dist;
        float back = Math3D.DotProduct(end, plane.normal) - plane.dist;
        boolean side = front < 0.0f;
        int sideIndex = side ? 1 : 0;
        if (back < 0.0f == side) {
            return this.RecursiveLightPoint(node.children[sideIndex], start, end);
        }
        float frac = front / (front - back);
        float[] mid = Vec3Cache.get();
        mid[0] = start[0] + (end[0] - start[0]) * frac;
        mid[1] = start[1] + (end[1] - start[1]) * frac;
        mid[2] = start[2] + (end[2] - start[2]) * frac;
        int r = this.RecursiveLightPoint(node.children[sideIndex], start, mid);
        if (r >= 0) {
            Vec3Cache.release();
            return r;
        }
        if (back < 0.0f == side) {
            Vec3Cache.release();
            return -1;
        }
        Math3D.VectorCopy(mid, this.lightspot);
        this.lightplane = plane;
        int surfIndex = node.firstsurface;
        int i = 0;
        while (i < node.numsurfaces) {
            msurface_t surf = Light.r_worldmodel.surfaces[surfIndex];
            if ((surf.flags & 0x14) == 0) {
                mtexinfo_t tex = surf.texinfo;
                int s = (int)(Math3D.DotProduct(mid, tex.vecs[0]) + tex.vecs[0][3]);
                int t = (int)(Math3D.DotProduct(mid, tex.vecs[1]) + tex.vecs[1][3]);
                if (s >= surf.texturemins[0] && t >= surf.texturemins[1]) {
                    int ds = s - surf.texturemins[0];
                    int dt = t - surf.texturemins[1];
                    if (ds <= surf.extents[0] && dt <= surf.extents[1]) {
                        if (surf.samples == null) {
                            return 0;
                        }
                        ds >>= 4;
                        dt >>= 4;
                        ByteBuffer lightmap = surf.samples;
                        int lightmapIndex = 0;
                        Math3D.VectorCopy(Globals.vec3_origin, this.pointcolor);
                        if (lightmap != null) {
                            lightmapIndex += 3 * (dt * ((surf.extents[0] >> 4) + 1) + ds);
                            for (int maps = 0; maps < 4 && surf.styles[maps] != -1; ++maps) {
                                float[] rgb = this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb;
                                float scale0 = this.gl_modulate.value * rgb[0];
                                float scale1 = this.gl_modulate.value * rgb[1];
                                float scale2 = this.gl_modulate.value * rgb[2];
                                this.pointcolor[0] = this.pointcolor[0] + (float)(lightmap.get(lightmapIndex + 0) & 0xFF) * scale0 * 0.003921569f;
                                this.pointcolor[1] = this.pointcolor[1] + (float)(lightmap.get(lightmapIndex + 1) & 0xFF) * scale1 * 0.003921569f;
                                this.pointcolor[2] = this.pointcolor[2] + (float)(lightmap.get(lightmapIndex + 2) & 0xFF) * scale2 * 0.003921569f;
                                lightmapIndex += 3 * ((surf.extents[0] >> 4) + 1) * ((surf.extents[1] >> 4) + 1);
                            }
                        }
                        Vec3Cache.release();
                        return 1;
                    }
                }
            }
            ++i;
            ++surfIndex;
        }
        r = this.RecursiveLightPoint(node.children[1 - sideIndex], mid, end);
        Vec3Cache.release();
        return r;
    }

    void R_LightPoint(float[] p, float[] color) {
        if (!$assertionsDisabled && p.length != 3) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        if (!$assertionsDisabled && color.length != 3) {
            throw new AssertionError((Object)"rgb bug");
        }
        if (Light.r_worldmodel.lightdata == null) {
            color[2] = 1.0f;
            color[1] = 1.0f;
            color[0] = 1.0f;
            return;
        }
        this.end[0] = p[0];
        this.end[1] = p[1];
        this.end[2] = p[2] - 2048.0f;
        float r = this.RecursiveLightPoint(Light.r_worldmodel.nodes[0], p, this.end);
        if (r == -1.0f) {
            Math3D.VectorCopy(Globals.vec3_origin, color);
        } else {
            Math3D.VectorCopy(this.pointcolor, color);
        }
        for (int lnum = 0; lnum < this.r_newrefdef.num_dlights; ++lnum) {
            dlight_t dl = this.r_newrefdef.dlights[lnum];
            Math3D.VectorSubtract(this.currententity.origin, dl.origin, this.end);
            float add = dl.intensity - Math3D.VectorLength(this.end);
            add *= 0.00390625f;
            if (!(add > 0.0f)) continue;
            Math3D.VectorMA(color, add, dl.color, color);
        }
        Math3D.VectorScale(color, this.gl_modulate.value, color);
    }

    void R_AddDynamicLights(msurface_t surf) {
        int smax = (surf.extents[0] >> 4) + 1;
        int tmax = (surf.extents[1] >> 4) + 1;
        mtexinfo_t tex = surf.texinfo;
        for (int lnum = 0; lnum < this.r_newrefdef.num_dlights; ++lnum) {
            float fminlight;
            if ((surf.dlightbits & 1 << lnum) == 0) continue;
            dlight_t dl = this.r_newrefdef.dlights[lnum];
            float frad = dl.intensity;
            float fdist = Math3D.DotProduct(dl.origin, surf.plane.normal) - surf.plane.dist;
            if ((frad -= Math.abs(fdist)) < (fminlight = 64.0f)) continue;
            fminlight = frad - fminlight;
            for (int i = 0; i < 3; ++i) {
                this.impact[i] = dl.origin[i] - surf.plane.normal[i] * fdist;
            }
            float local0 = Math3D.DotProduct(this.impact, tex.vecs[0]) + tex.vecs[0][3] - (float)surf.texturemins[0];
            float local1 = Math3D.DotProduct(this.impact, tex.vecs[1]) + tex.vecs[1][3] - (float)surf.texturemins[1];
            float[] pfBL = this.s_blocklights;
            int pfBLindex = 0;
            int t = 0;
            float ftacc = 0.0f;
            while (t < tmax) {
                int td = (int)(local1 - ftacc);
                if (td < 0) {
                    td = -td;
                }
                int s = 0;
                float fsacc = 0.0f;
                while (s < smax) {
                    int sd = (int)(local0 - fsacc);
                    if (sd < 0) {
                        sd = -sd;
                    }
                    if ((fdist = sd > td ? (float)(sd + (td >> 1)) : (float)(td + (sd >> 1))) < fminlight) {
                        int n = pfBLindex + 0;
                        pfBL[n] = pfBL[n] + (frad - fdist) * dl.color[0];
                        int n2 = pfBLindex + 1;
                        pfBL[n2] = pfBL[n2] + (frad - fdist) * dl.color[1];
                        int n3 = pfBLindex + 2;
                        pfBL[n3] = pfBL[n3] + (frad - fdist) * dl.color[2];
                    }
                    ++s;
                    fsacc += 16.0f;
                    pfBLindex += 3;
                }
                ++t;
                ftacc += 16.0f;
            }
        }
    }

    void R_SetCacheState(msurface_t surf) {
        for (int maps = 0; maps < 4 && surf.styles[maps] != -1; ++maps) {
            surf.cached_light[maps] = this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].white;
        }
    }

    void R_BuildLightMap(msurface_t surf, IntBuffer dest, int stride) {
        float t;
        int i;
        float[] bl;
        int tmax;
        int smax;
        int size;
        if ((surf.texinfo.flags & 0x3C) != 0) {
            Com.Error(1, "R_BuildLightMap called for non-lit surface");
        }
        if ((size = (smax = (surf.extents[0] >> 4) + 1) * (tmax = (surf.extents[1] >> 4) + 1)) > this.s_blocklights.length * 4 >> 4) {
            Com.Error(1, "Bad s_blocklights size");
        }
        try {
            float scale2;
            float scale1;
            float scale0;
            int blp;
            int maps;
            int nummaps;
            if (surf.samples == null) {
                for (int i2 = 0; i2 < size * 3; ++i2) {
                    this.s_blocklights[i2] = 255.0f;
                }
                throw this.gotoStore;
            }
            for (nummaps = 0; nummaps < 4 && surf.styles[nummaps] != -1; ++nummaps) {
            }
            ByteBuffer lightmap = surf.samples;
            int lightmapIndex = 0;
            if (nummaps == 1) {
                for (maps = 0; maps < 4 && surf.styles[maps] != -1; ++maps) {
                    bl = this.s_blocklights;
                    blp = 0;
                    scale0 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[0];
                    scale1 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[1];
                    scale2 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[2];
                    if (scale0 == 1.0f && scale1 == 1.0f && scale2 == 1.0f) {
                        for (i = 0; i < size; ++i) {
                            bl[blp++] = lightmap.get(lightmapIndex++) & 0xFF;
                            bl[blp++] = lightmap.get(lightmapIndex++) & 0xFF;
                            bl[blp++] = lightmap.get(lightmapIndex++) & 0xFF;
                        }
                        continue;
                    }
                    for (i = 0; i < size; ++i) {
                        bl[blp++] = (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale0;
                        bl[blp++] = (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale1;
                        bl[blp++] = (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale2;
                    }
                }
            } else {
                Arrays.fill(this.s_blocklights, 0, size * 3, 0.0f);
                for (maps = 0; maps < 4 && surf.styles[maps] != -1; ++maps) {
                    bl = this.s_blocklights;
                    blp = 0;
                    scale0 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[0];
                    scale1 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[1];
                    scale2 = this.gl_modulate.value * this.r_newrefdef.lightstyles[surf.styles[maps] & 0xFF].rgb[2];
                    if (scale0 == 1.0f && scale1 == 1.0f && scale2 == 1.0f) {
                        for (i = 0; i < size; ++i) {
                            int n = blp++;
                            bl[n] = bl[n] + (float)(lightmap.get(lightmapIndex++) & 0xFF);
                            int n2 = blp++;
                            bl[n2] = bl[n2] + (float)(lightmap.get(lightmapIndex++) & 0xFF);
                            int n3 = blp++;
                            bl[n3] = bl[n3] + (float)(lightmap.get(lightmapIndex++) & 0xFF);
                        }
                        continue;
                    }
                    for (i = 0; i < size; ++i) {
                        int n = blp++;
                        bl[n] = bl[n] + (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale0;
                        int n4 = blp++;
                        bl[n4] = bl[n4] + (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale1;
                        int n5 = blp++;
                        bl[n5] = bl[n5] + (float)(lightmap.get(lightmapIndex++) & 0xFF) * scale2;
                    }
                }
            }
            if (surf.dlightframe == this.r_framecount) {
                this.R_AddDynamicLights(surf);
            }
        }
        catch (Throwable store) {
            // empty catch block
        }
        stride -= smax;
        bl = this.s_blocklights;
        int blp = 0;
        char monolightmap = this.gl_monolightmap.string.charAt(0);
        int destp = 0;
        if (monolightmap == '0') {
            i = 0;
            while (i < tmax) {
                for (int j = 0; j < smax; ++j) {
                    int max;
                    int r = (int)bl[blp++];
                    int g = (int)bl[blp++];
                    int b = (int)bl[blp++];
                    if (r < 0) {
                        r = 0;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    if (b > (max = r > g ? r : g)) {
                        max = b;
                    }
                    int a = max;
                    if (max > 255) {
                        t = 255.0f / (float)max;
                        r = (int)((float)r * t);
                        g = (int)((float)g * t);
                        b = (int)((float)b * t);
                        a = (int)((float)a * t);
                    }
                    dest.put(destp++, a << 24 | b << 16 | g << 8 | r);
                }
                ++i;
                destp += stride;
            }
        } else {
            i = 0;
            while (i < tmax) {
                for (int j = 0; j < smax; ++j) {
                    int max;
                    int r = (int)bl[blp++];
                    int g = (int)bl[blp++];
                    int b = (int)bl[blp++];
                    if (r < 0) {
                        r = 0;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    if (b > (max = r > g ? r : g)) {
                        max = b;
                    }
                    int a = max;
                    if (max > 255) {
                        t = 255.0f / (float)max;
                        r = (int)((float)r * t);
                        g = (int)((float)g * t);
                        b = (int)((float)b * t);
                        a = (int)((float)a * t);
                    }
                    switch (monolightmap) {
                        case 'I': 
                        case 'L': {
                            r = a;
                            b = 0;
                            g = 0;
                            break;
                        }
                        case 'C': {
                            a = 255 - (r + g + b) / 3;
                            float af = (float)a / 255.0f;
                            r = (int)((float)r * af);
                            g = (int)((float)g * af);
                            b = (int)((float)b * af);
                            break;
                        }
                        default: {
                            b = 0;
                            g = 0;
                            r = 0;
                            a = 255 - a;
                        }
                    }
                    dest.put(destp++, a << 24 | b << 16 | g << 8 | r);
                }
                ++i;
                destp += stride;
            }
        }
    }

    static {
        $assertionsDisabled = !Light.class.desiredAssertionStatus();
    }
}

