/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.fast;

import jake2.client.VID;
import jake2.client.particle_t;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.qfiles;
import jake2.render.fast.Main;
import jake2.render.image_t;
import jake2.util.Lib;
import jake2.util.Vargs;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Image
extends Main {
    image_t draw_chars;
    image_t[] gltextures = new image_t[1024];
    int numgltextures;
    int base_textureid;
    byte[] intensitytable = new byte[256];
    byte[] gammatable = new byte[256];
    cvar_t intensity;
    int gl_solid_format = 3;
    int gl_alpha_format = 4;
    int gl_tex_solid_format = 3;
    int gl_tex_alpha_format = 4;
    int gl_filter_min = 9985;
    int gl_filter_max = 9729;
    int[] lastmodes = new int[]{-1, -1};
    static final glmode_t[] modes;
    static final int NUM_GL_MODES;
    static final gltmode_t[] gl_alpha_modes;
    static final int NUM_GL_ALPHA_MODES;
    static final gltmode_t[] gl_solid_modes;
    static final int NUM_GL_SOLID_MODES;
    static final int MAX_SCRAPS = 1;
    static final int BLOCK_WIDTH = 256;
    static final int BLOCK_HEIGHT = 256;
    int[][] scrap_allocated = new int[1][256];
    byte[][] scrap_texels = new byte[1][65536];
    boolean scrap_dirty;
    int scrap_uploads = 0;
    private Throwable gotoBreakOut;
    private Throwable gotoDone = this.gotoBreakOut = new Throwable();
    static final int FLOODFILL_FIFO_SIZE = 4096;
    static final int FLOODFILL_FIFO_MASK = 4095;
    static floodfill_t[] fifo;
    final int[] p1 = new int[1024];
    final int[] p2 = new int[1024];
    int upload_width;
    int upload_height;
    boolean uploaded_paletted;
    int[] scaled = new int[65536];
    ByteBuffer paletted_texture = Lib.newByteBuffer(65536);
    IntBuffer tex = Lib.newIntBuffer(131072, ByteOrder.LITTLE_ENDIAN);
    int[] trans = new int[131072];
    Map imageCache = new HashMap(1024);
    IntBuffer texnumBuffer = Lib.newIntBuffer(1);
    static final /* synthetic */ boolean $assertionsDisabled;

    Image() {
        for (int i = 0; i < this.gltextures.length; ++i) {
            this.gltextures[i] = new image_t(i);
        }
        this.numgltextures = 0;
    }

    void GL_SetTexturePalette(int[] palette) {
        if (!($assertionsDisabled || palette != null && palette.length == 256)) {
            throw new AssertionError((Object)"int palette[256] bug");
        }
        if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f) {
            ByteBuffer temptable = Lib.newByteBuffer(768);
            for (int i = 0; i < 256; ++i) {
                temptable.put(i * 3 + 0, (byte)(palette[i] >> 0 & 0xFF));
                temptable.put(i * 3 + 1, (byte)(palette[i] >> 8 & 0xFF));
                temptable.put(i * 3 + 2, (byte)(palette[i] >> 16 & 0xFF));
            }
            this.gl.glColorTable(33275, 6407, 256, 6407, 5121, temptable);
        }
    }

    void GL_EnableMultitexture(boolean enable) {
        if (enable) {
            this.GL_SelectTexture(this.TEXTURE1);
            this.gl.glEnable(3553);
            this.GL_TexEnv(7681);
        } else {
            this.GL_SelectTexture(this.TEXTURE1);
            this.gl.glDisable(3553);
            this.GL_TexEnv(7681);
        }
        this.GL_SelectTexture(this.TEXTURE0);
        this.GL_TexEnv(7681);
    }

    void GL_SelectTexture(int texture) {
        int tmu;
        int n = tmu = texture == this.TEXTURE0 ? 0 : 1;
        if (tmu != this.gl_state.currenttmu) {
            this.gl_state.currenttmu = tmu;
            this.gl.glActiveTextureARB(texture);
            this.gl.glClientActiveTextureARB(texture);
        }
    }

    void GL_TexEnv(int mode) {
        if (mode != this.lastmodes[this.gl_state.currenttmu]) {
            this.gl.glTexEnvi(8960, 8704, mode);
            this.lastmodes[this.gl_state.currenttmu] = mode;
        }
    }

    void GL_Bind(int texnum) {
        if (this.gl_nobind.value != 0.0f && this.draw_chars != null) {
            texnum = this.draw_chars.texnum;
        }
        if (this.gl_state.currenttextures[this.gl_state.currenttmu] == texnum) {
            return;
        }
        this.gl_state.currenttextures[this.gl_state.currenttmu] = texnum;
        this.gl.glBindTexture(3553, texnum);
    }

    void GL_MBind(int target, int texnum) {
        this.GL_SelectTexture(target);
        if (target == this.TEXTURE0 ? this.gl_state.currenttextures[0] == texnum : this.gl_state.currenttextures[1] == texnum) {
            return;
        }
        this.GL_Bind(texnum);
    }

    void GL_TextureMode(String string) {
        int i;
        for (i = 0; i < NUM_GL_MODES && !Image.modes[i].name.equalsIgnoreCase(string); ++i) {
        }
        if (i == NUM_GL_MODES) {
            VID.Printf(0, "bad filter name: [" + string + "]\n");
            return;
        }
        this.gl_filter_min = Image.modes[i].minimize;
        this.gl_filter_max = Image.modes[i].maximize;
        for (i = 0; i < this.numgltextures; ++i) {
            image_t glt = this.gltextures[i];
            if (glt.type == 3 || glt.type == 4) continue;
            this.GL_Bind(glt.texnum);
            this.gl.glTexParameteri(3553, 10241, this.gl_filter_min);
            this.gl.glTexParameteri(3553, 10240, this.gl_filter_max);
        }
    }

    void GL_TextureAlphaMode(String string) {
        int i;
        for (i = 0; i < NUM_GL_ALPHA_MODES && !Image.gl_alpha_modes[i].name.equalsIgnoreCase(string); ++i) {
        }
        if (i == NUM_GL_ALPHA_MODES) {
            VID.Printf(0, "bad alpha texture mode name: [" + string + "]\n");
            return;
        }
        this.gl_tex_alpha_format = Image.gl_alpha_modes[i].mode;
    }

    void GL_TextureSolidMode(String string) {
        int i;
        for (i = 0; i < NUM_GL_SOLID_MODES && !Image.gl_solid_modes[i].name.equalsIgnoreCase(string); ++i) {
        }
        if (i == NUM_GL_SOLID_MODES) {
            VID.Printf(0, "bad solid texture mode name: [" + string + "]\n");
            return;
        }
        this.gl_tex_solid_format = Image.gl_solid_modes[i].mode;
    }

    void GL_ImageList_f() {
        String[] palstrings = new String[]{"RGB", "PAL"};
        VID.Printf(0, "------------------\n");
        int texels = 0;
        for (int i = 0; i < this.numgltextures; ++i) {
            image_t image = this.gltextures[i];
            if (image.texnum <= 0) continue;
            texels += image.upload_width * image.upload_height;
            switch (image.type) {
                case 0: {
                    VID.Printf(0, "M");
                    break;
                }
                case 1: {
                    VID.Printf(0, "S");
                    break;
                }
                case 2: {
                    VID.Printf(0, "W");
                    break;
                }
                case 3: {
                    VID.Printf(0, "P");
                    break;
                }
                default: {
                    VID.Printf(0, " ");
                }
            }
            VID.Printf(0, " %3i %3i %s: %s\n", new Vargs(4).add(image.upload_width).add(image.upload_height).add(palstrings[image.paletted ? 1 : 0]).add(image.name));
        }
        VID.Printf(0, "Total texel count (not counting mipmaps): " + texels + '\n');
    }

    int Scrap_AllocBlock(int w, int h, pos_t pos) {
        for (int texnum = 0; texnum < 1; ++texnum) {
            int i;
            int best = 256;
            for (i = 0; i < 256 - w; ++i) {
                int j;
                int best2 = 0;
                for (j = 0; j < w && this.scrap_allocated[texnum][i + j] < best; ++j) {
                    if (this.scrap_allocated[texnum][i + j] <= best2) continue;
                    best2 = this.scrap_allocated[texnum][i + j];
                }
                if (j != w) continue;
                pos.x = i;
                pos.y = best = best2;
            }
            if (best + h > 256) continue;
            for (i = 0; i < w; ++i) {
                this.scrap_allocated[texnum][pos.x + i] = best + h;
            }
            return texnum;
        }
        return -1;
    }

    void Scrap_Upload() {
        ++this.scrap_uploads;
        this.GL_Bind(1152);
        this.GL_Upload8(this.scrap_texels[0], 256, 256, false, false);
        this.scrap_dirty = false;
    }

    byte[] LoadPCX(String filename, byte[][] palette, Dimension dim) {
        byte[] raw = FS.LoadFile(filename);
        if (raw == null) {
            VID.Printf(1, "Bad pcx file " + filename + '\n');
            return null;
        }
        qfiles.pcx_t pcx = new qfiles.pcx_t(raw);
        if (pcx.manufacturer != 10 || pcx.version != 5 || pcx.encoding != 1 || pcx.bits_per_pixel != 8 || pcx.xmax >= 640 || pcx.ymax >= 480) {
            VID.Printf(0, "Bad pcx file " + filename + '\n');
            return null;
        }
        int width = pcx.xmax - pcx.xmin + 1;
        int height = pcx.ymax - pcx.ymin + 1;
        byte[] pix = new byte[width * height];
        if (palette != null) {
            palette[0] = new byte[768];
            System.arraycopy(raw, raw.length - 768, palette[0], 0, 768);
        }
        if (dim != null) {
            dim.width = width;
            dim.height = height;
        }
        int count = 0;
        byte dataByte = 0;
        int runLength = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                dataByte = pcx.data.get();
                if ((dataByte & 0xC0) == 192) {
                    runLength = dataByte & 0x3F;
                    dataByte = pcx.data.get();
                    while (runLength-- > 0) {
                        pix[count++] = dataByte;
                        ++x;
                    }
                    continue;
                }
                pix[count++] = dataByte;
                ++x;
            }
        }
        return pix;
    }

    byte[] LoadTGA(String name, Dimension dim) {
        byte[] pic;
        block29: {
            int red;
            int green;
            int blue;
            int alphabyte;
            ByteBuffer buf_p;
            int columns;
            qfiles.tga_t targa_header;
            block28: {
                pic = null;
                byte[] raw = FS.LoadFile(name);
                if (raw == null) {
                    VID.Printf(1, "Bad tga file " + name + '\n');
                    return null;
                }
                targa_header = new qfiles.tga_t(raw);
                if (targa_header.image_type != 2 && targa_header.image_type != 10) {
                    Com.Error(1, "LoadTGA: Only type 2 and 10 targa RGB images supported\n");
                }
                if (targa_header.colormap_type != 0 || targa_header.pixel_size != 32 && targa_header.pixel_size != 24) {
                    Com.Error(1, "LoadTGA: Only 32 or 24 bit images supported (no colormaps)\n");
                }
                columns = targa_header.width;
                int rows = targa_header.height;
                int numPixels = columns * rows;
                if (dim != null) {
                    dim.width = columns;
                    dim.height = rows;
                }
                pic = new byte[numPixels * 4];
                if (targa_header.id_length != 0) {
                    targa_header.data.position(targa_header.id_length);
                }
                buf_p = targa_header.data;
                alphabyte = 0;
                blue = 0;
                green = 0;
                red = 0;
                if (targa_header.image_type != 2) break block28;
                for (int row = rows - 1; row >= 0; --row) {
                    int pixbuf = row * columns * 4;
                    block15: for (int column = 0; column < columns; ++column) {
                        switch (targa_header.pixel_size) {
                            case 24: {
                                blue = buf_p.get();
                                green = buf_p.get();
                                red = buf_p.get();
                                pic[pixbuf++] = red;
                                pic[pixbuf++] = green;
                                pic[pixbuf++] = blue;
                                pic[pixbuf++] = -1;
                                continue block15;
                            }
                            case 32: {
                                blue = buf_p.get();
                                green = buf_p.get();
                                red = buf_p.get();
                                alphabyte = buf_p.get();
                                pic[pixbuf++] = red;
                                pic[pixbuf++] = green;
                                pic[pixbuf++] = blue;
                                pic[pixbuf++] = alphabyte;
                            }
                        }
                    }
                }
                break block29;
            }
            if (targa_header.image_type != 10) break block29;
            for (int row = rows - 1; row >= 0; --row) {
                int pixbuf = row * columns * 4;
                try {
                    int column = 0;
                    while (column < columns) {
                        int j;
                        int packetHeader = buf_p.get() & 0xFF;
                        int packetSize = 1 + (packetHeader & 0x7F);
                        if ((packetHeader & 0x80) != 0) {
                            switch (targa_header.pixel_size) {
                                case 24: {
                                    blue = buf_p.get();
                                    green = buf_p.get();
                                    red = buf_p.get();
                                    alphabyte = -1;
                                    break;
                                }
                                case 32: {
                                    blue = buf_p.get();
                                    green = buf_p.get();
                                    red = buf_p.get();
                                    alphabyte = buf_p.get();
                                }
                            }
                            for (j = 0; j < packetSize; ++j) {
                                pic[pixbuf++] = red;
                                pic[pixbuf++] = green;
                                pic[pixbuf++] = blue;
                                pic[pixbuf++] = alphabyte;
                                if (++column != columns) continue;
                                column = 0;
                                if (row <= 0) {
                                    throw this.gotoBreakOut;
                                }
                                pixbuf = --row * columns * 4;
                            }
                            continue;
                        }
                        for (j = 0; j < packetSize; ++j) {
                            switch (targa_header.pixel_size) {
                                case 24: {
                                    blue = buf_p.get();
                                    green = buf_p.get();
                                    red = buf_p.get();
                                    pic[pixbuf++] = red;
                                    pic[pixbuf++] = green;
                                    pic[pixbuf++] = blue;
                                    pic[pixbuf++] = -1;
                                    break;
                                }
                                case 32: {
                                    blue = buf_p.get();
                                    green = buf_p.get();
                                    red = buf_p.get();
                                    alphabyte = buf_p.get();
                                    pic[pixbuf++] = red;
                                    pic[pixbuf++] = green;
                                    pic[pixbuf++] = blue;
                                    pic[pixbuf++] = alphabyte;
                                }
                            }
                            if (++column != columns) continue;
                            column = 0;
                            if (row <= 0) {
                                throw this.gotoBreakOut;
                            }
                            pixbuf = --row * columns * 4;
                        }
                    }
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return pic;
    }

    void R_FloodFillSkin(byte[] skin, int skinwidth, int skinheight) {
        int fillcolor = skin[0] & 0xFF;
        int inpt = 0;
        int outpt = 0;
        int filledcolor = -1;
        if (filledcolor == -1) {
            filledcolor = 0;
            for (int i = 0; i < 256; ++i) {
                if (d_8to24table[i] != -16777216) continue;
                filledcolor = i;
                break;
            }
        }
        if (fillcolor == filledcolor || fillcolor == 255) {
            return;
        }
        Image.fifo[inpt].x = 0;
        Image.fifo[inpt].y = 0;
        inpt = inpt + 1 & 0xFFF;
        while (outpt != inpt) {
            int dy;
            int dx;
            int off;
            short x = Image.fifo[outpt].x;
            short y = Image.fifo[outpt].y;
            int fdc = filledcolor;
            int pos = x + skinwidth * y;
            outpt = outpt + 1 & 0xFFF;
            if (x > 0) {
                off = -1;
                dx = -1;
                dy = 0;
                if (skin[pos + off] == (byte)fillcolor) {
                    skin[pos + off] = -1;
                    Image.fifo[inpt].x = (short)(x + dx);
                    Image.fifo[inpt].y = (short)(y + dy);
                    inpt = inpt + 1 & 0xFFF;
                } else if (skin[pos + off] != -1) {
                    fdc = skin[pos + off] & 0xFF;
                }
            }
            if (x < skinwidth - 1) {
                off = 1;
                dx = 1;
                dy = 0;
                if (skin[pos + off] == (byte)fillcolor) {
                    skin[pos + off] = -1;
                    Image.fifo[inpt].x = (short)(x + dx);
                    Image.fifo[inpt].y = (short)(y + dy);
                    inpt = inpt + 1 & 0xFFF;
                } else if (skin[pos + off] != -1) {
                    fdc = skin[pos + off] & 0xFF;
                }
            }
            if (y > 0) {
                off = -skinwidth;
                dx = 0;
                dy = -1;
                if (skin[pos + off] == (byte)fillcolor) {
                    skin[pos + off] = -1;
                    Image.fifo[inpt].x = (short)(x + dx);
                    Image.fifo[inpt].y = (short)(y + dy);
                    inpt = inpt + 1 & 0xFFF;
                } else if (skin[pos + off] != -1) {
                    fdc = skin[pos + off] & 0xFF;
                }
            }
            if (y < skinheight - 1) {
                off = skinwidth;
                dx = 0;
                dy = 1;
                if (skin[pos + off] == (byte)fillcolor) {
                    skin[pos + off] = -1;
                    Image.fifo[inpt].x = (short)(x + dx);
                    Image.fifo[inpt].y = (short)(y + dy);
                    inpt = inpt + 1 & 0xFFF;
                } else if (skin[pos + off] != -1) {
                    fdc = skin[pos + off] & 0xFF;
                }
            }
            skin[x + skinwidth * y] = (byte)fdc;
        }
    }

    void GL_ResampleTexture(int[] in, int inwidth, int inheight, int[] out, int outwidth, int outheight) {
        int i;
        Arrays.fill(this.p1, 0);
        Arrays.fill(this.p2, 0);
        int fracstep = inwidth * 65536 / outwidth;
        int frac = fracstep >> 2;
        for (i = 0; i < outwidth; ++i) {
            this.p1[i] = frac >> 16;
            frac += fracstep;
        }
        frac = 3 * (fracstep >> 2);
        for (i = 0; i < outwidth; ++i) {
            this.p2[i] = frac >> 16;
            frac += fracstep;
        }
        int outp = 0;
        for (i = 0; i < outheight; ++i) {
            int inrow = inwidth * (int)(((float)i + 0.25f) * (float)inheight / (float)outheight);
            int inrow2 = inwidth * (int)(((float)i + 0.75f) * (float)inheight / (float)outheight);
            frac = fracstep >> 1;
            for (int j = 0; j < outwidth; ++j) {
                int pix1 = in[inrow + this.p1[j]];
                int pix2 = in[inrow + this.p2[j]];
                int pix3 = in[inrow2 + this.p1[j]];
                int pix4 = in[inrow2 + this.p2[j]];
                int r = (pix1 >> 0 & 0xFF) + (pix2 >> 0 & 0xFF) + (pix3 >> 0 & 0xFF) + (pix4 >> 0 & 0xFF) >> 2;
                int g = (pix1 >> 8 & 0xFF) + (pix2 >> 8 & 0xFF) + (pix3 >> 8 & 0xFF) + (pix4 >> 8 & 0xFF) >> 2;
                int b = (pix1 >> 16 & 0xFF) + (pix2 >> 16 & 0xFF) + (pix3 >> 16 & 0xFF) + (pix4 >> 16 & 0xFF) >> 2;
                int a = (pix1 >> 24 & 0xFF) + (pix2 >> 24 & 0xFF) + (pix3 >> 24 & 0xFF) + (pix4 >> 24 & 0xFF) >> 2;
                out[outp++] = a << 24 | b << 16 | g << 8 | r;
            }
        }
    }

    void GL_LightScaleTexture(int[] in, int inwidth, int inheight, boolean only_gamma) {
        if (only_gamma) {
            int c = inwidth * inheight;
            for (int i = 0; i < c; ++i) {
                int color = in[i];
                int r = color >> 0 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 16 & 0xFF;
                r = this.gammatable[r] & 0xFF;
                g = this.gammatable[g] & 0xFF;
                b = this.gammatable[b] & 0xFF;
                in[i] = r << 0 | g << 8 | b << 16 | color & 0xFF000000;
            }
        } else {
            int c = inwidth * inheight;
            for (int i = 0; i < c; ++i) {
                int color = in[i];
                int r = color >> 0 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 16 & 0xFF;
                r = this.gammatable[this.intensitytable[r] & 0xFF] & 0xFF;
                g = this.gammatable[this.intensitytable[g] & 0xFF] & 0xFF;
                b = this.gammatable[this.intensitytable[b] & 0xFF] & 0xFF;
                in[i] = r << 0 | g << 8 | b << 16 | color & 0xFF000000;
            }
        }
    }

    void GL_MipMap(int[] in, int width, int height) {
        int[] out = in;
        int inIndex = 0;
        int outIndex = 0;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int p1 = in[inIndex + 0];
                int p2 = in[inIndex + 1];
                int p3 = in[inIndex + width + 0];
                int p4 = in[inIndex + width + 1];
                int r = (p1 >> 0 & 0xFF) + (p2 >> 0 & 0xFF) + (p3 >> 0 & 0xFF) + (p4 >> 0 & 0xFF) >> 2;
                int g = (p1 >> 8 & 0xFF) + (p2 >> 8 & 0xFF) + (p3 >> 8 & 0xFF) + (p4 >> 8 & 0xFF) >> 2;
                int b = (p1 >> 16 & 0xFF) + (p2 >> 16 & 0xFF) + (p3 >> 16 & 0xFF) + (p4 >> 16 & 0xFF) >> 2;
                int a = (p1 >> 24 & 0xFF) + (p2 >> 24 & 0xFF) + (p3 >> 24 & 0xFF) + (p4 >> 24 & 0xFF) >> 2;
                out[outIndex] = r << 0 | g << 8 | b << 16 | a << 24;
                j += 2;
                ++outIndex;
                inIndex += 2;
            }
            i += 2;
            inIndex += width;
        }
    }

    void GL_BuildPalettedTexture(ByteBuffer paletted_texture, int[] scaled, int scaled_width, int scaled_height) {
        int size = scaled_width * scaled_height;
        for (int i = 0; i < size; ++i) {
            int r = scaled[i] >> 3 & 0x1F;
            int g = scaled[i] >> 10 & 0x3F;
            int b = scaled[i] >> 19 & 0x1F;
            int c = r | g << 5 | b << 11;
            paletted_texture.put(i, this.gl_state.d_16to8table[c]);
        }
    }

    boolean GL_Upload32(int[] data, int width, int height, boolean mipmap) {
        int comp;
        int scaled_height;
        int scaled_width;
        Arrays.fill(this.scaled, 0);
        this.paletted_texture.clear();
        for (int j = 0; j < 65536; ++j) {
            this.paletted_texture.put(j, (byte)0);
        }
        this.uploaded_paletted = false;
        for (scaled_width = 1; scaled_width < width; scaled_width <<= 1) {
        }
        if (this.gl_round_down.value > 0.0f && scaled_width > width && mipmap) {
            scaled_width >>= 1;
        }
        for (scaled_height = 1; scaled_height < height; scaled_height <<= 1) {
        }
        if (this.gl_round_down.value > 0.0f && scaled_height > height && mipmap) {
            scaled_height >>= 1;
        }
        if (mipmap) {
            scaled_width >>= (int)this.gl_picmip.value;
            scaled_height >>= (int)this.gl_picmip.value;
        }
        if (scaled_width > 256) {
            scaled_width = 256;
        }
        if (scaled_height > 256) {
            scaled_height = 256;
        }
        if (scaled_width < 1) {
            scaled_width = 1;
        }
        if (scaled_height < 1) {
            scaled_height = 1;
        }
        this.upload_width = scaled_width;
        this.upload_height = scaled_height;
        if (scaled_width * scaled_height > 65536) {
            Com.Error(1, "GL_Upload32: too big");
        }
        int c = width * height;
        int samples = this.gl_solid_format;
        for (int i = 0; i < c; ++i) {
            if ((data[i] & 0xFF000000) == -16777216) continue;
            samples = this.gl_alpha_format;
            break;
        }
        if (samples == this.gl_solid_format) {
            comp = this.gl_tex_solid_format;
        } else if (samples == this.gl_alpha_format) {
            comp = this.gl_tex_alpha_format;
        } else {
            VID.Printf(0, "Unknown number of texture components " + samples + '\n');
            comp = samples;
        }
        try {
            if (scaled_width == width && scaled_height == height) {
                if (!mipmap) {
                    if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f && samples == this.gl_solid_format) {
                        this.uploaded_paletted = true;
                        this.GL_BuildPalettedTexture(this.paletted_texture, data, scaled_width, scaled_height);
                        this.gl.glTexImage2D(3553, 0, 6400, scaled_width, scaled_height, 0, 6400, 5121, this.paletted_texture);
                    } else {
                        this.tex.rewind();
                        this.tex.put(data);
                        this.tex.rewind();
                        this.gl.glTexImage2D(3553, 0, comp, scaled_width, scaled_height, 0, 6408, 5121, this.tex);
                    }
                    throw this.gotoDone;
                }
                System.arraycopy(data, 0, this.scaled, 0, width * height);
            } else {
                this.GL_ResampleTexture(data, width, height, this.scaled, scaled_width, scaled_height);
            }
            this.GL_LightScaleTexture(this.scaled, scaled_width, scaled_height, !mipmap);
            if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f && samples == this.gl_solid_format) {
                this.uploaded_paletted = true;
                this.GL_BuildPalettedTexture(this.paletted_texture, this.scaled, scaled_width, scaled_height);
                this.gl.glTexImage2D(3553, 0, 6400, scaled_width, scaled_height, 0, 6400, 5121, this.paletted_texture);
            } else {
                this.tex.rewind();
                this.tex.put(this.scaled);
                this.tex.rewind();
                this.gl.glTexImage2D(3553, 0, comp, scaled_width, scaled_height, 0, 6408, 5121, this.tex);
            }
            if (mipmap) {
                int miplevel = 0;
                while (scaled_width > 1 || scaled_height > 1) {
                    this.GL_MipMap(this.scaled, scaled_width, scaled_height);
                    scaled_height >>= 1;
                    if ((scaled_width >>= 1) < 1) {
                        scaled_width = 1;
                    }
                    if (scaled_height < 1) {
                        scaled_height = 1;
                    }
                    ++miplevel;
                    if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f && samples == this.gl_solid_format) {
                        this.uploaded_paletted = true;
                        this.GL_BuildPalettedTexture(this.paletted_texture, this.scaled, scaled_width, scaled_height);
                        this.gl.glTexImage2D(3553, miplevel, 6400, scaled_width, scaled_height, 0, 6400, 5121, this.paletted_texture);
                        continue;
                    }
                    this.tex.rewind();
                    this.tex.put(this.scaled);
                    this.tex.rewind();
                    this.gl.glTexImage2D(3553, miplevel, comp, scaled_width, scaled_height, 0, 6408, 5121, this.tex);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (mipmap) {
            this.gl.glTexParameterf(3553, 10241, this.gl_filter_min);
            this.gl.glTexParameterf(3553, 10240, this.gl_filter_max);
        } else {
            this.gl.glTexParameterf(3553, 10241, this.gl_filter_max);
            this.gl.glTexParameterf(3553, 10240, this.gl_filter_max);
        }
        return samples == this.gl_alpha_format;
    }

    boolean GL_Upload8(byte[] data, int width, int height, boolean mipmap, boolean is_sky) {
        Arrays.fill(this.trans, 0);
        int s = width * height;
        if (s > this.trans.length) {
            Com.Error(1, "GL_Upload8: too large");
        }
        if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f && is_sky) {
            this.gl.glTexImage2D(3553, 0, 6400, width, height, 0, 6400, 5121, ByteBuffer.wrap(data));
            this.gl.glTexParameterf(3553, 10241, this.gl_filter_max);
            this.gl.glTexParameterf(3553, 10240, this.gl_filter_max);
            return false;
        }
        for (int i = 0; i < s; ++i) {
            int p = data[i] & 0xFF;
            this.trans[i] = d_8to24table[p];
            if (p != 255) continue;
            p = i > width && (data[i - width] & 0xFF) != 255 ? data[i - width] & 0xFF : (i < s - width && (data[i + width] & 0xFF) != 255 ? data[i + width] & 0xFF : (i > 0 && (data[i - 1] & 0xFF) != 255 ? data[i - 1] & 0xFF : (i < s - 1 && (data[i + 1] & 0xFF) != 255 ? data[i + 1] & 0xFF : 0)));
            this.trans[i] = d_8to24table[p] & 0xFFFFFF;
        }
        return this.GL_Upload32(this.trans, width, height, mipmap);
    }

    image_t GL_LoadPic(String name, byte[] pic, int width, int height, int type, int bits) {
        image_t image;
        int i;
        for (i = 0; i < this.numgltextures; ++i) {
            image = this.gltextures[i];
            if (image.texnum == 0) break;
        }
        if (i == this.numgltextures) {
            if (this.numgltextures == 1024) {
                Com.Error(1, "MAX_GLTEXTURES");
            }
            ++this.numgltextures;
        }
        image = this.gltextures[i];
        if (name.length() > 64) {
            Com.Error(1, "Draw_LoadPic: \"" + name + "\" is too long");
        }
        image.name = name;
        image.registration_sequence = this.registration_sequence;
        image.width = width;
        image.height = height;
        image.type = type;
        if (type == 0 && bits == 8) {
            this.R_FloodFillSkin(pic, width, height);
        }
        if (image.type == 3 && bits == 8 && image.width < 64 && image.height < 64) {
            pos_t pos = new pos_t(0, 0);
            int texnum = this.Scrap_AllocBlock(image.width, image.height, pos);
            if (texnum == -1) {
                image.scrap = false;
                image.texnum = 1153 + image.getId();
                this.GL_Bind(image.texnum);
                if (bits == 8) {
                    image.has_alpha = this.GL_Upload8(pic, width, height, image.type != 3 && image.type != 4, image.type == 4);
                } else {
                    int[] tmp = new int[pic.length / 4];
                    for (i = 0; i < tmp.length; ++i) {
                        tmp[i] = (pic[4 * i + 0] & 0xFF) << 0;
                        int n = i;
                        tmp[n] = tmp[n] | (pic[4 * i + 1] & 0xFF) << 8;
                        int n2 = i;
                        tmp[n2] = tmp[n2] | (pic[4 * i + 2] & 0xFF) << 16;
                        int n3 = i;
                        tmp[n3] = tmp[n3] | (pic[4 * i + 3] & 0xFF) << 24;
                    }
                    image.has_alpha = this.GL_Upload32(tmp, width, height, image.type != 3 && image.type != 4);
                }
                image.upload_width = this.upload_width;
                image.upload_height = this.upload_height;
                image.paletted = this.uploaded_paletted;
                image.sl = 0.0f;
                image.sh = 1.0f;
                image.tl = 0.0f;
                image.th = 1.0f;
                return image;
            }
            this.scrap_dirty = true;
            int k = 0;
            for (i = 0; i < image.height; ++i) {
                int j = 0;
                while (j < image.width) {
                    this.scrap_texels[texnum][(pos.y + i) * 256 + pos.x + j] = pic[k];
                    ++j;
                    ++k;
                }
            }
            image.texnum = 1152 + texnum;
            image.scrap = true;
            image.has_alpha = true;
            image.sl = ((float)pos.x + 0.01f) / 256.0f;
            image.sh = ((float)(pos.x + image.width) - 0.01f) / 256.0f;
            image.tl = ((float)pos.y + 0.01f) / 256.0f;
            image.th = ((float)(pos.y + image.height) - 0.01f) / 256.0f;
        } else {
            image.scrap = false;
            image.texnum = 1153 + image.getId();
            this.GL_Bind(image.texnum);
            if (bits == 8) {
                image.has_alpha = this.GL_Upload8(pic, width, height, image.type != 3 && image.type != 4, image.type == 4);
            } else {
                int[] tmp = new int[pic.length / 4];
                for (i = 0; i < tmp.length; ++i) {
                    tmp[i] = (pic[4 * i + 0] & 0xFF) << 0;
                    int n = i;
                    tmp[n] = tmp[n] | (pic[4 * i + 1] & 0xFF) << 8;
                    int n4 = i;
                    tmp[n4] = tmp[n4] | (pic[4 * i + 2] & 0xFF) << 16;
                    int n5 = i;
                    tmp[n5] = tmp[n5] | (pic[4 * i + 3] & 0xFF) << 24;
                }
                image.has_alpha = this.GL_Upload32(tmp, width, height, image.type != 3 && image.type != 4);
            }
            image.upload_width = this.upload_width;
            image.upload_height = this.upload_height;
            image.paletted = this.uploaded_paletted;
            image.sl = 0.0f;
            image.sh = 1.0f;
            image.tl = 0.0f;
            image.th = 1.0f;
        }
        return image;
    }

    image_t GL_LoadWal(String name) {
        image_t image = null;
        byte[] raw = FS.LoadFile(name);
        if (raw == null) {
            VID.Printf(0, "GL_FindImage: can't load " + name + '\n');
            return this.r_notexture;
        }
        qfiles.miptex_t mt = new qfiles.miptex_t(raw);
        byte[] pix = new byte[mt.width * mt.height];
        System.arraycopy(raw, mt.offsets[0], pix, 0, pix.length);
        image = this.GL_LoadPic(name, pix, mt.width, mt.height, 2, 8);
        return image;
    }

    image_t GL_FindImage(String name, int type) {
        if (name == null || name.length() < 1) {
            return null;
        }
        image_t image = (image_t)this.imageCache.get(name);
        if (image != null) {
            image.registration_sequence = this.registration_sequence;
            return image;
        }
        image = null;
        byte[] pic = null;
        Dimension dim = new Dimension();
        if (name.endsWith(".pcx")) {
            pic = this.LoadPCX(name, null, dim);
            if (pic == null) {
                return null;
            }
            image = this.GL_LoadPic(name, pic, dim.width, dim.height, type, 8);
        } else if (name.endsWith(".wal")) {
            image = this.GL_LoadWal(name);
        } else if (name.endsWith(".tga")) {
            pic = this.LoadTGA(name, dim);
            if (pic == null) {
                return null;
            }
            image = this.GL_LoadPic(name, pic, dim.width, dim.height, type, 32);
        } else {
            pic = this.LoadPCX("pics/" + name + ".pcx", null, dim);
            if (pic == null) {
                return null;
            }
            image = this.GL_LoadPic(name, pic, dim.width, dim.height, type, 8);
        }
        this.imageCache.put(image.name, image);
        return image;
    }

    public image_t R_RegisterSkin(String name) {
        return this.GL_FindImage(name, 0);
    }

    void GL_FreeUnusedImages() {
        this.r_notexture.registration_sequence = this.registration_sequence;
        this.r_particletexture.registration_sequence = this.registration_sequence;
        image_t image = null;
        for (int i = 0; i < this.numgltextures; ++i) {
            image = this.gltextures[i];
            if (image.registration_sequence == this.registration_sequence || image.registration_sequence == 0 || image.type == 3) continue;
            this.texnumBuffer.clear();
            this.texnumBuffer.put(0, image.texnum);
            this.gl.glDeleteTextures(this.texnumBuffer);
            this.imageCache.remove(image.name);
            image.clear();
        }
    }

    protected void Draw_GetPalette() {
        byte[][] palette = new byte[1][];
        this.LoadPCX("pics/colormap.pcx", palette, null);
        if (palette[0] == null || palette[0].length != 768) {
            Com.Error(0, "Couldn't load pics/colormap.pcx");
        }
        byte[] pal = palette[0];
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            int r = pal[j++] & 0xFF;
            int g = pal[j++] & 0xFF;
            int b = pal[j++] & 0xFF;
            Image.d_8to24table[i] = 0xFF000000 | b << 16 | g << 8 | r << 0;
        }
        d_8to24table[255] = d_8to24table[255] & 0xFFFFFF;
        particle_t.setColorPalette(d_8to24table);
    }

    void GL_InitImages() {
        int i;
        float g = this.vid_gamma.value;
        this.registration_sequence = 1;
        this.intensity = Cvar.Get("intensity", "2", 0);
        if (this.intensity.value <= 1.0f) {
            Cvar.Set("intensity", "1");
        }
        this.gl_state.inverse_intensity = 1.0f / this.intensity.value;
        this.Draw_GetPalette();
        if (this.qglColorTableEXT) {
            this.gl_state.d_16to8table = FS.LoadFile("pics/16to8.dat");
            if (this.gl_state.d_16to8table == null) {
                Com.Error(0, "Couldn't load pics/16to8.pcx");
            }
        }
        if ((this.gl_config.renderer & 3) != 0) {
            g = 1.0f;
        }
        for (i = 0; i < 256; ++i) {
            if (g == 1.0f) {
                this.gammatable[i] = (byte)i;
                continue;
            }
            int inf = (int)(255.0 * Math.pow(((double)i + 0.5) / 255.5, g) + 0.5);
            if (inf < 0) {
                inf = 0;
            }
            if (inf > 255) {
                inf = 255;
            }
            this.gammatable[i] = (byte)inf;
        }
        for (i = 0; i < 256; ++i) {
            int j = (int)((float)i * this.intensity.value);
            if (j > 255) {
                j = 255;
            }
            this.intensitytable[i] = (byte)j;
        }
    }

    void GL_ShutdownImages() {
        for (int i = 0; i < this.numgltextures; ++i) {
            image_t image = this.gltextures[i];
            if (image.registration_sequence == 0) continue;
            this.texnumBuffer.clear();
            this.texnumBuffer.put(0, image.texnum);
            this.gl.glDeleteTextures(this.texnumBuffer);
            this.imageCache.remove(image.name);
            image.clear();
        }
    }

    static {
        $assertionsDisabled = !Image.class.desiredAssertionStatus();
        modes = new glmode_t[]{new glmode_t("GL_NEAREST", 9728, 9728), new glmode_t("GL_LINEAR", 9729, 9729), new glmode_t("GL_NEAREST_MIPMAP_NEAREST", 9984, 9728), new glmode_t("GL_LINEAR_MIPMAP_NEAREST", 9985, 9729), new glmode_t("GL_NEAREST_MIPMAP_LINEAR", 9986, 9728), new glmode_t("GL_LINEAR_MIPMAP_LINEAR", 9987, 9729)};
        NUM_GL_MODES = modes.length;
        gl_alpha_modes = new gltmode_t[]{new gltmode_t("default", 4), new gltmode_t("GL_RGBA", 6408), new gltmode_t("GL_RGBA8", 32856), new gltmode_t("GL_RGB5_A1", 32855), new gltmode_t("GL_RGBA4", 32854), new gltmode_t("GL_RGBA2", 32853)};
        NUM_GL_ALPHA_MODES = gl_alpha_modes.length;
        gl_solid_modes = new gltmode_t[]{new gltmode_t("default", 3), new gltmode_t("GL_RGB", 6407), new gltmode_t("GL_RGB8", 32849), new gltmode_t("GL_RGB5", 32848), new gltmode_t("GL_RGB4", 32847), new gltmode_t("GL_R3_G3_B2", 10768)};
        NUM_GL_SOLID_MODES = gl_solid_modes.length;
        fifo = new floodfill_t[4096];
        for (int j = 0; j < fifo.length; ++j) {
            Image.fifo[j] = new floodfill_t();
        }
    }

    static class floodfill_t {
        short x;
        short y;

        floodfill_t() {
        }
    }

    static class pos_t {
        int x;
        int y;

        pos_t(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    static class gltmode_t {
        String name;
        int mode;

        gltmode_t(String name, int mode) {
            this.name = name;
            this.mode = mode;
        }
    }

    static class glmode_t {
        String name;
        int minimize;
        int maximize;

        glmode_t(String name, int minimize, int maximze) {
            this.name = name;
            this.minimize = minimize;
            this.maximize = maximze;
        }
    }
}

