/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.basic;

import jake2.render.glpoly_t;

public final class Polygon
extends glpoly_t {
    private static final int MAXPOLYS = 20000;
    private static final int MAX_BUFFER_VERTICES = 120000;
    private static float[] buffer = new float[840000];
    private static int bufferIndex = 0;
    private static int polyCount = 0;
    private static Polygon[] polyCache = new Polygon[20000];

    public static glpoly_t create(int numverts) {
        Polygon poly = polyCache[polyCount++];
        poly.clear();
        poly.numverts = numverts;
        poly.pos = bufferIndex;
        bufferIndex += numverts;
        return poly;
    }

    public static void reset() {
        polyCount = 0;
        bufferIndex = 0;
    }

    private Polygon() {
    }

    private final void clear() {
        this.next = null;
        this.chain = null;
        this.numverts = 0;
        this.flags = 0;
    }

    public final float x(int index) {
        return buffer[this.offset(index)];
    }

    public final void x(int index, float value) {
        Polygon.buffer[this.offset((int)index)] = value;
    }

    public final float y(int index) {
        return buffer[this.offset(index) + 1];
    }

    public final void y(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 1] = value;
    }

    public final float z(int index) {
        return buffer[this.offset(index) + 2];
    }

    public final void z(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 2] = value;
    }

    public final float s1(int index) {
        return buffer[this.offset(index) + 3];
    }

    public final void s1(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 3] = value;
    }

    public final float t1(int index) {
        return buffer[this.offset(index) + 4];
    }

    public final void t1(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 4] = value;
    }

    public final float s2(int index) {
        return buffer[this.offset(index) + 5];
    }

    public final void s2(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 5] = value;
    }

    public final float t2(int index) {
        return buffer[this.offset(index) + 6];
    }

    public final void t2(int index, float value) {
        Polygon.buffer[this.offset((int)index) + 6] = value;
    }

    public final void beginScrolling(float value) {
    }

    public final void endScrolling() {
    }

    private final int offset(int index) {
        return (index + this.pos) * 7;
    }

    static {
        for (int i = 0; i < polyCache.length; ++i) {
            Polygon.polyCache[i] = new Polygon();
        }
    }
}

