/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.basic;

import jake2.client.VID;
import jake2.qcommon.FS;
import jake2.render.basic.Mesh;
import jake2.util.Lib;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class Misc
extends Mesh {
    byte[][] dottexture = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int TGA_HEADER_SIZE = 18;

    void R_InitParticleTexture() {
        int y;
        int x;
        byte[] data = new byte[256];
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                data[y * 32 + x * 4 + 0] = -1;
                data[y * 32 + x * 4 + 1] = -1;
                data[y * 32 + x * 4 + 2] = -1;
                data[y * 32 + x * 4 + 3] = (byte)(this.dottexture[x][y] * 255);
            }
        }
        this.r_particletexture = this.GL_LoadPic("***particle***", data, 8, 8, 1, 32);
        for (x = 0; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                data[y * 32 + x * 4 + 0] = (byte)(this.dottexture[x & 3][y & 3] * 255);
                data[y * 32 + x * 4 + 1] = 0;
                data[y * 32 + x * 4 + 2] = 0;
                data[y * 32 + x * 4 + 3] = -1;
            }
        }
        this.r_notexture = this.GL_LoadPic("***r_notexture***", data, 8, 8, 2, 32);
    }

    public void GL_ScreenShot_f() {
        StringBuffer sb = new StringBuffer(FS.Gamedir() + "/scrshot/jake00.tga");
        FS.CreatePath(sb.toString());
        File file = new File(sb.toString());
        int i = 0;
        int offset = sb.length() - 6;
        while (file.exists() && i++ < 100) {
            sb.setCharAt(offset, (char)(i / 10 + 48));
            sb.setCharAt(offset + 1, (char)(i % 10 + 48));
            file = new File(sb.toString());
        }
        if (i == 100) {
            VID.Printf(0, "Clean up your screenshots\n");
            return;
        }
        try {
            RandomAccessFile out = new RandomAccessFile(file, "rw");
            FileChannel ch = out.getChannel();
            int fileLength = 18 + vid.getWidth() * vid.getHeight() * 3;
            out.setLength(fileLength);
            MappedByteBuffer image = ch.map(FileChannel.MapMode.READ_WRITE, 0L, fileLength);
            image.put(0, (byte)0).put(1, (byte)0);
            image.put(2, (byte)2);
            image.put(12, (byte)(vid.getWidth() & 0xFF));
            image.put(13, (byte)(vid.getWidth() >> 8));
            image.put(14, (byte)(vid.getHeight() & 0xFF));
            image.put(15, (byte)(vid.getHeight() >> 8));
            image.put(16, (byte)24);
            image.position(18);
            ByteBuffer rgb = image.slice();
            if (vid.getWidth() % 4 != 0) {
                this.gl.glPixelStorei(3333, 1);
            }
            if (this.gl_config.getOpenGLVersion() >= 1.2f) {
                this.gl.glReadPixels(0, 0, vid.getWidth(), vid.getHeight(), 32992, 5121, rgb);
            } else {
                this.gl.glReadPixels(0, 0, vid.getWidth(), vid.getHeight(), 6407, 5121, rgb);
                for (i = 18; i < fileLength; i += 3) {
                    byte tmp = image.get(i);
                    image.put(i, image.get(i + 2));
                    image.put(i + 2, tmp);
                }
            }
            this.gl.glPixelStorei(3333, 4);
            ch.close();
        }
        catch (IOException e) {
            VID.Printf(0, e.getMessage() + '\n');
        }
        VID.Printf(0, "Wrote " + file + '\n');
    }

    void GL_Strings_f() {
        VID.Printf(0, "GL_VENDOR: " + this.gl_config.vendor_string + '\n');
        VID.Printf(0, "GL_RENDERER: " + this.gl_config.renderer_string + '\n');
        VID.Printf(0, "GL_VERSION: " + this.gl_config.version_string + '\n');
        VID.Printf(0, "GL_EXTENSIONS: " + this.gl_config.extensions_string + '\n');
    }

    void GL_SetDefaultState() {
        this.gl.glClearColor(1.0f, 0.0f, 0.5f, 0.5f);
        this.gl.glCullFace(1028);
        this.gl.glEnable(3553);
        this.gl.glEnable(3008);
        this.gl.glAlphaFunc(516, 0.666f);
        this.gl.glDisable(2929);
        this.gl.glDisable(2884);
        this.gl.glDisable(3042);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glShadeModel(7424);
        this.GL_TextureMode(this.gl_texturemode.string);
        this.GL_TextureAlphaMode(this.gl_texturealphamode.string);
        this.GL_TextureSolidMode(this.gl_texturesolidmode.string);
        this.gl.glTexParameterf(3553, 10241, this.gl_filter_min);
        this.gl.glTexParameterf(3553, 10240, this.gl_filter_max);
        this.gl.glTexParameterf(3553, 10242, 10497.0f);
        this.gl.glTexParameterf(3553, 10243, 10497.0f);
        this.gl.glBlendFunc(770, 771);
        this.GL_TexEnv(7681);
        if (this.qglPointParameterfEXT) {
            FloatBuffer attenuations = Lib.newFloatBuffer(4);
            attenuations.put(0, this.gl_particle_att_a.value);
            attenuations.put(1, this.gl_particle_att_b.value);
            attenuations.put(2, this.gl_particle_att_c.value);
            this.gl.glEnable(2832);
            this.gl.glPointParameterfEXT(33062, this.gl_particle_min_size.value);
            this.gl.glPointParameterfEXT(33063, this.gl_particle_max_size.value);
            this.gl.glPointParameterEXT(33065, attenuations);
        }
        if (this.qglColorTableEXT && this.gl_ext_palettedtexture.value != 0.0f) {
            this.gl.glEnable(33275);
            this.GL_SetTexturePalette(d_8to24table);
        }
        this.GL_UpdateSwapInterval();
    }

    void GL_UpdateSwapInterval() {
        if (this.gl_swapinterval.modified) {
            this.gl_swapinterval.modified = false;
            if (!this.gl_state.stereo_enabled) {
                this.gl.setSwapInterval((int)this.gl_swapinterval.value);
            }
        }
    }
}

