/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.basic;

import jake2.client.VID;
import jake2.client.entity_t;
import jake2.qcommon.qfiles;
import jake2.render.Anorms;
import jake2.render.basic.Light;
import jake2.render.image_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import java.nio.FloatBuffer;

public abstract class Mesh
extends Light {
    static final int NUMVERTEXNORMALS = 162;
    float[][] r_avertexnormals = Anorms.VERTEXNORMALS;
    float[][] s_lerped = new float[2048][4];
    float[] shadevector = new float[]{0.0f, 0.0f, 0.0f};
    float[] shadelight = new float[]{0.0f, 0.0f, 0.0f};
    static final int SHADEDOT_QUANT = 16;
    float[][] r_avertexnormal_dots = Anorms.VERTEXNORMAL_DOTS;
    float[] shadedots = this.r_avertexnormal_dots[0];
    FloatBuffer colorArrayBuf = Lib.newFloatBuffer(8192);
    FloatBuffer vertexArrayBuf = Lib.newFloatBuffer(6144);
    boolean isFilled = false;
    float[] tmpVec = new float[]{0.0f, 0.0f, 0.0f};

    void GL_LerpVerts(int nverts, int[] ov, int[] v, float[][] lerp, float[] move, float[] frontv, float[] backv) {
        if ((this.currententity.flags & 0x31C00) != 0) {
            for (int i = 0; i < nverts; ++i) {
                int vv = v[i];
                float[] normal = this.r_avertexnormals[vv >>> 24 & 0xFF];
                int ovv = ov[i];
                lerp[i][0] = move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0] + normal[0] * 4.0f;
                lerp[i][1] = move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1] + normal[1] * 4.0f;
                lerp[i][2] = move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2] + normal[2] * 4.0f;
            }
        } else {
            for (int i = 0; i < nverts; ++i) {
                int vv = v[i];
                int ovv = ov[i];
                lerp[i][0] = move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0];
                lerp[i][1] = move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1];
                lerp[i][2] = move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2];
            }
        }
    }

    void GL_LerpVerts(int nverts, int[] ov, int[] v, float[] move, float[] frontv, float[] backv) {
        FloatBuffer lerp = this.vertexArrayBuf;
        if ((this.currententity.flags & 0x31C00) != 0) {
            int j = 0;
            for (int i = 0; i < nverts; ++i) {
                int vv = v[i];
                float[] normal = this.r_avertexnormals[v[i] >>> 24 & 0xFF];
                int ovv = ov[i];
                lerp.put(j, move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0] + normal[0] * 4.0f);
                lerp.put(j + 1, move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1] + normal[1] * 4.0f);
                lerp.put(j + 2, move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2] + normal[2] * 4.0f);
                j += 3;
            }
        } else {
            int j = 0;
            for (int i = 0; i < nverts; ++i) {
                int ovv = ov[i];
                int vv = v[i];
                lerp.put(j, move[0] + (float)(ovv & 0xFF) * backv[0] + (float)(vv & 0xFF) * frontv[0]);
                lerp.put(j + 1, move[1] + (float)(ovv >>> 8 & 0xFF) * backv[1] + (float)(vv >>> 8 & 0xFF) * frontv[1]);
                lerp.put(j + 2, move[2] + (float)(ovv >>> 16 & 0xFF) * backv[2] + (float)(vv >>> 16 & 0xFF) * frontv[2]);
                j += 3;
            }
        }
    }

    void GL_DrawAliasFrameLerp(qfiles.dmdl_t paliashdr, float backlerp) {
        int i;
        int orderIndex = 0;
        float[] move = new float[]{0.0f, 0.0f, 0.0f};
        float[][] vectors = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
        float[] frontv = new float[]{0.0f, 0.0f, 0.0f};
        float[] backv = new float[]{0.0f, 0.0f, 0.0f};
        qfiles.daliasframe_t frame = paliashdr.aliasFrames[this.currententity.frame];
        int[] v = frame.verts;
        qfiles.daliasframe_t oldframe = paliashdr.aliasFrames[this.currententity.oldframe];
        int[] ov = oldframe.verts;
        int[] order = paliashdr.glCmds;
        float alpha = (this.currententity.flags & 0x20) != 0 ? this.currententity.alpha : 1.0f;
        if ((this.currententity.flags & 0x31C00) != 0) {
            this.gl.glDisable(3553);
        }
        float frontlerp = 1.0f - backlerp;
        Math3D.VectorSubtract(this.currententity.oldorigin, this.currententity.origin, frontv);
        Math3D.AngleVectors(this.currententity.angles, vectors[0], vectors[1], vectors[2]);
        move[0] = Math3D.DotProduct(frontv, vectors[0]);
        move[1] = -Math3D.DotProduct(frontv, vectors[1]);
        move[2] = Math3D.DotProduct(frontv, vectors[2]);
        Math3D.VectorAdd(move, oldframe.translate, move);
        for (i = 0; i < 3; ++i) {
            move[i] = backlerp * move[i] + frontlerp * frame.translate[i];
            frontv[i] = frontlerp * frame.scale[i];
            backv[i] = backlerp * oldframe.scale[i];
        }
        if (this.gl_vertex_arrays.value != 0.0f) {
            int count;
            this.GL_LerpVerts(paliashdr.num_xyz, ov, v, move, frontv, backv);
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 0, this.vertexArrayBuf);
            if ((this.currententity.flags & 0x31C00) != 0) {
                this.gl.glDisableClientState(32886);
                this.gl.glColor4f(this.shadelight[0], this.shadelight[1], this.shadelight[2], alpha);
            } else {
                this.gl.glEnableClientState(32886);
                this.gl.glColorPointer(4, 0, this.colorArrayBuf);
                FloatBuffer color = this.colorArrayBuf;
                int j = 0;
                for (i = 0; i < paliashdr.num_xyz; ++i) {
                    float l = this.shadedots[v[i] >>> 24 & 0xFF];
                    color.put(j++, l * this.shadelight[0]);
                    color.put(j++, l * this.shadelight[1]);
                    color.put(j++, l * this.shadelight[2]);
                    color.put(j++, alpha);
                }
            }
            if (this.qglLockArraysEXT) {
                this.gl.glLockArraysEXT(0, paliashdr.num_xyz);
            }
            while ((count = order[orderIndex++]) != 0) {
                int index_xyz;
                if (count < 0) {
                    count = -count;
                    this.gl.glBegin(6);
                } else {
                    this.gl.glBegin(5);
                }
                if ((this.currententity.flags & 0x31C00) != 0) {
                    do {
                        index_xyz = order[orderIndex + 2];
                        orderIndex += 3;
                        this.gl.glArrayElement(index_xyz);
                    } while (--count != 0);
                } else {
                    do {
                        this.gl.glTexCoord2f(Float.intBitsToFloat(order[orderIndex + 0]), Float.intBitsToFloat(order[orderIndex + 1]));
                        index_xyz = order[orderIndex + 2];
                        orderIndex += 3;
                        this.gl.glArrayElement(index_xyz);
                    } while (--count != 0);
                }
                this.gl.glEnd();
            }
            if (this.qglLockArraysEXT) {
                this.gl.glUnlockArraysEXT();
            }
        } else {
            int count;
            this.GL_LerpVerts(paliashdr.num_xyz, ov, v, this.s_lerped, move, frontv, backv);
            while ((count = order[orderIndex++]) != 0) {
                float[] tmp;
                int index_xyz;
                if (count < 0) {
                    count = -count;
                    this.gl.glBegin(6);
                } else {
                    this.gl.glBegin(5);
                }
                if ((this.currententity.flags & 0x1C00) != 0) {
                    do {
                        index_xyz = order[orderIndex + 2];
                        orderIndex += 3;
                        this.gl.glColor4f(this.shadelight[0], this.shadelight[1], this.shadelight[2], alpha);
                        tmp = this.s_lerped[index_xyz];
                        this.gl.glVertex3f(tmp[0], tmp[1], tmp[2]);
                    } while (--count != 0);
                } else {
                    do {
                        this.gl.glTexCoord2f(Float.intBitsToFloat(order[orderIndex + 0]), Float.intBitsToFloat(order[orderIndex + 1]));
                        index_xyz = order[orderIndex + 2];
                        orderIndex += 3;
                        float l = this.shadedots[v[index_xyz] >>> 24 & 0xFF];
                        this.gl.glColor4f(l * this.shadelight[0], l * this.shadelight[1], l * this.shadelight[2], alpha);
                        tmp = this.s_lerped[index_xyz];
                        this.gl.glVertex3f(tmp[0], tmp[1], tmp[2]);
                    } while (--count != 0);
                }
                this.gl.glEnd();
            }
        }
        if ((this.currententity.flags & 0x31C00) != 0) {
            this.gl.glEnable(3553);
        }
    }

    void GL_DrawAliasShadow(qfiles.dmdl_t paliashdr, int posenum) {
        int count;
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        float lheight = this.currententity.origin[2] - this.lightspot[2];
        int[] order = paliashdr.glCmds;
        float height = -lheight + 1.0f;
        int orderIndex = 0;
        int index = 0;
        while ((count = order[orderIndex++]) != 0) {
            if (count < 0) {
                count = -count;
                this.gl.glBegin(6);
            } else {
                this.gl.glBegin(5);
            }
            do {
                if (this.gl_vertex_arrays.value != 0.0f) {
                    index = order[orderIndex + 2] * 3;
                    point[0] = this.vertexArrayBuf.get(index);
                    point[1] = this.vertexArrayBuf.get(index + 1);
                    point[2] = this.vertexArrayBuf.get(index + 2);
                } else {
                    Math3D.VectorCopy(this.s_lerped[order[orderIndex + 2]], point);
                }
                point[0] = point[0] - this.shadevector[0] * (point[2] + lheight);
                point[1] = point[1] - this.shadevector[1] * (point[2] + lheight);
                point[2] = height;
                this.gl.glVertex3f(point[0], point[1], point[2]);
                orderIndex += 3;
            } while (--count != 0);
            this.gl.glEnd();
        }
    }

    boolean R_CullAliasModel(float[][] bbox, entity_t e) {
        float[] tmp;
        int i;
        qfiles.daliasframe_t poldframe;
        qfiles.daliasframe_t pframe;
        float[] mins = new float[]{0.0f, 0.0f, 0.0f};
        float[] maxs = new float[]{0.0f, 0.0f, 0.0f};
        float[][] vectors = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
        float[] thismins = new float[]{0.0f, 0.0f, 0.0f};
        float[] oldmins = new float[]{0.0f, 0.0f, 0.0f};
        float[] thismaxs = new float[]{0.0f, 0.0f, 0.0f};
        float[] oldmaxs = new float[]{0.0f, 0.0f, 0.0f};
        float[] angles = new float[]{0.0f, 0.0f, 0.0f};
        qfiles.dmdl_t paliashdr = (qfiles.dmdl_t)this.currentmodel.extradata;
        if (e.frame >= paliashdr.num_frames || e.frame < 0) {
            VID.Printf(0, "R_CullAliasModel " + this.currentmodel.name + ": no such frame " + e.frame + '\n');
            e.frame = 0;
        }
        if (e.oldframe >= paliashdr.num_frames || e.oldframe < 0) {
            VID.Printf(0, "R_CullAliasModel " + this.currentmodel.name + ": no such oldframe " + e.oldframe + '\n');
            e.oldframe = 0;
        }
        if ((pframe = paliashdr.aliasFrames[e.frame]) == (poldframe = paliashdr.aliasFrames[e.oldframe])) {
            for (i = 0; i < 3; ++i) {
                mins[i] = pframe.translate[i];
                maxs[i] = mins[i] + pframe.scale[i] * 255.0f;
            }
        } else {
            for (i = 0; i < 3; ++i) {
                thismins[i] = pframe.translate[i];
                thismaxs[i] = thismins[i] + pframe.scale[i] * 255.0f;
                oldmins[i] = poldframe.translate[i];
                oldmaxs[i] = oldmins[i] + poldframe.scale[i] * 255.0f;
                mins[i] = thismins[i] < oldmins[i] ? thismins[i] : oldmins[i];
                maxs[i] = thismaxs[i] > oldmaxs[i] ? thismaxs[i] : oldmaxs[i];
            }
        }
        for (i = 0; i < 8; ++i) {
            tmp = new float[]{0.0f, 0.0f, 0.0f};
            tmp[0] = (i & 1) != 0 ? mins[0] : maxs[0];
            tmp[1] = (i & 2) != 0 ? mins[1] : maxs[1];
            tmp[2] = (i & 4) != 0 ? mins[2] : maxs[2];
            Math3D.VectorCopy(tmp, bbox[i]);
        }
        Math3D.VectorCopy(e.angles, angles);
        angles[1] = -angles[1];
        Math3D.AngleVectors(angles, vectors[0], vectors[1], vectors[2]);
        for (i = 0; i < 8; ++i) {
            tmp = new float[]{0.0f, 0.0f, 0.0f};
            Math3D.VectorCopy(bbox[i], tmp);
            bbox[i][0] = Math3D.DotProduct(vectors[0], tmp);
            bbox[i][1] = -Math3D.DotProduct(vectors[1], tmp);
            bbox[i][2] = Math3D.DotProduct(vectors[2], tmp);
            Math3D.VectorAdd(e.origin, bbox[i], bbox[i]);
        }
        int aggregatemask = -1;
        for (int p = 0; p < 8; ++p) {
            int mask = 0;
            for (int f = 0; f < 4; ++f) {
                float dp = Math3D.DotProduct(this.frustum[f].normal, bbox[p]);
                if (!(dp - this.frustum[f].dist < 0.0f)) continue;
                mask |= 1 << f;
            }
            aggregatemask &= mask;
        }
        return aggregatemask != 0;
    }

    void R_DrawAliasModel(entity_t e) {
        image_t skin;
        int i;
        float[][] bbox = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
        if ((e.flags & 4) == 0 && this.R_CullAliasModel(bbox, e)) {
            return;
        }
        if ((e.flags & 4) != 0 && this.r_lefthand.value == 2.0f) {
            return;
        }
        qfiles.dmdl_t paliashdr = (qfiles.dmdl_t)this.currentmodel.extradata;
        if ((this.currententity.flags & 0x31C00) != 0) {
            Math3D.VectorClear(this.shadelight);
            if ((this.currententity.flags & 0x20000) != 0) {
                this.shadelight[0] = 0.56f;
                this.shadelight[1] = 0.59f;
                this.shadelight[2] = 0.45f;
            }
            if ((this.currententity.flags & 0x10000) != 0) {
                this.shadelight[0] = 0.9f;
                this.shadelight[1] = 0.7f;
            }
            if ((this.currententity.flags & 0x400) != 0) {
                this.shadelight[0] = 1.0f;
            }
            if ((this.currententity.flags & 0x800) != 0) {
                this.shadelight[1] = 1.0f;
            }
            if ((this.currententity.flags & 0x1000) != 0) {
                this.shadelight[2] = 1.0f;
            }
        } else if ((this.currententity.flags & 8) != 0) {
            for (i = 0; i < 3; ++i) {
                this.shadelight[i] = 1.0f;
            }
        } else {
            this.R_LightPoint(this.currententity.origin, this.shadelight);
            if ((this.currententity.flags & 4) != 0) {
                this.r_lightlevel.value = this.shadelight[0] > this.shadelight[1] ? (this.shadelight[0] > this.shadelight[2] ? 150.0f * this.shadelight[0] : 150.0f * this.shadelight[2]) : (this.shadelight[1] > this.shadelight[2] ? 150.0f * this.shadelight[1] : 150.0f * this.shadelight[2]);
            }
            if (this.gl_monolightmap.string.charAt(0) != '0') {
                float s = this.shadelight[0];
                if (s < this.shadelight[1]) {
                    s = this.shadelight[1];
                }
                if (s < this.shadelight[2]) {
                    s = this.shadelight[2];
                }
                this.shadelight[0] = s;
                this.shadelight[1] = s;
                this.shadelight[2] = s;
            }
        }
        if ((this.currententity.flags & 1) != 0) {
            for (i = 0; i < 3 && !(this.shadelight[i] > 0.1f); ++i) {
            }
            if (i == 3) {
                this.shadelight[0] = 0.1f;
                this.shadelight[1] = 0.1f;
                this.shadelight[2] = 0.1f;
            }
        }
        if ((this.currententity.flags & 0x200) != 0) {
            float scale = (float)((double)0.1f * Math.sin(this.r_newrefdef.time * 7.0f));
            for (i = 0; i < 3; ++i) {
                float min = this.shadelight[i] * 0.8f;
                int n = i;
                this.shadelight[n] = this.shadelight[n] + scale;
                if (!(this.shadelight[i] < min)) continue;
                this.shadelight[i] = min;
            }
        }
        if ((this.r_newrefdef.rdflags & 4) != 0 && (this.currententity.flags & 0x8000) != 0) {
            this.shadelight[0] = 1.0f;
            this.shadelight[1] = 0.0f;
            this.shadelight[2] = 0.0f;
        }
        this.shadedots = this.r_avertexnormal_dots[(int)((double)this.currententity.angles[1] * 0.044444444444444446) & 0xF];
        float an = (float)((double)(this.currententity.angles[1] / 180.0f) * Math.PI);
        this.shadevector[0] = (float)Math.cos(-an);
        this.shadevector[1] = (float)Math.sin(-an);
        this.shadevector[2] = 1.0f;
        Math3D.VectorNormalize(this.shadevector);
        this.c_alias_polys += paliashdr.num_tris;
        if ((this.currententity.flags & 0x10) != 0) {
            this.gl.glDepthRange(this.gldepthmin, (double)this.gldepthmin + 0.3 * (double)(this.gldepthmax - this.gldepthmin));
        }
        if ((this.currententity.flags & 4) != 0 && this.r_lefthand.value == 1.0f) {
            this.gl.glMatrixMode(5889);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            this.gl.glScalef(-1.0f, 1.0f, 1.0f);
            this.MYgluPerspective(this.r_newrefdef.fov_y, (float)this.r_newrefdef.width / (float)this.r_newrefdef.height, 4.0, 4096.0);
            this.gl.glMatrixMode(5888);
            this.gl.glCullFace(1029);
        }
        this.gl.glPushMatrix();
        e.angles[0] = -e.angles[0];
        this.R_RotateForEntity(e);
        e.angles[0] = -e.angles[0];
        if (this.currententity.skin != null) {
            skin = this.currententity.skin;
        } else if (this.currententity.skinnum >= 32) {
            skin = this.currentmodel.skins[0];
        } else {
            skin = this.currentmodel.skins[this.currententity.skinnum];
            if (skin == null) {
                skin = this.currentmodel.skins[0];
            }
        }
        if (skin == null) {
            skin = this.r_notexture;
        }
        this.GL_Bind(skin.texnum);
        this.gl.glShadeModel(7425);
        this.GL_TexEnv(8448);
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glEnable(3042);
        }
        if (this.currententity.frame >= paliashdr.num_frames || this.currententity.frame < 0) {
            VID.Printf(0, "R_DrawAliasModel " + this.currentmodel.name + ": no such frame " + this.currententity.frame + '\n');
            this.currententity.frame = 0;
            this.currententity.oldframe = 0;
        }
        if (this.currententity.oldframe >= paliashdr.num_frames || this.currententity.oldframe < 0) {
            VID.Printf(0, "R_DrawAliasModel " + this.currentmodel.name + ": no such oldframe " + this.currententity.oldframe + '\n');
            this.currententity.frame = 0;
            this.currententity.oldframe = 0;
        }
        if (this.r_lerpmodels.value == 0.0f) {
            this.currententity.backlerp = 0.0f;
        }
        this.GL_DrawAliasFrameLerp(paliashdr, this.currententity.backlerp);
        this.GL_TexEnv(7681);
        this.gl.glShadeModel(7424);
        this.gl.glPopMatrix();
        if ((this.currententity.flags & 4) != 0 && this.r_lefthand.value == 1.0f) {
            this.gl.glMatrixMode(5889);
            this.gl.glPopMatrix();
            this.gl.glMatrixMode(5888);
            this.gl.glCullFace(1028);
        }
        if ((this.currententity.flags & 0x20) != 0) {
            this.gl.glDisable(3042);
        }
        if ((this.currententity.flags & 0x10) != 0) {
            this.gl.glDepthRange(this.gldepthmin, this.gldepthmax);
        }
        if (this.gl_shadows.value != 0.0f && (this.currententity.flags & 0x24) == 0) {
            this.gl.glPushMatrix();
            this.R_RotateForEntity(e);
            this.gl.glDisable(3553);
            this.gl.glEnable(3042);
            this.gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
            this.GL_DrawAliasShadow(paliashdr, this.currententity.frame);
            this.gl.glEnable(3553);
            this.gl.glDisable(3042);
            this.gl.glPopMatrix();
        }
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

