/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.basic;

import jake2.client.VID;
import jake2.client.entity_t;
import jake2.client.particle_t;
import jake2.client.refdef_t;
import jake2.game.Cmd;
import jake2.game.cplane_t;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.qfiles;
import jake2.qcommon.xcommand_t;
import jake2.render.Base;
import jake2.render.basic.Warp;
import jake2.render.glconfig_t;
import jake2.render.glstate_t;
import jake2.render.image_t;
import jake2.render.mleaf_t;
import jake2.render.model_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import jake2.util.Vargs;
import java.awt.Dimension;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public abstract class Main
extends Base {
    public static int[] d_8to24table;
    int c_visible_lightmaps;
    int c_visible_textures;
    int registration_sequence;
    boolean qglColorTableEXT = false;
    boolean qglSelectTextureSGIS = false;
    boolean qglActiveTextureARB = false;
    boolean qglPointParameterfEXT = false;
    boolean qglLockArraysEXT = false;
    boolean qglMTexCoord2fSGIS = false;
    boolean qwglSwapIntervalEXT = false;
    model_t r_worldmodel;
    float gldepthmin;
    float gldepthmax;
    glconfig_t gl_config = new glconfig_t();
    glstate_t gl_state = new glstate_t();
    image_t r_notexture;
    image_t r_particletexture;
    entity_t currententity;
    model_t currentmodel;
    cplane_t[] frustum = new cplane_t[]{new cplane_t(), new cplane_t(), new cplane_t(), new cplane_t()};
    int r_visframecount;
    int r_framecount;
    int c_brush_polys;
    int c_alias_polys;
    float[] v_blend = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    float[] vup = new float[]{0.0f, 0.0f, 0.0f};
    float[] vpn = new float[]{0.0f, 0.0f, 0.0f};
    float[] vright = new float[]{0.0f, 0.0f, 0.0f};
    float[] r_origin = new float[]{0.0f, 0.0f, 0.0f};
    FloatBuffer r_world_matrix = Lib.newFloatBuffer(16);
    float[] r_base_world_matrix = new float[16];
    refdef_t r_newrefdef = new refdef_t();
    int r_viewcluster;
    int r_viewcluster2;
    int r_oldviewcluster;
    int r_oldviewcluster2;
    cvar_t r_norefresh;
    cvar_t r_drawentities;
    cvar_t r_drawworld;
    cvar_t r_speeds;
    cvar_t r_fullbright;
    cvar_t r_novis;
    cvar_t r_nocull;
    cvar_t r_lerpmodels;
    cvar_t r_lefthand;
    cvar_t r_lightlevel;
    cvar_t gl_nosubimage;
    cvar_t gl_allow_software;
    cvar_t gl_vertex_arrays;
    cvar_t gl_particle_min_size;
    cvar_t gl_particle_max_size;
    cvar_t gl_particle_size;
    cvar_t gl_particle_att_a;
    cvar_t gl_particle_att_b;
    cvar_t gl_particle_att_c;
    cvar_t gl_ext_swapinterval;
    cvar_t gl_ext_palettedtexture;
    cvar_t gl_ext_multitexture;
    cvar_t gl_ext_pointparameters;
    cvar_t gl_ext_compiled_vertex_array;
    cvar_t gl_log;
    cvar_t gl_bitdepth;
    cvar_t gl_drawbuffer;
    cvar_t gl_driver;
    cvar_t gl_lightmap;
    cvar_t gl_shadows;
    cvar_t gl_mode;
    cvar_t gl_dynamic;
    cvar_t gl_monolightmap;
    cvar_t gl_modulate;
    cvar_t gl_nobind;
    cvar_t gl_round_down;
    cvar_t gl_picmip;
    cvar_t gl_skymip;
    cvar_t gl_showtris;
    cvar_t gl_ztrick;
    cvar_t gl_finish;
    cvar_t gl_clear;
    cvar_t gl_cull;
    cvar_t gl_polyblend;
    cvar_t gl_flashblend;
    cvar_t gl_playermip;
    cvar_t gl_saturatelighting;
    cvar_t gl_swapinterval;
    cvar_t gl_texturemode;
    cvar_t gl_texturealphamode;
    cvar_t gl_texturesolidmode;
    cvar_t gl_lockpvs;
    cvar_t gl_3dlabs_broken;
    cvar_t vid_gamma;
    cvar_t vid_ref;
    int trickframe = 0;
    float[] r_turbsin = new float[256];
    int[] r_rawpalette = new int[256];
    static final int NUM_BEAM_SEGS = 6;
    float[][] start_points = new float[6][3];
    float[][] end_points = new float[6][3];
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract void Draw_GetPalette();

    abstract void GL_ImageList_f();

    public abstract void GL_ScreenShot_f();

    abstract void GL_SetTexturePalette(int[] var1);

    abstract void GL_Strings_f();

    abstract void Mod_Modellist_f();

    abstract mleaf_t Mod_PointInLeaf(float[] var1, model_t var2);

    abstract void GL_SetDefaultState();

    abstract void GL_InitImages();

    abstract void Mod_Init();

    abstract void R_InitParticleTexture();

    abstract void R_DrawAliasModel(entity_t var1);

    abstract void R_DrawBrushModel(entity_t var1);

    abstract void Draw_InitLocal();

    abstract void R_LightPoint(float[] var1, float[] var2);

    abstract void R_PushDlights();

    abstract void R_MarkLeaves();

    abstract void R_DrawWorld();

    abstract void R_RenderDlights();

    abstract void R_DrawAlphaSurfaces();

    abstract void Mod_FreeAll();

    abstract void GL_ShutdownImages();

    abstract void GL_Bind(int var1);

    abstract void GL_TexEnv(int var1);

    abstract void GL_TextureMode(String var1);

    abstract void GL_TextureAlphaMode(String var1);

    abstract void GL_TextureSolidMode(String var1);

    abstract void GL_UpdateSwapInterval();

    final boolean R_CullBox(float[] mins, float[] maxs) {
        if (!($assertionsDisabled || mins.length == 3 && maxs.length == 3)) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        if (this.r_nocull.value != 0.0f) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (Math3D.BoxOnPlaneSide(mins, maxs, this.frustum[i]) != 2) continue;
            return true;
        }
        return false;
    }

    final void R_RotateForEntity(entity_t e) {
        this.gl.glTranslatef(e.origin[0], e.origin[1], e.origin[2]);
        this.gl.glRotatef(e.angles[1], 0.0f, 0.0f, 1.0f);
        this.gl.glRotatef(-e.angles[0], 0.0f, 1.0f, 0.0f);
        this.gl.glRotatef(-e.angles[2], 1.0f, 0.0f, 0.0f);
    }

    void R_DrawSpriteModel(entity_t e) {
        float alpha = 1.0f;
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        qfiles.dsprite_t psprite = (qfiles.dsprite_t)this.currentmodel.extradata;
        e.frame %= psprite.numframes;
        qfiles.dsprframe_t frame = psprite.frames[e.frame];
        if ((e.flags & 0x20) != 0) {
            alpha = e.alpha;
        }
        if (alpha != 1.0f) {
            this.gl.glEnable(3042);
        }
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, alpha);
        this.GL_Bind(this.currentmodel.skins[e.frame].texnum);
        this.GL_TexEnv(8448);
        if ((double)alpha == 1.0) {
            this.gl.glEnable(3008);
        } else {
            this.gl.glDisable(3008);
        }
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(0.0f, 1.0f);
        Math3D.VectorMA(e.origin, -frame.origin_y, this.vup, point);
        Math3D.VectorMA(point, -frame.origin_x, this.vright, point);
        this.gl.glVertex3f(point[0], point[1], point[2]);
        this.gl.glTexCoord2f(0.0f, 0.0f);
        Math3D.VectorMA(e.origin, frame.height - frame.origin_y, this.vup, point);
        Math3D.VectorMA(point, -frame.origin_x, this.vright, point);
        this.gl.glVertex3f(point[0], point[1], point[2]);
        this.gl.glTexCoord2f(1.0f, 0.0f);
        Math3D.VectorMA(e.origin, frame.height - frame.origin_y, this.vup, point);
        Math3D.VectorMA(point, frame.width - frame.origin_x, this.vright, point);
        this.gl.glVertex3f(point[0], point[1], point[2]);
        this.gl.glTexCoord2f(1.0f, 1.0f);
        Math3D.VectorMA(e.origin, -frame.origin_y, this.vup, point);
        Math3D.VectorMA(point, frame.width - frame.origin_x, this.vright, point);
        this.gl.glVertex3f(point[0], point[1], point[2]);
        this.gl.glEnd();
        this.gl.glDisable(3008);
        this.GL_TexEnv(7681);
        if (alpha != 1.0f) {
            this.gl.glDisable(3042);
        }
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    void R_DrawNullModel() {
        int i;
        float[] shadelight = new float[]{0.0f, 0.0f, 0.0f};
        if ((this.currententity.flags & 8) != 0) {
            shadelight[2] = 0.0f;
            shadelight[1] = 0.0f;
            shadelight[0] = 0.0f;
            shadelight[2] = 0.8f;
        } else {
            this.R_LightPoint(this.currententity.origin, shadelight);
        }
        this.gl.glPushMatrix();
        this.R_RotateForEntity(this.currententity);
        this.gl.glDisable(3553);
        this.gl.glColor3f(shadelight[0], shadelight[1], shadelight[2]);
        this.gl.glBegin(6);
        this.gl.glVertex3f(0.0f, 0.0f, -16.0f);
        for (i = 0; i <= 4; ++i) {
            this.gl.glVertex3f((float)(16.0 * Math.cos((double)i * Math.PI / 2.0)), (float)(16.0 * Math.sin((double)i * Math.PI / 2.0)), 0.0f);
        }
        this.gl.glEnd();
        this.gl.glBegin(6);
        this.gl.glVertex3f(0.0f, 0.0f, 16.0f);
        for (i = 4; i >= 0; --i) {
            this.gl.glVertex3f((float)(16.0 * Math.cos((double)i * Math.PI / 2.0)), (float)(16.0 * Math.sin((double)i * Math.PI / 2.0)), 0.0f);
        }
        this.gl.glEnd();
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        this.gl.glPopMatrix();
        this.gl.glEnable(3553);
    }

    void R_DrawEntitiesOnList() {
        int i;
        if (this.r_drawentities.value == 0.0f) {
            return;
        }
        block10: for (i = 0; i < this.r_newrefdef.num_entities; ++i) {
            this.currententity = this.r_newrefdef.entities[i];
            if ((this.currententity.flags & 0x20) != 0) continue;
            if ((this.currententity.flags & 0x80) != 0) {
                this.R_DrawBeam(this.currententity);
                continue;
            }
            this.currentmodel = this.currententity.model;
            if (this.currentmodel == null) {
                this.R_DrawNullModel();
                continue;
            }
            switch (this.currentmodel.type) {
                case 3: {
                    this.R_DrawAliasModel(this.currententity);
                    continue block10;
                }
                case 1: {
                    this.R_DrawBrushModel(this.currententity);
                    continue block10;
                }
                case 2: {
                    this.R_DrawSpriteModel(this.currententity);
                    continue block10;
                }
                default: {
                    Com.Error(1, "Bad modeltype");
                }
            }
        }
        this.gl.glDepthMask(false);
        block11: for (i = 0; i < this.r_newrefdef.num_entities; ++i) {
            this.currententity = this.r_newrefdef.entities[i];
            if ((this.currententity.flags & 0x20) == 0) continue;
            if ((this.currententity.flags & 0x80) != 0) {
                this.R_DrawBeam(this.currententity);
                continue;
            }
            this.currentmodel = this.currententity.model;
            if (this.currentmodel == null) {
                this.R_DrawNullModel();
                continue;
            }
            switch (this.currentmodel.type) {
                case 3: {
                    this.R_DrawAliasModel(this.currententity);
                    continue block11;
                }
                case 1: {
                    this.R_DrawBrushModel(this.currententity);
                    continue block11;
                }
                case 2: {
                    this.R_DrawSpriteModel(this.currententity);
                    continue block11;
                }
                default: {
                    Com.Error(1, "Bad modeltype");
                }
            }
        }
        this.gl.glDepthMask(true);
    }

    void GL_DrawParticles(int num_particles) {
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorScale(this.vup, 1.5f, up);
        Math3D.VectorScale(this.vright, 1.5f, right);
        this.GL_Bind(this.r_particletexture.texnum);
        this.gl.glDepthMask(false);
        this.gl.glEnable(3042);
        this.GL_TexEnv(8448);
        this.gl.glBegin(4);
        FloatBuffer sourceVertices = particle_t.vertexArray;
        IntBuffer sourceColors = particle_t.colorArray;
        int j = 0;
        for (int i = 0; i < num_particles; ++i) {
            float origin_z;
            float scale;
            float origin_x = sourceVertices.get(j++);
            float origin_y = sourceVertices.get(j++);
            scale = (scale = (origin_x - this.r_origin[0]) * this.vpn[0] + (origin_y - this.r_origin[1]) * this.vpn[1] + ((origin_z = sourceVertices.get(j++)) - this.r_origin[2]) * this.vpn[2]) < 20.0f ? 1.0f : 1.0f + scale * 0.004f;
            int color = sourceColors.get(i);
            this.gl.glColor4ub((byte)(color >> 0 & 0xFF), (byte)(color >> 8 & 0xFF), (byte)(color >> 16 & 0xFF), (byte)(color >> 24 & 0xFF));
            this.gl.glTexCoord2f(0.0625f, 0.0625f);
            this.gl.glVertex3f(origin_x, origin_y, origin_z);
            this.gl.glTexCoord2f(1.0625f, 0.0625f);
            this.gl.glVertex3f(origin_x + up[0] * scale, origin_y + up[1] * scale, origin_z + up[2] * scale);
            this.gl.glTexCoord2f(0.0625f, 1.0625f);
            this.gl.glVertex3f(origin_x + right[0] * scale, origin_y + right[1] * scale, origin_z + right[2] * scale);
        }
        this.gl.glEnd();
        this.gl.glDisable(3042);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.gl.glDepthMask(true);
        this.GL_TexEnv(7681);
    }

    void R_DrawParticles() {
        if (this.gl_ext_pointparameters.value != 0.0f && this.qglPointParameterfEXT) {
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 0, particle_t.vertexArray);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, true, 0, particle_t.getColorAsByteBuffer());
            this.gl.glDepthMask(false);
            this.gl.glEnable(3042);
            this.gl.glDisable(3553);
            this.gl.glPointSize(this.gl_particle_size.value);
            this.gl.glDrawArrays(0, 0, this.r_newrefdef.num_particles);
            this.gl.glDisableClientState(32886);
            this.gl.glDisableClientState(32884);
            this.gl.glDisable(3042);
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.gl.glDepthMask(true);
            this.gl.glEnable(3553);
        } else {
            this.GL_DrawParticles(this.r_newrefdef.num_particles);
        }
    }

    void R_PolyBlend() {
        if (this.gl_polyblend.value == 0.0f) {
            return;
        }
        if (this.v_blend[3] == 0.0f) {
            return;
        }
        this.gl.glDisable(3008);
        this.gl.glEnable(3042);
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glLoadIdentity();
        this.gl.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        this.gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glColor4f(this.v_blend[0], this.v_blend[1], this.v_blend[2], this.v_blend[3]);
        this.gl.glBegin(7);
        this.gl.glVertex3f(10.0f, 100.0f, 100.0f);
        this.gl.glVertex3f(10.0f, -100.0f, 100.0f);
        this.gl.glVertex3f(10.0f, -100.0f, -100.0f);
        this.gl.glVertex3f(10.0f, 100.0f, -100.0f);
        this.gl.glEnd();
        this.gl.glDisable(3042);
        this.gl.glEnable(3553);
        this.gl.glEnable(3008);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    int SignbitsForPlane(cplane_t out) {
        int bits = 0;
        for (int j = 0; j < 3; ++j) {
            if (!(out.normal[j] < 0.0f)) continue;
            bits |= 1 << j;
        }
        return bits;
    }

    void R_SetFrustum() {
        Math3D.RotatePointAroundVector(this.frustum[0].normal, this.vup, this.vpn, -(90.0f - this.r_newrefdef.fov_x / 2.0f));
        Math3D.RotatePointAroundVector(this.frustum[1].normal, this.vup, this.vpn, 90.0f - this.r_newrefdef.fov_x / 2.0f);
        Math3D.RotatePointAroundVector(this.frustum[2].normal, this.vright, this.vpn, 90.0f - this.r_newrefdef.fov_y / 2.0f);
        Math3D.RotatePointAroundVector(this.frustum[3].normal, this.vright, this.vpn, -(90.0f - this.r_newrefdef.fov_y / 2.0f));
        for (int i = 0; i < 4; ++i) {
            this.frustum[i].type = (byte)5;
            this.frustum[i].dist = Math3D.DotProduct(this.r_origin, this.frustum[i].normal);
            this.frustum[i].signbits = (byte)this.SignbitsForPlane(this.frustum[i]);
        }
    }

    void R_SetupFrame() {
        ++this.r_framecount;
        Math3D.VectorCopy(this.r_newrefdef.vieworg, this.r_origin);
        Math3D.AngleVectors(this.r_newrefdef.viewangles, this.vpn, this.vright, this.vup);
        if ((this.r_newrefdef.rdflags & 2) == 0) {
            float[] temp;
            this.r_oldviewcluster = this.r_viewcluster;
            this.r_oldviewcluster2 = this.r_viewcluster2;
            mleaf_t leaf = this.Mod_PointInLeaf(this.r_origin, this.r_worldmodel);
            this.r_viewcluster = this.r_viewcluster2 = leaf.cluster;
            if (leaf.contents == 0) {
                temp = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.VectorCopy(this.r_origin, temp);
                temp[2] = temp[2] - 16.0f;
                leaf = this.Mod_PointInLeaf(temp, this.r_worldmodel);
                if ((leaf.contents & 1) == 0 && leaf.cluster != this.r_viewcluster2) {
                    this.r_viewcluster2 = leaf.cluster;
                }
            } else {
                temp = new float[]{0.0f, 0.0f, 0.0f};
                Math3D.VectorCopy(this.r_origin, temp);
                temp[2] = temp[2] + 16.0f;
                leaf = this.Mod_PointInLeaf(temp, this.r_worldmodel);
                if ((leaf.contents & 1) == 0 && leaf.cluster != this.r_viewcluster2) {
                    this.r_viewcluster2 = leaf.cluster;
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.v_blend[i] = this.r_newrefdef.blend[i];
        }
        this.c_brush_polys = 0;
        this.c_alias_polys = 0;
        if ((this.r_newrefdef.rdflags & 2) != 0) {
            this.gl.glEnable(3089);
            this.gl.glClearColor(0.3f, 0.3f, 0.3f, 1.0f);
            this.gl.glScissor(this.r_newrefdef.x, vid.getHeight() - this.r_newrefdef.height - this.r_newrefdef.y, this.r_newrefdef.width, this.r_newrefdef.height);
            this.gl.glClear(16640);
            this.gl.glClearColor(1.0f, 0.0f, 0.5f, 0.5f);
            this.gl.glDisable(3089);
        }
    }

    void MYgluPerspective(double fovy, double aspect, double zNear, double zFar) {
        double ymax = zNear * Math.tan(fovy * Math.PI / 360.0);
        double ymin = -ymax;
        double xmin = ymin * aspect;
        double xmax = ymax * aspect;
        this.gl.glFrustum(xmin += (double)(-(2.0f * this.gl_state.camera_separation)) / zNear, xmax += (double)(-(2.0f * this.gl_state.camera_separation)) / zNear, ymin, ymax, zNear, zFar);
    }

    void R_SetupGL() {
        int x = (int)Math.floor(this.r_newrefdef.x * vid.getWidth() / vid.getWidth());
        int x2 = (int)Math.ceil((this.r_newrefdef.x + this.r_newrefdef.width) * vid.getWidth() / vid.getWidth());
        int y = (int)Math.floor(vid.getHeight() - this.r_newrefdef.y * vid.getHeight() / vid.getHeight());
        int y2 = (int)Math.ceil(vid.getHeight() - (this.r_newrefdef.y + this.r_newrefdef.height) * vid.getHeight() / vid.getHeight());
        int w = x2 - x;
        int h = y - y2;
        this.gl.glViewport(x, y2, w, h);
        float screenaspect = (float)this.r_newrefdef.width / (float)this.r_newrefdef.height;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.MYgluPerspective(this.r_newrefdef.fov_y, screenaspect, 4.0, 4096.0);
        this.gl.glCullFace(1028);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        this.gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glRotatef(-this.r_newrefdef.viewangles[2], 1.0f, 0.0f, 0.0f);
        this.gl.glRotatef(-this.r_newrefdef.viewangles[0], 0.0f, 1.0f, 0.0f);
        this.gl.glRotatef(-this.r_newrefdef.viewangles[1], 0.0f, 0.0f, 1.0f);
        this.gl.glTranslatef(-this.r_newrefdef.vieworg[0], -this.r_newrefdef.vieworg[1], -this.r_newrefdef.vieworg[2]);
        this.gl.glGetFloat(2982, this.r_world_matrix);
        this.r_world_matrix.clear();
        if (this.gl_cull.value != 0.0f) {
            this.gl.glEnable(2884);
        } else {
            this.gl.glDisable(2884);
        }
        this.gl.glDisable(3042);
        this.gl.glDisable(3008);
        this.gl.glEnable(2929);
    }

    void R_Clear() {
        if (this.gl_ztrick.value != 0.0f) {
            if (this.gl_clear.value != 0.0f) {
                this.gl.glClear(16384);
            }
            ++this.trickframe;
            if ((this.trickframe & 1) != 0) {
                this.gldepthmin = 0.0f;
                this.gldepthmax = 0.49999f;
                this.gl.glDepthFunc(515);
            } else {
                this.gldepthmin = 1.0f;
                this.gldepthmax = 0.5f;
                this.gl.glDepthFunc(518);
            }
        } else {
            if (this.gl_clear.value != 0.0f) {
                this.gl.glClear(16640);
            } else {
                this.gl.glClear(256);
            }
            this.gldepthmin = 0.0f;
            this.gldepthmax = 1.0f;
            this.gl.glDepthFunc(515);
        }
        this.gl.glDepthRange(this.gldepthmin, this.gldepthmax);
    }

    void R_Flash() {
        this.R_PolyBlend();
    }

    void R_RenderView(refdef_t fd) {
        if (this.r_norefresh.value != 0.0f) {
            return;
        }
        this.r_newrefdef = fd;
        if (this.r_newrefdef == null) {
            Com.Error(1, "R_RenderView: refdef_t fd is null");
        }
        if (this.r_worldmodel == null && (this.r_newrefdef.rdflags & 2) == 0) {
            Com.Error(1, "R_RenderView: NULL worldmodel");
        }
        if (this.r_speeds.value != 0.0f) {
            this.c_brush_polys = 0;
            this.c_alias_polys = 0;
        }
        this.R_PushDlights();
        if (this.gl_finish.value != 0.0f) {
            this.gl.glFinish();
        }
        this.R_SetupFrame();
        this.R_SetFrustum();
        this.R_SetupGL();
        this.R_MarkLeaves();
        this.R_DrawWorld();
        this.R_DrawEntitiesOnList();
        this.R_RenderDlights();
        this.R_DrawParticles();
        this.R_DrawAlphaSurfaces();
        this.R_Flash();
        if (this.r_speeds.value != 0.0f) {
            VID.Printf(0, "%4i wpoly %4i epoly %i tex %i lmaps\n", new Vargs(4).add(this.c_brush_polys).add(this.c_alias_polys).add(this.c_visible_textures).add(this.c_visible_lightmaps));
        }
    }

    void R_SetGL2D() {
        this.gl.glViewport(0, 0, vid.getWidth(), vid.getHeight());
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, vid.getWidth(), vid.getHeight(), 0.0, -99999.0, 99999.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glDisable(2884);
        this.gl.glDisable(3042);
        this.gl.glEnable(3008);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    void R_SetLightLevel() {
        float[] shadelight = new float[]{0.0f, 0.0f, 0.0f};
        if ((this.r_newrefdef.rdflags & 2) != 0) {
            return;
        }
        this.R_LightPoint(this.r_newrefdef.vieworg, shadelight);
        this.r_lightlevel.value = shadelight[0] > shadelight[1] ? (shadelight[0] > shadelight[2] ? 150.0f * shadelight[0] : 150.0f * shadelight[2]) : (shadelight[1] > shadelight[2] ? 150.0f * shadelight[1] : 150.0f * shadelight[2]);
    }

    public void R_RenderFrame(refdef_t fd) {
        this.R_RenderView(fd);
        this.R_SetLightLevel();
        this.R_SetGL2D();
    }

    protected void R_Register() {
        this.r_lefthand = Cvar.Get("hand", "0", 3);
        this.r_norefresh = Cvar.Get("r_norefresh", "0", 0);
        this.r_fullbright = Cvar.Get("r_fullbright", "0", 0);
        this.r_drawentities = Cvar.Get("r_drawentities", "1", 0);
        this.r_drawworld = Cvar.Get("r_drawworld", "1", 0);
        this.r_novis = Cvar.Get("r_novis", "0", 0);
        this.r_nocull = Cvar.Get("r_nocull", "0", 0);
        this.r_lerpmodels = Cvar.Get("r_lerpmodels", "1", 0);
        this.r_speeds = Cvar.Get("r_speeds", "0", 0);
        this.r_lightlevel = Cvar.Get("r_lightlevel", "1", 0);
        this.gl_nosubimage = Cvar.Get("gl_nosubimage", "0", 0);
        this.gl_allow_software = Cvar.Get("gl_allow_software", "0", 0);
        this.gl_particle_min_size = Cvar.Get("gl_particle_min_size", "2", 1);
        this.gl_particle_max_size = Cvar.Get("gl_particle_max_size", "40", 1);
        this.gl_particle_size = Cvar.Get("gl_particle_size", "40", 1);
        this.gl_particle_att_a = Cvar.Get("gl_particle_att_a", "0.01", 1);
        this.gl_particle_att_b = Cvar.Get("gl_particle_att_b", "0.0", 1);
        this.gl_particle_att_c = Cvar.Get("gl_particle_att_c", "0.01", 1);
        this.gl_modulate = Cvar.Get("gl_modulate", "1.5", 1);
        this.gl_log = Cvar.Get("gl_log", "0", 0);
        this.gl_bitdepth = Cvar.Get("gl_bitdepth", "0", 0);
        this.gl_mode = Cvar.Get("gl_mode", "1", 1);
        this.gl_lightmap = Cvar.Get("gl_lightmap", "0", 0);
        this.gl_shadows = Cvar.Get("gl_shadows", "0", 1);
        this.gl_dynamic = Cvar.Get("gl_dynamic", "1", 0);
        this.gl_nobind = Cvar.Get("gl_nobind", "0", 0);
        this.gl_round_down = Cvar.Get("gl_round_down", "1", 0);
        this.gl_picmip = Cvar.Get("gl_picmip", "0", 0);
        this.gl_skymip = Cvar.Get("gl_skymip", "0", 0);
        this.gl_showtris = Cvar.Get("gl_showtris", "0", 0);
        this.gl_ztrick = Cvar.Get("gl_ztrick", "0", 0);
        this.gl_finish = Cvar.Get("gl_finish", "0", 1);
        this.gl_clear = Cvar.Get("gl_clear", "0", 0);
        this.gl_cull = Cvar.Get("gl_cull", "1", 0);
        this.gl_polyblend = Cvar.Get("gl_polyblend", "1", 0);
        this.gl_flashblend = Cvar.Get("gl_flashblend", "0", 0);
        this.gl_playermip = Cvar.Get("gl_playermip", "0", 0);
        this.gl_monolightmap = Cvar.Get("gl_monolightmap", "0", 0);
        this.gl_driver = Cvar.Get("gl_driver", "opengl32", 1);
        this.gl_texturemode = Cvar.Get("gl_texturemode", "GL_LINEAR_MIPMAP_NEAREST", 1);
        this.gl_texturealphamode = Cvar.Get("gl_texturealphamode", "default", 1);
        this.gl_texturesolidmode = Cvar.Get("gl_texturesolidmode", "default", 1);
        this.gl_lockpvs = Cvar.Get("gl_lockpvs", "0", 0);
        this.gl_vertex_arrays = Cvar.Get("gl_vertex_arrays", "0", 1);
        this.gl_ext_swapinterval = Cvar.Get("gl_ext_swapinterval", "1", 1);
        this.gl_ext_palettedtexture = Cvar.Get("gl_ext_palettedtexture", "0", 1);
        this.gl_ext_multitexture = Cvar.Get("gl_ext_multitexture", "1", 1);
        this.gl_ext_pointparameters = Cvar.Get("gl_ext_pointparameters", "1", 1);
        this.gl_ext_compiled_vertex_array = Cvar.Get("gl_ext_compiled_vertex_array", "1", 1);
        this.gl_drawbuffer = Cvar.Get("gl_drawbuffer", "GL_BACK", 0);
        this.gl_swapinterval = Cvar.Get("gl_swapinterval", "1", 1);
        this.gl_saturatelighting = Cvar.Get("gl_saturatelighting", "0", 0);
        this.gl_3dlabs_broken = Cvar.Get("gl_3dlabs_broken", "1", 1);
        this.vid_fullscreen = Cvar.Get("vid_fullscreen", "0", 1);
        this.vid_gamma = Cvar.Get("vid_gamma", "1.0", 1);
        this.vid_ref = Cvar.Get("vid_ref", "jogl", 1);
        Cmd.AddCommand("imagelist", new xcommand_t(){

            public void execute() {
                Main.this.GL_ImageList_f();
            }
        });
        Cmd.AddCommand("screenshot", new xcommand_t(){

            public void execute() {
                Main.this.glImpl.screenshot();
            }
        });
        Cmd.AddCommand("modellist", new xcommand_t(){

            public void execute() {
                Main.this.Mod_Modellist_f();
            }
        });
        Cmd.AddCommand("gl_strings", new xcommand_t(){

            public void execute() {
                Main.this.GL_Strings_f();
            }
        });
    }

    protected boolean R_SetMode() {
        boolean fullscreen = this.vid_fullscreen.value > 0.0f;
        this.vid_fullscreen.modified = false;
        this.gl_mode.modified = false;
        Dimension dim = new Dimension(vid.getWidth(), vid.getHeight());
        int err = this.glImpl.setMode(dim, (int)this.gl_mode.value, fullscreen);
        if (err == 0) {
            this.gl_state.prev_mode = (int)this.gl_mode.value;
        } else {
            if (err == 1) {
                Cvar.SetValue("vid_fullscreen", 0);
                this.vid_fullscreen.modified = false;
                VID.Printf(0, "ref_gl::R_SetMode() - fullscreen unavailable in this mode\n");
                err = this.glImpl.setMode(dim, (int)this.gl_mode.value, false);
                if (err == 0) {
                    return true;
                }
            } else if (err == 2) {
                Cvar.SetValue("gl_mode", this.gl_state.prev_mode);
                this.gl_mode.modified = false;
                VID.Printf(0, "ref_gl::R_SetMode() - invalid mode\n");
            }
            if ((err = this.glImpl.setMode(dim, this.gl_state.prev_mode, false)) != 0) {
                VID.Printf(0, "ref_gl::R_SetMode() - could not revert to safe mode\n");
                return false;
            }
        }
        return true;
    }

    protected boolean R_Init() {
        return this.R_Init(0, 0);
    }

    public boolean R_Init(int vid_xpos, int vid_ypos) {
        if (!$assertionsDisabled && Warp.SIN.length != 256) {
            throw new AssertionError((Object)"warpsin table bug");
        }
        for (int j = 0; j < 256; ++j) {
            this.r_turbsin[j] = Warp.SIN[j] * 0.5f;
        }
        VID.Printf(0, "ref_gl version: GL 0.01\n");
        this.Draw_GetPalette();
        this.R_Register();
        this.gl_state.prev_mode = 3;
        if (!this.R_SetMode()) {
            VID.Printf(0, "ref_gl::R_Init() - could not R_SetMode()\n");
            return false;
        }
        return true;
    }

    public boolean R_Init2() {
        VID.MenuInit();
        this.gl_config.vendor_string = this.gl.glGetString(7936);
        VID.Printf(0, "GL_VENDOR: " + this.gl_config.vendor_string + '\n');
        this.gl_config.renderer_string = this.gl.glGetString(7937);
        VID.Printf(0, "GL_RENDERER: " + this.gl_config.renderer_string + '\n');
        this.gl_config.version_string = this.gl.glGetString(7938);
        VID.Printf(0, "GL_VERSION: " + this.gl_config.version_string + '\n');
        this.gl_config.extensions_string = this.gl.glGetString(7939);
        VID.Printf(0, "GL_EXTENSIONS: " + this.gl_config.extensions_string + '\n');
        this.gl_config.parseOpenGLVersion();
        String renderer_buffer = this.gl_config.renderer_string.toLowerCase();
        String vendor_buffer = this.gl_config.vendor_string.toLowerCase();
        this.gl_config.renderer = renderer_buffer.indexOf("voodoo") >= 0 ? (renderer_buffer.indexOf("rush") < 0 ? 1 : 4) : (vendor_buffer.indexOf("sgi") >= 0 ? 0xF00000 : (renderer_buffer.indexOf("permedia") >= 0 ? 256 : (renderer_buffer.indexOf("glint") >= 0 ? 512 : (renderer_buffer.indexOf("glzicd") >= 0 ? 4096 : (renderer_buffer.indexOf("gdi") >= 0 ? 0x1000000 : (renderer_buffer.indexOf("pcx2") >= 0 ? 32 : (renderer_buffer.indexOf("verite") >= 0 ? 0x1C0000 : Integer.MIN_VALUE)))))));
        String monolightmap = this.gl_monolightmap.string.toUpperCase();
        if (monolightmap.length() < 2 || monolightmap.charAt(1) != 'F') {
            if (this.gl_config.renderer == 256) {
                Cvar.Set("gl_monolightmap", "A");
                VID.Printf(0, "...using gl_monolightmap 'a'\n");
            } else if ((this.gl_config.renderer & 0x70) != 0) {
                Cvar.Set("gl_monolightmap", "0");
            } else {
                Cvar.Set("gl_monolightmap", "0");
            }
        }
        if ((this.gl_config.renderer & 0x70) != 0) {
            Cvar.Set("scr_drawall", "1");
        } else {
            Cvar.Set("scr_drawall", "0");
        }
        Cvar.SetValue("gl_finish", 1);
        if (this.gl_config.renderer == 0x1000000) {
            Cvar.SetValue("gl_finish", 1);
        }
        this.gl_config.allow_cds = (this.gl_config.renderer & 0xF00) != 0 ? this.gl_3dlabs_broken.value == 0.0f : true;
        if (this.gl_config.allow_cds) {
            VID.Printf(0, "...allowing CDS\n");
        } else {
            VID.Printf(0, "...disabling CDS\n");
        }
        if (this.gl_config.extensions_string.indexOf("GL_EXT_compiled_vertex_array") >= 0 || this.gl_config.extensions_string.indexOf("GL_SGI_compiled_vertex_array") >= 0) {
            VID.Printf(0, "...enabling GL_EXT_compiled_vertex_array\n");
            this.qglLockArraysEXT = this.gl_ext_compiled_vertex_array.value != 0.0f;
        } else {
            VID.Printf(0, "...GL_EXT_compiled_vertex_array not found\n");
        }
        if (this.gl_config.extensions_string.indexOf("WGL_EXT_swap_control") >= 0) {
            this.qwglSwapIntervalEXT = true;
            VID.Printf(0, "...enabling WGL_EXT_swap_control\n");
        } else {
            this.qwglSwapIntervalEXT = false;
            VID.Printf(0, "...WGL_EXT_swap_control not found\n");
        }
        if (this.gl_config.extensions_string.indexOf("GL_EXT_point_parameters") >= 0) {
            if (this.gl_ext_pointparameters.value != 0.0f) {
                this.qglPointParameterfEXT = true;
                VID.Printf(0, "...using GL_EXT_point_parameters\n");
            } else {
                VID.Printf(0, "...ignoring GL_EXT_point_parameters\n");
            }
        } else {
            VID.Printf(0, "...GL_EXT_point_parameters not found\n");
        }
        if (!this.qglColorTableEXT && this.gl_config.extensions_string.indexOf("GL_EXT_paletted_texture") >= 0 && this.gl_config.extensions_string.indexOf("GL_EXT_shared_texture_palette") >= 0) {
            if (this.gl_ext_palettedtexture.value != 0.0f) {
                VID.Printf(0, "...using GL_EXT_shared_texture_palette\n");
                this.qglColorTableEXT = false;
            } else {
                VID.Printf(0, "...ignoring GL_EXT_shared_texture_palette\n");
                this.qglColorTableEXT = false;
            }
        } else {
            VID.Printf(0, "...GL_EXT_shared_texture_palette not found\n");
        }
        if (this.gl_config.extensions_string.indexOf("GL_ARB_multitexture") >= 0) {
            if (this.gl_ext_multitexture.value != 0.0f) {
                VID.Printf(0, "...using GL_ARB_multitexture\n");
                this.qglActiveTextureARB = true;
                this.qglMTexCoord2fSGIS = true;
                Cvar.SetValue("r_fullbright", 1);
            } else {
                VID.Printf(0, "...ignoring GL_ARB_multitexture\n");
                Cvar.SetValue("r_fullbright", 0);
            }
        } else {
            VID.Printf(0, "...GL_ARB_multitexture not found\n");
            Cvar.SetValue("r_fullbright", 0);
        }
        if (this.gl_config.extensions_string.indexOf("GL_SGIS_multitexture") >= 0) {
            if (this.qglActiveTextureARB) {
                VID.Printf(0, "...GL_SGIS_multitexture deprecated in favor of ARB_multitexture\n");
                Cvar.SetValue("r_fullbright", 1);
            } else if (this.gl_ext_multitexture.value != 0.0f) {
                VID.Printf(0, "...using GL_SGIS_multitexture\n");
                this.qglSelectTextureSGIS = true;
                this.qglMTexCoord2fSGIS = true;
                Cvar.SetValue("r_fullbright", 1);
            } else {
                VID.Printf(0, "...ignoring GL_SGIS_multitexture\n");
                Cvar.SetValue("r_fullbright", 0);
            }
        } else {
            VID.Printf(0, "...GL_SGIS_multitexture not found\n");
            if (!this.qglActiveTextureARB) {
                Cvar.SetValue("r_fullbright", 0);
            }
        }
        this.GL_SetDefaultState();
        this.GL_InitImages();
        this.Mod_Init();
        this.R_InitParticleTexture();
        this.Draw_InitLocal();
        int err = this.gl.glGetError();
        if (err != 0) {
            VID.Printf(0, "glGetError() = 0x%x\n\t%s\n", new Vargs(2).add(err).add("" + this.gl.glGetString(err)));
        }
        return true;
    }

    public void R_Shutdown() {
        Cmd.RemoveCommand("modellist");
        Cmd.RemoveCommand("screenshot");
        Cmd.RemoveCommand("imagelist");
        Cmd.RemoveCommand("gl_strings");
        this.Mod_FreeAll();
        this.GL_ShutdownImages();
        this.glImpl.shutdown();
    }

    public void R_BeginFrame(float camera_separation) {
        vid.update();
        this.gl_state.camera_separation = camera_separation;
        if (this.gl_mode.modified || this.vid_fullscreen.modified) {
            cvar_t ref = Cvar.Get("vid_ref", "lwjgl", 0);
            ref.modified = true;
        }
        if (this.gl_log.modified) {
            this.glImpl.enableLogging(this.gl_log.value != 0.0f);
            this.gl_log.modified = false;
        }
        if (this.gl_log.value != 0.0f) {
            this.glImpl.logNewFrame();
        }
        if (this.vid_gamma.modified) {
            this.vid_gamma.modified = false;
            if ((this.gl_config.renderer & 1) != 0) {
                VID.Printf(1, "gamma anpassung fuer VOODOO nicht gesetzt");
            }
        }
        this.glImpl.beginFrame(camera_separation);
        this.gl.glViewport(0, 0, vid.getWidth(), vid.getHeight());
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, vid.getWidth(), vid.getHeight(), 0.0, -99999.0, 99999.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glDisable(2884);
        this.gl.glDisable(3042);
        this.gl.glEnable(3008);
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.gl_drawbuffer.modified) {
            this.gl_drawbuffer.modified = false;
            if (this.gl_state.camera_separation == 0.0f || !this.gl_state.stereo_enabled) {
                if (this.gl_drawbuffer.string.equalsIgnoreCase("GL_FRONT")) {
                    this.gl.glDrawBuffer(1028);
                } else {
                    this.gl.glDrawBuffer(1029);
                }
            }
        }
        if (this.gl_texturemode.modified) {
            this.GL_TextureMode(this.gl_texturemode.string);
            this.gl_texturemode.modified = false;
        }
        if (this.gl_texturealphamode.modified) {
            this.GL_TextureAlphaMode(this.gl_texturealphamode.string);
            this.gl_texturealphamode.modified = false;
        }
        if (this.gl_texturesolidmode.modified) {
            this.GL_TextureSolidMode(this.gl_texturesolidmode.string);
            this.gl_texturesolidmode.modified = false;
        }
        this.GL_UpdateSwapInterval();
        this.R_Clear();
    }

    public void R_SetPalette(byte[] palette) {
        int color = 0;
        if (palette != null) {
            int j = 0;
            for (int i = 0; i < 256; ++i) {
                color = (palette[j++] & 0xFF) << 0;
                color |= (palette[j++] & 0xFF) << 8;
                color |= (palette[j++] & 0xFF) << 16;
                this.r_rawpalette[i] = color |= 0xFF000000;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                this.r_rawpalette[i] = d_8to24table[i] | 0xFF000000;
            }
        }
        this.GL_SetTexturePalette(this.r_rawpalette);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(16384);
        this.gl.glClearColor(1.0f, 0.0f, 0.5f, 0.5f);
    }

    void R_DrawBeam(entity_t e) {
        int i;
        float[] perpvec = new float[]{0.0f, 0.0f, 0.0f};
        float[] direction = new float[]{0.0f, 0.0f, 0.0f};
        float[] normalized_direction = new float[]{0.0f, 0.0f, 0.0f};
        float[] oldorigin = new float[]{0.0f, 0.0f, 0.0f};
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        oldorigin[0] = e.oldorigin[0];
        oldorigin[1] = e.oldorigin[1];
        oldorigin[2] = e.oldorigin[2];
        origin[0] = e.origin[0];
        origin[1] = e.origin[1];
        origin[2] = e.origin[2];
        normalized_direction[0] = direction[0] = oldorigin[0] - origin[0];
        normalized_direction[1] = direction[1] = oldorigin[1] - origin[1];
        normalized_direction[2] = direction[2] = oldorigin[2] - origin[2];
        if (Math3D.VectorNormalize(normalized_direction) == 0.0f) {
            return;
        }
        Math3D.PerpendicularVector(perpvec, normalized_direction);
        Math3D.VectorScale(perpvec, e.frame / 2, perpvec);
        for (i = 0; i < 6; ++i) {
            Math3D.RotatePointAroundVector(this.start_points[i], normalized_direction, perpvec, 60.0f * (float)i);
            Math3D.VectorAdd(this.start_points[i], origin, this.start_points[i]);
            Math3D.VectorAdd(this.start_points[i], direction, this.end_points[i]);
        }
        this.gl.glDisable(3553);
        this.gl.glEnable(3042);
        this.gl.glDepthMask(false);
        float r = d_8to24table[e.skinnum & 0xFF] & 0xFF;
        float g = d_8to24table[e.skinnum & 0xFF] >> 8 & 0xFF;
        float b = d_8to24table[e.skinnum & 0xFF] >> 16 & 0xFF;
        this.gl.glColor4f(r *= 0.003921569f, g *= 0.003921569f, b *= 0.003921569f, e.alpha);
        this.gl.glBegin(5);
        for (i = 0; i < 6; ++i) {
            float[] v = this.start_points[i];
            this.gl.glVertex3f(v[0], v[1], v[2]);
            v = this.end_points[i];
            this.gl.glVertex3f(v[0], v[1], v[2]);
            v = this.start_points[(i + 1) % 6];
            this.gl.glVertex3f(v[0], v[1], v[2]);
            v = this.end_points[(i + 1) % 6];
            this.gl.glVertex3f(v[0], v[1], v[2]);
        }
        this.gl.glEnd();
        this.gl.glEnable(3553);
        this.gl.glDisable(3042);
        this.gl.glDepthMask(true);
    }

    static {
        $assertionsDisabled = !Main.class.desiredAssertionStatus();
        d_8to24table = new int[256];
    }
}

