/*
 * Decompiled with CFR 0.152.
 */
package jake2.render.basic;

import jake2.client.VID;
import jake2.qcommon.Com;
import jake2.render.basic.Image;
import jake2.render.image_t;
import jake2.util.Lib;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public abstract class Draw
extends Image {
    IntBuffer image32 = Lib.newIntBuffer(65536);
    ByteBuffer image8 = Lib.newByteBuffer(65536);

    void Draw_InitLocal() {
        this.draw_chars = this.GL_FindImage("pics/conchars.pcx", 3);
        this.GL_Bind(this.draw_chars.texnum);
        this.gl.glTexParameterf(3553, 10241, 9728.0f);
        this.gl.glTexParameterf(3553, 10240, 9728.0f);
    }

    public void Draw_Char(int x, int y, int num) {
        if (((num &= 0xFF) & 0x7F) == 32) {
            return;
        }
        if (y <= -8) {
            return;
        }
        int row = num >> 4;
        int col = num & 0xF;
        float frow = (float)row * 0.0625f;
        float fcol = (float)col * 0.0625f;
        float size = 0.0625f;
        this.GL_Bind(this.draw_chars.texnum);
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(fcol, frow);
        this.gl.glVertex2f(x, y);
        this.gl.glTexCoord2f(fcol + size, frow);
        this.gl.glVertex2f(x + 8, y);
        this.gl.glTexCoord2f(fcol + size, frow + size);
        this.gl.glVertex2f(x + 8, y + 8);
        this.gl.glTexCoord2f(fcol, frow + size);
        this.gl.glVertex2f(x, y + 8);
        this.gl.glEnd();
    }

    public image_t Draw_FindPic(String name) {
        image_t image = null;
        if (!name.startsWith("/") && !name.startsWith("\\")) {
            String fullname = "pics/" + name + ".pcx";
            image = this.GL_FindImage(fullname, 3);
        } else {
            image = this.GL_FindImage(name.substring(1), 3);
        }
        return image;
    }

    public void Draw_GetPicSize(Dimension dim, String pic) {
        image_t image = this.Draw_FindPic(pic);
        dim.width = image != null ? image.width : -1;
        dim.height = image != null ? image.height : -1;
    }

    public void Draw_StretchPic(int x, int y, int w, int h, String pic) {
        image_t image = this.Draw_FindPic(pic);
        if (image == null) {
            VID.Printf(0, "Can't find pic: " + pic + '\n');
            return;
        }
        if (this.scrap_dirty) {
            this.Scrap_Upload();
        }
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glDisable(3008);
        }
        this.GL_Bind(image.texnum);
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(image.sl, image.tl);
        this.gl.glVertex2f(x, y);
        this.gl.glTexCoord2f(image.sh, image.tl);
        this.gl.glVertex2f(x + w, y);
        this.gl.glTexCoord2f(image.sh, image.th);
        this.gl.glVertex2f(x + w, y + h);
        this.gl.glTexCoord2f(image.sl, image.th);
        this.gl.glVertex2f(x, y + h);
        this.gl.glEnd();
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glEnable(3008);
        }
    }

    public void Draw_Pic(int x, int y, String pic) {
        image_t image = this.Draw_FindPic(pic);
        if (image == null) {
            VID.Printf(0, "Can't find pic: " + pic + '\n');
            return;
        }
        if (this.scrap_dirty) {
            this.Scrap_Upload();
        }
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glDisable(3008);
        }
        this.GL_Bind(image.texnum);
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(image.sl, image.tl);
        this.gl.glVertex2f(x, y);
        this.gl.glTexCoord2f(image.sh, image.tl);
        this.gl.glVertex2f(x + image.width, y);
        this.gl.glTexCoord2f(image.sh, image.th);
        this.gl.glVertex2f(x + image.width, y + image.height);
        this.gl.glTexCoord2f(image.sl, image.th);
        this.gl.glVertex2f(x, y + image.height);
        this.gl.glEnd();
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glEnable(3008);
        }
    }

    public void Draw_TileClear(int x, int y, int w, int h, String pic) {
        image_t image = this.Draw_FindPic(pic);
        if (image == null) {
            VID.Printf(0, "Can't find pic: " + pic + '\n');
            return;
        }
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glDisable(3008);
        }
        this.GL_Bind(image.texnum);
        this.gl.glBegin(7);
        this.gl.glTexCoord2f((float)x / 64.0f, (float)y / 64.0f);
        this.gl.glVertex2f(x, y);
        this.gl.glTexCoord2f((float)(x + w) / 64.0f, (float)y / 64.0f);
        this.gl.glVertex2f(x + w, y);
        this.gl.glTexCoord2f((float)(x + w) / 64.0f, (float)(y + h) / 64.0f);
        this.gl.glVertex2f(x + w, y + h);
        this.gl.glTexCoord2f((float)x / 64.0f, (float)(y + h) / 64.0f);
        this.gl.glVertex2f(x, y + h);
        this.gl.glEnd();
        if (!(this.gl_config.renderer != 0x1000000 && (this.gl_config.renderer & 0x1C0000) == 0 || image.has_alpha)) {
            this.gl.glEnable(3008);
        }
    }

    public void Draw_Fill(int x, int y, int w, int h, int colorIndex) {
        if (colorIndex > 255) {
            Com.Error(0, "Draw_Fill: bad color");
        }
        this.gl.glDisable(3553);
        int color = d_8to24table[colorIndex];
        this.gl.glColor3ub((byte)(color >> 0 & 0xFF), (byte)(color >> 8 & 0xFF), (byte)(color >> 16 & 0xFF));
        this.gl.glBegin(7);
        this.gl.glVertex2f(x, y);
        this.gl.glVertex2f(x + w, y);
        this.gl.glVertex2f(x + w, y + h);
        this.gl.glVertex2f(x, y + h);
        this.gl.glEnd();
        this.gl.glColor3f(1.0f, 1.0f, 1.0f);
        this.gl.glEnable(3553);
    }

    public void Draw_FadeScreen() {
        this.gl.glEnable(3042);
        this.gl.glDisable(3553);
        this.gl.glColor4f(0.0f, 0.0f, 0.0f, 0.8f);
        this.gl.glBegin(7);
        this.gl.glVertex2f(0.0f, 0.0f);
        this.gl.glVertex2f(vid.getWidth(), 0.0f);
        this.gl.glVertex2f(vid.getWidth(), vid.getHeight());
        this.gl.glVertex2f(0.0f, vid.getHeight());
        this.gl.glEnd();
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.gl.glEnable(3553);
        this.gl.glDisable(3042);
    }

    public void Draw_StretchRaw(int x, int y, int w, int h, int cols, int rows, byte[] data) {
        int trows;
        float hscale;
        this.GL_Bind(0);
        if (rows <= 256) {
            hscale = 1.0f;
            trows = rows;
        } else {
            hscale = (float)rows / 256.0f;
            trows = 256;
        }
        float t = (float)rows * hscale / 256.0f;
        if (!this.qglColorTableEXT) {
            int row;
            this.image32.clear();
            int destIndex = 0;
            for (int i = 0; i < trows && (row = (int)((float)i * hscale)) <= rows; ++i) {
                int sourceIndex = cols * row;
                destIndex = i * 256;
                int fracstep = cols * 65536 / 256;
                int frac = fracstep >> 1;
                for (int j = 0; j < 256; ++j) {
                    this.image32.put(destIndex + j, this.r_rawpalette[data[sourceIndex + (frac >> 16)] & 0xFF]);
                    frac += fracstep;
                }
            }
            this.gl.glTexImage2D(3553, 0, this.gl_tex_solid_format, 256, 256, 0, 6408, 5121, this.image32);
        } else {
            int row;
            this.image8.clear();
            int destIndex = 0;
            for (int i = 0; i < trows && (row = (int)((float)i * hscale)) <= rows; ++i) {
                int sourceIndex = cols * row;
                destIndex = i * 256;
                int fracstep = cols * 65536 / 256;
                int frac = fracstep >> 1;
                for (int j = 0; j < 256; ++j) {
                    this.image8.put(destIndex + j, data[sourceIndex + (frac >> 16)]);
                    frac += fracstep;
                }
            }
            this.gl.glTexImage2D(3553, 0, 6400, 256, 256, 0, 6400, 5121, this.image8);
        }
        this.gl.glTexParameterf(3553, 10241, 9729.0f);
        this.gl.glTexParameterf(3553, 10240, 9729.0f);
        if (this.gl_config.renderer == 0x1000000 || (this.gl_config.renderer & 0x1C0000) != 0) {
            this.gl.glDisable(3008);
        }
        this.gl.glBegin(7);
        this.gl.glTexCoord2f(0.0f, 0.0f);
        this.gl.glVertex2f(x, y);
        this.gl.glTexCoord2f(1.0f, 0.0f);
        this.gl.glVertex2f(x + w, y);
        this.gl.glTexCoord2f(1.0f, t);
        this.gl.glVertex2f(x + w, y + h);
        this.gl.glTexCoord2f(0.0f, t);
        this.gl.glVertex2f(x, y + h);
        this.gl.glEnd();
        if (this.gl_config.renderer == 0x1000000 || (this.gl_config.renderer & 0x1C0000) != 0) {
            this.gl.glEnable(3008);
        }
    }
}

