/*
 * Decompiled with CFR 0.152.
 */
package jake2.render;

import jake2.client.refexport_t;
import jake2.render.Ref;
import jake2.render.RenderAPI;
import jake2.render.fast.Misc;
import java.util.Vector;

public class Renderer {
    static RenderAPI fastRenderer = new Misc();
    static Vector drivers = new Vector(3);

    public static void register(Ref impl) {
        if (impl == null) {
            throw new IllegalArgumentException("Ref implementation can't be null");
        }
        if (!drivers.contains(impl)) {
            drivers.add(impl);
        }
    }

    public static refexport_t getDriver(String driverName) {
        return Renderer.getDriver(driverName, true);
    }

    public static refexport_t getDriver(String driverName, boolean fast) {
        Ref driver = null;
        int count = drivers.size();
        for (int i = 0; i < count; ++i) {
            driver = (Ref)drivers.get(i);
            if (!driver.getName().equals(driverName)) continue;
            return driver.GetRefAPI(fast ? fastRenderer : fastRenderer);
        }
        return null;
    }

    public static String getDefaultName() {
        return drivers.isEmpty() ? null : ((Ref)drivers.firstElement()).getName();
    }

    public static String getPreferedName() {
        return drivers.isEmpty() ? null : ((Ref)drivers.lastElement()).getName();
    }

    public static String[] getDriverNames() {
        if (drivers.isEmpty()) {
            return null;
        }
        int count = drivers.size();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = ((Ref)drivers.get(i)).getName();
        }
        return names;
    }

    static {
        try {
            try {
                Class.forName("net.java.games.jogl.GL");
                Class.forName("jake2.render.JoglRenderer");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("org.lwjgl.opengl.GL11");
                Class.forName("jake2.render.LwjglRenderer");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("javax.media.opengl.GL");
                Class.forName("jake2.render.Jsr231Renderer");
            }
            catch (ClassNotFoundException e) {}
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

