/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.qcommon.Com;
import jake2.qcommon.sizebuf_t;
import jake2.util.Lib;

public final class SZ {
    public static void Clear(sizebuf_t buf) {
        buf.clear();
    }

    public static void Init(sizebuf_t buf, byte[] data, int length) {
        buf.readcount = 0;
        buf.data = data;
        buf.maxsize = length;
        buf.cursize = 0;
        buf.overflowed = false;
        buf.allowoverflow = false;
    }

    public static int GetSpace(sizebuf_t buf, int length) {
        if (buf.cursize + length > buf.maxsize) {
            if (!buf.allowoverflow) {
                Com.Error(0, "SZ_GetSpace: overflow without allowoverflow set");
            }
            if (length > buf.maxsize) {
                Com.Error(0, "SZ_GetSpace: " + length + " is > full buffer size");
            }
            Com.Printf("SZ_GetSpace: overflow\n");
            SZ.Clear(buf);
            buf.overflowed = true;
        }
        int oldsize = buf.cursize;
        buf.cursize += length;
        return oldsize;
    }

    public static void Write(sizebuf_t buf, byte[] data, int length) {
        System.arraycopy(data, 0, buf.data, SZ.GetSpace(buf, length), length);
    }

    public static void Write(sizebuf_t buf, byte[] data, int offset, int length) {
        System.arraycopy(data, offset, buf.data, SZ.GetSpace(buf, length), length);
    }

    public static void Write(sizebuf_t buf, byte[] data) {
        int length = data.length;
        System.arraycopy(data, 0, buf.data, SZ.GetSpace(buf, length), length);
    }

    public static void Print(sizebuf_t buf, String data) {
        Com.dprintln("SZ.print():<" + data + ">");
        int length = data.length();
        byte[] str = Lib.stringToBytes(data);
        if (buf.cursize != 0) {
            if (buf.data[buf.cursize - 1] != 0) {
                System.arraycopy(str, 0, buf.data, SZ.GetSpace(buf, length + 1), length);
            } else {
                System.arraycopy(str, 0, buf.data, SZ.GetSpace(buf, length) - 1, length);
            }
        } else {
            System.arraycopy(str, 0, buf.data, SZ.GetSpace(buf, length), length);
        }
        buf.data[buf.cursize - 1] = 0;
    }
}

