/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.Jake2;
import jake2.client.CL;
import jake2.client.Key;
import jake2.client.SCR;
import jake2.game.Cmd;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.Netchan;
import jake2.qcommon.longjmpException;
import jake2.server.SV_MAIN;
import jake2.sys.NET;
import jake2.sys.Sys;
import jake2.sys.Timer;
import jake2.util.Vargs;
import java.io.FileWriter;
import java.io.IOException;

public final class Qcommon
extends Globals {
    public static final String BUILDSTRING = "Java " + System.getProperty("java.version");
    public static final String CPUSTRING = System.getProperty("os.arch");

    public static void Init(String[] args) {
        try {
            Com.InitArgv(args);
            Cbuf.Init();
            Cmd.Init();
            Cvar.Init();
            Key.Init();
            Cbuf.AddEarlyCommands(false);
            Cbuf.Execute();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.setStatus("initializing filesystem...");
            }
            FS.InitFilesystem();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.setStatus("loading config...");
            }
            Qcommon.reconfigure(false);
            FS.setCDDir();
            FS.markBaseSearchPaths();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.testQ2Data();
            }
            Qcommon.reconfigure(true);
            Cmd.AddCommand("error", Com.Error_f);
            Globals.host_speeds = Cvar.Get("host_speeds", "0", 0);
            Globals.log_stats = Cvar.Get("log_stats", "0", 0);
            Globals.developer = Cvar.Get("developer", "0", 1);
            Globals.timescale = Cvar.Get("timescale", "0", 0);
            Globals.fixedtime = Cvar.Get("fixedtime", "0", 0);
            Globals.logfile_active = Cvar.Get("logfile", "0", 0);
            Globals.showtrace = Cvar.Get("showtrace", "0", 0);
            Globals.dedicated = Cvar.Get("dedicated", "0", 8);
            String s = Com.sprintf("%4.2f %s %s %s", new Vargs(4).add(3.21f).add(CPUSTRING).add("2003").add(BUILDSTRING));
            Cvar.Get("version", s, 12);
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.setStatus("initializing network subsystem...");
            }
            NET.Init();
            Netchan.Netchan_Init();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.setStatus("initializing server subsystem...");
            }
            SV_MAIN.SV_Init();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.setStatus("initializing client subsystem...");
            }
            CL.Init();
            if (!Cbuf.AddLateCommands()) {
                if (Globals.dedicated.value == 0.0f) {
                    Cbuf.AddText("d1\n");
                } else {
                    Cbuf.AddText("dedicated_start\n");
                }
                Cbuf.Execute();
            } else {
                SCR.EndLoadingPlaque();
            }
            Com.Printf("====== Quake2 Initialized ======\n\n");
            CL.WriteConfiguration();
            if (Globals.dedicated.value != 1.0f) {
                Jake2.Q2Dialog.dispose();
            }
        }
        catch (longjmpException e) {
            Sys.Error("Error during initialization");
        }
    }

    public static void Frame(int msec) {
        try {
            if (Globals.log_stats.modified) {
                Globals.log_stats.modified = false;
                if (Globals.log_stats.value != 0.0f) {
                    if (Globals.log_stats_file != null) {
                        try {
                            Globals.log_stats_file.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        Globals.log_stats_file = null;
                    }
                    try {
                        Globals.log_stats_file = new FileWriter("stats.log");
                    }
                    catch (IOException e) {
                        Globals.log_stats_file = null;
                    }
                    if (Globals.log_stats_file != null) {
                        try {
                            Globals.log_stats_file.write("entities,dlights,parts,frame time\n");
                        }
                        catch (IOException e) {}
                    }
                } else if (Globals.log_stats_file != null) {
                    try {
                        Globals.log_stats_file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    Globals.log_stats_file = null;
                }
            }
            if (Globals.fixedtime.value != 0.0f) {
                msec = (int)Globals.fixedtime.value;
            } else if (Globals.timescale.value != 0.0f && (msec = (int)((float)msec * Globals.timescale.value)) < 1) {
                msec = 1;
            }
            if (Globals.showtrace.value != 0.0f) {
                Com.Printf("%4i traces  %4i points\n", new Vargs(2).add(Globals.c_traces).add(Globals.c_pointcontents));
                Globals.c_traces = 0;
                Globals.c_brush_traces = 0;
                Globals.c_pointcontents = 0;
            }
            Cbuf.Execute();
            int time_before = 0;
            int time_between = 0;
            int time_after = 0;
            if (Globals.host_speeds.value != 0.0f) {
                time_before = Timer.Milliseconds();
            }
            Com.debugContext = "SV:";
            SV_MAIN.SV_Frame(msec);
            if (Globals.host_speeds.value != 0.0f) {
                time_between = Timer.Milliseconds();
            }
            Com.debugContext = "CL:";
            CL.Frame(msec);
            if (Globals.host_speeds.value != 0.0f) {
                time_after = Timer.Milliseconds();
                int all = time_after - time_before;
                int sv = time_between - time_before;
                int cl = time_after - time_between;
                int gm = Globals.time_after_game - Globals.time_before_game;
                int rf = Globals.time_after_ref - Globals.time_before_ref;
                Com.Printf("all:%3i sv:%3i gm:%3i cl:%3i rf:%3i\n", new Vargs(5).add(all).add(sv -= gm).add(gm).add(cl -= rf).add(rf));
            }
        }
        catch (longjmpException e) {
            Com.DPrintf("longjmp exception:" + e);
        }
    }

    static void reconfigure(boolean clear) {
        String dir = Cvar.Get((String)"cddir", (String)"", (int)1).string;
        Cbuf.AddText("exec default.cfg\n");
        Cbuf.AddText("bind MWHEELUP weapnext\n");
        Cbuf.AddText("bind MWHEELDOWN weapprev\n");
        Cbuf.AddText("bind w +forward\n");
        Cbuf.AddText("bind s +back\n");
        Cbuf.AddText("bind a +moveleft\n");
        Cbuf.AddText("bind d +moveright\n");
        Cbuf.Execute();
        Cvar.Set("vid_fullscreen", "0");
        Cbuf.AddText("exec config.cfg\n");
        Cbuf.AddEarlyCommands(clear);
        Cbuf.Execute();
        if (!"".equals(dir)) {
            Cvar.Set("cddir", dir);
        }
    }
}

