/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Q2DataDialog
extends JDialog {
    static final String home = System.getProperty("user.home");
    static final String sep = System.getProperty("file.separator");
    private JButton changeButton;
    private JButton exitButton;
    private JButton cancelButton;
    private JPanel choosePanel;
    private JPanel statusPanel;
    private ProgressPanel progressPanel;
    private InstallPanel installPanel;
    private NotFoundPanel notFoundPanel;
    private JLabel status;
    JTextField jTextField1;
    private JButton okButton;
    private String dir;

    public Q2DataDialog() {
        this.initComponents();
        DisplayMode mode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        int x = (mode.getWidth() - this.getWidth()) / 2;
        int y = (mode.getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.dir = home + sep + "Jake2" + sep + "baseq2";
        this.jTextField1.setText(this.dir);
    }

    private void initComponents() {
        JComponent.setDefaultLocale(Locale.US);
        this.choosePanel = new JPanel();
        this.statusPanel = new JPanel();
        this.status = new JLabel("initializing Jake2...");
        this.jTextField1 = new JTextField();
        this.changeButton = new JButton();
        this.cancelButton = new JButton();
        this.exitButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Jake2 - Bytonic Software");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Q2DataDialog.this.formWindowClosing(evt);
            }
        });
        this.choosePanel.setLayout(new GridBagLayout());
        this.choosePanel.setMaximumSize(new Dimension(400, 100));
        this.choosePanel.setMinimumSize(new Dimension(400, 100));
        this.choosePanel.setPreferredSize(new Dimension(400, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 16;
        this.choosePanel.add((Component)new JLabel("baseq2 directory"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        gridBagConstraints.weightx = 1.0;
        this.choosePanel.add((Component)this.jTextField1, gridBagConstraints);
        this.changeButton.setText("...");
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Q2DataDialog.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 5);
        gridBagConstraints.anchor = 13;
        this.choosePanel.add((Component)this.changeButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.choosePanel.add((Component)new JPanel(), gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Q2DataDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 15;
        this.choosePanel.add((Component)this.cancelButton, gridBagConstraints);
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Q2DataDialog.this.exitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        this.choosePanel.add((Component)this.exitButton, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Q2DataDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        this.choosePanel.add((Component)this.okButton, gridBagConstraints);
        Jake2Canvas c = new Jake2Canvas();
        this.getContentPane().add((Component)c, "Center");
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusPanel.setMaximumSize(new Dimension(400, 100));
        this.statusPanel.setMinimumSize(new Dimension(400, 100));
        this.statusPanel.setPreferredSize(new Dimension(400, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.status, gridBagConstraints);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.progressPanel = new ProgressPanel(this);
        this.installPanel = new InstallPanel(this);
        this.notFoundPanel = new NotFoundPanel(this);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.showNotFoundPanel();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        if (!Globals.appletMode) {
            System.exit(1);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okButtonActionPerformed(ActionEvent evt) {
        this.dir = this.jTextField1.getText();
        if (this.dir != null) {
            Cvar.Set("cddir", this.dir);
            FS.setCDDir();
        }
        Q2DataDialog q2DataDialog = this;
        synchronized (q2DataDialog) {
            this.notifyAll();
        }
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("choose a valid baseq2 directory");
        chooser.showDialog(this, "OK");
        this.dir = null;
        try {
            this.dir = chooser.getSelectedFile().getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dir != null) {
            this.jTextField1.setText(this.dir);
        } else {
            this.dir = this.jTextField1.getText();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (!Globals.appletMode) {
            System.exit(1);
        }
        this.dispose();
    }

    void showChooseDialog() {
        this.getContentPane().remove(this.statusPanel);
        this.getContentPane().remove(this.progressPanel);
        this.getContentPane().remove(this.installPanel);
        this.getContentPane().remove(this.notFoundPanel);
        this.getContentPane().add((Component)this.choosePanel, "South");
        this.validate();
        this.repaint();
    }

    void showStatus() {
        this.getContentPane().remove(this.choosePanel);
        this.getContentPane().remove(this.installPanel);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.validate();
        this.repaint();
    }

    void showProgressPanel() {
        this.getContentPane().remove(this.choosePanel);
        this.getContentPane().remove(this.installPanel);
        this.getContentPane().add((Component)this.progressPanel, "South");
        this.validate();
        this.repaint();
    }

    void showInstallPanel() {
        this.getContentPane().remove(this.choosePanel);
        this.getContentPane().remove(this.statusPanel);
        this.getContentPane().remove(this.notFoundPanel);
        this.getContentPane().add((Component)this.installPanel, "South");
        this.validate();
        this.repaint();
    }

    void showNotFoundPanel() {
        this.getContentPane().remove(this.choosePanel);
        this.getContentPane().remove(this.installPanel);
        this.getContentPane().remove(this.statusPanel);
        this.getContentPane().add((Component)this.notFoundPanel, "South");
        this.validate();
        this.repaint();
    }

    void setStatus(String text) {
        this.status.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testQ2Data() {
        while (FS.LoadFile("pics/colormap.pcx") == null) {
            this.showNotFoundPanel();
            try {
                Q2DataDialog q2DataDialog = this;
                synchronized (q2DataDialog) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.showStatus();
        this.repaint();
    }

    static class ProgressPanel
    extends JPanel
    implements Runnable {
        static byte[] buf = new byte[8192];
        String destDir;
        String mirror;
        JProgressBar progress = new JProgressBar();
        JLabel label = new JLabel("");
        JButton cancel = new JButton("Cancel");
        Q2DataDialog parent;
        boolean running;

        public ProgressPanel(Q2DataDialog d) {
            this.initComponents();
            this.parent = d;
        }

        void initComponents() {
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
            this.progress.setStringPainted(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 15;
            this.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 11;
            this.add((Component)this.progress, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 0.0;
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProgressPanel.this.cancel();
                }
            });
            this.add((Component)this.cancel, gridBagConstraints);
            Dimension d = new Dimension(400, 100);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            ProgressPanel progressPanel = this;
            synchronized (progressPanel) {
                this.running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressPanel progressPanel = this;
            synchronized (progressPanel) {
                this.running = true;
            }
            InputStream in = null;
            OutputStream out = null;
            File outFile = null;
            this.label.setText("downloading...");
            File dir = null;
            try {
                dir = new File(this.destDir);
                dir.mkdirs();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (!dir.isDirectory() || !dir.canWrite()) {
                    this.endInstall("can't write to " + this.destDir);
                    return;
                }
            }
            catch (Exception e) {
                this.endInstall(e.getMessage());
                return;
            }
            try {
                URL url = new URL(this.mirror);
                URLConnection conn = url.openConnection();
                int length = conn.getContentLength();
                this.progress.setMaximum(length / 1024);
                this.progress.setMinimum(0);
                in = conn.getInputStream();
                outFile = File.createTempFile("Jake2Data", ".zip");
                outFile.deleteOnExit();
                out = new FileOutputStream(outFile);
                this.copyStream(in, out);
            }
            catch (Exception e) {
                this.endInstall(e.getMessage());
                return;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            try {
                this.installData(outFile.getCanonicalPath());
            }
            catch (Exception e) {
                this.endInstall(e.getMessage());
                return;
            }
            try {
                if (outFile != null) {
                    outFile.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.endInstall("installation successful");
        }

        void installData(String filename) throws Exception {
            InputStream in = null;
            OutputStream out = null;
            try {
                ZipFile f = new ZipFile(filename);
                Enumeration<? extends ZipEntry> e = f.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    int i = name.indexOf("/baseq2");
                    if (i <= -1 || name.indexOf(".dll") != -1) continue;
                    name = this.destDir + name.substring(i);
                    File outFile = new File(name);
                    if (entry.isDirectory()) {
                        outFile.mkdirs();
                        continue;
                    }
                    this.label.setText("installing " + outFile.getName());
                    this.progress.setMaximum((int)entry.getSize() / 1024);
                    this.progress.setValue(0);
                    outFile.getParentFile().mkdirs();
                    out = new FileOutputStream(outFile);
                    in = f.getInputStream(entry);
                    this.copyStream(in, out);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e1) {}
                try {
                    out.close();
                }
                catch (Exception e1) {}
            }
        }

        void endInstall(String message) {
            this.parent.notFoundPanel.message.setText(message);
            this.parent.jTextField1.setText(this.destDir + "/baseq2");
            this.parent.showChooseDialog();
            this.parent.okButtonActionPerformed(null);
        }

        void copyStream(InputStream in, OutputStream out) throws Exception {
            try {
                int l;
                int c = 0;
                while ((l = in.read(buf)) > 0) {
                    if (!this.running) {
                        throw new Exception("installation canceled");
                    }
                    out.write(buf, 0, l);
                    int k = (c += l) / 1024;
                    this.progress.setValue(k);
                    this.progress.setString(k + "/" + this.progress.getMaximum() + " KB");
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static class InstallPanel
    extends JPanel {
        private Vector mirrorNames = new Vector();
        private Vector mirrorLinks = new Vector();
        private Q2DataDialog parent;
        private JComboBox mirrorBox;
        private JTextField destDir;
        private JButton cancel;
        private JButton exit;
        private JButton install;
        private JButton choose;

        public InstallPanel(Q2DataDialog d) {
            this.initComponents();
            String dir = home + sep + "Jake2";
            this.destDir.setText(dir);
            this.initMirrors();
            this.parent = d;
        }

        private void initComponents() {
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            Dimension d = new Dimension(400, 100);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(5, 5, 0, 5);
            constraints.anchor = 16;
            this.add((Component)new JLabel("download mirror"), constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)new JLabel("destination directory"), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.gridwidth = 3;
            constraints.insets = new Insets(5, 5, 0, 5);
            constraints.fill = 2;
            this.mirrorBox = new JComboBox();
            this.add((Component)this.mirrorBox, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.fill = 1;
            constraints.insets = new Insets(5, 5, 5, 5);
            this.destDir = new JTextField();
            this.add((Component)this.destDir, constraints);
            constraints.gridx = 3;
            constraints.gridy = 1;
            constraints.weightx = 0.0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            this.choose = new JButton("...");
            this.choose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallPanel.this.choose();
                }
            });
            this.add((Component)this.choose, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.weighty = 1.0;
            constraints.fill = 0;
            this.exit = new JButton("Exit");
            this.exit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallPanel.this.exit();
                }
            });
            this.add((Component)this.exit, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 4;
            constraints.anchor = 15;
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallPanel.this.cancel();
                }
            });
            this.add((Component)this.cancel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.gridwidth = 2;
            constraints.anchor = 14;
            this.install = new JButton("Install");
            this.install.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallPanel.this.install();
                }
            });
            this.add((Component)this.install, constraints);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMirrors() {
            InputStream in = this.getClass().getResourceAsStream("/mirrors");
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            try {
                while (true) {
                    String name = r.readLine();
                    String value = r.readLine();
                    if (name == null) break;
                    if (value == null) {
                        break;
                    }
                    this.mirrorNames.add(name);
                    this.mirrorLinks.add(value);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception e1) {}
                try {
                    in.close();
                }
                catch (Exception e1) {}
            }
        }

        private void initMirrors() {
            int i;
            this.readMirrors();
            for (i = 0; i < this.mirrorNames.size(); ++i) {
                this.mirrorBox.addItem(this.mirrorNames.get(i));
            }
            i = Globals.rnd.nextInt(this.mirrorNames.size());
            this.mirrorBox.setSelectedIndex(i);
        }

        private void cancel() {
            this.parent.showNotFoundPanel();
        }

        private void install() {
            ((Q2DataDialog)this.parent).progressPanel.destDir = this.destDir.getText();
            ((Q2DataDialog)this.parent).progressPanel.mirror = (String)this.mirrorLinks.get(this.mirrorBox.getSelectedIndex());
            this.parent.showProgressPanel();
            new Thread(this.parent.progressPanel).start();
        }

        private void exit() {
            if (!Globals.appletMode) {
                System.exit(0);
            }
        }

        private void choose() {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setDialogType(2);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("choose destination directory");
            chooser.showDialog(this, "OK");
            String dir = null;
            try {
                dir = chooser.getSelectedFile().getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dir != null) {
                this.destDir.setText(dir);
            }
        }
    }

    static class NotFoundPanel
    extends JPanel {
        private Q2DataDialog parent;
        private ButtonGroup selection;
        private JRadioButton dir;
        private JRadioButton install;
        private JButton exit;
        private JButton ok;
        private JLabel message;

        NotFoundPanel(Q2DataDialog d) {
            this.parent = d;
            this.initComponents();
        }

        private void initComponents() {
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            Dimension d = new Dimension(400, 100);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.message = new JLabel("Quake2 level data not found");
            this.message.setForeground(Color.RED);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.insets = new Insets(5, 5, 2, 5);
            constraints.anchor = 10;
            this.add((Component)this.message, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 2, 0, 5);
            constraints.anchor = 17;
            JLabel label = new JLabel("select baseq2 directory from existing Quake2 installation");
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    NotFoundPanel.this.dir.setSelected(true);
                }
            });
            this.add((Component)label, constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            label = new JLabel("download and install Quake2 demo data (38MB)");
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    NotFoundPanel.this.install.setSelected(true);
                }
            });
            this.add((Component)label, constraints);
            this.selection = new ButtonGroup();
            this.dir = new JRadioButton();
            this.install = new JRadioButton();
            this.selection.add(this.dir);
            this.selection.add(this.install);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(0, 5, 0, 2);
            constraints.fill = 0;
            constraints.anchor = 13;
            this.dir.setSelected(true);
            this.add((Component)this.dir, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.add((Component)this.install, constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.fill = 0;
            constraints.anchor = 16;
            this.exit = new JButton("Exit");
            this.exit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!Globals.appletMode) {
                        System.exit(0);
                    }
                }
            });
            this.add((Component)this.exit, constraints);
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.anchor = 14;
            this.ok = new JButton("OK");
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NotFoundPanel.this.ok();
                }
            });
            this.add((Component)this.ok, constraints);
        }

        private void ok() {
            if (this.dir.isSelected()) {
                this.parent.showChooseDialog();
            } else {
                this.parent.showInstallPanel();
            }
        }
    }

    static class Jake2Canvas
    extends Canvas {
        private Image image;

        Jake2Canvas() {
            this.setSize(400, 200);
            try {
                this.image = ImageIO.read(this.getClass().getResource("/splash.png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
        }
    }
}

