/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.csurface_t;
import jake2.game.pmove_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.util.Math3D;

public class PMove {
    public static pmove_t pm;
    public static pml_t pml;
    public static float pm_stopspeed;
    public static float pm_maxspeed;
    public static float pm_duckspeed;
    public static float pm_accelerate;
    public static float pm_airaccelerate;
    public static float pm_wateraccelerate;
    public static float pm_friction;
    public static float pm_waterfriction;
    public static float pm_waterspeed;
    public static int[] jitterbits;
    public static int[] offset;
    static float[][] planes;

    public static void PM_ClipVelocity(float[] in, float[] normal, float[] out, float overbounce) {
        float backoff = Math3D.DotProduct(in, normal) * overbounce;
        for (int i = 0; i < 3; ++i) {
            float change = normal[i] * backoff;
            out[i] = in[i] - change;
            if (!(out[i] > -0.1f) || !(out[i] < 0.1f)) continue;
            out[i] = 0.0f;
        }
    }

    public static void PM_StepSlideMove_() {
        float[] dir = new float[]{0.0f, 0.0f, 0.0f};
        float[] primal_velocity = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        int numbumps = 4;
        Math3D.VectorCopy(PMove.pml.velocity, primal_velocity);
        int numplanes = 0;
        float time_left = PMove.pml.frametime;
        for (int bumpcount = 0; bumpcount < numbumps; ++bumpcount) {
            int i;
            for (i = 0; i < 3; ++i) {
                end[i] = PMove.pml.origin[i] + time_left * PMove.pml.velocity[i];
            }
            trace_t trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, end);
            if (trace.allsolid) {
                PMove.pml.velocity[2] = 0.0f;
                return;
            }
            if (trace.fraction > 0.0f) {
                Math3D.VectorCopy(trace.endpos, PMove.pml.origin);
                numplanes = 0;
            }
            if (trace.fraction == 1.0f) break;
            if (PMove.pm.numtouch < 32 && trace.ent != null) {
                PMove.pm.touchents[PMove.pm.numtouch] = trace.ent;
                ++PMove.pm.numtouch;
            }
            time_left -= time_left * trace.fraction;
            if (numplanes >= 5) {
                Math3D.VectorCopy(Globals.vec3_origin, PMove.pml.velocity);
                break;
            }
            Math3D.VectorCopy(trace.plane.normal, planes[numplanes]);
            ++numplanes;
            for (i = 0; i < numplanes; ++i) {
                int j;
                PMove.PM_ClipVelocity(PMove.pml.velocity, planes[i], PMove.pml.velocity, 1.01f);
                for (j = 0; !(j >= numplanes || j != i && Math3D.DotProduct(PMove.pml.velocity, planes[j]) < 0.0f); ++j) {
                }
                if (j == numplanes) break;
            }
            if (i == numplanes) {
                if (numplanes != 2) {
                    Math3D.VectorCopy(Globals.vec3_origin, PMove.pml.velocity);
                    break;
                }
                Math3D.CrossProduct(planes[0], planes[1], dir);
                float d = Math3D.DotProduct(dir, PMove.pml.velocity);
                Math3D.VectorScale(dir, d, PMove.pml.velocity);
            }
            if (!(Math3D.DotProduct(PMove.pml.velocity, primal_velocity) <= 0.0f)) continue;
            Math3D.VectorCopy(Globals.vec3_origin, PMove.pml.velocity);
            break;
        }
        if (PMove.pm.s.pm_time != 0) {
            Math3D.VectorCopy(primal_velocity, PMove.pml.velocity);
        }
    }

    public static void PM_StepSlideMove() {
        float[] start_o = new float[]{0.0f, 0.0f, 0.0f};
        float[] start_v = new float[]{0.0f, 0.0f, 0.0f};
        float[] down_o = new float[]{0.0f, 0.0f, 0.0f};
        float[] down_v = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        float[] down = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorCopy(PMove.pml.origin, start_o);
        Math3D.VectorCopy(PMove.pml.velocity, start_v);
        PMove.PM_StepSlideMove_();
        Math3D.VectorCopy(PMove.pml.origin, down_o);
        Math3D.VectorCopy(PMove.pml.velocity, down_v);
        Math3D.VectorCopy(start_o, up);
        up[2] = up[2] + 18.0f;
        trace_t trace = PMove.pm.trace.trace(up, PMove.pm.mins, PMove.pm.maxs, up);
        if (trace.allsolid) {
            return;
        }
        Math3D.VectorCopy(up, PMove.pml.origin);
        Math3D.VectorCopy(start_v, PMove.pml.velocity);
        PMove.PM_StepSlideMove_();
        Math3D.VectorCopy(PMove.pml.origin, down);
        down[2] = down[2] - 18.0f;
        trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, down);
        if (!trace.allsolid) {
            Math3D.VectorCopy(trace.endpos, PMove.pml.origin);
        }
        Math3D.VectorCopy(PMove.pml.origin, up);
        float down_dist = (down_o[0] - start_o[0]) * (down_o[0] - start_o[0]) + (down_o[1] - start_o[1]) * (down_o[1] - start_o[1]);
        float up_dist = (up[0] - start_o[0]) * (up[0] - start_o[0]) + (up[1] - start_o[1]) * (up[1] - start_o[1]);
        if (down_dist > up_dist || trace.plane.normal[2] < 0.7f) {
            Math3D.VectorCopy(down_o, PMove.pml.origin);
            Math3D.VectorCopy(down_v, PMove.pml.velocity);
            return;
        }
        PMove.pml.velocity[2] = down_v[2];
    }

    public static void PM_Friction() {
        float newspeed;
        float[] vel = PMove.pml.velocity;
        float speed = (float)Math.sqrt(vel[0] * vel[0] + vel[1] * vel[1] + vel[2] * vel[2]);
        if (speed < 1.0f) {
            vel[0] = 0.0f;
            vel[1] = 0.0f;
            return;
        }
        float drop = 0.0f;
        if (PMove.pm.groundentity != null && PMove.pml.groundsurface != null && 0 == (PMove.pml.groundsurface.flags & 2) || PMove.pml.ladder) {
            float friction = pm_friction;
            float control = speed < pm_stopspeed ? pm_stopspeed : speed;
            drop += control * friction * PMove.pml.frametime;
        }
        if (PMove.pm.waterlevel != 0 && !PMove.pml.ladder) {
            drop += speed * pm_waterfriction * (float)PMove.pm.waterlevel * PMove.pml.frametime;
        }
        if ((newspeed = speed - drop) < 0.0f) {
            newspeed = 0.0f;
        }
        vel[0] = vel[0] * (newspeed /= speed);
        vel[1] = vel[1] * newspeed;
        vel[2] = vel[2] * newspeed;
    }

    public static void PM_Accelerate(float[] wishdir, float wishspeed, float accel) {
        float currentspeed = Math3D.DotProduct(PMove.pml.velocity, wishdir);
        float addspeed = wishspeed - currentspeed;
        if (addspeed <= 0.0f) {
            return;
        }
        float accelspeed = accel * PMove.pml.frametime * wishspeed;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        for (int i = 0; i < 3; ++i) {
            int n = i;
            PMove.pml.velocity[n] = PMove.pml.velocity[n] + accelspeed * wishdir[i];
        }
    }

    public static void PM_AirAccelerate(float[] wishdir, float wishspeed, float accel) {
        float currentspeed;
        float addspeed;
        float wishspd = wishspeed;
        if (wishspd > 30.0f) {
            wishspd = 30.0f;
        }
        if ((addspeed = wishspd - (currentspeed = Math3D.DotProduct(PMove.pml.velocity, wishdir))) <= 0.0f) {
            return;
        }
        float accelspeed = accel * wishspeed * PMove.pml.frametime;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        for (int i = 0; i < 3; ++i) {
            int n = i;
            PMove.pml.velocity[n] = PMove.pml.velocity[n] + accelspeed * wishdir[i];
        }
    }

    public static void PM_AddCurrents(float[] wishvel) {
        float[] v = new float[]{0.0f, 0.0f, 0.0f};
        if (PMove.pml.ladder && Math.abs(PMove.pml.velocity[2]) <= 200.0f) {
            wishvel[2] = PMove.pm.viewangles[0] <= -15.0f && PMove.pm.cmd.forwardmove > 0 ? 200.0f : (PMove.pm.viewangles[0] >= 15.0f && PMove.pm.cmd.forwardmove > 0 ? -200.0f : (PMove.pm.cmd.upmove > 0 ? 200.0f : (PMove.pm.cmd.upmove < 0 ? -200.0f : 0.0f)));
            if (wishvel[0] < -25.0f) {
                wishvel[0] = -25.0f;
            } else if (wishvel[0] > 25.0f) {
                wishvel[0] = 25.0f;
            }
            if (wishvel[1] < -25.0f) {
                wishvel[1] = -25.0f;
            } else if (wishvel[1] > 25.0f) {
                wishvel[1] = 25.0f;
            }
        }
        if ((PMove.pm.watertype & 0xFC0000) != 0) {
            Math3D.VectorClear(v);
            if ((PMove.pm.watertype & 0x40000) != 0) {
                v[0] = v[0] + 1.0f;
            }
            if ((PMove.pm.watertype & 0x80000) != 0) {
                v[1] = v[1] + 1.0f;
            }
            if ((PMove.pm.watertype & 0x100000) != 0) {
                v[0] = v[0] - 1.0f;
            }
            if ((PMove.pm.watertype & 0x200000) != 0) {
                v[1] = v[1] - 1.0f;
            }
            if ((PMove.pm.watertype & 0x400000) != 0) {
                v[2] = v[2] + 1.0f;
            }
            if ((PMove.pm.watertype & 0x800000) != 0) {
                v[2] = v[2] - 1.0f;
            }
            float s = pm_waterspeed;
            if (PMove.pm.waterlevel == 1 && PMove.pm.groundentity != null) {
                s /= 2.0f;
            }
            Math3D.VectorMA(wishvel, s, v, wishvel);
        }
        if (PMove.pm.groundentity != null) {
            Math3D.VectorClear(v);
            if ((PMove.pml.groundcontents & 0x40000) != 0) {
                v[0] = v[0] + 1.0f;
            }
            if ((PMove.pml.groundcontents & 0x80000) != 0) {
                v[1] = v[1] + 1.0f;
            }
            if ((PMove.pml.groundcontents & 0x100000) != 0) {
                v[0] = v[0] - 1.0f;
            }
            if ((PMove.pml.groundcontents & 0x200000) != 0) {
                v[1] = v[1] - 1.0f;
            }
            if ((PMove.pml.groundcontents & 0x400000) != 0) {
                v[2] = v[2] + 1.0f;
            }
            if ((PMove.pml.groundcontents & 0x800000) != 0) {
                v[2] = v[2] - 1.0f;
            }
            Math3D.VectorMA(wishvel, 100.0f, v, wishvel);
        }
    }

    public static void PM_WaterMove() {
        float[] wishvel = new float[]{0.0f, 0.0f, 0.0f};
        float[] wishdir = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < 3; ++i) {
            wishvel[i] = PMove.pml.forward[i] * (float)PMove.pm.cmd.forwardmove + PMove.pml.right[i] * (float)PMove.pm.cmd.sidemove;
        }
        wishvel[2] = 0 == PMove.pm.cmd.forwardmove && 0 == PMove.pm.cmd.sidemove && 0 == PMove.pm.cmd.upmove ? wishvel[2] - 60.0f : wishvel[2] + (float)PMove.pm.cmd.upmove;
        PMove.PM_AddCurrents(wishvel);
        Math3D.VectorCopy(wishvel, wishdir);
        float wishspeed = Math3D.VectorNormalize(wishdir);
        if (wishspeed > pm_maxspeed) {
            Math3D.VectorScale(wishvel, pm_maxspeed / wishspeed, wishvel);
            wishspeed = pm_maxspeed;
        }
        wishspeed = (float)((double)wishspeed * 0.5);
        PMove.PM_Accelerate(wishdir, wishspeed, pm_wateraccelerate);
        PMove.PM_StepSlideMove();
    }

    public static void PM_AirMove() {
        float maxspeed;
        float[] wishvel = new float[]{0.0f, 0.0f, 0.0f};
        float[] wishdir = new float[]{0.0f, 0.0f, 0.0f};
        float fmove = PMove.pm.cmd.forwardmove;
        float smove = PMove.pm.cmd.sidemove;
        wishvel[0] = PMove.pml.forward[0] * fmove + PMove.pml.right[0] * smove;
        wishvel[1] = PMove.pml.forward[1] * fmove + PMove.pml.right[1] * smove;
        wishvel[2] = 0.0f;
        PMove.PM_AddCurrents(wishvel);
        Math3D.VectorCopy(wishvel, wishdir);
        float wishspeed = Math3D.VectorNormalize(wishdir);
        float f = maxspeed = (PMove.pm.s.pm_flags & 1) != 0 ? pm_duckspeed : pm_maxspeed;
        if (wishspeed > maxspeed) {
            Math3D.VectorScale(wishvel, maxspeed / wishspeed, wishvel);
            wishspeed = maxspeed;
        }
        if (PMove.pml.ladder) {
            PMove.PM_Accelerate(wishdir, wishspeed, pm_accelerate);
            if (0.0f == wishvel[2]) {
                if (PMove.pml.velocity[2] > 0.0f) {
                    PMove.pml.velocity[2] = PMove.pml.velocity[2] - (float)PMove.pm.s.gravity * PMove.pml.frametime;
                    if (PMove.pml.velocity[2] < 0.0f) {
                        PMove.pml.velocity[2] = 0.0f;
                    }
                } else {
                    PMove.pml.velocity[2] = PMove.pml.velocity[2] + (float)PMove.pm.s.gravity * PMove.pml.frametime;
                    if (PMove.pml.velocity[2] > 0.0f) {
                        PMove.pml.velocity[2] = 0.0f;
                    }
                }
            }
            PMove.PM_StepSlideMove();
        } else if (PMove.pm.groundentity != null) {
            PMove.pml.velocity[2] = 0.0f;
            PMove.PM_Accelerate(wishdir, wishspeed, pm_accelerate);
            PMove.pml.velocity[2] = PMove.pm.s.gravity > 0 ? 0.0f : PMove.pml.velocity[2] - (float)PMove.pm.s.gravity * PMove.pml.frametime;
            if (0.0f == PMove.pml.velocity[0] && 0.0f == PMove.pml.velocity[1]) {
                return;
            }
            PMove.PM_StepSlideMove();
        } else {
            if (pm_airaccelerate != 0.0f) {
                PMove.PM_AirAccelerate(wishdir, wishspeed, pm_accelerate);
            } else {
                PMove.PM_Accelerate(wishdir, wishspeed, 1.0f);
            }
            PMove.pml.velocity[2] = PMove.pml.velocity[2] - (float)PMove.pm.s.gravity * PMove.pml.frametime;
            PMove.PM_StepSlideMove();
        }
    }

    public static void PM_CatagorizePosition() {
        float[] point = new float[]{0.0f, 0.0f, 0.0f};
        point[0] = PMove.pml.origin[0];
        point[1] = PMove.pml.origin[1];
        point[2] = PMove.pml.origin[2] - 0.25f;
        if (PMove.pml.velocity[2] > 180.0f) {
            PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFFB);
            PMove.pm.groundentity = null;
        } else {
            trace_t trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, point);
            PMove.pml.groundsurface = trace.surface;
            PMove.pml.groundcontents = trace.contents;
            if (null == trace.ent || (double)trace.plane.normal[2] < 0.7 && !trace.startsolid) {
                PMove.pm.groundentity = null;
                PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFFB);
            } else {
                PMove.pm.groundentity = trace.ent;
                if ((PMove.pm.s.pm_flags & 8) != 0) {
                    PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFC7);
                    PMove.pm.s.pm_time = 0;
                }
                if (0 == (PMove.pm.s.pm_flags & 4)) {
                    PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 4);
                    if (PMove.pml.velocity[2] < -200.0f) {
                        PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 0x10);
                        PMove.pm.s.pm_time = PMove.pml.velocity[2] < -400.0f ? (byte)25 : (byte)18;
                    }
                }
            }
            if (PMove.pm.numtouch < 32 && trace.ent != null) {
                PMove.pm.touchents[PMove.pm.numtouch] = trace.ent;
                ++PMove.pm.numtouch;
            }
        }
        PMove.pm.waterlevel = 0;
        PMove.pm.watertype = 0;
        int sample2 = (int)(PMove.pm.viewheight - PMove.pm.mins[2]);
        int sample1 = sample2 / 2;
        point[2] = PMove.pml.origin[2] + PMove.pm.mins[2] + 1.0f;
        int cont = PMove.pm.pointcontents.pointcontents(point);
        if ((cont & 0x38) != 0) {
            PMove.pm.watertype = cont;
            PMove.pm.waterlevel = 1;
            point[2] = PMove.pml.origin[2] + PMove.pm.mins[2] + (float)sample1;
            cont = PMove.pm.pointcontents.pointcontents(point);
            if ((cont & 0x38) != 0) {
                PMove.pm.waterlevel = 2;
                point[2] = PMove.pml.origin[2] + PMove.pm.mins[2] + (float)sample2;
                cont = PMove.pm.pointcontents.pointcontents(point);
                if ((cont & 0x38) != 0) {
                    PMove.pm.waterlevel = 3;
                }
            }
        }
    }

    public static void PM_CheckJump() {
        if ((PMove.pm.s.pm_flags & 0x10) != 0) {
            return;
        }
        if (PMove.pm.cmd.upmove < 10) {
            PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFFD);
            return;
        }
        if ((PMove.pm.s.pm_flags & 2) != 0) {
            return;
        }
        if (PMove.pm.s.pm_type == 2) {
            return;
        }
        if (PMove.pm.waterlevel >= 2) {
            PMove.pm.groundentity = null;
            if (PMove.pml.velocity[2] <= -300.0f) {
                return;
            }
            PMove.pml.velocity[2] = PMove.pm.watertype == 32 ? 100.0f : (PMove.pm.watertype == 16 ? 80.0f : 50.0f);
            return;
        }
        if (PMove.pm.groundentity == null) {
            return;
        }
        PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 2);
        PMove.pm.groundentity = null;
        PMove.pml.velocity[2] = PMove.pml.velocity[2] + 270.0f;
        if (PMove.pml.velocity[2] < 270.0f) {
            PMove.pml.velocity[2] = 270.0f;
        }
    }

    public static void PM_CheckSpecialMovement() {
        float[] spot = new float[]{0.0f, 0.0f, 0.0f};
        float[] flatforward = new float[]{0.0f, 0.0f, 0.0f};
        if (PMove.pm.s.pm_time != 0) {
            return;
        }
        PMove.pml.ladder = false;
        flatforward[0] = PMove.pml.forward[0];
        flatforward[1] = PMove.pml.forward[1];
        flatforward[2] = 0.0f;
        Math3D.VectorNormalize(flatforward);
        Math3D.VectorMA(PMove.pml.origin, 1.0f, flatforward, spot);
        trace_t trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, spot);
        if (trace.fraction < 1.0f && (trace.contents & 0x20000000) != 0) {
            PMove.pml.ladder = true;
        }
        if (PMove.pm.waterlevel != 2) {
            return;
        }
        Math3D.VectorMA(PMove.pml.origin, 30.0f, flatforward, spot);
        spot[2] = spot[2] + 4.0f;
        int cont = PMove.pm.pointcontents.pointcontents(spot);
        if (0 == (cont & 1)) {
            return;
        }
        spot[2] = spot[2] + 16.0f;
        cont = PMove.pm.pointcontents.pointcontents(spot);
        if (cont != 0) {
            return;
        }
        Math3D.VectorScale(flatforward, 50.0f, PMove.pml.velocity);
        PMove.pml.velocity[2] = 350.0f;
        PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 8);
        PMove.pm.s.pm_time = (byte)-1;
    }

    public static void PM_FlyMove(boolean doclip) {
        float currentspeed;
        float addspeed;
        int i;
        float[] wishvel = new float[]{0.0f, 0.0f, 0.0f};
        float[] wishdir = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        PMove.pm.viewheight = 22.0f;
        float speed = Math3D.VectorLength(PMove.pml.velocity);
        if (speed < 1.0f) {
            Math3D.VectorCopy(Globals.vec3_origin, PMove.pml.velocity);
        } else {
            float friction;
            float drop = 0.0f;
            float control = speed < pm_stopspeed ? pm_stopspeed : speed;
            float newspeed = speed - (drop += control * (friction = pm_friction * 1.5f) * PMove.pml.frametime);
            if (newspeed < 0.0f) {
                newspeed = 0.0f;
            }
            Math3D.VectorScale(PMove.pml.velocity, newspeed /= speed, PMove.pml.velocity);
        }
        float fmove = PMove.pm.cmd.forwardmove;
        float smove = PMove.pm.cmd.sidemove;
        Math3D.VectorNormalize(PMove.pml.forward);
        Math3D.VectorNormalize(PMove.pml.right);
        for (i = 0; i < 3; ++i) {
            wishvel[i] = PMove.pml.forward[i] * fmove + PMove.pml.right[i] * smove;
        }
        wishvel[2] = wishvel[2] + (float)PMove.pm.cmd.upmove;
        Math3D.VectorCopy(wishvel, wishdir);
        float wishspeed = Math3D.VectorNormalize(wishdir);
        if (wishspeed > pm_maxspeed) {
            Math3D.VectorScale(wishvel, pm_maxspeed / wishspeed, wishvel);
            wishspeed = pm_maxspeed;
        }
        if ((addspeed = wishspeed - (currentspeed = Math3D.DotProduct(PMove.pml.velocity, wishdir))) <= 0.0f) {
            return;
        }
        float accelspeed = pm_accelerate * PMove.pml.frametime * wishspeed;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        for (i = 0; i < 3; ++i) {
            int n = i;
            PMove.pml.velocity[n] = PMove.pml.velocity[n] + accelspeed * wishdir[i];
        }
        if (doclip) {
            for (i = 0; i < 3; ++i) {
                end[i] = PMove.pml.origin[i] + PMove.pml.frametime * PMove.pml.velocity[i];
            }
            trace_t trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, end);
            Math3D.VectorCopy(trace.endpos, PMove.pml.origin);
        } else {
            Math3D.VectorMA(PMove.pml.origin, PMove.pml.frametime, PMove.pml.velocity, PMove.pml.origin);
        }
    }

    public static void PM_CheckDuck() {
        PMove.pm.mins[0] = -16.0f;
        PMove.pm.mins[1] = -16.0f;
        PMove.pm.maxs[0] = 16.0f;
        PMove.pm.maxs[1] = 16.0f;
        if (PMove.pm.s.pm_type == 3) {
            PMove.pm.mins[2] = 0.0f;
            PMove.pm.maxs[2] = 16.0f;
            PMove.pm.viewheight = 8.0f;
            return;
        }
        PMove.pm.mins[2] = -24.0f;
        if (PMove.pm.s.pm_type == 2) {
            PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 1);
        } else if (PMove.pm.cmd.upmove < 0 && (PMove.pm.s.pm_flags & 4) != 0) {
            PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags | 1);
        } else if ((PMove.pm.s.pm_flags & 1) != 0) {
            PMove.pm.maxs[2] = 32.0f;
            trace_t trace = PMove.pm.trace.trace(PMove.pml.origin, PMove.pm.mins, PMove.pm.maxs, PMove.pml.origin);
            if (!trace.allsolid) {
                PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFFE);
            }
        }
        if ((PMove.pm.s.pm_flags & 1) != 0) {
            PMove.pm.maxs[2] = 4.0f;
            PMove.pm.viewheight = -2.0f;
        } else {
            PMove.pm.maxs[2] = 32.0f;
            PMove.pm.viewheight = 22.0f;
        }
    }

    public static void PM_DeadMove() {
        if (null == PMove.pm.groundentity) {
            return;
        }
        float forward = Math3D.VectorLength(PMove.pml.velocity);
        if ((forward -= 20.0f) <= 0.0f) {
            Math3D.VectorClear(PMove.pml.velocity);
        } else {
            Math3D.VectorNormalize(PMove.pml.velocity);
            Math3D.VectorScale(PMove.pml.velocity, forward, PMove.pml.velocity);
        }
    }

    public static boolean PM_GoodPosition() {
        float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        float[] end = new float[]{0.0f, 0.0f, 0.0f};
        if (PMove.pm.s.pm_type == 1) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            origin[i] = end[i] = (float)PMove.pm.s.origin[i] * 0.125f;
        }
        trace_t trace = PMove.pm.trace.trace(origin, PMove.pm.mins, PMove.pm.maxs, end);
        return !trace.allsolid;
    }

    public static void PM_SnapPosition() {
        int i;
        int[] sign = new int[]{0, 0, 0};
        short[] base = new short[]{0, 0, 0};
        for (i = 0; i < 3; ++i) {
            PMove.pm.s.velocity[i] = (short)(PMove.pml.velocity[i] * 8.0f);
        }
        for (i = 0; i < 3; ++i) {
            sign[i] = PMove.pml.origin[i] >= 0.0f ? 1 : -1;
            PMove.pm.s.origin[i] = (short)(PMove.pml.origin[i] * 8.0f);
            if ((double)PMove.pm.s.origin[i] * 0.125 != (double)PMove.pml.origin[i]) continue;
            sign[i] = 0;
        }
        Math3D.VectorCopy(PMove.pm.s.origin, base);
        for (int j = 0; j < 8; ++j) {
            int bits = jitterbits[j];
            Math3D.VectorCopy(base, PMove.pm.s.origin);
            for (i = 0; i < 3; ++i) {
                if ((bits & 1 << i) == 0) continue;
                int n = i;
                PMove.pm.s.origin[n] = (short)(PMove.pm.s.origin[n] + sign[i]);
            }
            if (!PMove.PM_GoodPosition()) continue;
            return;
        }
        Math3D.VectorCopy(PMove.pml.previous_origin, PMove.pm.s.origin);
    }

    public static void PM_InitialSnapPosition() {
        short[] base = new short[]{0, 0, 0};
        Math3D.VectorCopy(PMove.pm.s.origin, base);
        for (int z = 0; z < 3; ++z) {
            PMove.pm.s.origin[2] = (short)(base[2] + offset[z]);
            for (int y = 0; y < 3; ++y) {
                PMove.pm.s.origin[1] = (short)(base[1] + offset[y]);
                for (int x = 0; x < 3; ++x) {
                    PMove.pm.s.origin[0] = (short)(base[0] + offset[x]);
                    if (!PMove.PM_GoodPosition()) continue;
                    PMove.pml.origin[0] = (float)PMove.pm.s.origin[0] * 0.125f;
                    PMove.pml.origin[1] = (float)PMove.pm.s.origin[1] * 0.125f;
                    PMove.pml.origin[2] = (float)PMove.pm.s.origin[2] * 0.125f;
                    Math3D.VectorCopy(PMove.pm.s.origin, PMove.pml.previous_origin);
                    return;
                }
            }
        }
        Com.DPrintf("Bad InitialSnapPosition\n");
    }

    public static void PM_ClampAngles() {
        if ((PMove.pm.s.pm_flags & 0x20) != 0) {
            PMove.pm.viewangles[1] = Math3D.SHORT2ANGLE(PMove.pm.cmd.angles[1] + PMove.pm.s.delta_angles[1]);
            PMove.pm.viewangles[0] = 0.0f;
            PMove.pm.viewangles[2] = 0.0f;
        } else {
            for (int i = 0; i < 3; ++i) {
                short temp = (short)(PMove.pm.cmd.angles[i] + PMove.pm.s.delta_angles[i]);
                PMove.pm.viewangles[i] = Math3D.SHORT2ANGLE(temp);
            }
            if (PMove.pm.viewangles[0] > 89.0f && PMove.pm.viewangles[0] < 180.0f) {
                PMove.pm.viewangles[0] = 89.0f;
            } else if (PMove.pm.viewangles[0] < 271.0f && PMove.pm.viewangles[0] >= 180.0f) {
                PMove.pm.viewangles[0] = 271.0f;
            }
        }
        Math3D.AngleVectors(PMove.pm.viewangles, PMove.pml.forward, PMove.pml.right, PMove.pml.up);
    }

    public static void Pmove(pmove_t pmove) {
        pm = pmove;
        PMove.pm.numtouch = 0;
        Math3D.VectorClear(PMove.pm.viewangles);
        PMove.pm.viewheight = 0.0f;
        PMove.pm.groundentity = null;
        PMove.pm.watertype = 0;
        PMove.pm.waterlevel = 0;
        PMove.pml.groundsurface = null;
        PMove.pml.groundcontents = 0;
        PMove.pml.origin[0] = (float)PMove.pm.s.origin[0] * 0.125f;
        PMove.pml.origin[1] = (float)PMove.pm.s.origin[1] * 0.125f;
        PMove.pml.origin[2] = (float)PMove.pm.s.origin[2] * 0.125f;
        PMove.pml.velocity[0] = (float)PMove.pm.s.velocity[0] * 0.125f;
        PMove.pml.velocity[1] = (float)PMove.pm.s.velocity[1] * 0.125f;
        PMove.pml.velocity[2] = (float)PMove.pm.s.velocity[2] * 0.125f;
        Math3D.VectorCopy(PMove.pm.s.origin, PMove.pml.previous_origin);
        PMove.pml.frametime = (float)(PMove.pm.cmd.msec & 0xFF) * 0.001f;
        PMove.PM_ClampAngles();
        if (PMove.pm.s.pm_type == 1) {
            PMove.PM_FlyMove(false);
            PMove.PM_SnapPosition();
            return;
        }
        if (PMove.pm.s.pm_type >= 2) {
            PMove.pm.cmd.forwardmove = 0;
            PMove.pm.cmd.sidemove = 0;
            PMove.pm.cmd.upmove = 0;
        }
        if (PMove.pm.s.pm_type == 4) {
            return;
        }
        PMove.PM_CheckDuck();
        if (PMove.pm.snapinitial) {
            PMove.PM_InitialSnapPosition();
        }
        PMove.PM_CatagorizePosition();
        if (PMove.pm.s.pm_type == 2) {
            PMove.PM_DeadMove();
        }
        PMove.PM_CheckSpecialMovement();
        if (PMove.pm.s.pm_time != 0) {
            int msec = PMove.pm.cmd.msec >>> 3;
            if (msec == 0) {
                msec = 1;
            }
            if (msec >= (PMove.pm.s.pm_time & 0xFF)) {
                PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFC7);
                PMove.pm.s.pm_time = 0;
            } else {
                PMove.pm.s.pm_time = (byte)((PMove.pm.s.pm_time & 0xFF) - msec);
            }
        }
        if ((PMove.pm.s.pm_flags & 0x20) == 0) {
            if ((PMove.pm.s.pm_flags & 8) != 0) {
                PMove.pml.velocity[2] = PMove.pml.velocity[2] - (float)PMove.pm.s.gravity * PMove.pml.frametime;
                if (PMove.pml.velocity[2] < 0.0f) {
                    PMove.pm.s.pm_flags = (byte)(PMove.pm.s.pm_flags & 0xFFFFFFC7);
                    PMove.pm.s.pm_time = 0;
                }
                PMove.PM_StepSlideMove();
            } else {
                PMove.PM_CheckJump();
                PMove.PM_Friction();
                if (PMove.pm.waterlevel >= 2) {
                    PMove.PM_WaterMove();
                } else {
                    float[] angles = new float[]{0.0f, 0.0f, 0.0f};
                    Math3D.VectorCopy(PMove.pm.viewangles, angles);
                    if (angles[0] > 180.0f) {
                        angles[0] = angles[0] - 360.0f;
                    }
                    angles[0] = angles[0] / 3.0f;
                    Math3D.AngleVectors(angles, PMove.pml.forward, PMove.pml.right, PMove.pml.up);
                    PMove.PM_AirMove();
                }
            }
        }
        PMove.PM_CatagorizePosition();
        PMove.PM_SnapPosition();
    }

    static {
        pml = new pml_t();
        pm_stopspeed = 100.0f;
        pm_maxspeed = 300.0f;
        pm_duckspeed = 100.0f;
        pm_accelerate = 10.0f;
        pm_airaccelerate = 0.0f;
        pm_wateraccelerate = 10.0f;
        pm_friction = 6.0f;
        pm_waterfriction = 1.0f;
        pm_waterspeed = 400.0f;
        jitterbits = new int[]{0, 4, 1, 2, 3, 5, 6, 7};
        offset = new int[]{0, -1, 1};
        planes = new float[5][3];
    }

    public static class pml_t {
        public float[] origin = new float[]{0.0f, 0.0f, 0.0f};
        public float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
        public float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        public float[] right = new float[]{0.0f, 0.0f, 0.0f};
        public float[] up = new float[]{0.0f, 0.0f, 0.0f};
        public float frametime;
        public csurface_t groundsurface;
        public int groundcontents;
        public float[] previous_origin = new float[]{0.0f, 0.0f, 0.0f};
        public boolean ladder;
    }
}

