/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.MSG;
import jake2.qcommon.SZ;
import jake2.qcommon.netadr_t;
import jake2.qcommon.netchan_t;
import jake2.qcommon.sizebuf_t;
import jake2.server.SV_MAIN;
import jake2.sys.NET;
import jake2.sys.Timer;
import jake2.util.Lib;

public final class Netchan
extends SV_MAIN {
    public static cvar_t showpackets;
    public static cvar_t showdrop;
    public static cvar_t qport;
    public static sizebuf_t net_message;
    public static byte[] net_message_buffer;
    private static final byte[] send_buf;
    private static final sizebuf_t send;

    public static void Netchan_Init() {
        long port = Timer.Milliseconds() & 0xFFFF;
        showpackets = Cvar.Get("showpackets", "0", 0);
        showdrop = Cvar.Get("showdrop", "0", 0);
        qport = Cvar.Get("qport", "" + port, 8);
    }

    public static void Netchan_OutOfBand(int net_socket, netadr_t adr, int length, byte[] data) {
        SZ.Init(send, send_buf, 1400);
        MSG.WriteInt(send, -1);
        SZ.Write(send, data, length);
        NET.SendPacket(net_socket, Netchan.send.cursize, Netchan.send.data, adr);
    }

    public static void OutOfBandPrint(int net_socket, netadr_t adr, String s) {
        Netchan.Netchan_OutOfBand(net_socket, adr, s.length(), Lib.stringToBytes(s));
    }

    public static void Setup(int sock, netchan_t chan, netadr_t adr, int qport) {
        chan.clear();
        chan.sock = sock;
        chan.remote_address.set(adr);
        chan.qport = qport;
        chan.last_received = Globals.curtime;
        chan.incoming_sequence = 0;
        chan.outgoing_sequence = 1;
        SZ.Init(chan.message, chan.message_buf, chan.message_buf.length);
        chan.message.allowoverflow = true;
    }

    public static boolean Netchan_CanReliable(netchan_t chan) {
        return chan.reliable_length == 0;
    }

    public static boolean Netchan_NeedReliable(netchan_t chan) {
        boolean send_reliable = false;
        if (chan.incoming_acknowledged > chan.last_reliable_sequence && chan.incoming_reliable_acknowledged != chan.reliable_sequence) {
            send_reliable = true;
        }
        if (0 == chan.reliable_length && chan.message.cursize != 0) {
            send_reliable = true;
        }
        return send_reliable;
    }

    public static void Transmit(netchan_t chan, int length, byte[] data) {
        int send_reliable;
        if (chan.message.overflowed) {
            chan.fatal_error = true;
            Com.Printf(NET.AdrToString(chan.remote_address) + ":Outgoing message overflow\n");
            return;
        }
        int n = send_reliable = Netchan.Netchan_NeedReliable(chan) ? 1 : 0;
        if (chan.reliable_length == 0 && chan.message.cursize != 0) {
            System.arraycopy(chan.message_buf, 0, chan.reliable_buf, 0, chan.message.cursize);
            chan.reliable_length = chan.message.cursize;
            chan.message.cursize = 0;
            chan.reliable_sequence ^= 1;
        }
        SZ.Init(send, send_buf, send_buf.length);
        int w1 = chan.outgoing_sequence & Integer.MAX_VALUE | send_reliable << 31;
        int w2 = chan.incoming_sequence & Integer.MAX_VALUE | chan.incoming_reliable_sequence << 31;
        ++chan.outgoing_sequence;
        chan.last_sent = Globals.curtime;
        MSG.WriteInt(send, w1);
        MSG.WriteInt(send, w2);
        if (chan.sock == 0) {
            MSG.WriteShort(send, (int)Netchan.qport.value);
        }
        if (send_reliable != 0) {
            SZ.Write(send, chan.reliable_buf, chan.reliable_length);
            chan.last_reliable_sequence = chan.outgoing_sequence;
        }
        if (Netchan.send.maxsize - Netchan.send.cursize >= length) {
            SZ.Write(send, data, length);
        } else {
            Com.Printf("Netchan_Transmit: dumped unreliable\n");
        }
        NET.SendPacket(chan.sock, Netchan.send.cursize, Netchan.send.data, chan.remote_address);
        if (Netchan.showpackets.value != 0.0f) {
            if (send_reliable != 0) {
                Com.Printf("send " + Netchan.send.cursize + " : s=" + (chan.outgoing_sequence - 1) + " reliable=" + chan.reliable_sequence + " ack=" + chan.incoming_sequence + " rack=" + chan.incoming_reliable_sequence + "\n");
            } else {
                Com.Printf("send " + Netchan.send.cursize + " : s=" + (chan.outgoing_sequence - 1) + " ack=" + chan.incoming_sequence + " rack=" + chan.incoming_reliable_sequence + "\n");
            }
        }
    }

    public static boolean Process(netchan_t chan, sizebuf_t msg) {
        MSG.BeginReading(msg);
        int sequence = MSG.ReadLong(msg);
        int sequence_ack = MSG.ReadLong(msg);
        if (chan.sock == 1) {
            MSG.ReadShort(msg);
        }
        int reliable_message = sequence >>> 31;
        int reliable_ack = sequence_ack >>> 31;
        sequence &= Integer.MAX_VALUE;
        sequence_ack &= Integer.MAX_VALUE;
        if (Netchan.showpackets.value != 0.0f) {
            if (reliable_message != 0) {
                Com.Printf("recv " + msg.cursize + " : s=" + sequence + " reliable=" + (chan.incoming_reliable_sequence ^ 1) + " ack=" + sequence_ack + " rack=" + reliable_ack + "\n");
            } else {
                Com.Printf("recv " + msg.cursize + " : s=" + sequence + " ack=" + sequence_ack + " rack=" + reliable_ack + "\n");
            }
        }
        if (sequence <= chan.incoming_sequence) {
            if (Netchan.showdrop.value != 0.0f) {
                Com.Printf(NET.AdrToString(chan.remote_address) + ":Out of order packet " + sequence + " at " + chan.incoming_sequence + "\n");
            }
            return false;
        }
        chan.dropped = sequence - (chan.incoming_sequence + 1);
        if (chan.dropped > 0 && Netchan.showdrop.value != 0.0f) {
            Com.Printf(NET.AdrToString(chan.remote_address) + ":Dropped " + chan.dropped + " packets at " + sequence + "\n");
        }
        if (reliable_ack == chan.reliable_sequence) {
            chan.reliable_length = 0;
        }
        chan.incoming_sequence = sequence;
        chan.incoming_acknowledged = sequence_ack;
        chan.incoming_reliable_acknowledged = reliable_ack;
        if (reliable_message != 0) {
            chan.incoming_reliable_sequence ^= 1;
        }
        chan.last_received = Globals.curtime;
        return true;
    }

    static {
        net_message = new sizebuf_t();
        net_message_buffer = new byte[1400];
        send_buf = new byte[1400];
        send = new sizebuf_t();
    }
}

