/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.entity_state_t;
import jake2.game.usercmd_t;
import jake2.qcommon.Com;
import jake2.qcommon.SZ;
import jake2.qcommon.sizebuf_t;
import jake2.util.Lib;
import jake2.util.Math3D;

public class MSG
extends Globals {
    public static byte[] readbuf;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void WriteChar(sizebuf_t sb, int c) {
        sb.data[SZ.GetSpace((sizebuf_t)sb, (int)1)] = (byte)(c & 0xFF);
    }

    public static void WriteChar(sizebuf_t sb, float c) {
        MSG.WriteChar(sb, (int)c);
    }

    public static void WriteByte(sizebuf_t sb, int c) {
        sb.data[SZ.GetSpace((sizebuf_t)sb, (int)1)] = (byte)(c & 0xFF);
    }

    public static void WriteByte(sizebuf_t sb, float c) {
        MSG.WriteByte(sb, (int)c);
    }

    public static void WriteShort(sizebuf_t sb, int c) {
        int i = SZ.GetSpace(sb, 2);
        sb.data[i++] = (byte)(c & 0xFF);
        sb.data[i] = (byte)(c >>> 8 & 0xFF);
    }

    public static void WriteInt(sizebuf_t sb, int c) {
        int i = SZ.GetSpace(sb, 4);
        sb.data[i++] = (byte)(c & 0xFF);
        sb.data[i++] = (byte)(c >>> 8 & 0xFF);
        sb.data[i++] = (byte)(c >>> 16 & 0xFF);
        sb.data[i++] = (byte)(c >>> 24 & 0xFF);
    }

    public static void WriteLong(sizebuf_t sb, int c) {
        MSG.WriteInt(sb, c);
    }

    public static void WriteFloat(sizebuf_t sb, float f) {
        MSG.WriteInt(sb, Float.floatToIntBits(f));
    }

    public static void WriteString(sizebuf_t sb, String s) {
        String x = s;
        if (s == null) {
            x = "";
        }
        SZ.Write(sb, Lib.stringToBytes(x));
        MSG.WriteByte(sb, 0);
    }

    public static void WriteString(sizebuf_t sb, byte[] s) {
        MSG.WriteString(sb, new String(s).trim());
    }

    public static void WriteCoord(sizebuf_t sb, float f) {
        MSG.WriteShort(sb, (int)(f * 8.0f));
    }

    public static void WritePos(sizebuf_t sb, float[] pos) {
        if (!$assertionsDisabled && pos.length != 3) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        MSG.WriteShort(sb, (int)(pos[0] * 8.0f));
        MSG.WriteShort(sb, (int)(pos[1] * 8.0f));
        MSG.WriteShort(sb, (int)(pos[2] * 8.0f));
    }

    public static void WriteAngle(sizebuf_t sb, float f) {
        MSG.WriteByte(sb, (int)(f * 256.0f / 360.0f) & 0xFF);
    }

    public static void WriteAngle16(sizebuf_t sb, float f) {
        MSG.WriteShort(sb, Math3D.ANGLE2SHORT(f));
    }

    public static void WriteDeltaUsercmd(sizebuf_t buf, usercmd_t from, usercmd_t cmd) {
        int bits = 0;
        if (cmd.angles[0] != from.angles[0]) {
            bits |= 1;
        }
        if (cmd.angles[1] != from.angles[1]) {
            bits |= 2;
        }
        if (cmd.angles[2] != from.angles[2]) {
            bits |= 4;
        }
        if (cmd.forwardmove != from.forwardmove) {
            bits |= 8;
        }
        if (cmd.sidemove != from.sidemove) {
            bits |= 0x10;
        }
        if (cmd.upmove != from.upmove) {
            bits |= 0x20;
        }
        if (cmd.buttons != from.buttons) {
            bits |= 0x40;
        }
        if (cmd.impulse != from.impulse) {
            bits |= 0x80;
        }
        MSG.WriteByte(buf, bits);
        if ((bits & 1) != 0) {
            MSG.WriteShort(buf, cmd.angles[0]);
        }
        if ((bits & 2) != 0) {
            MSG.WriteShort(buf, cmd.angles[1]);
        }
        if ((bits & 4) != 0) {
            MSG.WriteShort(buf, cmd.angles[2]);
        }
        if ((bits & 8) != 0) {
            MSG.WriteShort(buf, cmd.forwardmove);
        }
        if ((bits & 0x10) != 0) {
            MSG.WriteShort(buf, cmd.sidemove);
        }
        if ((bits & 0x20) != 0) {
            MSG.WriteShort(buf, cmd.upmove);
        }
        if ((bits & 0x40) != 0) {
            MSG.WriteByte(buf, cmd.buttons);
        }
        if ((bits & 0x80) != 0) {
            MSG.WriteByte(buf, cmd.impulse);
        }
        MSG.WriteByte(buf, cmd.msec);
        MSG.WriteByte(buf, cmd.lightlevel);
    }

    public static void WriteDir(sizebuf_t sb, float[] dir) {
        if (dir == null) {
            MSG.WriteByte(sb, 0);
            return;
        }
        float bestd = 0.0f;
        int best = 0;
        for (int i = 0; i < 162; ++i) {
            float d = Math3D.DotProduct(dir, bytedirs[i]);
            if (!(d > bestd)) continue;
            bestd = d;
            best = i;
        }
        MSG.WriteByte(sb, best);
    }

    public static void ReadDir(sizebuf_t sb, float[] dir) {
        int b = MSG.ReadByte(sb);
        if (b >= 162) {
            Com.Error(1, "MSF_ReadDir: out of range");
        }
        Math3D.VectorCopy(bytedirs[b], dir);
    }

    public static void WriteDeltaEntity(entity_state_t from, entity_state_t to, sizebuf_t msg, boolean force, boolean newentity) {
        if (0 == to.number) {
            Com.Error(0, "Unset entity number");
        }
        if (to.number >= 1024) {
            Com.Error(0, "Entity number >= MAX_EDICTS");
        }
        int bits = 0;
        if (to.number >= 256) {
            bits |= 0x100;
        }
        if (to.origin[0] != from.origin[0]) {
            bits |= 1;
        }
        if (to.origin[1] != from.origin[1]) {
            bits |= 2;
        }
        if (to.origin[2] != from.origin[2]) {
            bits |= 0x200;
        }
        if (to.angles[0] != from.angles[0]) {
            bits |= 0x400;
        }
        if (to.angles[1] != from.angles[1]) {
            bits |= 4;
        }
        if (to.angles[2] != from.angles[2]) {
            bits |= 8;
        }
        if (to.skinnum != from.skinnum) {
            bits = to.skinnum < 256 ? (bits |= 0x10000) : (to.skinnum < 65536 ? (bits |= 0x2000000) : (bits |= 0x2010000));
        }
        if (to.frame != from.frame) {
            bits = to.frame < 256 ? (bits |= 0x10) : (bits |= 0x20000);
        }
        if (to.effects != from.effects) {
            bits = to.effects < 256 ? (bits |= 0x4000) : (to.effects < 32768 ? (bits |= 0x80000) : (bits |= 0x84000));
        }
        if (to.renderfx != from.renderfx) {
            bits = to.renderfx < 256 ? (bits |= 0x1000) : (to.renderfx < 32768 ? (bits |= 0x40000) : (bits |= 0x41000));
        }
        if (to.solid != from.solid) {
            bits |= 0x8000000;
        }
        if (to.event != 0) {
            bits |= 0x20;
        }
        if (to.modelindex != from.modelindex) {
            bits |= 0x800;
        }
        if (to.modelindex2 != from.modelindex2) {
            bits |= 0x100000;
        }
        if (to.modelindex3 != from.modelindex3) {
            bits |= 0x200000;
        }
        if (to.modelindex4 != from.modelindex4) {
            bits |= 0x400000;
        }
        if (to.sound != from.sound) {
            bits |= 0x4000000;
        }
        if (newentity || (to.renderfx & 0x80) != 0) {
            bits |= 0x1000000;
        }
        if (bits == 0 && !force) {
            return;
        }
        if ((bits & 0xFF000000) != 0) {
            bits |= 0x808080;
        } else if ((bits & 0xFF0000) != 0) {
            bits |= 0x8080;
        } else if ((bits & 0xFF00) != 0) {
            bits |= 0x80;
        }
        MSG.WriteByte(msg, bits & 0xFF);
        if ((bits & 0xFF000000) != 0) {
            MSG.WriteByte(msg, bits >>> 8 & 0xFF);
            MSG.WriteByte(msg, bits >>> 16 & 0xFF);
            MSG.WriteByte(msg, bits >>> 24 & 0xFF);
        } else if ((bits & 0xFF0000) != 0) {
            MSG.WriteByte(msg, bits >>> 8 & 0xFF);
            MSG.WriteByte(msg, bits >>> 16 & 0xFF);
        } else if ((bits & 0xFF00) != 0) {
            MSG.WriteByte(msg, bits >>> 8 & 0xFF);
        }
        if ((bits & 0x100) != 0) {
            MSG.WriteShort(msg, to.number);
        } else {
            MSG.WriteByte(msg, to.number);
        }
        if ((bits & 0x800) != 0) {
            MSG.WriteByte(msg, to.modelindex);
        }
        if ((bits & 0x100000) != 0) {
            MSG.WriteByte(msg, to.modelindex2);
        }
        if ((bits & 0x200000) != 0) {
            MSG.WriteByte(msg, to.modelindex3);
        }
        if ((bits & 0x400000) != 0) {
            MSG.WriteByte(msg, to.modelindex4);
        }
        if ((bits & 0x10) != 0) {
            MSG.WriteByte(msg, to.frame);
        }
        if ((bits & 0x20000) != 0) {
            MSG.WriteShort(msg, to.frame);
        }
        if ((bits & 0x10000) != 0 && (bits & 0x2000000) != 0) {
            MSG.WriteInt(msg, to.skinnum);
        } else if ((bits & 0x10000) != 0) {
            MSG.WriteByte(msg, to.skinnum);
        } else if ((bits & 0x2000000) != 0) {
            MSG.WriteShort(msg, to.skinnum);
        }
        if ((bits & 0x84000) == 540672) {
            MSG.WriteInt(msg, to.effects);
        } else if ((bits & 0x4000) != 0) {
            MSG.WriteByte(msg, to.effects);
        } else if ((bits & 0x80000) != 0) {
            MSG.WriteShort(msg, to.effects);
        }
        if ((bits & 0x41000) == 266240) {
            MSG.WriteInt(msg, to.renderfx);
        } else if ((bits & 0x1000) != 0) {
            MSG.WriteByte(msg, to.renderfx);
        } else if ((bits & 0x40000) != 0) {
            MSG.WriteShort(msg, to.renderfx);
        }
        if ((bits & 1) != 0) {
            MSG.WriteCoord(msg, to.origin[0]);
        }
        if ((bits & 2) != 0) {
            MSG.WriteCoord(msg, to.origin[1]);
        }
        if ((bits & 0x200) != 0) {
            MSG.WriteCoord(msg, to.origin[2]);
        }
        if ((bits & 0x400) != 0) {
            MSG.WriteAngle(msg, to.angles[0]);
        }
        if ((bits & 4) != 0) {
            MSG.WriteAngle(msg, to.angles[1]);
        }
        if ((bits & 8) != 0) {
            MSG.WriteAngle(msg, to.angles[2]);
        }
        if ((bits & 0x1000000) != 0) {
            MSG.WriteCoord(msg, to.old_origin[0]);
            MSG.WriteCoord(msg, to.old_origin[1]);
            MSG.WriteCoord(msg, to.old_origin[2]);
        }
        if ((bits & 0x4000000) != 0) {
            MSG.WriteByte(msg, to.sound);
        }
        if ((bits & 0x20) != 0) {
            MSG.WriteByte(msg, to.event);
        }
        if ((bits & 0x8000000) != 0) {
            MSG.WriteShort(msg, to.solid);
        }
    }

    public static void BeginReading(sizebuf_t msg) {
        msg.readcount = 0;
    }

    public static int ReadChar(sizebuf_t msg_read) {
        int c = msg_read.readcount + 1 > msg_read.cursize ? -1 : msg_read.data[msg_read.readcount];
        ++msg_read.readcount;
        return c;
    }

    public static int ReadByte(sizebuf_t msg_read) {
        int c = msg_read.readcount + 1 > msg_read.cursize ? -1 : msg_read.data[msg_read.readcount] & 0xFF;
        ++msg_read.readcount;
        return c;
    }

    public static short ReadShort(sizebuf_t msg_read) {
        int c = msg_read.readcount + 2 > msg_read.cursize ? -1 : (int)((short)((msg_read.data[msg_read.readcount] & 0xFF) + (msg_read.data[msg_read.readcount + 1] << 8)));
        msg_read.readcount += 2;
        return (short)c;
    }

    public static int ReadLong(sizebuf_t msg_read) {
        int c;
        if (msg_read.readcount + 4 > msg_read.cursize) {
            Com.Printf("buffer underrun in ReadLong!");
            c = -1;
        } else {
            c = msg_read.data[msg_read.readcount] & 0xFF | (msg_read.data[msg_read.readcount + 1] & 0xFF) << 8 | (msg_read.data[msg_read.readcount + 2] & 0xFF) << 16 | (msg_read.data[msg_read.readcount + 3] & 0xFF) << 24;
        }
        msg_read.readcount += 4;
        return c;
    }

    public static float ReadFloat(sizebuf_t msg_read) {
        int n = MSG.ReadLong(msg_read);
        return Float.intBitsToFloat(n);
    }

    public static String ReadString(sizebuf_t msg_read) {
        byte c;
        int l = 0;
        while ((c = (byte)MSG.ReadByte(msg_read)) != -1 && c != 0) {
            MSG.readbuf[l] = c;
            if (++l < 2047) continue;
        }
        String ret = new String(readbuf, 0, l);
        return ret;
    }

    public static String ReadStringLine(sizebuf_t msg_read) {
        byte c;
        int l = 0;
        while ((c = (byte)MSG.ReadChar(msg_read)) != -1 && c != 0 && c != 10) {
            MSG.readbuf[l] = c;
            if (++l < 2047) continue;
        }
        String ret = new String(readbuf, 0, l).trim();
        Com.dprintln("MSG.ReadStringLine:[" + ret.replace('\u0000', '@') + "]");
        return ret;
    }

    public static float ReadCoord(sizebuf_t msg_read) {
        return (float)MSG.ReadShort(msg_read) * 0.125f;
    }

    public static void ReadPos(sizebuf_t msg_read, float[] pos) {
        if (!$assertionsDisabled && pos.length != 3) {
            throw new AssertionError((Object)"vec3_t bug");
        }
        pos[0] = (float)MSG.ReadShort(msg_read) * 0.125f;
        pos[1] = (float)MSG.ReadShort(msg_read) * 0.125f;
        pos[2] = (float)MSG.ReadShort(msg_read) * 0.125f;
    }

    public static float ReadAngle(sizebuf_t msg_read) {
        return (float)MSG.ReadChar(msg_read) * 1.40625f;
    }

    public static float ReadAngle16(sizebuf_t msg_read) {
        return Math3D.SHORT2ANGLE(MSG.ReadShort(msg_read));
    }

    public static void ReadDeltaUsercmd(sizebuf_t msg_read, usercmd_t from, usercmd_t move) {
        move.set(from);
        int bits = MSG.ReadByte(msg_read);
        if ((bits & 1) != 0) {
            move.angles[0] = MSG.ReadShort(msg_read);
        }
        if ((bits & 2) != 0) {
            move.angles[1] = MSG.ReadShort(msg_read);
        }
        if ((bits & 4) != 0) {
            move.angles[2] = MSG.ReadShort(msg_read);
        }
        if ((bits & 8) != 0) {
            move.forwardmove = MSG.ReadShort(msg_read);
        }
        if ((bits & 0x10) != 0) {
            move.sidemove = MSG.ReadShort(msg_read);
        }
        if ((bits & 0x20) != 0) {
            move.upmove = MSG.ReadShort(msg_read);
        }
        if ((bits & 0x40) != 0) {
            move.buttons = (byte)MSG.ReadByte(msg_read);
        }
        if ((bits & 0x80) != 0) {
            move.impulse = (byte)MSG.ReadByte(msg_read);
        }
        move.msec = (byte)MSG.ReadByte(msg_read);
        move.lightlevel = (byte)MSG.ReadByte(msg_read);
    }

    public static void ReadData(sizebuf_t msg_read, byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            data[i] = (byte)MSG.ReadByte(msg_read);
        }
    }

    static {
        $assertionsDisabled = !MSG.class.desiredAssertionStatus();
        readbuf = new byte[2048];
    }
}

