/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.qcommon.Com;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;

public class MP3 {
    private String mp3file = null;
    private Player player = null;
    private FileInputStream fis = null;
    private BufferedInputStream bis = null;
    private Bitstream bs = null;
    private String id3v2 = null;
    private int totallength;
    private int totalbytes;
    private int currentpos;
    private boolean ispaused = false;
    private boolean isplaying = false;
    private boolean islooping = false;
    private boolean iscomplete = false;
    private boolean isinitialized = false;
    private boolean iserror = false;

    public MP3(String filename, boolean looping) {
        this.mp3file = filename;
        this.islooping = looping;
        if (this.init() == -1) {
            this.isinitialized = false;
            this.iserror = true;
        } else {
            this.isinitialized = true;
        }
        this.iserror = false;
    }

    private int init() {
        try {
            this.fis = new FileInputStream(this.mp3file);
        }
        catch (FileNotFoundException e) {
            Com.DPrintf("MP3 Player File: " + this.mp3file + " failed to open.\n");
            return -1;
        }
        this.bis = new BufferedInputStream(this.fis);
        this.bs = new Bitstream((InputStream)this.bis);
        try {
            this.player = new Player((InputStream)this.bis);
        }
        catch (JavaLayerException e1) {
            Com.DPrintf("MP3 Player failed to initialize player.\n");
            return -1;
        }
        try {
            this.totalbytes = this.fis.available();
        }
        catch (IOException e1) {
            Com.DPrintf("MP3 Player failed to initialize totalbytes.\n");
        }
        this.totallength = this.player.getPosition();
        this.iscomplete = false;
        InputStream id3in = this.bs.getRawID3v2();
        if (id3in != null) {
            BufferedInputStream id3 = new BufferedInputStream(id3in);
            StringBuffer id3out = new StringBuffer();
            try {
                int _char;
                while ((_char = id3.read()) != -1) {
                    id3out.append((char)_char);
                }
            }
            catch (IOException e) {
                Com.DPrintf("MP3 player id3out.append failed\n");
            }
            try {
                id3.close();
            }
            catch (IOException e) {
                Com.DPrintf("MP3 player id3.close failed\n");
            }
            this.id3v2 = id3out.toString();
        } else {
            this.id3v2 = "";
        }
        return 0;
    }

    public boolean isComplete() {
        return this.iscomplete;
    }

    public boolean isInitialized() {
        return this.isinitialized;
    }

    public boolean isPlaying() {
        return this.isplaying;
    }

    public boolean isPaused() {
        return this.ispaused;
    }

    public boolean isError() {
        return this.iserror;
    }

    public int getTotalLength() {
        if (!this.isinitialized) {
            return 0;
        }
        return this.totallength;
    }

    public int getPosition() {
        if (this.ispaused || !this.isplaying || !this.isinitialized) {
            return 0;
        }
        return this.player.getPosition();
    }

    public String getRawID3v2() {
        return this.id3v2;
    }

    public void pause() {
        if (this.ispaused || !this.isplaying || !this.isinitialized) {
            return;
        }
        try {
            this.currentpos = this.fis.available();
        }
        catch (IOException e) {
            Com.DPrintf("MP3 player pause() fis.available() failed\n");
            this.iserror = true;
        }
        this.ispaused = true;
        this.player.close();
        Com.DPrintf("MP3 player is paused.\n");
    }

    public void resume() {
        if (!(this.ispaused && this.isplaying && this.isinitialized)) {
            return;
        }
        if (this.init() == -1) {
            Com.DPrintf("MP3 player failed to init resume\n");
            this.isinitialized = false;
            this.isplaying = false;
            this.ispaused = false;
            this.iserror = true;
            return;
        }
        try {
            this.fis.skip(this.totalbytes - this.currentpos);
        }
        catch (IOException e) {
            Com.DPrintf("MP3 player failed to skip resume\n");
            this.isinitialized = false;
            this.iserror = true;
            this.ispaused = false;
            this.isplaying = false;
        }
        this.isinitialized = true;
        this.play();
        if (!this.iserror) {
            this.ispaused = false;
            Com.DPrintf("MP3 player has resumed.\n");
        } else {
            Com.DPrintf("MP3 player resume failed?\n");
        }
    }

    public void stop() {
        if (this.isplaying) {
            this.id3v2 = "";
            this.totallength = 0;
            this.totalbytes = 0;
            this.currentpos = 0;
            this.ispaused = false;
            this.isplaying = false;
            this.islooping = false;
            this.iscomplete = true;
            this.isinitialized = false;
            this.player.close();
        }
    }

    public void play() {
        if (this.isplaying && !this.ispaused || !this.isinitialized) {
            return;
        }
        this.isplaying = true;
        new Thread(){

            public void run() {
                try {
                    while (true) {
                        MP3.this.player.play();
                        if (!MP3.this.islooping || MP3.this.ispaused) {
                            MP3.this.iscomplete = true;
                            break;
                        }
                        if (MP3.this.init() == -1) {
                            MP3.this.isinitialized = false;
                            MP3.this.iserror = true;
                            MP3.this.iscomplete = true;
                            Com.DPrintf("MP3 player error while looping.\n");
                            break;
                        }
                        MP3.this.isinitialized = true;
                        MP3.this.iserror = false;
                        Com.DPrintf("MP3 player looping track.\n");
                    }
                    Com.DPrintf("MP3 player finished track.\n");
                }
                catch (Exception e) {
                    Com.DPrintf("MP3 player failed to play.\n");
                    MP3.this.isplaying = false;
                    MP3.this.iserror = true;
                }
            }
        }.start();
    }
}

