/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.cvar_t;
import jake2.qcommon.CDAudio;
import jake2.qcommon.Cbuf;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.xcommand_t;
import jake2.sys.Sys;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class FS
extends Globals {
    public static String fs_gamedir;
    private static String fs_userdir;
    public static cvar_t fs_basedir;
    public static cvar_t fs_cddir;
    public static cvar_t fs_gamedirvar;
    public static List fs_links;
    public static searchpath_t fs_searchpaths;
    public static searchpath_t fs_base_searchpaths;
    public static int file_from_pak;
    public static final int MAX_READ = 65536;
    static final int IDPAKHEADER = 1262698832;
    static final int MAX_FILES_IN_PACK = 4096;
    static byte[] tmpText;

    public static void CreatePath(String path) {
        File f;
        int index = path.lastIndexOf(47);
        if (index > 0 && !(f = new File(path.substring(0, index))).mkdirs() && !f.isDirectory()) {
            Com.Printf("can't create path \"" + path + '\"' + "\n");
        }
    }

    public static void FCloseFile(RandomAccessFile file) throws IOException {
        file.close();
    }

    public static void FCloseFile(InputStream stream) throws IOException {
        stream.close();
    }

    public static int FileLength(String filename) {
        file_from_pak = 0;
        Iterator it = fs_links.iterator();
        while (it.hasNext()) {
            filelink_t link = (filelink_t)it.next();
            if (!filename.regionMatches(0, link.from, 0, link.fromlength)) continue;
            String netpath = link.to + filename.substring(link.fromlength);
            File file = new File(netpath);
            if (file.canRead()) {
                Com.DPrintf("link file: " + netpath + '\n');
                return (int)file.length();
            }
            return -1;
        }
        searchpath_t search = fs_searchpaths;
        while (search != null) {
            if (search.pack != null) {
                pack_t pak = search.pack;
                packfile_t entry = (packfile_t)pak.files.get(filename = filename.toLowerCase());
                if (entry != null) {
                    file_from_pak = 1;
                    Com.DPrintf("PackFile: " + pak.filename + " : " + filename + '\n');
                    File file = new File(pak.filename);
                    if (!file.canRead()) {
                        Com.Error(0, "Couldn't reopen " + pak.filename);
                    }
                    return entry.filelen;
                }
            } else {
                String netpath = search.filename + '/' + filename;
                File file = new File(netpath);
                if (file.canRead()) {
                    Com.DPrintf("FindFile: " + netpath + '\n');
                    return (int)file.length();
                }
            }
            search = search.next;
        }
        Com.DPrintf("FindFile: can't find " + filename + '\n');
        return -1;
    }

    public static RandomAccessFile FOpenFile(String filename) throws IOException {
        File file = null;
        file_from_pak = 0;
        Iterator it = fs_links.iterator();
        while (it.hasNext()) {
            filelink_t link = (filelink_t)it.next();
            if (!filename.regionMatches(0, link.from, 0, link.fromlength)) continue;
            String netpath = link.to + filename.substring(link.fromlength);
            file = new File(netpath);
            if (file.canRead()) {
                return new RandomAccessFile(file, "r");
            }
            return null;
        }
        searchpath_t search = fs_searchpaths;
        while (search != null) {
            if (search.pack != null) {
                pack_t pak = search.pack;
                packfile_t entry = (packfile_t)pak.files.get(filename = filename.toLowerCase());
                if (entry != null) {
                    file_from_pak = 1;
                    file = new File(pak.filename);
                    if (!file.canRead()) {
                        Com.Error(0, "Couldn't reopen " + pak.filename);
                    }
                    if (pak.handle == null || !pak.handle.getFD().valid()) {
                        pak.handle = new RandomAccessFile(pak.filename, "r");
                    }
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    raf.seek(entry.filepos);
                    return raf;
                }
            } else {
                String netpath = search.filename + '/' + filename;
                file = new File(netpath);
                if (file.canRead()) {
                    return new RandomAccessFile(file, "r");
                }
            }
            search = search.next;
        }
        return null;
    }

    public static void Read(byte[] buffer, int len, RandomAccessFile f) {
        int offset = 0;
        int read = 0;
        boolean tries = false;
        int remaining = len;
        while (remaining != 0) {
            int block = Math.min(remaining, 65536);
            try {
                read = f.read(buffer, offset, block);
            }
            catch (IOException e) {
                Com.Error(0, e.toString());
            }
            if (read == 0) {
                if (!tries) {
                    tries = true;
                    CDAudio.Stop();
                } else {
                    Com.Error(0, "FS_Read: 0 bytes read");
                }
            } else if (read == -1) {
                Com.Error(0, "FS_Read: -1 bytes read");
            }
            remaining -= read;
            offset += read;
        }
    }

    public static byte[] LoadFile(String path) {
        byte[] buf = null;
        int len = 0;
        int index = path.indexOf(0);
        if (index != -1) {
            path = path.substring(0, index);
        }
        if ((len = FS.FileLength(path)) < 1) {
            return null;
        }
        try {
            RandomAccessFile file = FS.FOpenFile(path);
            buf = new byte[len];
            file.readFully(buf);
            file.close();
        }
        catch (IOException e) {
            Com.Error(0, e.toString());
        }
        return buf;
    }

    public static ByteBuffer LoadMappedFile(String filename) {
        File file = null;
        int fileLength = 0;
        AbstractInterruptibleChannel channel = null;
        FileInputStream input = null;
        ByteBuffer buffer = null;
        file_from_pak = 0;
        try {
            Iterator it = fs_links.iterator();
            while (it.hasNext()) {
                filelink_t link = (filelink_t)it.next();
                if (!filename.regionMatches(0, link.from, 0, link.fromlength)) continue;
                String netpath = link.to + filename.substring(link.fromlength);
                file = new File(netpath);
                if (file.canRead()) {
                    input = new FileInputStream(file);
                    channel = input.getChannel();
                    fileLength = (int)((FileChannel)channel).size();
                    buffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
                    input.close();
                    return buffer;
                }
                return null;
            }
            searchpath_t search = fs_searchpaths;
            while (search != null) {
                if (search.pack != null) {
                    pack_t pak = search.pack;
                    packfile_t entry = (packfile_t)pak.files.get(filename = filename.toLowerCase());
                    if (entry != null) {
                        file_from_pak = 1;
                        file = new File(pak.filename);
                        if (!file.canRead()) {
                            Com.Error(0, "Couldn't reopen " + pak.filename);
                        }
                        if (pak.handle == null || !pak.handle.getFD().valid()) {
                            pak.handle = new RandomAccessFile(pak.filename, "r");
                        }
                        if (pak.backbuffer == null) {
                            channel = pak.handle.getChannel();
                            pak.backbuffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, pak.handle.length());
                            channel.close();
                        }
                        pak.backbuffer.position(entry.filepos);
                        buffer = pak.backbuffer.slice();
                        buffer.limit(entry.filelen);
                        return buffer;
                    }
                } else {
                    String netpath = search.filename + '/' + filename;
                    file = new File(netpath);
                    if (file.canRead()) {
                        input = new FileInputStream(file);
                        channel = input.getChannel();
                        fileLength = (int)((FileChannel)channel).size();
                        buffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
                        input.close();
                        return buffer;
                    }
                }
                search = search.next;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (input != null) {
                input.close();
            } else if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return null;
    }

    public static void FreeFile(byte[] buffer) {
        buffer = null;
    }

    static pack_t LoadPackFile(String packfile) {
        Hashtable<String, packfile_t> newfiles;
        RandomAccessFile file;
        int numpackfiles = 0;
        pack_t pack = null;
        try {
            file = new RandomAccessFile(packfile, "r");
            FileChannel fc = file.getChannel();
            MappedByteBuffer packhandle = fc.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            packhandle.order(ByteOrder.LITTLE_ENDIAN);
            fc.close();
            if (packhandle == null || packhandle.limit() < 1) {
                return null;
            }
            dpackheader_t header = new dpackheader_t();
            header.ident = packhandle.getInt();
            header.dirofs = packhandle.getInt();
            header.dirlen = packhandle.getInt();
            if (header.ident != 1262698832) {
                Com.Error(0, packfile + " is not a packfile");
            }
            if ((numpackfiles = header.dirlen / 64) > 4096) {
                Com.Error(0, packfile + " has " + numpackfiles + " files");
            }
            newfiles = new Hashtable<String, packfile_t>(numpackfiles);
            ((ByteBuffer)packhandle).position(header.dirofs);
            packfile_t entry = null;
            for (int i = 0; i < numpackfiles; ++i) {
                packhandle.get(tmpText);
                entry = new packfile_t();
                entry.name = new String(tmpText).trim();
                entry.filepos = packhandle.getInt();
                entry.filelen = packhandle.getInt();
                newfiles.put(entry.name.toLowerCase(), entry);
            }
        }
        catch (IOException e) {
            Com.DPrintf(e.getMessage() + '\n');
            return null;
        }
        pack = new pack_t();
        pack.filename = new String(packfile);
        pack.handle = file;
        pack.numfiles = numpackfiles;
        pack.files = newfiles;
        Com.Printf("Added packfile " + packfile + " (" + numpackfiles + " files)\n");
        return pack;
    }

    static void AddGameDirectory(String dir) {
        fs_gamedir = new String(dir);
        searchpath_t search = new searchpath_t();
        search.filename = new String(dir);
        if (fs_searchpaths != null) {
            search.next = FS.fs_searchpaths.next;
            FS.fs_searchpaths.next = search;
        } else {
            fs_searchpaths = search;
        }
        for (int i = 0; i < 10; ++i) {
            pack_t pak;
            String pakfile = dir + "/pak" + i + ".pak";
            if (!new File(pakfile).canRead() || (pak = FS.LoadPackFile(pakfile)) == null) continue;
            search = new searchpath_t();
            search.pack = pak;
            search.filename = "";
            search.next = fs_searchpaths;
            fs_searchpaths = search;
        }
    }

    public static String Gamedir() {
        return fs_userdir != null ? fs_userdir : "baseq2";
    }

    public static String BaseGamedir() {
        return fs_gamedir != null ? fs_gamedir : "baseq2";
    }

    public static void ExecAutoexec() {
        int canthave;
        String dir = fs_userdir;
        String name = dir != null && dir.length() > 0 ? dir + "/autoexec.cfg" : FS.fs_basedir.string + '/' + "baseq2" + "/autoexec.cfg";
        if (Sys.FindAll(name, 0, canthave = 26) != null) {
            Cbuf.AddText("exec autoexec.cfg\n");
        }
    }

    public static void SetGamedir(String dir) {
        if (dir.indexOf("..") != -1 || dir.indexOf("/") != -1 || dir.indexOf("\\") != -1 || dir.indexOf(":") != -1) {
            Com.Printf("Gamedir should be a single filename, not a path\n");
            return;
        }
        while (fs_searchpaths != fs_base_searchpaths) {
            if (FS.fs_searchpaths.pack != null) {
                try {
                    FS.fs_searchpaths.pack.handle.close();
                }
                catch (IOException e) {
                    Com.DPrintf(e.getMessage() + '\n');
                }
                FS.fs_searchpaths.pack.files.clear();
                FS.fs_searchpaths.pack.files = null;
                FS.fs_searchpaths.pack = null;
            }
            searchpath_t next = FS.fs_searchpaths.next;
            fs_searchpaths = null;
            fs_searchpaths = next;
        }
        if (Globals.dedicated != null && Globals.dedicated.value == 0.0f) {
            Cbuf.AddText("vid_restart\nsnd_restart\n");
        }
        fs_gamedir = FS.fs_basedir.string + '/' + dir;
        if (dir.equals("baseq2") || dir.length() == 0) {
            Cvar.FullSet("gamedir", "", 12);
            Cvar.FullSet("game", "", 20);
        } else {
            Cvar.FullSet("gamedir", dir, 12);
            if (FS.fs_cddir.string != null && FS.fs_cddir.string.length() > 0) {
                FS.AddGameDirectory(FS.fs_cddir.string + '/' + dir);
            }
            FS.AddGameDirectory(FS.fs_basedir.string + '/' + dir);
        }
    }

    public static void Link_f() {
        filelink_t entry = null;
        if (Cmd.Argc() != 3) {
            Com.Printf("USAGE: link <from> <to>\n");
            return;
        }
        Iterator it = fs_links.iterator();
        while (it.hasNext()) {
            entry = (filelink_t)it.next();
            if (!entry.from.equals(Cmd.Argv(1))) continue;
            if (Cmd.Argv(2).length() < 1) {
                it.remove();
                return;
            }
            entry.to = new String(Cmd.Argv(2));
            return;
        }
        if (Cmd.Argv(2).length() > 0) {
            entry = new filelink_t();
            entry.from = new String(Cmd.Argv(1));
            entry.fromlength = entry.from.length();
            entry.to = new String(Cmd.Argv(2));
            fs_links.add(entry);
        }
    }

    public static String[] ListFiles(String findname, int musthave, int canthave) {
        String[] list = null;
        File[] files = Sys.FindAll(findname, musthave, canthave);
        if (files != null) {
            list = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                list[i] = files[i].getPath();
            }
        }
        return list;
    }

    public static void Dir_f() {
        String path = null;
        String findname = null;
        String wildcard = "*.*";
        if (Cmd.Argc() != 1) {
            wildcard = Cmd.Argv(1);
        }
        while ((path = FS.NextPath(path)) != null) {
            String tmp = findname;
            findname = path + '/' + wildcard;
            if (tmp != null) {
                tmp.replaceAll("\\\\", "/");
            }
            Com.Printf("Directory of " + findname + '\n');
            Com.Printf("----\n");
            String[] dirnames = FS.ListFiles(findname, 0, 0);
            if (dirnames != null) {
                int index = 0;
                for (int i = 0; i < dirnames.length; ++i) {
                    index = dirnames[i].lastIndexOf(47);
                    if (index > 0) {
                        Com.Printf(dirnames[i].substring(index + 1, dirnames[i].length()) + '\n');
                        continue;
                    }
                    Com.Printf(dirnames[i] + '\n');
                }
            }
            Com.Printf("\n");
        }
    }

    public static void Path_f() {
        Com.Printf("Current search path:\n");
        searchpath_t s = fs_searchpaths;
        while (s != null) {
            if (s == fs_base_searchpaths) {
                Com.Printf("----------\n");
            }
            if (s.pack != null) {
                Com.Printf(s.pack.filename + " (" + s.pack.numfiles + " files)\n");
            } else {
                Com.Printf(s.filename + '\n');
            }
            s = s.next;
        }
        Com.Printf("\nLinks:\n");
        Iterator it = fs_links.iterator();
        while (it.hasNext()) {
            filelink_t link = (filelink_t)it.next();
            Com.Printf(link.from + " : " + link.to + '\n');
        }
    }

    public static String NextPath(String prevpath) {
        if (prevpath == null || prevpath.length() == 0) {
            return fs_gamedir;
        }
        String prev = fs_gamedir;
        searchpath_t s = fs_searchpaths;
        while (s != null) {
            if (s.pack == null) {
                if (prevpath == prev) {
                    return s.filename;
                }
                prev = s.filename;
            }
            s = s.next;
        }
        return null;
    }

    public static void InitFilesystem() {
        Cmd.AddCommand("path", new xcommand_t(){

            public void execute() {
                FS.Path_f();
            }
        });
        Cmd.AddCommand("link", new xcommand_t(){

            public void execute() {
                FS.Link_f();
            }
        });
        Cmd.AddCommand("dir", new xcommand_t(){

            public void execute() {
                FS.Dir_f();
            }
        });
        fs_userdir = System.getProperty("user.home") + "/.jake2";
        FS.CreatePath(fs_userdir + "/");
        FS.AddGameDirectory(fs_userdir);
        fs_basedir = Cvar.Get("basedir", ".", 8);
        FS.setCDDir();
        FS.AddGameDirectory(FS.fs_basedir.string + '/' + "baseq2");
        FS.markBaseSearchPaths();
        fs_gamedirvar = Cvar.Get("game", "", 20);
        if (FS.fs_gamedirvar.string.length() > 0) {
            FS.SetGamedir(FS.fs_gamedirvar.string);
        }
    }

    static void setCDDir() {
        fs_cddir = Cvar.Get("cddir", "", 1);
        if (FS.fs_cddir.string.length() > 0) {
            FS.AddGameDirectory(FS.fs_cddir.string);
        }
    }

    static void markBaseSearchPaths() {
        fs_base_searchpaths = fs_searchpaths;
    }

    public static int Developer_searchpath(int who) {
        searchpath_t s = fs_searchpaths;
        while (s != null) {
            if (s.filename.indexOf("xatrix") != -1) {
                return 1;
            }
            if (s.filename.indexOf("rogue") != -1) {
                return 2;
            }
            s = s.next;
        }
        return 0;
    }

    static {
        fs_links = new LinkedList();
        file_from_pak = 0;
        tmpText = new byte[56];
    }

    static class dpackheader_t {
        int ident;
        int dirofs;
        int dirlen;

        dpackheader_t() {
        }
    }

    public static class searchpath_t {
        String filename;
        pack_t pack;
        searchpath_t next;
    }

    public static class filelink_t {
        String from;
        int fromlength;
        String to;
    }

    public static class pack_t {
        String filename;
        RandomAccessFile handle;
        ByteBuffer backbuffer;
        int numfiles;
        Hashtable files;
    }

    public static class packfile_t {
        static final int SIZE = 64;
        static final int NAME_SIZE = 56;
        String name;
        int filepos;
        int filelen;

        public String toString() {
            return this.name + " [ length: " + this.filelen + " pos: " + this.filepos + " ]";
        }
    }
}

