/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.Cmd;
import jake2.game.Info;
import jake2.game.cvar_t;
import jake2.qcommon.Com;
import jake2.qcommon.FS;
import jake2.qcommon.xcommand_t;
import jake2.util.Lib;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class Cvar
extends Globals {
    static xcommand_t Set_f = new xcommand_t(){

        public void execute() {
            int c = Cmd.Argc();
            if (c != 3 && c != 4) {
                Com.Printf("usage: set <variable> <value> [u / s]\n");
                return;
            }
            if (c == 4) {
                int flags;
                if (Cmd.Argv(3).equals("u")) {
                    flags = 2;
                } else if (Cmd.Argv(3).equals("s")) {
                    flags = 4;
                } else {
                    Com.Printf("flags can only be 'u' or 's'\n");
                    return;
                }
                Cvar.FullSet(Cmd.Argv(1), Cmd.Argv(2), flags);
            } else {
                Cvar.Set(Cmd.Argv(1), Cmd.Argv(2));
            }
        }
    };
    static xcommand_t List_f = new xcommand_t(){

        public void execute() {
            int i = 0;
            cvar_t var = Globals.cvar_vars;
            while (var != null) {
                if ((var.flags & 1) != 0) {
                    Com.Printf("*");
                } else {
                    Com.Printf(" ");
                }
                if ((var.flags & 2) != 0) {
                    Com.Printf("U");
                } else {
                    Com.Printf(" ");
                }
                if ((var.flags & 4) != 0) {
                    Com.Printf("S");
                } else {
                    Com.Printf(" ");
                }
                if ((var.flags & 8) != 0) {
                    Com.Printf("-");
                } else if ((var.flags & 0x10) != 0) {
                    Com.Printf("L");
                } else {
                    Com.Printf(" ");
                }
                Com.Printf(" " + var.name + " \"" + var.string + "\"\n");
                var = var.next;
                ++i;
            }
            Com.Printf(i + " cvars\n");
        }
    };

    public static cvar_t Get(String var_name, String var_value, int flags) {
        if ((flags & 6) != 0 && !Cvar.InfoValidate(var_name)) {
            Com.Printf("invalid info cvar name\n");
            return null;
        }
        cvar_t var = Cvar.FindVar(var_name);
        if (var != null) {
            var.flags |= flags;
            return var;
        }
        if (var_value == null) {
            return null;
        }
        if ((flags & 6) != 0 && !Cvar.InfoValidate(var_value)) {
            Com.Printf("invalid info cvar value\n");
            return null;
        }
        var = new cvar_t();
        var.name = new String(var_name);
        var.string = new String(var_value);
        var.modified = true;
        var.value = Lib.atof(var.string);
        var.next = Globals.cvar_vars;
        Globals.cvar_vars = var;
        var.flags = flags;
        return var;
    }

    static void Init() {
        Cmd.AddCommand("set", Set_f);
        Cmd.AddCommand("cvarlist", List_f);
    }

    public static String VariableString(String var_name) {
        cvar_t var = Cvar.FindVar(var_name);
        return var == null ? "" : var.string;
    }

    static cvar_t FindVar(String var_name) {
        cvar_t var = Globals.cvar_vars;
        while (var != null) {
            if (var_name.equals(var.name)) {
                return var;
            }
            var = var.next;
        }
        return null;
    }

    public static cvar_t FullSet(String var_name, String value, int flags) {
        cvar_t var = Cvar.FindVar(var_name);
        if (null == var) {
            return Cvar.Get(var_name, value, flags);
        }
        var.modified = true;
        if ((var.flags & 2) != 0) {
            Globals.userinfo_modified = true;
        }
        var.string = value;
        var.value = Lib.atof(var.string);
        var.flags = flags;
        return var;
    }

    public static cvar_t Set(String var_name, String value) {
        return Cvar.Set2(var_name, value, false);
    }

    public static cvar_t ForceSet(String var_name, String value) {
        return Cvar.Set2(var_name, value, true);
    }

    static cvar_t Set2(String var_name, String value, boolean force) {
        cvar_t var = Cvar.FindVar(var_name);
        if (var == null) {
            return Cvar.Get(var_name, value, 0);
        }
        if ((var.flags & 6) != 0 && !Cvar.InfoValidate(value)) {
            Com.Printf("invalid info cvar value\n");
            return var;
        }
        if (!force) {
            if ((var.flags & 8) != 0) {
                Com.Printf(var_name + " is write protected.\n");
                return var;
            }
            if ((var.flags & 0x10) != 0) {
                if (var.latched_string != null) {
                    if (value.equals(var.latched_string)) {
                        return var;
                    }
                    var.latched_string = null;
                } else if (value.equals(var.string)) {
                    return var;
                }
                if (Globals.server_state != 0) {
                    Com.Printf(var_name + " will be changed for next game.\n");
                    var.latched_string = value;
                } else {
                    var.string = value;
                    var.value = Lib.atof(var.string);
                    if (var.name.equals("game")) {
                        FS.SetGamedir(var.string);
                        FS.ExecAutoexec();
                    }
                }
                return var;
            }
        } else if (var.latched_string != null) {
            var.latched_string = null;
        }
        if (value.equals(var.string)) {
            return var;
        }
        var.modified = true;
        if ((var.flags & 2) != 0) {
            Globals.userinfo_modified = true;
        }
        var.string = value;
        try {
            var.value = Float.parseFloat(var.string);
        }
        catch (Exception e) {
            var.value = 0.0f;
        }
        return var;
    }

    public static void SetValue(String var_name, int value) {
        Cvar.Set(var_name, "" + value);
    }

    public static void SetValue(String var_name, float value) {
        if (value == (float)((int)value)) {
            Cvar.Set(var_name, "" + (int)value);
        } else {
            Cvar.Set(var_name, "" + value);
        }
    }

    public static float VariableValue(String var_name) {
        cvar_t var = Cvar.FindVar(var_name);
        if (var == null) {
            return 0.0f;
        }
        return Lib.atof(var.string);
    }

    public static boolean Command() {
        cvar_t v = Cvar.FindVar(Cmd.Argv(0));
        if (v == null) {
            return false;
        }
        if (Cmd.Argc() == 1) {
            Com.Printf("\"" + v.name + "\" is \"" + v.string + "\"\n");
            return true;
        }
        Cvar.Set(v.name, Cmd.Argv(1));
        return true;
    }

    public static String BitInfo(int bit) {
        String info = "";
        cvar_t var = Globals.cvar_vars;
        while (var != null) {
            if ((var.flags & bit) != 0) {
                info = Info.Info_SetValueForKey(info, var.name, var.string);
            }
            var = var.next;
        }
        return info;
    }

    public static String Serverinfo() {
        return Cvar.BitInfo(4);
    }

    public static void GetLatchedVars() {
        cvar_t var = Globals.cvar_vars;
        while (var != null) {
            if (var.latched_string != null && var.latched_string.length() != 0) {
                var.string = var.latched_string;
                var.latched_string = null;
                var.value = Lib.atof(var.string);
                if (var.name.equals("game")) {
                    FS.SetGamedir(var.string);
                    FS.ExecAutoexec();
                }
            }
            var = var.next;
        }
    }

    public static String Userinfo() {
        return Cvar.BitInfo(2);
    }

    public static void WriteVariables(String path) {
        RandomAccessFile f = Lib.fopen(path, "rw");
        if (f == null) {
            return;
        }
        try {
            f.seek(f.length());
        }
        catch (IOException e1) {
            Lib.fclose(f);
            return;
        }
        cvar_t var = cvar_vars;
        while (var != null) {
            if ((var.flags & 1) != 0) {
                String buffer = "set " + var.name + " \"" + var.string + "\"\n";
                try {
                    f.writeBytes(buffer);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            var = var.next;
        }
        Lib.fclose(f);
    }

    public static Vector CompleteVariable(String partial) {
        Vector<String> vars = new Vector<String>();
        cvar_t cvar = Globals.cvar_vars;
        while (cvar != null) {
            if (cvar.name.startsWith(partial)) {
                vars.add(cvar.name);
            }
            cvar = cvar.next;
        }
        return vars;
    }

    static boolean InfoValidate(String s) {
        if (s.indexOf("\\") != -1) {
            return false;
        }
        if (s.indexOf("\"") != -1) {
            return false;
        }
        return s.indexOf(";") == -1;
    }
}

