/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.client.CL;
import jake2.client.Console;
import jake2.game.Cmd;
import jake2.qcommon.CRC;
import jake2.qcommon.FS;
import jake2.qcommon.MD4;
import jake2.qcommon.longjmpException;
import jake2.qcommon.xcommand_t;
import jake2.server.SV_MAIN;
import jake2.sys.Sys;
import jake2.util.PrintfFormat;
import jake2.util.Vargs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class Com {
    static String debugContext = "";
    static String _debugContext = "";
    static int com_argc;
    static String[] com_argv;
    static int rd_target;
    static StringBuffer rd_buffer;
    static int rd_buffersize;
    static RD_Flusher rd_flusher;
    static boolean recursive;
    static String msg;
    public static char[] com_token;
    public static xcommand_t Error_f;
    static byte[] chktbl;
    static byte[] chkb;

    public static void BeginRedirect(int target, StringBuffer buffer, int buffersize, RD_Flusher flush) {
        if (0 == target || null == buffer || 0 == buffersize || null == flush) {
            return;
        }
        rd_target = target;
        rd_buffer = buffer;
        rd_buffersize = buffersize;
        rd_flusher = flush;
        rd_buffer.setLength(0);
    }

    public static void EndRedirect() {
        rd_flusher.rd_flush(rd_target, rd_buffer);
        rd_target = 0;
        rd_buffer = null;
        rd_buffersize = 0;
        rd_flusher = null;
    }

    public static String Parse(ParseHelp hlp) {
        int len;
        block8: {
            len = 0;
            if (hlp.data == null) {
                return "";
            }
            while (true) {
                hlp.skipwhites();
                if (hlp.isEof()) {
                    hlp.data = null;
                    return "";
                }
                if (hlp.getchar() != '/') break block8;
                if (hlp.nextchar() != '/') break;
                hlp.skiptoeol();
            }
            hlp.prevchar();
        }
        if (hlp.getchar() == '\"') {
            hlp.nextchar();
            while (true) {
                char c = hlp.getchar();
                hlp.nextchar();
                if (c == '\"' || c == '\u0000') {
                    return new String(com_token, 0, len);
                }
                if (len >= 1024) continue;
                Com.com_token[len] = c;
                ++len;
            }
        }
        char c = hlp.getchar();
        do {
            if (len >= 1024) continue;
            Com.com_token[len] = c;
            ++len;
        } while ((c = hlp.nextchar()) > ' ');
        if (len == 1024) {
            Com.Printf("Token exceeded 1024 chars, discarded.\n");
            len = 0;
        }
        return new String(com_token, 0, len);
    }

    public static void Error(int code, String fmt) throws longjmpException {
        Com.Error(code, fmt, null);
    }

    public static void Error(int code, String fmt, Vargs vargs) throws longjmpException {
        if (recursive) {
            Sys.Error("recursive error after: " + msg);
        }
        recursive = true;
        msg = Com.sprintf(fmt, vargs);
        if (code == 2) {
            CL.Drop();
            recursive = false;
            throw new longjmpException();
        }
        if (code == 1) {
            Com.Printf("********************\nERROR: " + msg + "\n********************\n");
            SV_MAIN.SV_Shutdown("Server crashed: " + msg + "\n", false);
            CL.Drop();
            recursive = false;
            throw new longjmpException();
        }
        SV_MAIN.SV_Shutdown("Server fatal crashed: %s" + msg + "\n", false);
        CL.Shutdown();
        Sys.Error(msg);
    }

    static void InitArgv(String[] args) throws longjmpException {
        if (args.length > 50) {
            Com.Error(0, "argc > MAX_NUM_ARGVS");
        }
        com_argc = args.length;
        for (int i = 0; i < com_argc; ++i) {
            Com.com_argv[i] = args[i].length() >= 1024 ? "" : args[i];
        }
    }

    public static void DPrintf(String fmt) {
        _debugContext = debugContext;
        Com.DPrintf(fmt, null);
        _debugContext = "";
    }

    public static void dprintln(String fmt) {
        Com.DPrintf(_debugContext + fmt + "\n", null);
    }

    public static void Printf(String fmt) {
        Com.Printf(_debugContext + fmt, null);
    }

    public static void DPrintf(String fmt, Vargs vargs) {
        if (Globals.developer == null || Globals.developer.value == 0.0f) {
            return;
        }
        _debugContext = debugContext;
        Com.Printf(fmt, vargs);
        _debugContext = "";
    }

    public static void Printf(String fmt, Vargs vargs) {
        String msg = Com.sprintf(_debugContext + fmt, vargs);
        if (rd_target != 0) {
            if (msg.length() + rd_buffer.length() > rd_buffersize - 1) {
                rd_flusher.rd_flush(rd_target, rd_buffer);
                rd_buffer.setLength(0);
            }
            rd_buffer.append(msg);
            return;
        }
        Console.Print(msg);
        Sys.ConsoleOutput(msg);
        if (Globals.logfile_active != null && Globals.logfile_active.value != 0.0f) {
            if (Globals.logfile == null) {
                String name = FS.Gamedir() + "/qconsole.log";
                if (Globals.logfile_active.value > 2.0f) {
                    try {
                        Globals.logfile = new RandomAccessFile(name, "rw");
                        Globals.logfile.seek(Globals.logfile.length());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Globals.logfile = new RandomAccessFile(name, "rw");
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (Globals.logfile != null) {
                try {
                    Globals.logfile.writeChars(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Globals.logfile_active.value > 1.0f) {
                // empty if block
            }
        }
    }

    public static void Println(String fmt) {
        Com.Printf(_debugContext + fmt + "\n");
    }

    public static String sprintf(String fmt, Vargs vargs) {
        String msg = "";
        msg = vargs == null || vargs.size() == 0 ? fmt : new PrintfFormat(fmt).sprintf(vargs.toArray());
        return msg;
    }

    public static int Argc() {
        return com_argc;
    }

    public static String Argv(int arg) {
        if (arg < 0 || arg >= com_argc || com_argv[arg].length() < 1) {
            return "";
        }
        return com_argv[arg];
    }

    public static void ClearArgv(int arg) {
        if (arg < 0 || arg >= com_argc || com_argv[arg].length() < 1) {
            return;
        }
        Com.com_argv[arg] = "";
    }

    public static void Quit() {
        SV_MAIN.SV_Shutdown("Server quit\n", false);
        CL.Shutdown();
        if (Globals.logfile != null) {
            try {
                Globals.logfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Globals.logfile = null;
        }
        Sys.Quit();
    }

    public static void SetServerState(int i) {
        Globals.server_state = i;
    }

    public static int BlockChecksum(byte[] buf, int length) {
        return MD4.Com_BlockChecksum(buf, length);
    }

    public static String StripExtension(String string) {
        int i = string.lastIndexOf(46);
        if (i < 0) {
            return string;
        }
        return string.substring(0, i);
    }

    public static byte BlockSequenceCRCByte(byte[] base, int offset, int length, int sequence) {
        if (sequence < 0) {
            Sys.Error("sequence < 0, this shouldn't happen\n");
        }
        int p_ndx = sequence % 1020;
        length = Math.min(60, length);
        System.arraycopy(base, offset, chkb, 0, length);
        Com.chkb[length] = chktbl[p_ndx + 0];
        Com.chkb[length + 1] = chktbl[p_ndx + 1];
        Com.chkb[length + 2] = chktbl[p_ndx + 2];
        Com.chkb[length + 3] = chktbl[p_ndx + 3];
        int crc = CRC.CRC_Block(chkb, length += 4);
        int x = 0;
        for (int n = 0; n < length; ++n) {
            x += chkb[n] & 0xFF;
        }
        return (byte)((crc ^= x) & 0xFF);
    }

    static {
        com_argv = new String[50];
        recursive = false;
        msg = "";
        com_token = new char[1024];
        Error_f = new xcommand_t(){

            public void execute() throws longjmpException {
                Com.Error(0, Cmd.Argv(1));
            }
        };
        chktbl = new byte[]{-124, 71, 81, -63, -109, 34, 33, 36, 47, 102, 96, 77, -80, 124, -38, -120, 84, 21, 43, -58, 108, -119, -59, -99, 72, -18, -26, -118, -75, -12, -53, -5, -15, 12, 46, -96, -41, -55, 31, -42, 6, -102, 9, 65, 84, 103, 70, -57, 116, -29, -56, -74, 93, -90, 54, -60, -85, 44, 126, -123, -88, -92, -90, 77, -106, 25, 25, -102, -52, -40, -84, 57, 94, 60, -14, -11, 90, 114, -27, -87, -47, -77, 35, -126, 111, 41, -53, -47, -52, 113, -5, -22, -110, -21, 28, -54, 76, 112, -2, 77, -55, 103, 67, 71, -108, -71, 71, -68, 63, 1, -85, 123, -90, -30, 118, -17, 90, 122, 41, 11, 81, 84, 103, -40, 28, 20, 62, 41, -20, -23, 45, 72, 103, -1, -19, 84, 79, 72, -64, -86, 97, -9, 120, 18, 3, 122, -98, -117, -49, -125, 123, -82, -54, 123, -39, -23, 83, 42, -21, -46, -40, -51, -93, 16, 37, 120, 90, -75, 35, 6, -109, -73, -124, -46, -67, -106, 117, -91, 94, -49, 78, -23, 80, -95, -26, -99, -79, -29, -123, 102, 40, 78, 67, -36, 110, -69, 51, -98, -13, 13, 0, -63, -49, 103, 52, 6, 124, 113, -29, 99, -73, -73, -33, -110, -60, -62, 37, 92, -1, -61, 110, -4, -86, 30, 42, 72, 17, 28, 54, 104, 120, -122, 121, 48, -61, -42, -34, -68, 58, 42, 109, 30, 70, -35, -32, -128, 30, 68, 59, 111, -81, 49, -38, -94, -67, 119, 6, 86, -64, -73, -110, 75, 55, -64, -4, -62, -43, -5, -88, -38, -11, 87, -88, 24, -64, -33, -25, -86, 42, -32, 124, 111, 119, -79, 38, -70, -7, 46, 29, 22, -53, -72, -94, 68, -43, 47, 26, 121, 116, -121, 75, 0, -55, 74, 58, 101, -113, -26, 93, -27, 10, 119, -40, 26, 20, 65, 117, -79, -30, 80, 44, -109, 56, 43, 109, -13, -10, -37, 31, -51, -1, 20, 112, -25, 22, -24, 61, -16, -29, -68, 94, -74, 63, -52, -127, 36, 103, -13, -105, 59, -2, 58, -106, -123, -33, -28, 110, 60, -123, 5, 14, -93, 43, 7, -56, -65, -27, 19, -126, 98, 8, 97, 105, 75, 71, 98, 115, 68, 100, -114, -30, -111, -90, -102, -73, -23, 4, -74, 84, 12, -59, -87, 71, -90, -55, 8, -2, 78, -90, -52, -118, 91, -112, 111, 43, 63, -74, 10, -106, -64, 120, 88, 60, 118, 109, -108, 26, -28, 78, -72, 56, -69, -11, -21, 41, -40, -80, -13, 21, 30, -103, -106, 60, 93, 99, -43, -79, -83, 82, -72, 85, 112, 117, 62, 26, -43, -38, -10, 122, 72, 125, 68, 65, -7, 17, -50, -41, -54, -91, 61, 122, 121, 126, 125, 37, 27, 119, -68, -9, -57, 15, -124, -107, 16, -110, 103, 21, 17, 90, 94, 65, 102, 15, 56, 3, -78, -15, 93, -8, -85, -64, 2, 118, -124, 40, -12, -99, 86, 70, 96, 32, -37, 104, -89, -69, -18, -84, 21, 1, 47, 32, 9, -37, -64, 22, -95, -119, -7, -108, 89, 0, -63, 118, -65, -63, 77, 93, 45, -87, -123, 44, -42, -45, 20, -52, 2, -61, -62, -6, 107, -73, -90, -17, -35, 18, 38, -92, 99, -29, 98, -67, 86, -118, 82, 43, -71, -33, 9, -68, 14, -105, -87, -80, -126, 70, 8, -43, 26, -114, 27, -89, -112, -104, -71, -69, 60, 23, -102, -14, -126, -70, 100, 10, 127, -54, 90, -116, 124, -45, 121, 9, 91, 38, -69, -67, 37, -33, 61, 111, -102, -113, -18, 33, 102, -80, -115, -124, 76, -111, 69, -44, 119, 79, -77, -116, -68, -88, -103, -86, 25, 83, 124, 2, -121, -69, 11, 124, 26, 45, -33, 72, 68, 6, -42, 125, 12, 45, 53, 118, -82, -60, 95, 113, -123, -105, -60, 61, -17, 82, -66, 0, -28, -51, 73, -47, -47, 28, 60, -48, 28, 66, -81, -44, -67, 88, 52, 7, 50, -18, -71, -75, -22, -1, -41, -116, 13, 46, 47, -81, -121, -69, -26, 82, 113, 34, -11, 37, 23, -95, -126, 4, -62, 74, -67, 87, -58, -85, -56, 53, 12, 60, -39, -62, 67, -37, 39, -110, -49, -72, 37, 96, -6, 33, 59, 4, 82, -56, -106, -70, 116, -29, 103, 62, -114, -115, 97, -112, -110, 89, -74, 26, 28, 94, 33, -63, 101, -27, -90, 52, 5, 111, -59, 96, -79, -125, -63, -43, -43, -19, -39, -57, 17, 123, 73, 122, -7, -7, -124, 71, -101, -30, -91, -126, -32, -62, -120, -48, -78, 88, -120, 127, 69, 9, 103, 116, 97, -65, -26, 64, -30, -99, -62, 71, 5, -119, -19, -53, -69, -73, 39, -25, -36, 122, -3, -65, -88, -48, -86, 16, 57, 60, 32, -16, -45, 110, -79, 114, -8, -26, 15, -17, 55, -27, 9, 51, 90, -125, 67, -128, 79, 101, 47, 124, -116, 106, -96, -126, 12, -44, -44, -6, -127, 96, 61, -33, 6, -15, 95, 8, 13, 109, 67, -14, -29, 17, 125, -128, 50, -59, -5, -59, -39, 39, -20, -58, 78, 101, 39, 118, -121, -90, -18, -18, -41, -117, -47, -96, 92, -80, 66, 19, 14, -107, 74, -14, 6, -58, 67, 51, -12, -57, -8, -25, 31, -35, -28, 70, 74, 112, 57, 108, -48, -19, -54, -66, 96, 59, -47, 123, 87, 72, -27, 58, 121, -63, 105, 51, 83, 27, -128, -72, -111, 125, -76, -10, 23, 26, 29, 90, 50, -42, -52, 113, 41, 63, 40, -69, -13, 94, 113, -72, 67, -81, -8, -71, 100, -17, -60, -91, 108, 8, 83, -57, 0, 16, 57, 79, -35, -28, -74, 25, 39, -5, -72, -11, 50, 115, -27, -53, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        chkb = new byte[64];
    }

    public static class ParseHelp {
        public int index;
        public char[] data;
        private int length;

        public ParseHelp(String in) {
            if (in == null) {
                this.data = null;
                this.length = 0;
            } else {
                this.data = in.toCharArray();
                this.length = this.data.length;
            }
            this.index = 0;
        }

        public ParseHelp(char[] in) {
            this(in, 0);
        }

        public ParseHelp(char[] in, int offset) {
            this.data = in;
            this.index = offset;
            this.length = this.data != null ? this.data.length : 0;
        }

        public char getchar() {
            if (this.index < this.length) {
                return this.data[this.index];
            }
            return '\u0000';
        }

        public char nextchar() {
            ++this.index;
            if (this.index < this.length) {
                return this.data[this.index];
            }
            return '\u0000';
        }

        public char prevchar() {
            if (this.index > 0) {
                --this.index;
                return this.data[this.index];
            }
            return '\u0000';
        }

        public boolean isEof() {
            return this.index >= this.length;
        }

        public char skipwhites() {
            char c = '\u0000';
            while (this.index < this.length && (c = this.data[this.index]) <= ' ' && c != '\u0000') {
                ++this.index;
            }
            return c;
        }

        public char skipwhitestoeol() {
            char c = '\u0000';
            while (this.index < this.length && (c = this.data[this.index]) <= ' ' && c != '\n' && c != '\u0000') {
                ++this.index;
            }
            return c;
        }

        public char skiptoeol() {
            char c = '\u0000';
            while (this.index < this.length && (c = this.data[this.index]) != '\n' && c != '\u0000') {
                ++this.index;
            }
            return c;
        }
    }

    public static abstract class RD_Flusher {
        public abstract void rd_flush(int var1, StringBuffer var2);
    }
}

