/*
 * Decompiled with CFR 0.152.
 */
package jake2.qcommon;

import jake2.Globals;
import jake2.game.cmodel_t;
import jake2.game.cplane_t;
import jake2.game.cvar_t;
import jake2.game.mapsurface_t;
import jake2.game.trace_t;
import jake2.qcommon.Com;
import jake2.qcommon.Cvar;
import jake2.qcommon.FS;
import jake2.qcommon.MD4;
import jake2.qcommon.lump_t;
import jake2.qcommon.qfiles;
import jake2.qcommon.texinfo_t;
import jake2.util.Lib;
import jake2.util.Math3D;
import jake2.util.Vargs;
import jake2.util.Vec3Cache;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;

public class CM {
    static int checkcount;
    static String map_name;
    static int numbrushsides;
    static cbrushside_t[] map_brushsides;
    public static int numtexinfo;
    public static mapsurface_t[] map_surfaces;
    static int numplanes;
    static cplane_t[] map_planes;
    static int numnodes;
    static cnode_t[] map_nodes;
    static int numleafs;
    static cleaf_t[] map_leafs;
    static int emptyleaf;
    static int solidleaf;
    static int numleafbrushes;
    public static int[] map_leafbrushes;
    public static int numcmodels;
    public static cmodel_t[] map_cmodels;
    public static int numbrushes;
    public static cbrush_t[] map_brushes;
    public static int numvisibility;
    public static byte[] map_visibility;
    public static qfiles.dvis_t map_vis;
    public static int numentitychars;
    public static String map_entitystring;
    public static int numareas;
    public static carea_t[] map_areas;
    public static int numareaportals;
    public static qfiles.dareaportal_t[] map_areaportals;
    public static int numclusters;
    public static mapsurface_t nullsurface;
    public static int floodvalid;
    public static boolean[] portalopen;
    public static cvar_t map_noareas;
    public static byte[] cmod_base;
    public static int checksum;
    public static int last_checksum;
    static boolean debugloadmap;
    static cplane_t[] box_planes;
    static int box_headnode;
    static cbrush_t box_brush;
    static cleaf_t box_leaf;
    private static int leaf_count;
    private static int leaf_maxcount;
    private static int[] leaf_list;
    private static float[] leaf_mins;
    private static float[] leaf_maxs;
    private static int leaf_topnode;
    private static final float DIST_EPSILON = 0.03125f;
    private static float[] trace_start;
    private static float[] trace_end;
    private static float[] trace_mins;
    private static float[] trace_maxs;
    private static float[] trace_extents;
    private static trace_t trace_trace;
    private static int trace_contents;
    private static boolean trace_ispoint;
    public static byte[] pvsrow;
    public static byte[] phsrow;

    public static cmodel_t CM_LoadMap(String name, boolean clientload, int[] checksum) {
        Com.DPrintf("CM_LoadMap(" + name + ")...\n");
        map_noareas = Cvar.Get("map_noareas", "0", 0);
        if (map_name.equals(name) && (clientload || 0.0f == Cvar.VariableValue("flushmap"))) {
            checksum[0] = last_checksum;
            if (!clientload) {
                Arrays.fill(portalopen, false);
                CM.FloodAreaConnections();
            }
            return map_cmodels[0];
        }
        numnodes = 0;
        numleafs = 0;
        numcmodels = 0;
        numvisibility = 0;
        numentitychars = 0;
        map_entitystring = "";
        map_name = "";
        if (name == null || name.length() == 0) {
            numleafs = 1;
            numclusters = 1;
            numareas = 1;
            checksum[0] = 0;
            return map_cmodels[0];
        }
        byte[] buf = FS.LoadFile(name);
        if (buf == null) {
            Com.Error(1, "Couldn't load " + name);
        }
        int length = buf.length;
        ByteBuffer bbuf = ByteBuffer.wrap(buf);
        checksum[0] = last_checksum = MD4.Com_BlockChecksum(buf, length);
        qfiles.dheader_t header = new qfiles.dheader_t(bbuf.slice());
        if (header.version != 38) {
            Com.Error(1, "CMod_LoadBrushModel: " + name + " has wrong version number (" + header.version + " should be " + 38 + ")");
        }
        cmod_base = buf;
        CM.CMod_LoadSurfaces(header.lumps[5]);
        CM.CMod_LoadLeafs(header.lumps[8]);
        CM.CMod_LoadLeafBrushes(header.lumps[10]);
        CM.CMod_LoadPlanes(header.lumps[1]);
        CM.CMod_LoadBrushes(header.lumps[14]);
        CM.CMod_LoadBrushSides(header.lumps[15]);
        CM.CMod_LoadSubmodels(header.lumps[13]);
        CM.CMod_LoadNodes(header.lumps[4]);
        CM.CMod_LoadAreas(header.lumps[17]);
        CM.CMod_LoadAreaPortals(header.lumps[18]);
        CM.CMod_LoadVisibility(header.lumps[3]);
        CM.CMod_LoadEntityString(header.lumps[0]);
        FS.FreeFile(buf);
        CM.CM_InitBoxHull();
        Arrays.fill(portalopen, false);
        CM.FloodAreaConnections();
        map_name = name;
        return map_cmodels[0];
    }

    public static void CMod_LoadSubmodels(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadSubmodels()\n");
        if (l.filelen % qfiles.dmodel_t.SIZE != 0) {
            Com.Error(1, "CMod_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / qfiles.dmodel_t.SIZE) < 1) {
            Com.Error(1, "Map with no models");
        }
        if (count > 1024) {
            Com.Error(1, "Map has too many models");
        }
        Com.DPrintf(" numcmodels=" + count + "\n");
        numcmodels = count;
        if (debugloadmap) {
            Com.DPrintf("submodles(headnode, <origin>, <mins>, <maxs>)\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dmodel_t in = new qfiles.dmodel_t(ByteBuffer.wrap(cmod_base, i * qfiles.dmodel_t.SIZE + l.fileofs, qfiles.dmodel_t.SIZE));
            cmodel_t out = map_cmodels[i];
            for (int j = 0; j < 3; ++j) {
                out.mins[j] = in.mins[j] - 1.0f;
                out.maxs[j] = in.maxs[j] + 1.0f;
                out.origin[j] = in.origin[j];
            }
            out.headnode = in.headnode;
            if (!debugloadmap) continue;
            Com.DPrintf("|%6i|%8.2f|%8.2f|%8.2f|  %8.2f|%8.2f|%8.2f|   %8.2f|%8.2f|%8.2f|\n", new Vargs().add(out.headnode).add(out.origin[0]).add(out.origin[1]).add(out.origin[2]).add(out.mins[0]).add(out.mins[1]).add(out.mins[2]).add(out.maxs[0]).add(out.maxs[1]).add(out.maxs[2]));
        }
    }

    public static void CMod_LoadSurfaces(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadSurfaces()\n");
        if (l.filelen % 76 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / 76) < 1) {
            Com.Error(1, "Map with no surfaces");
        }
        if (count > 8192) {
            Com.Error(1, "Map has too many surfaces");
        }
        numtexinfo = count;
        Com.DPrintf(" numtexinfo=" + count + "\n");
        if (debugloadmap) {
            Com.DPrintf("surfaces:\n");
        }
        for (int i = 0; i < count; ++i) {
            mapsurface_t out = CM.map_surfaces[i] = new mapsurface_t();
            texinfo_t in = new texinfo_t(cmod_base, l.fileofs + i * 76, 76);
            out.c.name = in.texture;
            out.rname = in.texture;
            out.c.flags = in.flags;
            out.c.value = in.value;
            if (!debugloadmap) continue;
            Com.DPrintf("|%20s|%20s|%6i|%6i|\n", new Vargs().add(out.c.name).add(out.rname).add(out.c.value).add(out.c.flags));
        }
    }

    public static void CMod_LoadNodes(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadNodes()\n");
        if (l.filelen % qfiles.dnode_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size:" + l.fileofs + "," + qfiles.dnode_t.SIZE);
        }
        if ((count = l.filelen / qfiles.dnode_t.SIZE) < 1) {
            Com.Error(1, "Map has no nodes");
        }
        if (count > 65536) {
            Com.Error(1, "Map has too many nodes");
        }
        numnodes = count;
        Com.DPrintf(" numnodes=" + count + "\n");
        if (debugloadmap) {
            Com.DPrintf("nodes(planenum, child[0], child[1])\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dnode_t in = new qfiles.dnode_t(ByteBuffer.wrap(cmod_base, qfiles.dnode_t.SIZE * i + l.fileofs, qfiles.dnode_t.SIZE));
            cnode_t out = map_nodes[i];
            out.plane = map_planes[in.planenum];
            for (int j = 0; j < 2; ++j) {
                int child;
                out.children[j] = child = in.children[j];
            }
            if (!debugloadmap) continue;
            Com.DPrintf("|%6i| %6i| %6i|\n", new Vargs().add(in.planenum).add(out.children[0]).add(out.children[1]));
        }
    }

    public static void CMod_LoadBrushes(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadBrushes()\n");
        if (l.filelen % qfiles.dbrush_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / qfiles.dbrush_t.SIZE) > 8192) {
            Com.Error(1, "Map has too many brushes");
        }
        numbrushes = count;
        Com.DPrintf(" numbrushes=" + count + "\n");
        if (debugloadmap) {
            Com.DPrintf("brushes:(firstbrushside, numsides, contents)\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dbrush_t in = new qfiles.dbrush_t(ByteBuffer.wrap(cmod_base, i * qfiles.dbrush_t.SIZE + l.fileofs, qfiles.dbrush_t.SIZE));
            cbrush_t out = map_brushes[i];
            out.firstbrushside = in.firstside;
            out.numsides = in.numsides;
            out.contents = in.contents;
            if (!debugloadmap) continue;
            Com.DPrintf("| %6i| %6i| %8X|\n", new Vargs().add(out.firstbrushside).add(out.numsides).add(out.contents));
        }
    }

    public static void CMod_LoadLeafs(lump_t l) {
        int i;
        int count;
        Com.DPrintf("CMod_LoadLeafs()\n");
        if (l.filelen % 28 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / 28) < 1) {
            Com.Error(1, "Map with no leafs");
        }
        if (count > 65536) {
            Com.Error(1, "Map has too many planes");
        }
        Com.DPrintf(" numleafes=" + count + "\n");
        numleafs = count;
        numclusters = 0;
        if (debugloadmap) {
            Com.DPrintf("cleaf-list:(contents, cluster, area, firstleafbrush, numleafbrushes)\n");
        }
        for (i = 0; i < count; ++i) {
            qfiles.dleaf_t in = new qfiles.dleaf_t(cmod_base, i * 28 + l.fileofs, 28);
            cleaf_t out = map_leafs[i];
            out.contents = in.contents;
            out.cluster = in.cluster;
            out.area = in.area;
            out.firstleafbrush = (short)in.firstleafbrush;
            out.numleafbrushes = (short)in.numleafbrushes;
            if (out.cluster >= numclusters) {
                numclusters = out.cluster + 1;
            }
            if (!debugloadmap) continue;
            Com.DPrintf("|%8x|%6i|%6i|%6i|\n", new Vargs().add(out.contents).add(out.cluster).add(out.area).add(out.firstleafbrush).add(out.numleafbrushes));
        }
        Com.DPrintf(" numclusters=" + numclusters + "\n");
        if (CM.map_leafs[0].contents != 1) {
            Com.Error(1, "Map leaf 0 is not CONTENTS_SOLID");
        }
        solidleaf = 0;
        emptyleaf = -1;
        for (i = 1; i < numleafs; ++i) {
            if (CM.map_leafs[i].contents != 0) continue;
            emptyleaf = i;
            break;
        }
        if (emptyleaf == -1) {
            Com.Error(1, "Map does not have an empty leaf");
        }
    }

    public static void CMod_LoadPlanes(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadPlanes()\n");
        if (l.filelen % 20 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / 20) < 1) {
            Com.Error(1, "Map with no planes");
        }
        if (count > 65536) {
            Com.Error(1, "Map has too many planes");
        }
        Com.DPrintf(" numplanes=" + count + "\n");
        numplanes = count;
        if (debugloadmap) {
            Com.DPrintf("cplanes(normal[0],normal[1],normal[2], dist, type, signbits)\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dplane_t in = new qfiles.dplane_t(ByteBuffer.wrap(cmod_base, i * 20 + l.fileofs, 20));
            cplane_t out = map_planes[i];
            int bits = 0;
            for (int j = 0; j < 3; ++j) {
                out.normal[j] = in.normal[j];
                if (!(out.normal[j] < 0.0f)) continue;
                bits |= 1 << j;
            }
            out.dist = in.dist;
            out.type = (byte)in.type;
            out.signbits = (byte)bits;
            if (!debugloadmap) continue;
            Com.DPrintf("|%6.2f|%6.2f|%6.2f| %10.2f|%3i| %1i|\n", new Vargs().add(out.normal[0]).add(out.normal[1]).add(out.normal[2]).add(out.dist).add(out.type).add(out.signbits));
        }
    }

    public static void CMod_LoadLeafBrushes(lump_t l) {
        Com.DPrintf("CMod_LoadLeafBrushes()\n");
        if (l.filelen % 2 != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        int count = l.filelen / 2;
        Com.DPrintf(" numbrushes=" + count + "\n");
        if (count < 1) {
            Com.Error(1, "Map with no planes");
        }
        if (count > 65536) {
            Com.Error(1, "Map has too many leafbrushes");
        }
        int[] out = map_leafbrushes;
        numleafbrushes = count;
        ByteBuffer bb = ByteBuffer.wrap(cmod_base, l.fileofs, count * 2).order(ByteOrder.LITTLE_ENDIAN);
        if (debugloadmap) {
            Com.DPrintf("map_brushes:\n");
        }
        for (int i = 0; i < count; ++i) {
            out[i] = bb.getShort();
            if (!debugloadmap) continue;
            Com.DPrintf("|%6i|%6i|\n", new Vargs().add(i).add(out[i]));
        }
    }

    public static void CMod_LoadBrushSides(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadBrushSides()\n");
        if (l.filelen % qfiles.dbrushside_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / qfiles.dbrushside_t.SIZE) > 65536) {
            Com.Error(1, "Map has too many planes");
        }
        numbrushsides = count;
        Com.DPrintf(" numbrushsides=" + count + "\n");
        if (debugloadmap) {
            Com.DPrintf("brushside(planenum, surfacenum):\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dbrushside_t in = new qfiles.dbrushside_t(ByteBuffer.wrap(cmod_base, i * qfiles.dbrushside_t.SIZE + l.fileofs, qfiles.dbrushside_t.SIZE));
            cbrushside_t out = map_brushsides[i];
            int num = in.planenum;
            out.plane = map_planes[num];
            short j = in.texinfo;
            if (j >= numtexinfo) {
                Com.Error(1, "Bad brushside texinfo");
            }
            out.surface = j == -1 ? new mapsurface_t() : map_surfaces[j];
            if (!debugloadmap) continue;
            Com.DPrintf("| %6i| %6i|\n", new Vargs().add(num).add((int)j));
        }
    }

    public static void CMod_LoadAreas(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadAreas()\n");
        if (l.filelen % qfiles.darea_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / qfiles.darea_t.SIZE) > 256) {
            Com.Error(1, "Map has too many areas");
        }
        Com.DPrintf(" numareas=" + count + "\n");
        numareas = count;
        if (debugloadmap) {
            Com.DPrintf("areas(numportals, firstportal)\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.darea_t in = new qfiles.darea_t(ByteBuffer.wrap(cmod_base, i * qfiles.darea_t.SIZE + l.fileofs, qfiles.darea_t.SIZE));
            carea_t out = map_areas[i];
            out.numareaportals = in.numareaportals;
            out.firstareaportal = in.firstareaportal;
            out.floodvalid = 0;
            out.floodnum = 0;
            if (!debugloadmap) continue;
            Com.DPrintf("| %6i| %6i|\n", new Vargs().add(out.numareaportals).add(out.firstareaportal));
        }
    }

    public static void CMod_LoadAreaPortals(lump_t l) {
        int count;
        Com.DPrintf("CMod_LoadAreaPortals()\n");
        if (l.filelen % qfiles.dareaportal_t.SIZE != 0) {
            Com.Error(1, "MOD_LoadBmodel: funny lump size");
        }
        if ((count = l.filelen / qfiles.dareaportal_t.SIZE) > 256) {
            Com.Error(1, "Map has too many areas");
        }
        numareaportals = count;
        Com.DPrintf(" numareaportals=" + count + "\n");
        if (debugloadmap) {
            Com.DPrintf("areaportals(portalnum, otherarea)\n");
        }
        for (int i = 0; i < count; ++i) {
            qfiles.dareaportal_t in = new qfiles.dareaportal_t(ByteBuffer.wrap(cmod_base, i * qfiles.dareaportal_t.SIZE + l.fileofs, qfiles.dareaportal_t.SIZE));
            qfiles.dareaportal_t out = map_areaportals[i];
            out.portalnum = in.portalnum;
            out.otherarea = in.otherarea;
            if (!debugloadmap) continue;
            Com.DPrintf("|%6i|%6i|\n", new Vargs().add(out.portalnum).add(out.otherarea));
        }
    }

    public static void CMod_LoadVisibility(lump_t l) {
        Com.DPrintf("CMod_LoadVisibility()\n");
        numvisibility = l.filelen;
        Com.DPrintf(" numvisibility=" + numvisibility + "\n");
        if (l.filelen > 0x100000) {
            Com.Error(1, "Map has too large visibility lump");
        }
        System.arraycopy(cmod_base, l.fileofs, map_visibility, 0, l.filelen);
        ByteBuffer bb = ByteBuffer.wrap(map_visibility, 0, l.filelen);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        map_vis = new qfiles.dvis_t(bb);
    }

    public static void CMod_LoadEntityString(lump_t l) {
        int x;
        Com.DPrintf("CMod_LoadEntityString()\n");
        numentitychars = l.filelen;
        if (l.filelen > 262144) {
            Com.Error(1, "Map has too large entity lump");
        }
        for (x = 0; x < l.filelen && cmod_base[x + l.fileofs] != 0; ++x) {
        }
        map_entitystring = new String(cmod_base, l.fileofs, x).trim();
        Com.dprintln("entitystring=" + map_entitystring.length() + " bytes, [" + map_entitystring.substring(0, Math.min(map_entitystring.length(), 15)) + "...]");
    }

    public static cmodel_t InlineModel(String name) {
        int num;
        if (name == null || name.charAt(0) != '*') {
            Com.Error(1, "CM_InlineModel: bad name");
        }
        if ((num = Lib.atoi(name.substring(1))) < 1 || num >= numcmodels) {
            Com.Error(1, "CM_InlineModel: bad number");
        }
        return map_cmodels[num];
    }

    public static int CM_NumClusters() {
        return numclusters;
    }

    public static int CM_NumInlineModels() {
        return numcmodels;
    }

    public static String CM_EntityString() {
        return map_entitystring;
    }

    public static int CM_LeafContents(int leafnum) {
        if (leafnum < 0 || leafnum >= numleafs) {
            Com.Error(1, "CM_LeafContents: bad number");
        }
        return CM.map_leafs[leafnum].contents;
    }

    public static int CM_LeafCluster(int leafnum) {
        if (leafnum < 0 || leafnum >= numleafs) {
            Com.Error(1, "CM_LeafCluster: bad number");
        }
        return CM.map_leafs[leafnum].cluster;
    }

    public static int CM_LeafArea(int leafnum) {
        if (leafnum < 0 || leafnum >= numleafs) {
            Com.Error(1, "CM_LeafArea: bad number");
        }
        return CM.map_leafs[leafnum].area;
    }

    public static void CM_InitBoxHull() {
        box_headnode = numnodes;
        box_planes = new cplane_t[]{map_planes[numplanes], map_planes[numplanes + 1], map_planes[numplanes + 2], map_planes[numplanes + 3], map_planes[numplanes + 4], map_planes[numplanes + 5], map_planes[numplanes + 6], map_planes[numplanes + 7], map_planes[numplanes + 8], map_planes[numplanes + 9], map_planes[numplanes + 10], map_planes[numplanes + 11], map_planes[numplanes + 12]};
        if (numnodes + 6 > 65536 || numbrushes + 1 > 8192 || numleafbrushes + 1 > 65536 || numbrushsides + 6 > 65536 || numplanes + 12 > 65536) {
            Com.Error(1, "Not enough room for box tree");
        }
        box_brush = map_brushes[numbrushes];
        CM.box_brush.numsides = 6;
        CM.box_brush.firstbrushside = numbrushsides;
        CM.box_brush.contents = 0x2000000;
        box_leaf = map_leafs[numleafs];
        CM.box_leaf.contents = 0x2000000;
        CM.box_leaf.firstleafbrush = (short)numleafbrushes;
        CM.box_leaf.numleafbrushes = 1;
        CM.map_leafbrushes[CM.numleafbrushes] = numbrushes;
        for (int i = 0; i < 6; ++i) {
            int side = i & 1;
            cbrushside_t s = map_brushsides[numbrushsides + i];
            s.plane = map_planes[numplanes + i * 2 + side];
            s.surface = nullsurface;
            cnode_t c = map_nodes[box_headnode + i];
            c.plane = map_planes[numplanes + i * 2];
            c.children[side] = -1 - emptyleaf;
            c.children[side ^ 1] = i != 5 ? box_headnode + i + 1 : -1 - numleafs;
            cplane_t p = box_planes[i * 2];
            p.type = (byte)(i >> 1);
            p.signbits = 0;
            Math3D.VectorClear(p.normal);
            p.normal[i >> 1] = 1.0f;
            p = box_planes[i * 2 + 1];
            p.type = (byte)(3 + (i >> 1));
            p.signbits = 0;
            Math3D.VectorClear(p.normal);
            p.normal[i >> 1] = -1.0f;
        }
    }

    public static int HeadnodeForBox(float[] mins, float[] maxs) {
        CM.box_planes[0].dist = maxs[0];
        CM.box_planes[1].dist = -maxs[0];
        CM.box_planes[2].dist = mins[0];
        CM.box_planes[3].dist = -mins[0];
        CM.box_planes[4].dist = maxs[1];
        CM.box_planes[5].dist = -maxs[1];
        CM.box_planes[6].dist = mins[1];
        CM.box_planes[7].dist = -mins[1];
        CM.box_planes[8].dist = maxs[2];
        CM.box_planes[9].dist = -maxs[2];
        CM.box_planes[10].dist = mins[2];
        CM.box_planes[11].dist = -mins[2];
        return box_headnode;
    }

    private static int CM_PointLeafnum_r(float[] p, int num) {
        while (num >= 0) {
            cnode_t node = map_nodes[num];
            cplane_t plane = node.plane;
            float d = plane.type < 3 ? p[plane.type] - plane.dist : Math3D.DotProduct(plane.normal, p) - plane.dist;
            if (d < 0.0f) {
                num = node.children[1];
                continue;
            }
            num = node.children[0];
        }
        ++Globals.c_pointcontents;
        return -1 - num;
    }

    public static int CM_PointLeafnum(float[] p) {
        if (numplanes == 0) {
            return 0;
        }
        return CM.CM_PointLeafnum_r(p, 0);
    }

    private static void CM_BoxLeafnums_r(int nodenum) {
        while (true) {
            if (nodenum < 0) {
                if (leaf_count >= leaf_maxcount) {
                    Com.DPrintf("CM_BoxLeafnums_r: overflow\n");
                    return;
                }
                CM.leaf_list[CM.leaf_count++] = -1 - nodenum;
                return;
            }
            cnode_t node = map_nodes[nodenum];
            cplane_t plane = node.plane;
            int s = Math3D.BoxOnPlaneSide(leaf_mins, leaf_maxs, plane);
            if (s == 1) {
                nodenum = node.children[0];
                continue;
            }
            if (s == 2) {
                nodenum = node.children[1];
                continue;
            }
            if (leaf_topnode == -1) {
                leaf_topnode = nodenum;
            }
            CM.CM_BoxLeafnums_r(node.children[0]);
            nodenum = node.children[1];
        }
    }

    private static int CM_BoxLeafnums_headnode(float[] mins, float[] maxs, int[] list, int listsize, int headnode, int[] topnode) {
        leaf_list = list;
        leaf_count = 0;
        leaf_maxcount = listsize;
        leaf_mins = mins;
        leaf_maxs = maxs;
        leaf_topnode = -1;
        CM.CM_BoxLeafnums_r(headnode);
        if (topnode != null) {
            topnode[0] = leaf_topnode;
        }
        return leaf_count;
    }

    public static int CM_BoxLeafnums(float[] mins, float[] maxs, int[] list, int listsize, int[] topnode) {
        return CM.CM_BoxLeafnums_headnode(mins, maxs, list, listsize, CM.map_cmodels[0].headnode, topnode);
    }

    public static int PointContents(float[] p, int headnode) {
        if (numnodes == 0) {
            return 0;
        }
        int l = CM.CM_PointLeafnum_r(p, headnode);
        return CM.map_leafs[l].contents;
    }

    public static int TransformedPointContents(float[] p, int headnode, float[] origin, float[] angles) {
        float[] p_l = new float[]{0.0f, 0.0f, 0.0f};
        float[] temp = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorSubtract(p, origin, p_l);
        if (headnode != box_headnode && (angles[0] != 0.0f || angles[1] != 0.0f || angles[2] != 0.0f)) {
            Math3D.AngleVectors(angles, forward, right, up);
            Math3D.VectorCopy(p_l, temp);
            p_l[0] = Math3D.DotProduct(temp, forward);
            p_l[1] = -Math3D.DotProduct(temp, right);
            p_l[2] = Math3D.DotProduct(temp, up);
        }
        int l = CM.CM_PointLeafnum_r(p_l, headnode);
        return CM.map_leafs[l].contents;
    }

    public static void CM_ClipBoxToBrush(float[] mins, float[] maxs, float[] p1, float[] p2, trace_t trace, cbrush_t brush) {
        float[] ofs = new float[]{0.0f, 0.0f, 0.0f};
        float enterfrac = -1.0f;
        float leavefrac = 1.0f;
        cplane_t clipplane = null;
        if (brush.numsides == 0) {
            return;
        }
        ++Globals.c_brush_traces;
        boolean getout = false;
        boolean startout = false;
        cbrushside_t leadside = null;
        for (int i = 0; i < brush.numsides; ++i) {
            float f;
            float dist;
            cbrushside_t side = map_brushsides[brush.firstbrushside + i];
            cplane_t plane = side.plane;
            if (!trace_ispoint) {
                for (int j = 0; j < 3; ++j) {
                    ofs[j] = plane.normal[j] < 0.0f ? maxs[j] : mins[j];
                }
                dist = Math3D.DotProduct(ofs, plane.normal);
                dist = plane.dist - dist;
            } else {
                dist = plane.dist;
            }
            float d1 = Math3D.DotProduct(p1, plane.normal) - dist;
            float d2 = Math3D.DotProduct(p2, plane.normal) - dist;
            if (d2 > 0.0f) {
                getout = true;
            }
            if (d1 > 0.0f) {
                startout = true;
            }
            if (d1 > 0.0f && d2 >= d1) {
                return;
            }
            if (d1 <= 0.0f && d2 <= 0.0f) continue;
            if (d1 > d2) {
                f = (d1 - 0.03125f) / (d1 - d2);
                if (!(f > enterfrac)) continue;
                enterfrac = f;
                clipplane = plane;
                leadside = side;
                continue;
            }
            f = (d1 + 0.03125f) / (d1 - d2);
            if (!(f < leavefrac)) continue;
            leavefrac = f;
        }
        if (!startout) {
            trace.startsolid = true;
            if (!getout) {
                trace.allsolid = true;
            }
            return;
        }
        if (enterfrac < leavefrac && enterfrac > -1.0f && enterfrac < trace.fraction) {
            if (enterfrac < 0.0f) {
                enterfrac = 0.0f;
            }
            trace.fraction = enterfrac;
            trace.plane.set(clipplane);
            trace.surface = leadside.surface.c;
            trace.contents = brush.contents;
        }
    }

    public static void CM_TestBoxInBrush(float[] mins, float[] maxs, float[] p1, trace_t trace, cbrush_t brush) {
        float[] ofs = new float[]{0.0f, 0.0f, 0.0f};
        if (brush.numsides == 0) {
            return;
        }
        for (int i = 0; i < brush.numsides; ++i) {
            cbrushside_t side = map_brushsides[brush.firstbrushside + i];
            cplane_t plane = side.plane;
            for (int j = 0; j < 3; ++j) {
                ofs[j] = plane.normal[j] < 0.0f ? maxs[j] : mins[j];
            }
            float dist = Math3D.DotProduct(ofs, plane.normal);
            dist = plane.dist - dist;
            float d1 = Math3D.DotProduct(p1, plane.normal) - dist;
            if (!(d1 > 0.0f)) continue;
            return;
        }
        trace.allsolid = true;
        trace.startsolid = true;
        trace.fraction = 0.0f;
        trace.contents = brush.contents;
    }

    public static void CM_TraceToLeaf(int leafnum) {
        cleaf_t leaf = map_leafs[leafnum];
        if (0 == (leaf.contents & trace_contents)) {
            return;
        }
        for (int k = 0; k < leaf.numleafbrushes; ++k) {
            int brushnum = map_leafbrushes[leaf.firstleafbrush + k];
            cbrush_t b = map_brushes[brushnum];
            if (b.checkcount == checkcount) continue;
            b.checkcount = checkcount;
            if (0 == (b.contents & trace_contents)) continue;
            CM.CM_ClipBoxToBrush(trace_mins, trace_maxs, trace_start, trace_end, trace_trace, b);
            if (0.0f != CM.trace_trace.fraction) continue;
            return;
        }
    }

    public static void CM_TestInLeaf(int leafnum) {
        cleaf_t leaf = map_leafs[leafnum];
        if (0 == (leaf.contents & trace_contents)) {
            return;
        }
        for (int k = 0; k < leaf.numleafbrushes; ++k) {
            int brushnum = map_leafbrushes[leaf.firstleafbrush + k];
            cbrush_t b = map_brushes[brushnum];
            if (b.checkcount == checkcount) continue;
            b.checkcount = checkcount;
            if (0 == (b.contents & trace_contents)) continue;
            CM.CM_TestBoxInBrush(trace_mins, trace_maxs, trace_start, trace_trace, b);
            if (0.0f != CM.trace_trace.fraction) continue;
            return;
        }
    }

    public static void CM_RecursiveHullCheck(int num, float p1f, float p2f, float[] p1, float[] p2) {
        int i;
        float frac;
        float frac2;
        int side;
        float idist;
        float offset;
        float t2;
        float t1;
        if (CM.trace_trace.fraction <= p1f) {
            return;
        }
        if (num < 0) {
            CM.CM_TraceToLeaf(-1 - num);
            return;
        }
        cnode_t node = map_nodes[num];
        cplane_t plane = node.plane;
        if (plane.type < 3) {
            t1 = p1[plane.type] - plane.dist;
            t2 = p2[plane.type] - plane.dist;
            offset = trace_extents[plane.type];
        } else {
            t1 = Math3D.DotProduct(plane.normal, p1) - plane.dist;
            t2 = Math3D.DotProduct(plane.normal, p2) - plane.dist;
            offset = trace_ispoint ? 0.0f : Math.abs(trace_extents[0] * plane.normal[0]) + Math.abs(trace_extents[1] * plane.normal[1]) + Math.abs(trace_extents[2] * plane.normal[2]);
        }
        if (t1 >= offset && t2 >= offset) {
            CM.CM_RecursiveHullCheck(node.children[0], p1f, p2f, p1, p2);
            return;
        }
        if (t1 < -offset && t2 < -offset) {
            CM.CM_RecursiveHullCheck(node.children[1], p1f, p2f, p1, p2);
            return;
        }
        if (t1 < t2) {
            idist = 1.0f / (t1 - t2);
            side = 1;
            frac2 = (t1 + offset + 0.03125f) * idist;
            frac = (t1 - offset + 0.03125f) * idist;
        } else if (t1 > t2) {
            idist = 1.0f / (t1 - t2);
            side = 0;
            frac2 = (t1 - offset - 0.03125f) * idist;
            frac = (t1 + offset + 0.03125f) * idist;
        } else {
            side = 0;
            frac = 1.0f;
            frac2 = 0.0f;
        }
        if (frac < 0.0f) {
            frac = 0.0f;
        }
        if (frac > 1.0f) {
            frac = 1.0f;
        }
        float midf = p1f + (p2f - p1f) * frac;
        float[] mid = Vec3Cache.get();
        for (i = 0; i < 3; ++i) {
            mid[i] = p1[i] + frac * (p2[i] - p1[i]);
        }
        CM.CM_RecursiveHullCheck(node.children[side], p1f, midf, p1, mid);
        if (frac2 < 0.0f) {
            frac2 = 0.0f;
        }
        if (frac2 > 1.0f) {
            frac2 = 1.0f;
        }
        midf = p1f + (p2f - p1f) * frac2;
        for (i = 0; i < 3; ++i) {
            mid[i] = p1[i] + frac2 * (p2[i] - p1[i]);
        }
        CM.CM_RecursiveHullCheck(node.children[side ^ 1], midf, p2f, mid, p2);
        Vec3Cache.release();
    }

    public static trace_t BoxTrace(float[] start, float[] end, float[] mins, float[] maxs, int headnode, int brushmask) {
        ++checkcount;
        ++Globals.c_traces;
        trace_trace = new trace_t();
        CM.trace_trace.fraction = 1.0f;
        CM.trace_trace.surface = CM.nullsurface.c;
        if (numnodes == 0) {
            return trace_trace;
        }
        trace_contents = brushmask;
        Math3D.VectorCopy(start, trace_start);
        Math3D.VectorCopy(end, trace_end);
        Math3D.VectorCopy(mins, trace_mins);
        Math3D.VectorCopy(maxs, trace_maxs);
        if (start[0] == end[0] && start[1] == end[1] && start[2] == end[2]) {
            int[] leafs = new int[1024];
            float[] c1 = new float[]{0.0f, 0.0f, 0.0f};
            float[] c2 = new float[]{0.0f, 0.0f, 0.0f};
            int topnode = 0;
            Math3D.VectorAdd(start, mins, c1);
            Math3D.VectorAdd(start, maxs, c2);
            int i = 0;
            while (i < 3) {
                int n = i;
                c1[n] = c1[n] - 1.0f;
                int n2 = i++;
                c2[n2] = c2[n2] + 1.0f;
            }
            int[] tn = new int[]{topnode};
            int numleafs = CM.CM_BoxLeafnums_headnode(c1, c2, leafs, 1024, headnode, tn);
            topnode = tn[0];
            for (i = 0; i < numleafs; ++i) {
                CM.CM_TestInLeaf(leafs[i]);
                if (CM.trace_trace.allsolid) break;
            }
            Math3D.VectorCopy(start, CM.trace_trace.endpos);
            return trace_trace;
        }
        if (mins[0] == 0.0f && mins[1] == 0.0f && mins[2] == 0.0f && maxs[0] == 0.0f && maxs[1] == 0.0f && maxs[2] == 0.0f) {
            trace_ispoint = true;
            Math3D.VectorClear(trace_extents);
        } else {
            trace_ispoint = false;
            CM.trace_extents[0] = -mins[0] > maxs[0] ? -mins[0] : maxs[0];
            CM.trace_extents[1] = -mins[1] > maxs[1] ? -mins[1] : maxs[1];
            CM.trace_extents[2] = -mins[2] > maxs[2] ? -mins[2] : maxs[2];
        }
        CM.CM_RecursiveHullCheck(headnode, 0.0f, 1.0f, start, end);
        if (CM.trace_trace.fraction == 1.0f) {
            Math3D.VectorCopy(end, CM.trace_trace.endpos);
        } else {
            for (int i = 0; i < 3; ++i) {
                CM.trace_trace.endpos[i] = start[i] + CM.trace_trace.fraction * (end[i] - start[i]);
            }
        }
        return trace_trace;
    }

    public static trace_t TransformedBoxTrace(float[] start, float[] end, float[] mins, float[] maxs, int headnode, int brushmask, float[] origin, float[] angles) {
        float[] start_l = new float[]{0.0f, 0.0f, 0.0f};
        float[] end_l = new float[]{0.0f, 0.0f, 0.0f};
        float[] a = new float[]{0.0f, 0.0f, 0.0f};
        float[] forward = new float[]{0.0f, 0.0f, 0.0f};
        float[] right = new float[]{0.0f, 0.0f, 0.0f};
        float[] up = new float[]{0.0f, 0.0f, 0.0f};
        float[] temp = new float[]{0.0f, 0.0f, 0.0f};
        Math3D.VectorSubtract(start, origin, start_l);
        Math3D.VectorSubtract(end, origin, end_l);
        boolean rotated = headnode != box_headnode && (angles[0] != 0.0f || angles[1] != 0.0f || angles[2] != 0.0f);
        if (rotated) {
            Math3D.AngleVectors(angles, forward, right, up);
            Math3D.VectorCopy(start_l, temp);
            start_l[0] = Math3D.DotProduct(temp, forward);
            start_l[1] = -Math3D.DotProduct(temp, right);
            start_l[2] = Math3D.DotProduct(temp, up);
            Math3D.VectorCopy(end_l, temp);
            end_l[0] = Math3D.DotProduct(temp, forward);
            end_l[1] = -Math3D.DotProduct(temp, right);
            end_l[2] = Math3D.DotProduct(temp, up);
        }
        trace_t trace = CM.BoxTrace(start_l, end_l, mins, maxs, headnode, brushmask);
        if (rotated && (double)trace.fraction != 1.0) {
            Math3D.VectorNegate(angles, a);
            Math3D.AngleVectors(a, forward, right, up);
            Math3D.VectorCopy(trace.plane.normal, temp);
            trace.plane.normal[0] = Math3D.DotProduct(temp, forward);
            trace.plane.normal[1] = -Math3D.DotProduct(temp, right);
            trace.plane.normal[2] = Math3D.DotProduct(temp, up);
        }
        trace.endpos[0] = start[0] + trace.fraction * (end[0] - start[0]);
        trace.endpos[1] = start[1] + trace.fraction * (end[1] - start[1]);
        trace.endpos[2] = start[2] + trace.fraction * (end[2] - start[2]);
        return trace;
    }

    public static void CM_DecompressVis(byte[] in, int offset, byte[] out) {
        int row;
        int outp = 0;
        int inp = offset;
        if (in == null || numvisibility == 0) {
            for (row = numclusters + 7 >> 3; row != 0; --row) {
                out[outp++] = -1;
            }
            return;
        }
        do {
            if (in[inp] != 0) {
                out[outp++] = in[inp++];
                continue;
            }
            int c = in[inp + 1] & 0xFF;
            inp += 2;
            if (outp + c > row) {
                c = row - outp;
                Com.DPrintf("warning: Vis decompression overrun\n");
            }
            while (c != 0) {
                out[outp++] = 0;
                --c;
            }
        } while (outp < row);
    }

    public static byte[] CM_ClusterPVS(int cluster) {
        if (cluster == -1) {
            Arrays.fill(pvsrow, 0, numclusters + 7 >> 3, (byte)0);
        } else {
            CM.CM_DecompressVis(map_visibility, CM.map_vis.bitofs[cluster][0], pvsrow);
        }
        return pvsrow;
    }

    public static byte[] CM_ClusterPHS(int cluster) {
        if (cluster == -1) {
            Arrays.fill(phsrow, 0, numclusters + 7 >> 3, (byte)0);
        } else {
            CM.CM_DecompressVis(map_visibility, CM.map_vis.bitofs[cluster][1], phsrow);
        }
        return phsrow;
    }

    public static void FloodArea_r(carea_t area, int floodnum) {
        if (area.floodvalid == floodvalid) {
            if (area.floodnum == floodnum) {
                return;
            }
            Com.Error(1, "FloodArea_r: reflooded");
        }
        area.floodnum = floodnum;
        area.floodvalid = floodvalid;
        for (int i = 0; i < area.numareaportals; ++i) {
            qfiles.dareaportal_t p = map_areaportals[area.firstareaportal + i];
            if (!portalopen[p.portalnum]) continue;
            CM.FloodArea_r(map_areas[p.otherarea], floodnum);
        }
    }

    public static void FloodAreaConnections() {
        Com.DPrintf("FloodAreaConnections...\n");
        ++floodvalid;
        int floodnum = 0;
        for (int i = 1; i < numareas; ++i) {
            carea_t area = map_areas[i];
            if (area.floodvalid == floodvalid) continue;
            CM.FloodArea_r(area, ++floodnum);
        }
    }

    public static void CM_SetAreaPortalState(int portalnum, boolean open) {
        if (portalnum > numareaportals) {
            Com.Error(1, "areaportal > numareaportals");
        }
        CM.portalopen[portalnum] = open;
        CM.FloodAreaConnections();
    }

    public static boolean CM_AreasConnected(int area1, int area2) {
        if (CM.map_noareas.value != 0.0f) {
            return true;
        }
        if (area1 > numareas || area2 > numareas) {
            Com.Error(1, "area > numareas");
        }
        return CM.map_areas[area1].floodnum == CM.map_areas[area2].floodnum;
    }

    public static int CM_WriteAreaBits(byte[] buffer, int area) {
        int bytes = numareas + 7 >> 3;
        if (CM.map_noareas.value != 0.0f) {
            Arrays.fill(buffer, 0, bytes, (byte)-1);
        } else {
            Arrays.fill(buffer, 0, bytes, (byte)0);
            int floodnum = CM.map_areas[area].floodnum;
            for (int i = 0; i < numareas; ++i) {
                if (CM.map_areas[i].floodnum != floodnum && area != 0) continue;
                int n = i >> 3;
                buffer[n] = (byte)(buffer[n] | 1 << (i & 7));
            }
        }
        return bytes;
    }

    public static void CM_WritePortalState(RandomAccessFile os) {
        try {
            for (int n = 0; n < portalopen.length; ++n) {
                if (portalopen[n]) {
                    os.writeInt(1);
                    continue;
                }
                os.writeInt(0);
            }
        }
        catch (Exception e) {
            Com.Printf("ERROR:" + e);
            e.printStackTrace();
        }
    }

    public static void CM_ReadPortalState(RandomAccessFile f) {
        int len = portalopen.length * 4;
        byte[] buf = new byte[len];
        FS.Read(buf, len, f);
        ByteBuffer bb = ByteBuffer.wrap(buf);
        IntBuffer ib = bb.asIntBuffer();
        for (int n = 0; n < portalopen.length; ++n) {
            CM.portalopen[n] = ib.get() != 0;
        }
        CM.FloodAreaConnections();
    }

    public static boolean CM_HeadnodeVisible(int nodenum, byte[] visbits) {
        if (nodenum < 0) {
            int leafnum = -1 - nodenum;
            int cluster = CM.map_leafs[leafnum].cluster;
            if (cluster == -1) {
                return false;
            }
            return 0 != (visbits[cluster >>> 3] & 1 << (cluster & 7));
        }
        cnode_t node = map_nodes[nodenum];
        if (CM.CM_HeadnodeVisible(node.children[0], visbits)) {
            return true;
        }
        return CM.CM_HeadnodeVisible(node.children[1], visbits);
    }

    static {
        int n;
        map_name = "";
        map_brushsides = new cbrushside_t[65536];
        for (n = 0; n < 65536; ++n) {
            CM.map_brushsides[n] = new cbrushside_t();
        }
        map_surfaces = new mapsurface_t[8192];
        for (n = 0; n < 8192; ++n) {
            CM.map_surfaces[n] = new mapsurface_t();
        }
        map_planes = new cplane_t[65542];
        for (n = 0; n < 65542; ++n) {
            CM.map_planes[n] = new cplane_t();
        }
        map_nodes = new cnode_t[65542];
        for (n = 0; n < 65542; ++n) {
            CM.map_nodes[n] = new cnode_t();
        }
        numleafs = 1;
        map_leafs = new cleaf_t[65536];
        for (n = 0; n < 65536; ++n) {
            CM.map_leafs[n] = new cleaf_t();
        }
        map_leafbrushes = new int[65536];
        map_cmodels = new cmodel_t[1024];
        for (n = 0; n < 1024; ++n) {
            CM.map_cmodels[n] = new cmodel_t();
        }
        map_brushes = new cbrush_t[8192];
        for (n = 0; n < 8192; ++n) {
            CM.map_brushes[n] = new cbrush_t();
        }
        map_visibility = new byte[0x100000];
        map_vis = new qfiles.dvis_t(ByteBuffer.wrap(map_visibility));
        numareas = 1;
        map_areas = new carea_t[256];
        for (n = 0; n < 256; ++n) {
            CM.map_areas[n] = new carea_t();
        }
        map_areaportals = new qfiles.dareaportal_t[1024];
        for (n = 0; n < 1024; ++n) {
            CM.map_areaportals[n] = new qfiles.dareaportal_t();
        }
        numclusters = 1;
        nullsurface = new mapsurface_t();
        portalopen = new boolean[1024];
        debugloadmap = false;
        trace_start = new float[]{0.0f, 0.0f, 0.0f};
        trace_end = new float[]{0.0f, 0.0f, 0.0f};
        trace_mins = new float[]{0.0f, 0.0f, 0.0f};
        trace_maxs = new float[]{0.0f, 0.0f, 0.0f};
        trace_extents = new float[]{0.0f, 0.0f, 0.0f};
        trace_trace = new trace_t();
        pvsrow = new byte[8192];
        phsrow = new byte[8192];
    }

    public static class carea_t {
        int numareaportals;
        int firstareaportal;
        int floodnum;
        int floodvalid;
    }

    public static class cbrush_t {
        int contents;
        int numsides;
        int firstbrushside;
        int checkcount;
    }

    public static class cleaf_t {
        int contents;
        int cluster;
        int area;
        short firstleafbrush;
        short numleafbrushes;
    }

    public static class cbrushside_t {
        cplane_t plane;
        mapsurface_t surface;
    }

    public static class cnode_t {
        cplane_t plane;
        int[] children = new int[]{0, 0};
    }
}

